/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin;

import com.sun.enterprise.module.Module;
import com.sun.enterprise.module.ModulesRegistry;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.v3.data.ApplicationInfo;
import com.sun.enterprise.v3.data.ContainerInfo;
import com.sun.enterprise.v3.data.ContainerRegistry;
import java.util.Collection;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.container.Sniffer;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;

@Service(name="list-containers")
@I18n(value="list.containers.command")
public class ListContainersCommand
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(ListContainersCommand.class);
    @Inject
    ContainerRegistry containerRegistry;
    @Inject
    ModulesRegistry modulesRegistry;
    @Inject
    Habitat habitat;

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        report.setActionDescription(localStrings.getLocalString("list.containers.command", "List of Containers"));
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        ActionReport.MessagePart top = report.getTopMessagePart();
        top.setMessage(localStrings.getLocalString("list.containers.command", "List of Containers"));
        top.setChildrenType(localStrings.getLocalString("container", "Container"));
        Collection sniffers = this.habitat.getAllByContract(Sniffer.class);
        if (sniffers == null) {
            top.setMessage(localStrings.getLocalString("list.containers.nocontainer", "No container currently configured"));
        } else {
            for (Sniffer sniffer : sniffers) {
                ActionReport.MessagePart container = top.addChild();
                container.setMessage(sniffer.getModuleType());
                container.addProperty(localStrings.getLocalString("contractprovider", "ContractProvider"), sniffer.getModuleType());
                ContainerInfo containerInfo = this.containerRegistry.getContainer(sniffer.getModuleType());
                if (containerInfo == null) continue;
                container.addProperty(localStrings.getLocalString("status", "Status"), localStrings.getLocalString("started", "Started"));
                Module connectorModule = this.modulesRegistry.find(containerInfo.getSniffer().getClass());
                container.addProperty(localStrings.getLocalString("connector", "Connector"), connectorModule.getModuleDefinition().getName() + ":" + connectorModule.getModuleDefinition().getVersion());
                container.addProperty(localStrings.getLocalString("implementation", "Implementation"), containerInfo.getContainer().getClass().toString());
                Iterable<ApplicationInfo> apps = containerInfo.getApplications();
                if (apps.iterator().hasNext()) {
                    container.setChildrenType(localStrings.getLocalString("list.containers.listapps", "Applications deployed"));
                    for (ApplicationInfo info : apps) {
                        container.addChild().setMessage(info.getName());
                    }
                    continue;
                }
                container.addProperty("Status", "Not Started");
            }
        }
    }
}

