/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin.commands;

import com.sun.enterprise.util.i18n.StringManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class Joe {
    static final String NAME_VALUE_DELIMITER = "=";
    static final char VALID_JOE_START = '-';
    static final String OPTION_DELIMITER = ":";
    static final String DOMAINXML_DELIM = " ";
    public static final String CMDLINE_JVMOPTS_REGEX = "(-([^:]|[.*\\:.*])+:?)+";
    public static final String SPLIT_PATTERN = "(?<!\\\\):";
    private final String name;
    private final String value;
    private String ts;
    private static final StringManager lsm = StringManager.getManager(Joe.class);

    Joe(String name) {
        this(name, "");
    }

    Joe(String name, String value) {
        if (name == null || value == null) {
            throw new IllegalArgumentException("null value for name or value of a JVM Option");
        }
        if (name.length() <= 1) {
            throw new IllegalArgumentException("Illegal JVM Option name (too short): " + name);
        }
        if (name.charAt(0) != '-') {
            String msg = lsm.getString("joe.invalid.start", (Object)name);
            throw new IllegalArgumentException(msg);
        }
        this.name = name = name.replace("\\", "");
        this.value = value;
        this.ts = "".equals(value) ? name : name + NAME_VALUE_DELIMITER + value;
        this.ts = Joe.quoteIfNeeded(this.ts);
    }

    String getName() {
        return this.name;
    }

    String getValue() {
        return this.value;
    }

    boolean existsIn(List<String> options) {
        for (String option : options) {
            if (!this.toString().equals(option)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return this.ts;
    }

    private static String quoteIfNeeded(String s) {
        if (s.indexOf(DOMAINXML_DELIM) != -1) {
            s = "\"" + s + "\"";
        }
        return s;
    }

    static List<Joe> toJoes(String cmd) {
        String[] parts;
        if (cmd == null) {
            throw new IllegalArgumentException("null arg");
        }
        ArrayList<Joe> joes = new ArrayList<Joe>();
        Pattern syntax = Pattern.compile(CMDLINE_JVMOPTS_REGEX);
        Matcher matcher = syntax.matcher(cmd);
        if (!matcher.matches()) {
            String msg = lsm.getString("joe.invalid.cmd.syntax", (Object)cmd);
            throw new IllegalArgumentException(msg);
        }
        Pattern splitter = Pattern.compile(SPLIT_PATTERN);
        for (String part : parts = splitter.split(cmd)) {
            joes.add(new Joe(part));
        }
        return Collections.unmodifiableList(joes);
    }

    static List<String> toStrings(List<Joe> joes) {
        if (joes == null) {
            throw new IllegalArgumentException("null args");
        }
        ArrayList<String> strings = new ArrayList<String>(joes.size());
        for (Joe joe : joes) {
            strings.add(joe.toString());
        }
        return Collections.unmodifiableList(strings);
    }

    static List<Joe> pruneJoes(List<String> fromDomainXml, List<Joe> nascent) {
        ArrayList<Joe> pruned = new ArrayList<Joe>(nascent);
        for (Joe joe : nascent) {
            if (!joe.existsIn(fromDomainXml)) continue;
            pruned.remove(joe);
        }
        return pruned;
    }
}

