/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.deployment;

import com.sun.enterprise.module.ModuleDefinition;
import com.sun.enterprise.v3.server.ServerEnvironment;
import java.io.File;
import java.lang.instrument.ClassFileTransformer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.deployment.archive.ReadableArchive;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeploymentContextImpl
implements DeploymentContext {
    final ReadableArchive source;
    final Properties parameters;
    final Logger logger;
    final ServerEnvironment env;
    ClassLoader cloader;
    Properties props;
    Map<String, Object> modulesMetaData = new HashMap<String, Object>();
    List<ClassFileTransformer> transformers = new ArrayList<ClassFileTransformer>();
    List<ModuleDefinition> publicAPIs = new ArrayList<ModuleDefinition>();

    public DeploymentContextImpl(Logger logger, ReadableArchive source, Properties params, ServerEnvironment env) {
        this.source = source;
        this.logger = logger;
        this.parameters = params;
        this.env = env;
    }

    public ReadableArchive getSource() {
        return this.source;
    }

    public Properties getCommandParameters() {
        return this.parameters;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public ClassLoader getClassLoader() {
        return this.cloader;
    }

    public void setClassLoader(ClassLoader cloader) {
        this.cloader = cloader;
    }

    public File getScratchDir(String subDirName) {
        String appName = this.parameters.getProperty("name");
        File rootScratchDir = subDirName == null ? new File(this.env.getApplicationStubPath()) : new File(this.env.getApplicationStubPath(), subDirName);
        return new File(rootScratchDir, appName);
    }

    public File getSourceDir() {
        return new File(this.source.getURI());
    }

    public void addModuleMetaData(Object metaData) {
        this.modulesMetaData.put(metaData.getClass().getName(), metaData);
    }

    public <T> T getModuleMetaData(Class<T> metadataType) {
        Object moduleMetaData = this.modulesMetaData.get(metadataType.getName());
        if (moduleMetaData != null) {
            return metadataType.cast(moduleMetaData);
        }
        return null;
    }

    public synchronized Properties getProps() {
        if (this.props == null) {
            this.props = new Properties();
        }
        return this.props;
    }

    public void setProps(Properties props) {
        this.props = props;
    }

    public void addTransformer(ClassFileTransformer transformer) {
        this.transformers.add(transformer);
    }

    public List<ClassFileTransformer> getTransformers() {
        return this.transformers;
    }

    public void addPublicAPI(ModuleDefinition def) throws UnsupportedOperationException {
        this.publicAPIs.add(def);
    }

    public List<ModuleDefinition> getPublicAPIs() {
        return this.publicAPIs;
    }
}

