/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.deployment;

import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.v3.server.ApplicationLifecycle;
import com.sun.enterprise.v3.server.ServerEnvironment;
import java.util.logging.Level;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@Service(name="disable")
@I18n(value="disable.command")
@Scoped(value=PerLookup.class)
public class DisableCommand
extends ApplicationLifecycle
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(DisableCommand.class);
    @Inject
    ServerEnvironment env;
    @Param(primary=true, name="component")
    String component = null;

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        if (!this.isRegistered(this.component)) {
            report.setMessage(localStrings.getLocalString("application.notreg", "Application {0} not registered", new Object[]{this.component}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        try {
            this.disable(this.component, report);
            if (report.getActionExitCode().equals((Object)ActionReport.ExitCode.SUCCESS)) {
                this.setEnableAttributeInDomainXML(this.component, false);
            }
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Error during disabling: ", e);
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setMessage(e.getMessage());
        }
    }
}

