/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.deployment;

import com.sun.enterprise.config.serverbeans.Application;
import com.sun.enterprise.config.serverbeans.ApplicationRef;
import com.sun.enterprise.config.serverbeans.Applications;
import com.sun.enterprise.config.serverbeans.Module;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.deploy.shared.ArchiveFactory;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.v3.data.ApplicationInfo;
import com.sun.enterprise.v3.deployment.DeploymentContextImpl;
import com.sun.enterprise.v3.server.ApplicationLifecycle;
import com.sun.enterprise.v3.server.ServerEnvironment;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.container.Sniffer;
import org.glassfish.api.deployment.archive.ArchiveHandler;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@Service(name="enable")
@I18n(value="enable.command")
@Scoped(value=PerLookup.class)
public class EnableCommand
extends ApplicationLifecycle
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(EnableCommand.class);
    @Inject
    ServerEnvironment env;
    @Inject
    Applications applications;
    @Inject
    Server server;
    @Inject
    ArchiveFactory archiveFactory;
    @Param(primary=true, name="component")
    String component = null;
    @Param(optional=true)
    String target = "server";
    public static final String COMPONENT = "component";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(AdminCommandContext context) {
        ReadableArchive archive;
        Properties parameters = context.getCommandParameters();
        ActionReport report = context.getActionReport();
        if (!this.isRegistered(this.component)) {
            report.setMessage(localStrings.getLocalString("application.notreg", "Application {0} not registered", new Object[]{this.component}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        if (this.getSniffers().isEmpty()) {
            String msg = localStrings.getLocalString("nocontainer", "No container services registered, done...");
            this.logger.severe(msg);
            report.setMessage(msg);
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        File file = null;
        Properties commandParams = new Properties();
        Properties contextProps = new Properties();
        try {
            Object path = null;
            Application app = null;
            ApplicationRef appRef = null;
            for (Module module : this.applications.getModules()) {
                if (!module.getName().equals(this.component)) continue;
                app = (Application)module;
                break;
            }
            for (ApplicationRef ref : this.server.getApplicationRef()) {
                if (!ref.getRef().equals(this.component)) continue;
                appRef = ref;
                break;
            }
            commandParams = this.populateDeployParamsFromDomainXML(app, appRef);
            contextProps = this.populateDeployPropsFromDomainXML(app);
            parameters.putAll((Map<?, ?>)commandParams);
            URI uri = new URI(parameters.getProperty("location"));
            file = new File(uri);
            if (!file.exists()) {
                report.setMessage(localStrings.getLocalString("fnf", "File not found", new Object[]{file.getAbsolutePath()}));
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
            archive = this.archiveFactory.openArchive(file);
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Error opening deployable artifact : " + file.getAbsolutePath(), e);
            report.setMessage(localStrings.getLocalString("unknownarchiveformat", "Archive format not recognized"));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        try {
            ArchiveHandler archiveHandler = this.getArchiveHandler(archive);
            if (archiveHandler == null) {
                report.setMessage(localStrings.getLocalString("unknownarchivetype", "Archive type of {0} was not recognized", new Object[]{file.getName()}));
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
            ClassLoader parentCL = this.createSnifferParentCL(null, this.getSniffers());
            ClassLoader cloader = archiveHandler.getClassLoader(parentCL, archive);
            Collection<Sniffer> appSniffers = this.getSniffers(archive, cloader);
            if (appSniffers.size() == 0) {
                report.setMessage(localStrings.getLocalString("unknownmoduletpe", "Module type not recognized"));
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
            DeploymentContextImpl deploymentContext = new DeploymentContextImpl(this.logger, archive, parameters, this.env);
            deploymentContext.setClassLoader(cloader);
            deploymentContext.setProps(contextProps);
            ApplicationInfo appInfo = this.enable(appSniffers, deploymentContext, report);
            if (report.getActionExitCode().equals((Object)ActionReport.ExitCode.SUCCESS)) {
                this.setEnableAttributeInDomainXML(this.component, true);
            }
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Error during enabling: ", e);
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setMessage(e.getMessage());
        }
        finally {
            try {
                archive.close();
            }
            catch (IOException e) {
                this.logger.log(Level.INFO, "Error while closing deployable artifact : " + file.getAbsolutePath(), e);
            }
        }
    }
}

