/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.deployment;

import com.sun.enterprise.config.serverbeans.Application;
import com.sun.enterprise.config.serverbeans.Module;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.v3.deployment.DeployDirCommand;
import com.sun.enterprise.v3.deployment.ListComponentsCommand;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommandContext;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@Service(name="list-applications")
@I18n(value="list.applications")
@Scoped(value=PerLookup.class)
public class ListApplicationsCommand
extends ListComponentsCommand {
    @Param(optional=true, acceptableValues="application, ejb, web, connector, webservice, jruby")
    String type = null;
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(DeployDirCommand.class);

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        if (!this.checkTypeValue(this.type, report)) {
            return;
        }
        ActionReport.MessagePart part = report.getTopMessagePart();
        int numOfApplications = 0;
        for (Module module : this.applications.getModules()) {
            Application app;
            if (!(module instanceof Application) || !(app = (Application)module).getObjectType().equals("user") || this.type != null && !this.isApplicationOfThisType(app, this.type)) continue;
            ActionReport.MessagePart childPart = part.addChild();
            childPart.setMessage(app.getName() + " " + this.getSnifferEngines(app, true));
            childPart.addProperty("nb-name", app.getName());
            childPart.addProperty("nb-location", app.getLocation());
            childPart.addProperty("nb-engine", this.getSnifferEngines(app, false));
            childPart.addProperty("nb-enabled", app.getEnabled());
            childPart.addProperty("nb-directory-deployed", app.getDirectoryDeployed());
            childPart.addProperty("nb-context-root", app.getContextRoot() == null ? "" : app.getContextRoot());
            ++numOfApplications;
        }
        if (numOfApplications == 0) {
            part.setMessage(localStrings.getLocalString("list.components.no.elements.to.list", "Nothing to List."));
        }
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }
}

