/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.deployment;

import com.sun.enterprise.config.serverbeans.Application;
import com.sun.enterprise.config.serverbeans.Applications;
import com.sun.enterprise.config.serverbeans.Engine;
import com.sun.enterprise.config.serverbeans.Module;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.v3.server.ApplicationLifecycle;
import java.util.List;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.container.Sniffer;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@Service(name="list-components")
@I18n(value="list.components")
@Scoped(value=PerLookup.class)
public class ListComponentsCommand
extends ApplicationLifecycle
implements AdminCommand {
    @Inject
    Applications applications;
    @Param(optional=true, acceptableValues="application, ejb, web, connector, webservice, jruby")
    String type = null;
    private final String VALID_TYPES = "application|ejb|web|connector|webservice|jruby";
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(ListComponentsCommand.class);

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        if (!this.checkTypeValue(this.type, report)) {
            return;
        }
        ActionReport.MessagePart part = report.getTopMessagePart();
        int numOfApplications = 0;
        for (Module module : this.applications.getModules()) {
            Application app;
            if (!(module instanceof Application) || !(app = (Application)module).getObjectType().equals("user") || this.type != null && !this.isApplicationOfThisType(app, this.type)) continue;
            ActionReport.MessagePart childPart = part.addChild();
            childPart.setMessage(app.getName() + " " + this.getSnifferEngines(app, true));
            ++numOfApplications;
        }
        if (numOfApplications == 0) {
            part.setMessage(localStrings.getLocalString("list.components.no.elements.to.list", "Nothing to List."));
        }
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }

    boolean checkTypeValue(String type, ActionReport report) {
        if (type != null && !type.matches("application|ejb|web|connector|webservice|jruby")) {
            report.setMessage(localStrings.getLocalString("list.components.command.invalid.type", "Invalid type value, " + type, new Object[]{type}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return false;
        }
        return true;
    }

    boolean isApplicationOfThisType(Application app, String type) {
        List engineList = app.getEngine();
        for (Engine engine : engineList) {
            if (!engine.getSniffer().equals(type)) continue;
            return true;
        }
        return false;
    }

    String getSnifferEngines(Application app, boolean format) {
        List engineList = app.getEngine();
        StringBuffer se = new StringBuffer();
        if (!engineList.isEmpty()) {
            if (format) {
                se.append("<");
            }
            for (Engine engine : engineList) {
                String engType = engine.getSniffer();
                if (!this.displaySnifferEngine(engType)) continue;
                se.append(engine.getSniffer() + ", ");
            }
            if (se.length() > 2) {
                se.replace(se.length() - 2, se.length(), format ? ">" : "");
            } else if (format) {
                se.append(">");
            }
        }
        return se.toString();
    }

    boolean displaySnifferEngine(String engType) {
        Sniffer sniffer = this.getSniffer(engType);
        return sniffer.isUserVisible();
    }
}

