/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.server;

import com.sun.enterprise.module.ModulesRegistry;
import com.sun.enterprise.module.bootstrap.ModuleStartup;
import com.sun.enterprise.module.bootstrap.StartupContext;
import com.sun.enterprise.v3.admin.AdminAdapter;
import com.sun.enterprise.v3.admin.adapter.AdminConsoleAdapter;
import com.sun.enterprise.v3.server.ServerEnvironment;
import com.sun.logging.LogDomains;
import java.util.Calendar;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.Async;
import org.glassfish.api.Startup;
import org.glassfish.internal.api.Init;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.Inhabitant;

@Service
public class AppServerStartup
implements ModuleStartup {
    StartupContext context;
    static final Logger logger = LogDomains.getLogger((String)"javax.enterprise.system.core");
    @Inject
    ServerEnvironment env;
    @Inject
    Habitat habitat;
    @Inject
    ModulesRegistry systemRegistry;

    @Inject
    public void setStartupContext(StartupContext context) {
        this.context = context;
    }

    public void run() {
        logger.fine("HK2 initialized in " + (System.currentTimeMillis() - this.context.getCreationTime()) + " ms");
        if (this.context == null) {
            System.err.println("Startup context not provided, cannot continue");
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Startup class : " + this.getClass().getName());
        }
        this.habitat.addComponent(null, (Object)this.systemRegistry);
        this.habitat.addComponent("javax.enterprise.system.core", (Object)logger);
        Collection inits = this.habitat.getAllByContract(Init.class);
        for (Init init : inits) {
            logger.fine(init + " Init done in " + (System.currentTimeMillis() - this.context.getCreationTime()) + " ms");
        }
        logger.fine("Init done in " + (System.currentTimeMillis() - this.context.getCreationTime()) + " ms");
        Thread t = new Thread(new Runnable(){

            public void run() {
                for (Inhabitant i : AppServerStartup.this.habitat.getInhabitants(Startup.class)) {
                    if (i.type().getAnnotation(Async.class) == null) continue;
                    i.get();
                }
            }
        }, "AppServerStartup");
        t.start();
        for (Inhabitant i : this.habitat.getInhabitants(Startup.class)) {
            if (i.type().getAnnotation(Async.class) != null) continue;
            i.get();
            if (!logger.isLoggable(Level.FINE)) continue;
            logger.info(i.get() + " startup done in " + (System.currentTimeMillis() - this.context.getCreationTime()) + " ms");
        }
        logger.info("Glassfish v3 started in " + (Calendar.getInstance().getTimeInMillis() - this.context.getCreationTime()) + " ms");
        try {
            t.join(1000L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        AdminAdapter admin = (AdminAdapter)this.habitat.getComponent(AdminAdapter.class);
        admin.ready();
        AdminConsoleAdapter ac = (AdminConsoleAdapter)((Object)this.habitat.getComponent(AdminConsoleAdapter.class));
        ac.ready();
    }
}

