/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.services.impl;

import com.sun.enterprise.v3.services.impl.ContextRootMapper;
import com.sun.enterprise.v3.services.impl.GlassfishProtocolChain;
import com.sun.enterprise.v3.services.impl.GrizzlyEmbeddedHttp;
import com.sun.enterprise.v3.services.impl.GrizzlyUtils;
import com.sun.enterprise.v3.services.impl.HttpUtils;
import com.sun.grizzly.Context;
import com.sun.grizzly.ProtocolFilter;
import com.sun.grizzly.http.HtmlHelper;
import com.sun.grizzly.tcp.Adapter;
import com.sun.grizzly.tcp.Request;
import com.sun.grizzly.tcp.Response;
import com.sun.grizzly.tcp.StaticResourcesAdapter;
import com.sun.grizzly.util.ByteBufferInputStream;
import com.sun.grizzly.util.OutputWriter;
import com.sun.grizzly.util.WorkerThread;
import com.sun.grizzly.util.buf.ByteChunk;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectableChannel;
import java.util.logging.Level;

public class HttpProtocolFilter
implements ProtocolFilter {
    private GrizzlyEmbeddedHttp grizzlyEmbeddedHttp;
    private final ProtocolFilter wrappedFilter;
    private ContextRootMapper.ContextRootInfo fallbackContextRootInfo;
    private static byte[] errorBody = HttpUtils.getErrorPage("Glassfish/v3", "HTTP Status 404");

    public HttpProtocolFilter(ProtocolFilter wrappedFilter, GrizzlyEmbeddedHttp grizzlyEmbeddedHttp) {
        this.grizzlyEmbeddedHttp = grizzlyEmbeddedHttp;
        this.wrappedFilter = wrappedFilter;
        StaticResourcesAdapter adapter = new StaticResourcesAdapter(){

            protected void customizedErrorPage(Request req, Response res) throws Exception {
                ByteChunk chunk = new ByteChunk();
                chunk.setBytes(errorBody, 0, errorBody.length);
                res.setContentLength(errorBody.length);
                res.sendHeaders();
                res.doWrite(chunk);
            }
        };
        adapter.setRootFolder(GrizzlyEmbeddedHttp.getWebAppRootPath());
        this.fallbackContextRootInfo = new ContextRootMapper.ContextRootInfo((Adapter)adapter, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(Context ctx) throws IOException {
        block8: {
            WorkerThread thread = (WorkerThread)Thread.currentThread();
            ByteBuffer byteBuffer = thread.getByteBuffer();
            try {
                if (byteBuffer.position() < 5 && GrizzlyUtils.readToWorkerThreadBuffers(ctx.getSelectionKey(), ByteBufferInputStream.getDefaultReadTimeout()) == -1) {
                    ctx.setKeyRegistrationState(Context.KeyRegistrationState.CANCEL);
                    return false;
                }
                boolean wasMap = this.grizzlyEmbeddedHttp.getContextRootMapper().map((GlassfishProtocolChain)ctx.getProtocolChain(), byteBuffer, null, this.fallbackContextRootInfo);
                if (wasMap) break block8;
                try {
                    ByteBuffer bb = HtmlHelper.getErrorPage((String)"Not Found", (String)"HTTP/1.1 404 Not Found\n");
                    OutputWriter.flushChannel((SelectableChannel)ctx.getSelectionKey().channel(), (ByteBuffer)bb);
                }
                catch (IOException ex) {
                    GrizzlyEmbeddedHttp.logger().log(Level.FINE, "Send Error failed", ex);
                }
                finally {
                    thread.getByteBuffer().clear();
                }
                return false;
            }
            catch (IOException ex) {
                GrizzlyEmbeddedHttp.logger().fine(ex.getMessage());
            }
        }
        return this.wrappedFilter.execute(ctx);
    }

    public boolean postExecute(Context ctx) throws IOException {
        return this.wrappedFilter.postExecute(ctx);
    }

    public void setFallbackAdapter(Adapter adapter) {
        this.fallbackContextRootInfo.setAdapter(adapter);
    }

    public Adapter getFallbackAdapter() {
        return this.fallbackContextRootInfo.getAdapter();
    }
}

