/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.deployment.autodeploy;

import com.sun.enterprise.config.serverbeans.DasConfig;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.logging.LogDomains;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipFile;
import org.glassfish.deployment.autodeploy.AutoDeployer;
import org.glassfish.deployment.autodeploy.AutoDeploymentException;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PostConstruct;

@Service
public class AutodeployRetryManager
implements PostConstruct {
    private final int RETRY_LIMIT_DEFAULT = 30;
    private HashMap<File, Info> invalidFiles = new HashMap();
    private static final Logger sLogger = LogDomains.getLogger((String)"javax.enterprise.system.tools.deployment");
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(AutodeployRetryManager.class);
    @Inject
    private DasConfig activeDasConfig;
    private int timeout = 30;

    public void postConstruct() {
        this.setTimeout();
    }

    AutoDeployer.AutodeploymentStatus testFileAsArchive(String file) throws AutoDeploymentException {
        AutoDeployer.AutodeploymentStatus result;
        try {
            File inFile = new File(file);
            if (!inFile.isDirectory()) {
                if (file.endsWith(".class")) {
                    return AutoDeployer.AutodeploymentStatus.SUCCESS;
                }
                ZipFile zipFile = this.openFileAsZipFile(inFile);
                if (zipFile != null) {
                    result = AutoDeployer.AutodeploymentStatus.SUCCESS;
                    zipFile.close();
                } else {
                    result = AutoDeployer.AutodeploymentStatus.PENDING;
                }
            } else {
                result = AutoDeployer.AutodeploymentStatus.SUCCESS;
            }
        }
        catch (AutoDeploymentException ade) {
            result = AutoDeployer.AutodeploymentStatus.FAILURE;
        }
        catch (IOException ioe) {
            String msg = localStrings.getLocalString("enterprise.deployment.autodeploy.error_closing_archive", "error closing file {0} after testing it as an archive");
            throw new AutoDeploymentException(msg, ioe);
        }
        return result;
    }

    private ZipFile openFileAsZipFile(File f) throws AutoDeploymentException {
        ZipFile zipFile;
        block2: {
            zipFile = null;
            try {
                zipFile = new ZipFile(f);
                this.recordSuccessfulOpen(f);
            }
            catch (IOException ioe) {
                boolean failedPreviously;
                String errorMsg = null;
                if (zipFile != null || (failedPreviously = this.recordFailedOpen(f))) break block2;
                Info info = this.get(f);
                errorMsg = localStrings.getLocalString("enterprise.deployment.autodeploy.error_opening_start_retry", "error opening {0} as JAR; may be slow copy; starting retry until {1}", new Object[]{f, new Date(info.retryExpiration).toString()});
                sLogger.log(Level.INFO, errorMsg);
            }
        }
        return zipFile;
    }

    Info get(File file) {
        Info info = this.invalidFiles.get(file);
        return info;
    }

    boolean shouldOpen(File file) {
        boolean result = true;
        String msg = null;
        boolean loggable = sLogger.isLoggable(Level.FINE);
        Info info = this.invalidFiles.get(file);
        if (info != null) {
            result = info.shouldOpen();
            if (loggable) {
                msg = result ? localStrings.getLocalString("enterprise.deployment.autodeploy.try_stable_length", "file {0} has stable length so it should open as a JAR", new Object[]{file.getAbsolutePath()}) : localStrings.getLocalString("enterprise.deployment.autodeploy.no_try_unstable_length", "file {0} has an unstable length of {1}; do not retry yet", new Object[]{file.getAbsolutePath(), String.valueOf(file.length())});
            }
            info.update();
        } else if (loggable) {
            msg = localStrings.getLocalString("enterprise.deployment.autodeploy.try_not_monitored", "file {0} should be opened as an archive because it is not being monitored as a slowly-growing file", new Object[]{file.getAbsolutePath()});
        }
        if (loggable) {
            sLogger.log(Level.FINE, msg);
        }
        return result;
    }

    boolean recordFailedDeployment(File file) throws AutoDeploymentException {
        return this.recordFailedOpen(file);
    }

    boolean recordSuccessfulDeployment(File file) {
        return this.recordSuccessfulOpen(file);
    }

    boolean recordSuccessfulUndeployment(File file) {
        return this.endMonitoring(file);
    }

    boolean recordFailedUndeployment(File file) {
        return this.endMonitoring(file);
    }

    boolean endMonitoring(File file) {
        return this.invalidFiles.remove(file) != null;
    }

    private boolean recordFailedOpen(File file) throws AutoDeploymentException {
        Info info = this.get(file);
        boolean fileAlreadyPresent = info != null;
        if (!fileAlreadyPresent) {
            info = this.createInfo(file);
            this.invalidFiles.put(file, info);
            if (sLogger.isLoggable(Level.FINE)) {
                String msg = localStrings.getLocalString("enterprise.deployment.autodeploy.begin_monitoring", "will monitor {0} waiting for its size to be stable size until {1}", new Object[]{file.getAbsolutePath(), new Date(info.retryExpiration).toString()});
                sLogger.log(Level.FINE, msg);
            }
        } else {
            info.update();
            boolean loggable = sLogger.isLoggable(Level.FINE);
            if (!info.hasRetryPeriodExpired()) {
                if (loggable) {
                    String msg = localStrings.getLocalString("enterprise.deployment.autodeploy.continue_monitoring", "file {0} remains eligible for monitoring until {1}", new Object[]{file.getAbsolutePath(), new Date(info.retryExpiration).toString()});
                    sLogger.log(Level.FINE, msg);
                }
            } else {
                String msg = localStrings.getLocalString("enterprise.deployment.autodeploy.abort_monitoring", "File {0} is no longer eligible for retry; its size has been stable for {1} second{1,choice,0#s|1#|1<s} but it is still unrecognized as an archive", new Object[]{file.getAbsolutePath(), this.timeout});
                if (loggable) {
                    sLogger.log(Level.FINE, msg);
                }
                this.invalidFiles.remove(file);
                throw new AutoDeploymentException(msg);
            }
        }
        return fileAlreadyPresent;
    }

    private boolean recordSuccessfulOpen(File file) {
        if (sLogger.isLoggable(Level.FINE)) {
            String msg = localStrings.getLocalString("enterprise.deployment.autodeploy.end_monitoring", "File {0} opened successfully; no need to monitor it further", new Object[]{file.getAbsolutePath()});
            sLogger.log(Level.FINE, msg);
        }
        return this.invalidFiles.remove(file) != null;
    }

    private void setTimeout() {
        int newTimeout = this.timeout;
        String timeoutText = this.activeDasConfig.getAutodeployRetryTimeout();
        if (timeoutText == null || timeoutText.equals("")) {
            this.timeout = 30;
            return;
        }
        try {
            int configuredTimeout = Integer.parseInt(timeoutText);
            if (configuredTimeout > 1000) {
                sLogger.warning(localStrings.getLocalString("enterprise.deployment.autodeploy.configured_timeout_large", "Configured timeout value of {0} second{0,choice,0#s|1#|1<s} will be used but seems very large", new Object[]{configuredTimeout}));
                newTimeout = configuredTimeout;
            } else if (configuredTimeout <= 0) {
                sLogger.warning(localStrings.getLocalString("enterprise.deployment.autodeploy.configured_timeout_small", "Configured timeout value of {0} second{0,choice,0#s|1#|1<s} is too small; using previous value of {1} second{1,choice,0#s|1#|1<s}", new Object[]{configuredTimeout, this.timeout}));
            } else {
                newTimeout = configuredTimeout;
            }
        }
        catch (NumberFormatException ex) {
            sLogger.warning(localStrings.getLocalString("enterprise.deployment.autodeploy.configured_timeout_invalid", "Could not convert configured timeout value of \"{0}\" to a number; using previous value of {1} second{1,choice,0#s|1#|1<s}", new Object[]{timeoutText, this.timeout}));
        }
        this.timeout = newTimeout;
    }

    private Info createInfo(File f) {
        if (f.isDirectory()) {
            return new DirectoryInfo(f);
        }
        return new JarInfo(f);
    }

    private class DirectoryInfo
    extends Info {
        private long whenScanned;

        public DirectoryInfo(File f) {
            super(f);
            this.whenScanned = 0L;
        }

        protected boolean shouldOpen() {
            return true;
        }

        protected boolean update() {
            long newWhenScanned = System.currentTimeMillis();
            boolean hasChanged = this.isNewerFile(this.file, this.whenScanned);
            if (hasChanged) {
                this.postponeRetryExpiration();
            }
            this.whenScanned = newWhenScanned;
            return hasChanged;
        }

        private boolean isNewerFile(File f, long timestamp) {
            boolean aFileIsNewer;
            boolean bl = aFileIsNewer = f.lastModified() > timestamp;
            if (!aFileIsNewer && f.isDirectory()) {
                File containedFile;
                File[] arr$ = f.listFiles();
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$ && !(aFileIsNewer = this.isNewerFile(containedFile = arr$[i$], timestamp)); ++i$) {
                }
            }
            return aFileIsNewer;
        }
    }

    private class JarInfo
    extends Info {
        private long recordedLength;

        public JarInfo(File f) {
            super(f);
            this.recordedLength = 0L;
        }

        protected boolean shouldOpen() {
            return this.file.length() == this.recordedLength;
        }

        protected boolean update() {
            long currentLength = this.file.length();
            boolean hasChanged = this.recordedLength != currentLength;
            if (hasChanged) {
                this.postponeRetryExpiration();
            }
            this.recordedLength = currentLength;
            return hasChanged;
        }
    }

    private abstract class Info {
        protected File file = null;
        protected long retryExpiration = 0L;

        public Info(File file) {
            this.file = file;
            this.update();
        }

        protected abstract boolean shouldOpen();

        protected abstract boolean update();

        private boolean hasRetryPeriodExpired() {
            return System.currentTimeMillis() > this.retryExpiration;
        }

        protected void postponeRetryExpiration() {
            this.retryExpiration = System.currentTimeMillis() + (long)(AutodeployRetryManager.this.timeout * 1000);
        }
    }
}

