/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.universal;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Vector;

public class StringUtils {
    public static final String NEWLINE = System.getProperty("line.separator");

    private StringUtils() {
    }

    public static String formatSQLException(SQLException ex) {
        String s = "SQLException:\n";
        do {
            s = s + "SQLState: " + ex.getSQLState() + "\n";
            s = s + "Message:  " + ex.getMessage() + "\n";
            s = s + "Vendor:   " + ex.getErrorCode() + "\n";
            s = s + "\n";
        } while ((ex = ex.getNextException()) != null);
        return s;
    }

    public static int maxWidth(Vector v) {
        int max = 0;
        if (v == null || v.size() <= 0 || !(v.elementAt(0) instanceof String)) {
            return 0;
        }
        for (int i = v.size() - 1; i >= 0; --i) {
            int len = ((String)v.elementAt(i)).length();
            if (len <= max) continue;
            max = len;
        }
        return max;
    }

    public static boolean isHex(String s) {
        int slen = s.length();
        for (int i = 0; i < slen; ++i) {
            if (StringUtils.isHex(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isHex(char c) {
        String hex = "0123456789abcdefABCDEF";
        int hexlen = hex.length();
        for (int i = 0; i < hexlen; ++i) {
            if (hex.charAt(i) != c) continue;
            return true;
        }
        return false;
    }

    public static String getPenultimateDirName(String s) {
        if (s == null || s.length() <= 0) {
            return s;
        }
        if (s.indexOf(47) < 0 && s.indexOf(92) < 0) {
            return "";
        }
        int index = (s = s.replace('\\', '/')).lastIndexOf(47);
        if (index < 0) {
            return "";
        }
        if ((index = (s = s.substring(0, index)).lastIndexOf(47)) >= 0) {
            s = s.substring(index + 1);
        }
        return s;
    }

    public static String toShortClassName(String className) {
        int index = className.lastIndexOf(46);
        if (index >= 0 && index < className.length() - 1) {
            return className.substring(index + 1);
        }
        return className;
    }

    public static String padRight(String s, int len) {
        if (s == null || s.length() >= len) {
            return s;
        }
        for (int i = len - s.length(); i > 0; --i) {
            s = s + ' ';
        }
        return s;
    }

    public static String padLeft(String s, int len, char c) {
        String ss = "";
        if (s == null || s.length() >= len) {
            return s;
        }
        for (int i = len - s.length(); i > 0; --i) {
            ss = ss + c;
        }
        return ss + s;
    }

    public static String padLeft(String s, int len) {
        return StringUtils.padLeft(s, len, ' ');
    }

    public static String[] toLines(String s) {
        if (s == null) {
            return new String[0];
        }
        ArrayList<String> list = new ArrayList<String>();
        int start = 0;
        int end = 0;
        end = s.indexOf(10, start);
        while (end >= 0 && start < s.length()) {
            list.add(s.substring(start, end));
            start = end + 1;
            end = s.indexOf(10, start);
        }
        if (start < s.length()) {
            list.add(s.substring(start));
        }
        String[] ss = new String[list.size()];
        list.toArray(ss);
        return ss;
    }

    public static void prepend(String[] ss, String what) {
        for (int i = 0; i < ss.length; ++i) {
            ss[i] = what + ss[i];
        }
    }

    public static String UpperCaseFirstLetter(String s) {
        if (s == null || s.length() <= 0) {
            return s;
        }
        return s.substring(0, 1).toUpperCase() + s.substring(1);
    }

    public static String replace(String s, String token, String replace) {
        if (s == null || s.length() <= 0 || token == null || token.length() <= 0) {
            return s;
        }
        int index = s.indexOf(token);
        if (index < 0) {
            return s;
        }
        int tokenLength = token.length();
        String ret = s.substring(0, index);
        ret = ret + replace;
        ret = ret + s.substring(index + tokenLength);
        return ret;
    }

    public static boolean isAllWhite(String s) {
        if (s == null) {
            return true;
        }
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            if (Character.isWhitespace(c)) continue;
            return false;
        }
        return true;
    }

    public static void main(String[] args) {
        int len = args.length;
        if (len == 1 && args[0].equalsIgnoreCase("toLine")) {
            StringUtils.testToLine();
        } else if (len > 1 && args[0].equalsIgnoreCase("isHex")) {
            StringUtils.testHex(args);
        } else {
            StringUtils.usage();
        }
    }

    private static void usage() {
        System.out.println("StringUtils -- main() for testing usage:\n");
        System.out.println("java netscape.blizzard.util.StringUtils toLine");
        System.out.println("java netscape.blizzard.util.StringUtils isHex number1 number2 ...");
    }

    private static void testHex(String[] args) {
        System.out.println("StringUtils -- Testing Hex");
        for (int i = 1; i < args.length; ++i) {
            System.out.println(StringUtils.padRight(args[i], 16) + "  " + (StringUtils.isHex(args[i]) ? "yesHex" : "notHex"));
        }
    }

    private static void testToLine() {
        System.out.println("StringUtils -- Testing toLine()");
        String[] ss = new String[]{null, "", "abc\ndef\n", "abc\ndef", "abc", "abc\n", "abc\n\n", "q", "\n\nk\n\nz\n\n", "sd.adj;ld"};
        for (int k = 0; k < ss.length; ++k) {
            String[] s2 = StringUtils.toLines(ss[k]);
            System.out.println("String #" + k + ", Number of Lines:  " + s2.length);
            for (int i = 0; i < s2.length; ++i) {
                System.out.println(s2[i]);
            }
        }
    }

    public static void testUpperCase() {
        String[] test = new String[]{"xyz", "HITHERE", "123aa", "aSSS", "yothere"};
        for (int i = 0; i < test.length; ++i) {
            System.out.println(test[i] + " >>> " + StringUtils.UpperCaseFirstLetter(test[i]));
        }
    }

    public static boolean ok(String s) {
        return s != null && s.length() > 0;
    }

    public static String removeEnclosingQuotes(String s) {
        if (s == null) {
            return null;
        }
        if (StringUtils.isDoubleQuoted(s) || StringUtils.isSingleQuoted(s)) {
            return s.substring(1, s.length() - 1);
        }
        return s;
    }

    private static boolean isDoubleQuoted(String s) {
        return s.startsWith("\"") && s.endsWith("\"") && s.length() > 1;
    }

    private static boolean isSingleQuoted(String s) {
        return s.startsWith("'") && s.endsWith("'") && s.length() > 1;
    }
}

