/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.naming.pcosnaming;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

class CounterDB {
    public static final int rootCounter = 0;
    private static final String counterFileName = "counter";
    private Integer counter;
    private transient File counterFile;

    CounterDB(File logDir) {
        this.counterFile = new File(logDir, counterFileName);
        if (!this.counterFile.exists()) {
            this.counter = 0;
            this.writeCounter();
        } else {
            this.readCounter();
        }
    }

    private void readCounter() {
        try {
            FileInputStream fis = new FileInputStream(this.counterFile);
            ObjectInputStream ois = new ObjectInputStream(fis);
            this.counter = (Integer)ois.readObject();
            ois.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void writeCounter() {
        try {
            this.counterFile.delete();
            FileOutputStream fos = new FileOutputStream(this.counterFile);
            ObjectOutputStream oos = new ObjectOutputStream(fos);
            oos.writeObject(this.counter);
            oos.flush();
            oos.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public synchronized int getNextCounter() {
        int counterVal = this.counter;
        this.counter = ++counterVal;
        this.writeCounter();
        return counterVal;
    }
}

