/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rx.rm.faults;

import com.sun.xml.ws.api.SOAPVersion;
import com.sun.xml.ws.api.addressing.AddressingVersion;
import com.sun.xml.ws.api.message.Message;
import com.sun.xml.ws.api.message.Messages;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.rx.RxRuntimeException;
import com.sun.xml.ws.rx.rm.runtime.RmRuntimeVersion;
import com.sun.xml.ws.rx.rm.runtime.RuntimeContext;
import com.sun.xml.ws.rx.rm.runtime.sequence.Sequence;
import java.util.List;
import java.util.Locale;
import javax.xml.namespace.QName;
import javax.xml.soap.Detail;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFault;

public abstract class AbstractSoapFaultException
extends RxRuntimeException {
    private final boolean mustTryTodeliver;
    private final String faultReasonText;

    protected AbstractSoapFaultException(String exceptionMessage, String faultReasonText, boolean mustTryToDeliver, Throwable cause) {
        super(exceptionMessage, cause);
        this.faultReasonText = faultReasonText;
        this.mustTryTodeliver = mustTryToDeliver;
    }

    protected AbstractSoapFaultException(String exceptionMessage, String faultReasonText, boolean mustTryToDeliver) {
        super(exceptionMessage);
        this.faultReasonText = faultReasonText;
        this.mustTryTodeliver = mustTryToDeliver;
    }

    public abstract Code getCode();

    public abstract QName getSubcode(RmRuntimeVersion var1);

    public final String getReason() {
        return this.faultReasonText;
    }

    public abstract Detail getDetail(RuntimeContext var1);

    public boolean mustTryToDeliver() {
        return this.mustTryTodeliver;
    }

    public Packet toRequest(RuntimeContext rc) {
        return rc.communicator.createRequestPacket(this.createSoapFaultMessage(rc, true), AbstractSoapFaultException.getProperFaultActionForAddressingVersion(rc.rmVersion, rc.addressingVersion), false);
    }

    public Packet toResponse(RuntimeContext rc, Packet request) {
        return rc.communicator.createResponsePacket(request, this.createSoapFaultMessage(rc, true), AbstractSoapFaultException.getProperFaultActionForAddressingVersion(rc.rmVersion, rc.addressingVersion));
    }

    protected final Message createSoapFaultMessage(RuntimeContext rc, boolean attachSequenceFaultElement) {
        try {
            SOAPFault soapFault = rc.soapVersion.saajSoapFactory.createFault();
            if (this.faultReasonText != null) {
                soapFault.setFaultString(this.faultReasonText, Locale.ENGLISH);
            }
            Detail detail = this.getDetail(rc);
            switch (rc.soapVersion) {
                case SOAP_11: {
                    soapFault.setFaultCode(this.getSubcode(rc.rmVersion));
                    break;
                }
                case SOAP_12: {
                    soapFault.setFaultCode(this.getCode().asQName(rc.soapVersion));
                    soapFault.appendFaultSubcode(this.getSubcode(rc.rmVersion));
                    if (detail == null) break;
                    soapFault.addChildElement(detail);
                    break;
                }
                default: {
                    throw new RxRuntimeException("Unsupported SOAP version: '" + rc.soapVersion.toString() + "'");
                }
            }
            Message soapFaultMessage = Messages.create(soapFault);
            if (attachSequenceFaultElement && rc.soapVersion == SOAPVersion.SOAP_11) {
                soapFaultMessage.getHeaders().add(rc.protocolHandler.createSequenceFaultElementHeader(this.getSubcode(rc.rmVersion), detail));
            }
            return soapFaultMessage;
        }
        catch (SOAPException ex) {
            throw new RxRuntimeException("Error creating a SOAP fault", ex);
        }
    }

    protected static String getProperFaultActionForAddressingVersion(RmRuntimeVersion rmVersion, AddressingVersion addressingVersion) {
        return addressingVersion == AddressingVersion.MEMBER ? addressingVersion.getDefaultFaultAction() : rmVersion.protocolVersion.wsrmFaultAction;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Code {
        Sender{

            QName asQName(SOAPVersion sv) {
                return sv.faultCodeClient;
            }
        }
        ,
        Receiver{

            QName asQName(SOAPVersion sv) {
                return sv.faultCodeServer;
            }
        };


        abstract QName asQName(SOAPVersion var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static final class DetailBuilder {
        private final RuntimeContext rc;
        private final Detail detail;

        public DetailBuilder(RuntimeContext rc) {
            this.rc = rc;
            try {
                this.detail = rc.soapVersion.saajSoapFactory.createDetail();
            }
            catch (SOAPException ex) {
                throw new RxRuntimeException("Error creating a SOAP fault detail", ex);
            }
        }

        public Detail build() {
            return this.detail;
        }

        public DetailBuilder addSequenceIdentifier(String sequenceId) {
            try {
                this.detail.addDetailEntry(new QName(this.rc.rmVersion.protocolVersion.protocolNamespaceUri, "Identifier")).setValue(sequenceId);
            }
            catch (SOAPException ex) {
                throw new RxRuntimeException("Error creating a SOAP fault detail", ex);
            }
            return this;
        }

        public DetailBuilder addMaxMessageNumber(long number) {
            try {
                this.detail.addDetailEntry(new QName(this.rc.rmVersion.protocolVersion.protocolNamespaceUri, "MaxMessageNumber")).setValue(Long.toString(number));
            }
            catch (SOAPException ex) {
                throw new RxRuntimeException("Error creating a SOAP fault detail", ex);
            }
            return this;
        }

        public DetailBuilder addSequenceAcknowledgement(List<Sequence.AckRange> ackedRanges) {
            return this;
        }
    }
}

