/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.interceptor.proxy;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.interceptor.InvocationContext;
import org.jboss.interceptor.InterceptorException;
import org.jboss.interceptor.model.InterceptionType;
import org.jboss.interceptor.model.InterceptorMetadata;
import org.jboss.interceptor.model.metadata.MethodReference;
import org.jboss.interceptor.proxy.InterceptionHandler;
import org.jboss.interceptor.util.ReflectionUtils;

public abstract class AbstractClassInterceptionHandler
implements InterceptionHandler,
Serializable {
    private InterceptorMetadata interceptorMetadata;

    public abstract Object getInterceptorInstance();

    public AbstractClassInterceptionHandler(InterceptorMetadata interceptorMetadata) {
        this.interceptorMetadata = interceptorMetadata;
    }

    public Object invoke(Object target, InterceptionType interceptionType, InvocationContext invocationContext) throws Exception {
        List<MethodReference> methods = this.interceptorMetadata.getInterceptorMethods(interceptionType);
        if (methods != null) {
            DelegatingInvocationContext delegatingInvocationContext = new DelegatingInvocationContext(invocationContext, this.getInterceptorInstance(), methods, interceptionType);
            return delegatingInvocationContext.proceed();
        }
        throw new InterceptorException(target.toString() + " was requested to perform " + interceptionType.name() + " but no such method is defined on it");
    }

    public InterceptorMetadata getInterceptorMetadata() {
        return this.interceptorMetadata;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class DelegatingInvocationContext
    implements InvocationContext {
        private InvocationContext delegateInvocationContext;
        private Object targetObject;
        private InterceptionType interceptionType;
        private Queue<MethodReference> invocationQueue;

        public DelegatingInvocationContext(InvocationContext delegateInvocationContext, Object targetObject, List<MethodReference> methods, InterceptionType interceptionType) {
            this.delegateInvocationContext = delegateInvocationContext;
            this.targetObject = targetObject;
            this.interceptionType = interceptionType;
            this.invocationQueue = new ConcurrentLinkedQueue<MethodReference>(methods);
        }

        public Map<String, Object> getContextData() {
            return this.delegateInvocationContext.getContextData();
        }

        public Method getMethod() {
            return this.delegateInvocationContext.getMethod();
        }

        public Object[] getParameters() {
            return this.delegateInvocationContext.getParameters();
        }

        public Object getTarget() {
            return this.delegateInvocationContext.getTarget();
        }

        public Object proceed() throws Exception {
            if (!this.invocationQueue.isEmpty()) {
                try {
                    if (AbstractClassInterceptionHandler.this.interceptorMetadata.isTargetClass() && this.interceptionType.isLifecycleCallback()) {
                        for (MethodReference interceptorMethod : this.invocationQueue) {
                            ReflectionUtils.ensureAccessible(interceptorMethod.getJavaMethod());
                            interceptorMethod.getJavaMethod().invoke(this.targetObject, new Object[0]);
                        }
                        return null;
                    }
                    MethodReference interceptorMethod = this.invocationQueue.remove();
                    ReflectionUtils.ensureAccessible(interceptorMethod.getJavaMethod());
                    if (interceptorMethod.getJavaMethod().getParameterTypes().length == 0) {
                        return interceptorMethod.getJavaMethod().invoke(this.targetObject, new Object[0]);
                    }
                    return interceptorMethod.getJavaMethod().invoke(this.targetObject, this);
                }
                catch (InvocationTargetException e) {
                    if (e.getCause() instanceof Exception) {
                        throw (Exception)e.getCause();
                    }
                    throw new InterceptorException(e);
                }
            }
            return this.delegateInvocationContext.proceed();
        }

        public void setParameters(Object[] params) {
            this.delegateInvocationContext.setParameters(params);
        }

        public Object getTimer() {
            return this.delegateInvocationContext.getTimer();
        }
    }
}

