/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.jdbc;

import com.sun.messaging.jmq.jmsserver.FaultInjection;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.config.BrokerConfig;
import com.sun.messaging.jmq.jmsserver.config.ConfigListener;
import com.sun.messaging.jmq.jmsserver.config.PropertyUpdateException;
import com.sun.messaging.jmq.jmsserver.persist.Store;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.ConnectionInfo;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.DBConstants;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.DBManager;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.Util;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.RuntimeFaultInjection;
import com.sun.messaging.jmq.util.SupportUtil;
import com.sun.messaging.jmq.util.log.Logger;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.PooledConnection;

public class DBConnectionPool
implements DBConstants {
    private static boolean DEBUG = false;
    public static final String REAP_INTERVAL_PROP = "imq.persist.jdbc.connection.reaptime";
    public static final int DEFAULT_REAP_INTERVAL = 300;
    public static final String TIMEOUT_IDLE_PROP = "imq.persist.jdbc.connection.timeoutIdle";
    public static final String NUM_CONN_PROP = "imq.persist.jdbc.connection.limit";
    public static final String MIN_CONN_PROP = "imq.persist.jdbc.min_connections";
    public static final String MAX_CONN_PROP = "imq.persist.jdbc.max_connections";
    static final int DEFAULT_NUM_CONN = 5;
    public static final String VALIDATION_QUERY_PROP = "imq.persist.jdbc.connection.validationQuery";
    public static final String VALIDATE_ON_GET_PROP = "imq.persist.jdbc.connection.validateOnGet";
    private static int minConnections;
    private static int maxConnections;
    private static boolean initialized;
    private static ReentrantLock lock;
    private static LinkedBlockingQueue<ConnectionInfo> idleConnections;
    private static ConcurrentHashMap<ConnectionInfo, Thread> activeConnections;
    private static Map<Object, ConnectionInfo> connMap;
    private static ConnectionReaperTask connectionReaper;
    private static ConnectionEventListener connectionListener;
    private static long reapInterval;
    private static DBManager dbmgr;
    private static Logger logger;
    protected static BrokerResources br;
    private static String validationQuery;
    private static boolean validateOnGet;
    private static boolean timeoutIdle;
    private static boolean isPoolDataSource;
    private static ConfigListener cfgListener;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void init(DBManager dBManager) throws BrokerException {
        if (!initialized) {
            lock.lock();
            try {
                long l;
                if (initialized) {
                    Object var7_1 = null;
                    lock.unlock();
                    return;
                }
                dbmgr = dBManager;
                isPoolDataSource = dbmgr.isPoolDataSource();
                validationQuery = Globals.getConfig().getProperty(VALIDATION_QUERY_PROP);
                if (validationQuery != null && validationQuery.trim().length() == 0) {
                    validationQuery = null;
                }
                DBConnectionPool.initValidationQuery();
                if (validationQuery != null) {
                    logger.log(8, "imq.persist.jdbc.connection.validationQuery=" + validationQuery);
                }
                validateOnGet = Globals.getConfig().getBooleanProperty(VALIDATE_ON_GET_PROP, Globals.getHAEnabled());
                logger.log(8, "imq.persist.jdbc.connection.validateOnGet=" + validateOnGet);
                timeoutIdle = Globals.getConfig().getBooleanProperty(TIMEOUT_IDLE_PROP, true);
                logger.log(8, "imq.persist.jdbc.connection.timeoutIdle=" + timeoutIdle);
                int n = Globals.getConfig().getIntProperty(NUM_CONN_PROP, 5);
                if (n < 1) {
                    n = 5;
                    logger.log(16, "Invalid number of connections specified, set to default of " + n);
                }
                if ((minConnections = Globals.getConfig().getIntProperty(MIN_CONN_PROP, n)) < 1) {
                    minConnections = n;
                    logger.log(16, "Invalid number of minimum connections specified, set to default of " + minConnections);
                }
                if ((maxConnections = Globals.getConfig().getIntProperty(MAX_CONN_PROP, n)) < minConnections) {
                    maxConnections = minConnections;
                    logger.log(16, "Invalid number of maximum connections specified, set to default of " + maxConnections);
                }
                if ((l = Globals.getConfig().getLongProperty(REAP_INTERVAL_PROP, 300L)) < 60L) {
                    l = 300L;
                    logger.log(16, "Invalid reap time interval for pool maintenance thread specified, set to default of " + l);
                }
                logger.log(8, "imq.persist.jdbc.connection.reaptime=" + l);
                reapInterval = l * 1000L;
                if (dbmgr.getCreateDBURL() != null && Globals.getConfig().getBooleanProperty("imq.persist.storecreate.all", false)) {
                    try {
                        Connection connection = dbmgr.connectToCreate();
                        connection.close();
                    }
                    catch (Exception exception) {
                        String string = dbmgr.getCreateDBURL();
                        logger.log(32, "B3073", (Object)string, (Throwable)exception);
                        throw new BrokerException(br.getString("B3073", string, exception));
                    }
                }
                if (connectionListener == null) {
                    connectionListener = new DBConnectionListener();
                }
                logger.log(8, "imq.persist.jdbc.min_connections=" + minConnections);
                logger.log(8, "imq.persist.jdbc.max_connections=" + maxConnections);
                for (int i = 0; i < minConnections; ++i) {
                    ConnectionInfo connectionInfo = DBConnectionPool.createConnection();
                    idleConnections.offer(connectionInfo);
                }
                Globals.getConfig().addListener(MIN_CONN_PROP, cfgListener);
                Globals.getConfig().addListener(MAX_CONN_PROP, cfgListener);
                Globals.getConfig().addListener(REAP_INTERVAL_PROP, cfgListener);
                if (connectionReaper != null) {
                    connectionReaper.cancel();
                }
                connectionReaper = new ConnectionReaperTask();
                Globals.getTimer().schedule((TimerTask)connectionReaper, reapInterval, reapInterval);
                initialized = true;
            }
            catch (Throwable throwable) {
                Object var7_3 = null;
                lock.unlock();
                throw throwable;
            }
            Object var7_2 = null;
            lock.unlock();
            {
            }
        }
    }

    public static Hashtable getDebugState() {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put("initialized", String.valueOf(initialized));
        hashtable.put("minConnections", String.valueOf(minConnections));
        hashtable.put("maxConnections", String.valueOf(maxConnections));
        hashtable.put("reapInterval", String.valueOf(reapInterval));
        hashtable.put("timeoutIdle", timeoutIdle);
        hashtable.put("validateQuery", Boolean.valueOf(validationQuery));
        hashtable.put("validateOnGet", validateOnGet);
        hashtable.put("isPoolDataSource", isPoolDataSource);
        hashtable.put("idleConnections.size", String.valueOf(idleConnections.size()));
        hashtable.put("activeConnections.size", String.valueOf(activeConnections.size()));
        return hashtable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void close() {
        if (!initialized) {
            return;
        }
        lock.lock();
        try {
            if (connectionReaper != null) {
                connectionReaper.cancel();
                connectionReaper = null;
            }
            Globals.getConfig().removeListener(MIN_CONN_PROP, cfgListener);
            Globals.getConfig().removeListener(MAX_CONN_PROP, cfgListener);
            Globals.getConfig().removeListener(REAP_INTERVAL_PROP, cfgListener);
            for (ConnectionInfo connectionInfo : idleConnections) {
                DBConnectionPool.destroyConnection(connectionInfo);
            }
            idleConnections.clear();
            initialized = false;
            Object var3_2 = null;
            lock.unlock();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            lock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void reset() throws BrokerException {
        if (Store.getDEBUG() || DEBUG) {
            logger.log(8, "DBConnectionPool.reset(): reset connection pool");
        }
        if (!initialized) {
            return;
        }
        ArrayList arrayList = new ArrayList(maxConnections);
        lock.lock();
        try {
            activeConnections.clear();
            idleConnections.drainTo(arrayList);
            for (int i = 0; i < minConnections; ++i) {
                ConnectionInfo connectionInfo = DBConnectionPool.createConnection();
                idleConnections.offer(connectionInfo);
            }
            for (ConnectionInfo connectionInfo : arrayList) {
                DBConnectionPool.destroyConnection(connectionInfo);
            }
            Object var4_4 = null;
            lock.unlock();
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            lock.unlock();
            throw throwable;
        }
    }

    private static ConnectionInfo createConnection() throws BrokerException {
        Object object = dbmgr.newConnection();
        ConnectionInfo connectionInfo = new ConnectionInfo(object, connectionListener);
        connMap.put(object, connectionInfo);
        return connectionInfo;
    }

    private static void destroyConnection(ConnectionInfo connectionInfo) {
        connectionInfo.destroy();
        connMap.remove(connectionInfo.getKey());
    }

    static Connection getConnection() throws BrokerException {
        Object object;
        Object object2;
        if (Store.getDEBUG() || DEBUG) {
            logger.log(8, "[" + Thread.currentThread() + "]DBConnectionPool.getConnection()[" + idleConnections.size() + ", " + activeConnections.size() + "]");
        }
        if (DEBUG) {
            object2 = FaultInjection.getInjection();
            if (((FaultInjection)object2).FAULT_INJECTION) {
                ((RuntimeFaultInjection)object2).checkFaultAndSleep("jdbc.getconn.1", null);
            }
        }
        object2 = null;
        boolean bl = false;
        boolean bl2 = false;
        ConnectionInfo connectionInfo = idleConnections.poll();
        if (connectionInfo == null && activeConnections.size() < maxConnections) {
            connectionInfo = DBConnectionPool.createConnection();
            try {
                object2 = connectionInfo.getConnection();
            }
            catch (Exception exception) {
                DBConnectionPool.destroyConnection(connectionInfo);
                throw new BrokerException(connectionInfo + exception.getMessage(), exception);
            }
            if (Store.getDEBUG() || DEBUG) {
                bl = true;
            }
        } else {
            while (connectionInfo == null) {
                try {
                    if ((Store.getDEBUG() || DEBUG) && !bl2) {
                        bl2 = true;
                    }
                    if ((connectionInfo = idleConnections.poll(60L, TimeUnit.SECONDS)) != null) continue;
                    object = new StringBuffer(1024);
                    for (Map.Entry entry : activeConnections.entrySet()) {
                        Thread thread = (Thread)entry.getValue();
                        ((StringBuffer)object).append("\n").append(thread.getName()).append(": using connection: ").append(entry.getKey());
                        StackTraceElement[] stackTraceElementArray = thread.getStackTrace();
                        for (int i = 0; i < stackTraceElementArray.length; ++i) {
                            ((StringBuffer)object).append("\n\tat " + stackTraceElementArray[i]);
                        }
                    }
                    String object32 = br.getKString("B1340", "[" + minConnections + "," + maxConnections + "]", 60) + "\n" + ((StringBuffer)object).toString();
                    logger.log(16, object32);
                    if (!Globals.getStore().closed()) continue;
                    throw new BrokerException(object32);
                }
                catch (Exception exception) {
                    if (exception instanceof BrokerException) {
                        throw (BrokerException)exception;
                    }
                    if (!Store.getDEBUG() && !DEBUG) continue;
                    logger.logStack(8, "DBConnectionPool.getConnection(): " + exception.getMessage(), exception);
                }
            }
            if (!DBConnectionPool.validateConnection(connectionInfo, validateOnGet, true)) {
                DBConnectionPool.destroyConnection(connectionInfo);
                try {
                    connectionInfo = DBConnectionPool.createConnection();
                    object2 = connectionInfo.getConnection();
                    logger.log(8, br.getString("B1149", "" + connectionInfo, dbmgr.getOpenDBURL()));
                }
                catch (Exception exception) {
                    DBConnectionPool.destroyConnection(connectionInfo);
                    String string = br.getString("B4206", dbmgr.getOpenDBURL());
                    logger.logStack(32, string, exception);
                    throw new BrokerException(string, exception);
                }
            }
            try {
                object2 = connectionInfo.getConnection();
            }
            catch (Exception exception) {
                DBConnectionPool.destroyConnection(connectionInfo);
                throw new BrokerException(connectionInfo + exception.getMessage(), exception);
            }
        }
        object = Thread.currentThread();
        activeConnections.put(connectionInfo, (Thread)object);
        if (Store.getDEBUG() || DEBUG) {
            logger.log(8, "DBConnectionPool.getConnection()[" + bl + "," + bl2 + "]: " + ((Thread)object).getName() + " [" + new Date() + "]: check out connection: 0x" + object2.hashCode() + connectionInfo);
        }
        return object2;
    }

    static void freeConnection(Connection connection, Throwable throwable) {
        if (Store.getDEBUG() || DEBUG) {
            logger.log(8, "DBConnectionPool.freeConnection(): connection: 0x" + connection.hashCode() + (throwable == null ? "" : ", ex=" + throwable));
        }
        if (isPoolDataSource) {
            try {
                connection.close();
            }
            catch (Exception exception) {
                logger.log(16, br.getKString("B2229", "0x" + connection.hashCode(), exception.toString()));
            }
            return;
        }
        ConnectionInfo connectionInfo = connMap.get(connection);
        if (connectionInfo == null) {
            logger.log(16, br.getKString("B2230", "0x" + connection.hashCode()));
            try {
                connection.close();
            }
            catch (Exception exception) {
                logger.log(16, br.getKString("B2229", "0x" + connection.hashCode(), exception.toString()));
            }
            return;
        }
        connectionInfo.setException(throwable);
        DBConnectionPool.returnConnection(connectionInfo, throwable);
    }

    static void returnConnection(ConnectionInfo connectionInfo, Throwable throwable) {
        DBConnectionPool.returnConnection(connectionInfo, throwable, false);
    }

    static void returnConnection(ConnectionInfo connectionInfo, Throwable throwable, boolean bl) {
        Thread thread;
        if (Store.getDEBUG() || DEBUG) {
            logger.log(8, "DBConnectionPool.returnConnection(): connection: " + connectionInfo + (throwable == null ? "" : ", ex=" + throwable) + (!bl ? "" : ", destroy=" + bl));
        }
        if ((thread = activeConnections.remove(connectionInfo)) == null) {
            if (bl) {
                logger.log(8, br.getKString("B1344", connectionInfo.toString(), throwable.toString()));
                if (!idleConnections.remove(connectionInfo) && (Store.getDEBUG() || DEBUG)) {
                    logger.log(8, "Destroy an inactive/non-idle database connection " + connectionInfo.toString());
                }
            } else if (Store.getDEBUG() || DEBUG) {
                logger.log(16, "DBConnectionPool.returnConnection(" + connectionInfo + (throwable == null ? "" : ", ex=" + throwable) + "): not found in connection pool\n" + SupportUtil.getStackTrace(""));
            } else {
                logger.log(16, br.getKString("B2228", "" + connectionInfo + "[" + (throwable == null ? "" : ", ex=" + throwable) + "]"));
            }
            DBConnectionPool.destroyConnection(connectionInfo);
        } else {
            if (bl) {
                logger.log(8, br.getKString("B1345", connectionInfo.toString(), throwable.toString()));
                DBConnectionPool.destroyConnection(connectionInfo);
                return;
            }
            if (throwable != null && !DBConnectionPool.validateConnection(connectionInfo, throwable instanceof SQLException || throwable.getCause() instanceof SQLException, false)) {
                DBConnectionPool.destroyConnection(connectionInfo);
                return;
            }
            connectionInfo.idleStart();
            idleConnections.offer(connectionInfo);
        }
    }

    private static void initValidationQuery() {
        if (dbmgr.isMysql()) {
            validationQuery = "/* ping */";
        } else if (dbmgr.isOracle()) {
            validationQuery = "SELECT 1 FROM DUAL";
        } else if (validationQuery == null && dbmgr.isStoreInited()) {
            try {
                validationQuery = "SELECT 1 FROM " + dbmgr.getDAOFactory().getVersionDAO().getTableName();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private static boolean validateConnection(ConnectionInfo var0, boolean var1_1, boolean var2_2) {
        block43: {
            block42: {
                block41: {
                    block40: {
                        block38: {
                            block39: {
                                var3_3 = var1_1;
                                var4_4 = null;
                                var5_5 = null;
                                var6_6 = null;
                                var0.setValidating(true);
                                var7_7 = var0.getKey();
                                if (!(var7_7 instanceof Connection)) break block38;
                                if (!((Connection)var7_7).isClosed()) break block39;
                                var8_9 = false;
                                var22_17 = null;
                                var0.setValidating(false);
                                var0.setException(null);
                                return var8_9;
                            }
                            if (Util.isConnectionError(var0.getException(), DBConnectionPool.dbmgr)) {
                                var8_10 = false;
                                var22_18 = null;
                                var0.setValidating(false);
                                var0.setException(null);
                                return var8_10;
                            }
                            break block40;
                        }
                        if (var0.getException() == null) break block40;
                        var8_11 = false;
                        var22_19 = null;
                        var0.setValidating(false);
                        var0.setException(null);
                        return var8_11;
                    }
                    if (!var2_2 || System.currentTimeMillis() - var0.getIdleStartTime() < DBConnectionPool.reapInterval) ** GOTO lbl48
                    if (!DBConnectionPool.timeoutIdle) break block41;
                    var8_12 = false;
                    var22_20 = null;
                    var0.setValidating(false);
                    var0.setException(null);
                    return var8_12;
                }
                var3_3 = true;
lbl48:
                // 2 sources

                if (var3_3) break block42;
                var8_13 = true;
                var22_21 = null;
                var0.setValidating(false);
                var0.setException(null);
                return var8_13;
            }
            var4_4 = var0.getConnection();
            if (var4_4 != null) break block43;
            var8_14 = false;
            var22_22 = null;
            var0.setValidating(false);
            var0.setException(null);
            return var8_14;
        }
        try {
            block46: {
                var8_15 = null;
                try {
                    block44: {
                        var5_5 = var4_4.createStatement();
                        var9_26 = var5_5.getQueryTimeout();
                        if (DBConnectionPool.dbmgr.isJDBC4()) {
                            try {
                                var10_27 = Connection.class;
                                var11_30 = var10_27.getMethod("isValid", new Class[]{Integer.TYPE});
                                var12_31 = System.currentTimeMillis();
                                var14_32 = (Boolean)var11_30.invoke((Object)var4_4, new Object[]{new Integer(var9_26)});
                                if (!var14_32) {
                                    if (System.currentTimeMillis() < var12_31 + (long)var9_26 * 1000L) {
                                        var8_15 = false;
                                    }
                                } else {
                                    var8_15 = var14_32;
                                }
                            }
                            catch (NoSuchMethodException var10_28) {
                                DBConnectionPool.dbmgr.setJDBC4(false);
                            }
                            catch (Throwable var10_29) {
                                if (!Store.getDEBUG() && !DBConnectionPool.DEBUG) break block44;
                                DBConnectionPool.logger.logStack(8, "Exception in invoking Connection.isValid(" + var9_26 + ")", var10_29);
                            }
                        }
                    }
                    var10_27 = null;
                    if (var8_15 == null && (var10_27 = DBConnectionPool.validationQuery) == null) {
                        var8_15 = true;
                    }
                    if (var8_15 == null) {
                        try {
                            var6_6 = var5_5.executeQuery((String)var10_27);
                            var8_15 = var6_6.next() ? Boolean.valueOf(true) : Boolean.valueOf(false);
                            var16_33 = null;
                        }
                        catch (Throwable var15_37) {
                            var16_34 = null;
                            try {
                                if (!var4_4.getAutoCommit()) {
                                    var4_4.rollback();
                                }
                            }
                            catch (Exception var17_36) {
                                DBConnectionPool.logger.log(16, DBConnectionPool.br.getKString("B2226", "[" + (String)var10_27 + "]" + var0, var17_36.toString()));
                                var8_15 = false;
                            }
                            throw var15_37;
                        }
                        try {
                            if (!var4_4.getAutoCommit()) {
                                var4_4.rollback();
                            }
                        }
                        catch (Exception var17_35) {
                            DBConnectionPool.logger.log(16, DBConnectionPool.br.getKString("B2226", "[" + (String)var10_27 + "]" + var0, var17_35.toString()));
                            var8_15 = false;
                        }
                    }
                    var19_38 = null;
                    if (var6_6 == null) break block46;
                }
                catch (Throwable var18_42) {
                    var19_39 = null;
                    if (var6_6 != null) {
                        var6_6.close();
                    }
                    if (var5_5 != null) {
                        var5_5.close();
                    }
                    if (var7_7 instanceof PooledConnection) {
                        try {
                            var4_4.close();
                        }
                        catch (Exception var20_41) {
                            DBConnectionPool.logger.log(16, DBConnectionPool.br.getKString("B2226", "" + var0 + "[0x" + var4_4.hashCode() + "]", var20_41.toString()));
                            var8_15 = false;
                        }
                    }
                    throw var18_42;
                }
                var6_6.close();
            }
            if (var5_5 != null) {
                var5_5.close();
            }
            if (var7_7 instanceof PooledConnection) {
                try {
                    var4_4.close();
                }
                catch (Exception var20_40) {
                    DBConnectionPool.logger.log(16, DBConnectionPool.br.getKString("B2226", "" + var0 + "[0x" + var4_4.hashCode() + "]", var20_40.toString()));
                    var8_15 = false;
                }
            }
            if (var8_15 == null) {
                var8_15 = false;
            }
            var9_26 = (int)var8_15.booleanValue();
            var22_23 = null;
            var0.setValidating(false);
            var0.setException(null);
            return (boolean)var9_26;
        }
        catch (Exception var7_8) {
            try {
                DBConnectionPool.logger.logStack(16, DBConnectionPool.br.getKString("B2226", var0.toString(), var7_8.getMessage()), var7_8);
                var8_16 = false;
                var22_24 = null;
                var0.setValidating(false);
                var0.setException(null);
                return var8_16;
            }
            catch (Throwable var21_43) {
                var22_25 = null;
                var0.setValidating(false);
                var0.setException(null);
                throw var21_43;
            }
        }
    }

    static void reapExcessConnection() {
        int n = 0;
        ConnectionInfo connectionInfo = null;
        int n2 = idleConnections.size();
        int n3 = activeConnections.size();
        if (Store.getDEBUG() || DEBUG) {
            logger.log(8, "DBConnectionPool.reapExcessConnection(): pool size: min=" + minConnections + ", max=" + maxConnections + ", active=" + n3 + ", idle=" + n2);
        }
        while (n2 > 0 && n3 + n2 > minConnections) {
            connectionInfo = idleConnections.poll();
            DBConnectionPool.destroyConnection(connectionInfo);
            ++n;
            n2 = idleConnections.size();
            n3 = activeConnections.size();
        }
        logger.log(8, br.getKString("B1342", n));
        if (!timeoutIdle) {
            return;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Object[] objectArray = idleConnections.toArray();
        int n4 = objectArray.length > minConnections ? minConnections : objectArray.length;
        long l = System.currentTimeMillis();
        boolean bl = false;
        for (int i = 0; i < n4; ++i) {
            arrayList.add(objectArray[i]);
            if (l - ((ConnectionInfo)objectArray[i]).getIdleStartTime() < reapInterval) continue;
            bl = true;
        }
        if (!bl || arrayList.size() == 0) {
            return;
        }
        connectionInfo = idleConnections.peek();
        if (connectionInfo == null) {
            return;
        }
        ArrayList<ConnectionInfo> arrayList2 = new ArrayList<ConnectionInfo>();
        Thread thread = Thread.currentThread();
        int n5 = 0;
        int n6 = 0;
        while (n5 < n4) {
            if (DEBUG) {
                logger.log(8, "DBConnectionPool.reapExcessConnection idleTimeoutCnt=" + n6 + ", cnt=" + n4 + ", i=" + n5);
            }
            if ((connectionInfo = idleConnections.peek()) == null || !arrayList.contains(connectionInfo) || arrayList2.contains(connectionInfo) || (connectionInfo = idleConnections.poll()) == null) break;
            arrayList2.add(connectionInfo);
            ++n5;
            activeConnections.put(connectionInfo, thread);
            if (arrayList.contains(connectionInfo) && l - connectionInfo.getIdleStartTime() >= reapInterval) {
                activeConnections.remove(connectionInfo);
                DBConnectionPool.destroyConnection(connectionInfo);
                ++n6;
                if (activeConnections.size() + idleConnections.size() >= minConnections) continue;
                try {
                    connectionInfo = DBConnectionPool.createConnection();
                    if (idleConnections.size() + activeConnections.size() < minConnections) {
                        idleConnections.offer(connectionInfo);
                        continue;
                    }
                    DBConnectionPool.destroyConnection(connectionInfo);
                }
                catch (BrokerException brokerException) {
                    if (Store.getDEBUG() || DEBUG) {
                        logger.logStack(16, "JDBC connection pool reaper thread failed to create new connection", brokerException);
                        continue;
                    }
                    logger.log(16, br.getKString("B2235", brokerException.getMessage()));
                }
                continue;
            }
            activeConnections.remove(connectionInfo);
            idleConnections.offer(connectionInfo);
        }
        logger.log(8, br.getKString("B1343", n6));
    }

    static {
        initialized = false;
        lock = new ReentrantLock();
        idleConnections = new LinkedBlockingQueue();
        activeConnections = new ConcurrentHashMap();
        connMap = Collections.synchronizedMap(new HashMap());
        connectionReaper = null;
        connectionListener = null;
        dbmgr = null;
        logger = Globals.getLogger();
        br = Globals.getBrokerResources();
        validationQuery = null;
        validateOnGet = false;
        timeoutIdle = true;
        isPoolDataSource = false;
        cfgListener = new ConfigListener(){

            public void validate(String string, String string2) throws PropertyUpdateException {
                if (string.equals(DBConnectionPool.MIN_CONN_PROP)) {
                    int n = 0;
                    try {
                        n = Integer.parseInt(string2);
                    }
                    catch (Exception exception) {
                        throw new PropertyUpdateException(2, br.getString("B4027", string + "=" + string2), exception);
                    }
                    if (n < 1) {
                        throw new PropertyUpdateException(2, "A minimum value of 1 connection is required");
                    }
                    if (n > maxConnections) {
                        throw new PropertyUpdateException(2, "Minimum connections " + n + " is greater than maximum connections " + maxConnections);
                    }
                } else if (string.equals(DBConnectionPool.MAX_CONN_PROP)) {
                    int n = 0;
                    try {
                        n = Integer.parseInt(string2);
                    }
                    catch (Exception exception) {
                        throw new PropertyUpdateException(2, br.getString("B4027", string + "=" + string2), exception);
                    }
                    if (n < minConnections) {
                        throw new PropertyUpdateException(2, "Maximum connections " + n + " is less than minimum connections " + minConnections);
                    }
                } else if (string.equals(DBConnectionPool.REAP_INTERVAL_PROP)) {
                    int n = 0;
                    try {
                        n = Integer.parseInt(string2);
                    }
                    catch (Exception exception) {
                        throw new PropertyUpdateException(2, br.getString("B4027", string + "=" + string2), exception);
                    }
                    if (n < 60) {
                        throw new PropertyUpdateException(2, "A minimum value of 60 seconds is required for reap time interval");
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean update(String string, String string2) {
                BrokerConfig brokerConfig = Globals.getConfig();
                lock.lock();
                try {
                    if (string.equals(DBConnectionPool.MAX_CONN_PROP)) {
                        maxConnections = brokerConfig.getIntProperty(DBConnectionPool.MAX_CONN_PROP);
                    } else if (string.equals(DBConnectionPool.MIN_CONN_PROP)) {
                        minConnections = brokerConfig.getIntProperty(DBConnectionPool.MIN_CONN_PROP);
                    } else if (string.equals(DBConnectionPool.REAP_INTERVAL_PROP)) {
                        reapInterval = brokerConfig.getLongProperty(DBConnectionPool.REAP_INTERVAL_PROP) * 1000L;
                    }
                    Object var5_4 = null;
                    lock.unlock();
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    lock.unlock();
                    throw throwable;
                }
                if (connectionReaper != null) {
                    connectionReaper.cancel();
                }
                connectionReaper = new ConnectionReaperTask();
                Globals.getTimer().schedule((TimerTask)connectionReaper, reapInterval, reapInterval);
                return true;
            }
        };
    }

    static class DBConnectionListener
    implements ConnectionEventListener {
        public void connectionClosed(ConnectionEvent connectionEvent) {
            PooledConnection pooledConnection = (PooledConnection)connectionEvent.getSource();
            ConnectionInfo connectionInfo = (ConnectionInfo)connMap.get(pooledConnection);
            if (connectionInfo == null) {
                throw new IllegalStateException("No mapping for PooledConnection 0x" + pooledConnection.hashCode() + "[" + pooledConnection.getClass().getName() + "]");
            }
            if (Store.getDEBUG() || DEBUG) {
                Logger logger = logger;
                logger;
                logger.log(8, "JDBC connectionClosed event on " + connectionInfo);
            }
            if (!connectionInfo.inValidating()) {
                DBConnectionPool.returnConnection(connectionInfo, connectionInfo.getException());
            }
        }

        public void connectionErrorOccurred(ConnectionEvent connectionEvent) {
            PooledConnection pooledConnection = (PooledConnection)connectionEvent.getSource();
            pooledConnection.removeConnectionEventListener(this);
            ConnectionInfo connectionInfo = (ConnectionInfo)connMap.get(pooledConnection);
            if (connectionInfo == null) {
                throw new IllegalStateException("connectionErrorOccurred: No mapping for PooledConnection 0x" + pooledConnection.hashCode() + "[" + pooledConnection.getClass().getName() + "]");
            }
            SQLException sQLException = connectionEvent.getSQLException();
            Logger logger = logger;
            logger;
            logger.log(16, br.getKString("B2231", "" + connectionInfo, "" + sQLException));
            if (sQLException == null) {
                sQLException = new SQLException();
            }
            connectionInfo.setException(sQLException);
            if (!connectionInfo.inValidating()) {
                DBConnectionPool.returnConnection(connectionInfo, connectionInfo.getException(), true);
            }
        }
    }

    static class ConnectionReaperTask
    extends TimerTask {
        private volatile boolean canceled = false;

        ConnectionReaperTask() {
        }

        public boolean cancel() {
            this.canceled = true;
            return super.cancel();
        }

        public void run() {
            if (this.canceled) {
                return;
            }
            try {
                DBConnectionPool.reapExcessConnection();
            }
            catch (Exception exception) {
                Globals.getLogger().logStack(32, "B3245", exception);
            }
        }
    }
}

