/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jms.ra;

import com.sun.messaging.Queue;
import com.sun.messaging.Topic;
import com.sun.messaging.XAConnectionFactory;
import com.sun.messaging.jmq.jmsclient.XAConnectionImpl;
import com.sun.messaging.jmq.jmsclient.XASessionImpl;
import com.sun.messaging.jmq.jmsservice.JMSService;
import com.sun.messaging.jms.notification.Event;
import com.sun.messaging.jms.notification.EventListener;
import com.sun.messaging.jms.ra.ActivationSpec;
import com.sun.messaging.jms.ra.DirectConnection;
import com.sun.messaging.jms.ra.DirectConnectionFactory;
import com.sun.messaging.jms.ra.DirectSession;
import com.sun.messaging.jms.ra.MessageListener;
import com.sun.messaging.jms.ra.ResourceAdapter;
import com.sun.messaging.jms.ra.util.CustomTokenizer;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.logging.Logger;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.MessageConsumer;
import javax.jms.XASession;
import javax.resource.NotSupportedException;
import javax.resource.ResourceException;
import javax.resource.spi.InvalidPropertyException;
import javax.resource.spi.endpoint.MessageEndpointFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EndpointConsumer
implements ExceptionListener,
EventListener {
    protected ResourceAdapter ra = null;
    private XAConnectionFactory xacf = null;
    protected DirectConnectionFactory dcf = null;
    private int cID = 0;
    private int fID = 0;
    private int destinationType = 0;
    protected boolean isDeliveryTransacted = false;
    protected boolean noAckDelivery = false;
    protected Method onMessageMethod = null;
    protected boolean isDurable = false;
    protected String clientId = null;
    protected String mName = null;
    protected boolean deactivated = false;
    protected XAConnectionImpl xac = null;
    protected XASessionImpl xas = null;
    private DirectConnection dc = null;
    private DirectSession ds = null;
    protected MessageListener msgListener = null;
    protected MessageConsumer msgConsumer = null;
    protected MessageConsumer msgConsumer2 = null;
    protected Destination destination = null;
    protected boolean isRADirect = false;
    protected ActivationSpec aSpec = null;
    protected MessageEndpointFactory endpointFactory = null;
    protected String username = null;
    protected String password = null;
    protected String selector = null;
    protected String subscriptionName = null;
    protected int exRedeliveryAttempts = 0;
    protected int exRedeliveryInterval = 0;
    private boolean stopping = false;
    private int reconnectAttempts = 6;
    private int reconnectInterval = 30000;
    private int addressListIterations = 3;
    private boolean logRCFailures = true;
    private int maxLoopDelay = 120000;
    private static final transient String _className = "com.sun.messaging.jms.ra.EndpointConsumer";
    protected static final transient String _lgrNameInboundMessage = "javax.resourceadapter.mqjmsra.inbound.message";
    protected static final transient Logger _loggerIM = Logger.getLogger("javax.resourceadapter.mqjmsra.inbound.message");
    protected static final transient String _lgrMIDPrefix = "MQJMSRA_EC";
    protected static final transient String _lgrMID_EET = "MQJMSRA_EC1001: ";
    protected static final transient String _lgrMID_INF = "MQJMSRA_EC1101: ";
    protected static final transient String _lgrMID_WRN = "MQJMSRA_EC2001: ";
    protected static final transient String _lgrMID_ERR = "MQJMSRA_EC3001: ";
    protected static final transient String _lgrMID_EXC = "MQJMSRA_EC4001: ";

    protected EndpointConsumer() {
    }

    public EndpointConsumer(ResourceAdapter resourceAdapter) {
        _loggerIM.entering(_className, "constructor()", resourceAdapter);
        this.ra = resourceAdapter;
        this.xacf = resourceAdapter._getXACF();
        if (!resourceAdapter.getInAppClientContainer()) {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    System.setProperty("imq.DaemonThreads", "true");
                    return null;
                }
            });
        }
        this.reconnectAttempts = resourceAdapter.getReconnectAttempts();
        this.reconnectInterval = resourceAdapter.getReconnectInterval();
        this.addressListIterations = resourceAdapter.getAddressListIterations();
        try {
            this.xacf.setProperty("imqReconnectEnabled", Boolean.toString(false));
            this.xacf.setProperty("imqReconnectAttempts", Integer.toString(this.reconnectAttempts));
            this.xacf.setProperty("imqReconnectInterval", Integer.toString(this.reconnectInterval));
            this.xacf.setProperty("imqAddressListIterations", Integer.toString(1));
        }
        catch (JMSException jMSException) {
            System.err.println("MQRA:EC:constr:Exception setting cf reconnect params-" + jMSException.getMessage());
        }
    }

    public EndpointConsumer(ResourceAdapter resourceAdapter, MessageEndpointFactory messageEndpointFactory, javax.resource.spi.ActivationSpec activationSpec, boolean bl) throws NotSupportedException {
        if (resourceAdapter == null || messageEndpointFactory == null || activationSpec == null) {
            throw new NotSupportedException("MQRA:EC:const:null RA||EPF||AS");
        }
        if (!(activationSpec instanceof ActivationSpec)) {
            throw new NotSupportedException("MQRA:EC:const:Unsupported ActivationSpec Class-" + activationSpec.getClass());
        }
        this.aSpec = (ActivationSpec)activationSpec;
        this.endpointFactory = messageEndpointFactory;
        this.ra = resourceAdapter;
        this.isRADirect = bl;
        this._init();
    }

    protected void _init() throws NotSupportedException {
        if (!this.ra.getInAppClientContainer()) {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    System.setProperty("imq.DaemonThreads", "true");
                    return null;
                }
            });
        }
        this.xacf = this.ra._getXACF();
        this.reconnectAttempts = this.ra.getReconnectAttempts();
        this.reconnectInterval = this.ra.getReconnectInterval();
        this.addressListIterations = this.ra.getAddressListIterations();
        try {
            this.xacf.setProperty("imqReconnectEnabled", "false");
            this.xacf.setProperty("imqReconnectAttempts", Integer.toString(this.reconnectAttempts));
            this.xacf.setProperty("imqReconnectInterval", Integer.toString(this.reconnectInterval));
            this.xacf.setProperty("imqAddressListIterations", Integer.toString(1));
        }
        catch (JMSException jMSException) {
            System.err.println("MQRA:EC:constr:Exception setting cf reconnect params-" + jMSException.getMessage());
        }
        this.onMessageMethod = this.ra._getOnMessageMethod();
        this.exRedeliveryAttempts = this.aSpec.getEndpointExceptionRedeliveryAttempts();
        this.exRedeliveryInterval = this.aSpec.getEndpointExceptionRedeliveryInterval();
        this.username = this.aSpec.getUserName();
        this.password = this.aSpec.getPassword();
        this.mName = this.aSpec.getMdbName();
        this.selector = this.aSpec.getMessageSelector();
        this.subscriptionName = this.aSpec.getSubscriptionName();
        String string = this.aSpec.getClientId();
        this.clientId = string != null && !"".equals(string) && string.length() > 0 ? string : null;
        try {
            this.isDeliveryTransacted = this.endpointFactory.isDeliveryTransacted(this.onMessageMethod);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        this.setDestinationType();
        if (this.destinationType == 2) {
            this.setIsDurable();
        }
        if (!this.isDurable) {
            if (this.aSpec._isNoAckDeliverySet() && this.destination instanceof Topic && !this.isDeliveryTransacted) {
                this.noAckDelivery = true;
            }
            String string2 = this.aSpec.getMdbName();
            if (this.aSpec._isInClusteredContainerSet() && this.aSpec.isUseSharedSubscriptionInClusteredContainer() && this.clientId == null) {
                if (string2 == null || "".equals(string2)) {
                    throw new NotSupportedException("MQRA:EC:Error:Clustered Message Consumer requires non-null clientID OR mdbName:clientID=" + this.clientId + ":mdbName=" + string2);
                }
                this.clientId = this.aSpec._getGroupName() != null ? this.aSpec._getGroupName() + "{m:" + string2 + "}" : "{m:" + string2 + "}";
            }
        }
        if (!this.aSpec._isRADirectEnabled()) {
            this.isRADirect = false;
        }
        if (this.isRADirect) {
            this.createDirectMessageConsumer();
        } else {
            this.createRemoteMessageConsumer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onException(JMSException jMSException) {
        _loggerIM.severe("MQJMSRA_EC4001: onException:" + jMSException.getMessage());
        this.logRCFailures = true;
        if (this.msgListener != null) {
            this.msgListener.invalidateOnMessageRunners();
        }
        int n = this.reconnectInterval;
        int n2 = 0;
        while (!this.stopping) {
            try {
                Thread.sleep(n);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                ++n2;
                if (this.logRCFailures) {
                    _loggerIM.severe("MQJMSRA_EC4001: onException:" + this.aSpec.toString());
                }
                _loggerIM.severe("MQJMSRA_EC4001: onException:reconnect attempt loop# " + n2 + " :Delayed " + n + " milliseconds.");
                EndpointConsumer endpointConsumer = this;
                synchronized (endpointConsumer) {
                    if (!this.stopping) {
                        this.createRemoteMessageConsumer();
                        _loggerIM.severe("MQJMSRA_EC4001: onException:reconnect success on loop# " + n2 + " for " + this.aSpec.toString());
                    }
                    break;
                }
            }
            catch (Exception exception) {
                if (this.logRCFailures) {
                    _loggerIM.severe("MQJMSRA_EC4001: onException:Unable to re-establish connection for " + this.aSpec.toString() + "\nin " + this.ra.toString());
                } else {
                    this.logRCFailures = false;
                }
                if (n >= this.maxLoopDelay || (n *= 3) <= this.maxLoopDelay) continue;
                n = this.maxLoopDelay;
            }
        }
    }

    @Override
    public void onEvent(Event event) {
        _loggerIM.entering(_className, "onEvent()", event);
        _loggerIM.info("MQJMSRA_EC1101: onEvent:Connection Event:" + event.toString());
    }

    public ResourceAdapter getResourceAdapter() {
        return this.ra;
    }

    public int getConsumerID() {
        return this.cID;
    }

    public int getFactoryID() {
        return this.fID;
    }

    public MessageEndpointFactory getMessageEndpointFactory() {
        MessageEndpointFactory messageEndpointFactory = this.ra._getMessageFactory(this.fID);
        return messageEndpointFactory;
    }

    public XASession getXASession() {
        return this.xas;
    }

    public DirectSession getDirectSession() {
        return this.ds;
    }

    public void setDeactivated() {
        this.deactivated = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createRemoteMessageConsumer() throws NotSupportedException {
        Map<String, String> map = null;
        try {
            this.xacf.setProperty("imqDefaultUsername", this.aSpec.getUserName());
            this.xacf.setProperty("imqDefaultPassword", this.aSpec.getPassword());
            this.xacf.setProperty("imqAddressList", this.aSpec._AddressList());
            this.xacf.setProperty("imqReconnectEnabled", "false");
            map = this.setAdditionalConnectionFactoryProperties(this.aSpec.getOptions());
        }
        catch (JMSException jMSException) {
            System.err.println("MQRA:EC:createRemoteMessageConsumer:Exception setting xacf properties-" + jMSException.getMessage());
        }
        for (int i = 1; i <= this.addressListIterations; ++i) {
            Object var6_14;
            try {
                try {
                    this.xac = (XAConnectionImpl)this.xacf.createXAConnection();
                    if (this.aSpec._isInClusteredContainerSet() && this.aSpec.isUseSharedSubscriptionInClusteredContainer()) {
                        this.xac.setRANamespaceUID(this.aSpec._getRAUID());
                    }
                    _loggerIM.fine("MQRA:EC:createRemoteMessageConsumer setting clientID to " + this.clientId);
                    if (this.clientId != null) {
                        this.xac.setClientID(this.clientId);
                    }
                    this.xac.setExceptionListener(this);
                    this.xac.setEventListener(this);
                    var6_14 = null;
                    this.clearAdditionalConnectionFactoryProperties(map);
                    break;
                }
                catch (JMSException jMSException) {
                    System.err.println("MQRA:EC:createRemoteMessageConsumer failed on addressListIteration # " + i + " of " + this.addressListIterations + ":Exception=" + jMSException.getMessage());
                    if (this.xac != null) {
                        try {
                            this.xac.close();
                        }
                        catch (JMSException jMSException2) {
                            // empty catch block
                        }
                        this.xac = null;
                    }
                    if (i >= this.addressListIterations || this.stopping) {
                        System.err.println("MQRA:EC:createRemoteMessageConsumer failed:aborting after " + this.addressListIterations + " addressListIterations");
                        if (this.logRCFailures) {
                            jMSException.printStackTrace();
                        }
                        NotSupportedException notSupportedException = new NotSupportedException("MQRA:EC:Error:createRemoteMessageConsumer failed:aborting due to:" + jMSException.getMessage());
                        notSupportedException.initCause((Throwable)jMSException);
                        throw notSupportedException;
                    }
                    try {
                        Thread.sleep(this.reconnectInterval);
                    }
                    catch (Exception exception) {
                    }
                    var6_14 = null;
                    this.clearAdditionalConnectionFactoryProperties(map);
                    continue;
                }
            }
            catch (Throwable throwable) {
                var6_14 = null;
                this.clearAdditionalConnectionFactoryProperties(map);
                throw throwable;
            }
        }
        try {
            this.xas = this.isDurable ? (XASessionImpl)this.xac.createSession(false, 2) : (this.noAckDelivery ? (XASessionImpl)this.xac.createSession(32768) : (XASessionImpl)this.xac.createSession(false, 2));
            this.xas._setRAEndpointSession();
            if (this.isDurable) {
                this.msgConsumer = this.xas.createDurableSubscriber((javax.jms.Topic)this.destination, this.aSpec.getSubscriptionName(), this.aSpec.getMessageSelector(), false);
            } else {
                this.msgConsumer = this.xas.createConsumer(this.destination, this.aSpec.getMessageSelector());
                if (this.destination instanceof javax.jms.Queue && this.aSpec._isInClusteredContainerSet()) {
                    try {
                        this.msgConsumer2 = this.xas.createConsumer(this.destination, this.aSpec.getMessageSelector());
                        this.msgConsumer2.close();
                        this.msgConsumer2 = null;
                    }
                    catch (JMSException jMSException) {
                        if (this.xac != null) {
                            try {
                                this.xac.close();
                            }
                            catch (JMSException jMSException3) {
                                // empty catch block
                            }
                            this.xac = null;
                        }
                        NotSupportedException notSupportedException = new NotSupportedException("MQRA:EC:Error clustering multiple consumers on Queue:\n" + jMSException.getMessage());
                        notSupportedException.initCause((Throwable)jMSException);
                        throw notSupportedException;
                    }
                }
            }
            this.msgListener = new MessageListener(this, this.endpointFactory, this.aSpec);
            this.msgConsumer.setMessageListener((javax.jms.MessageListener)this.msgListener);
            this.xac.start();
            this.updateFactoryConsumerTables(this.endpointFactory, this.aSpec);
        }
        catch (JMSException jMSException) {
            if (this.xac != null) {
                try {
                    this.xac.close();
                }
                catch (JMSException jMSException4) {
                    // empty catch block
                }
                this.xac = null;
            }
            NotSupportedException notSupportedException = new NotSupportedException("MQRA:EC:Error creating Remote Message Consumer:\n" + jMSException.getMessage());
            notSupportedException.initCause((Throwable)jMSException);
            throw notSupportedException;
        }
    }

    private Map<String, String> setAdditionalConnectionFactoryProperties(String string) {
        if (string == null) {
            return null;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Hashtable<String, String> hashtable = null;
        try {
            hashtable = CustomTokenizer.parseToProperties(string);
        }
        catch (InvalidPropertyException invalidPropertyException) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("MQJMSRA_EC4001: Invalid value for activation spec property options: " + string);
            illegalArgumentException.initCause(invalidPropertyException);
            throw illegalArgumentException;
        }
        Enumeration<String> enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = enumeration.nextElement();
            if (string2.equals("imqReconnectEnabled") | string2.equals("imqReconnectInterval") | string2.equals("imqDefaultUsername") | string2.equals("imqDefaultPassword") | string2.equals("imqAddressList") | string2.equals("imqAddressListIterations") | string2.equals("imqReconnectAttempts")) {
                _loggerIM.warning("MQJMSRA_EC2001: Cannot use activation spec property options to set property " + string2 + ": ignoring");
                continue;
            }
            try {
                hashMap.put(string2, this.xacf.getProperty(string2));
                this.xacf.setProperty(string2, hashtable.get(string2));
            }
            catch (JMSException jMSException) {
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException("MQJMSRA_EC4001: Error setting connection factory property " + string2 + " (defined in activation spec property options) to " + hashtable.get(string2));
                illegalArgumentException.initCause(jMSException);
                throw illegalArgumentException;
            }
        }
        return hashMap;
    }

    private void clearAdditionalConnectionFactoryProperties(Map<String, String> map) {
        if (map == null) {
            return;
        }
        for (String string : map.keySet()) {
            try {
                this.xacf.setProperty(string, map.get(string));
            }
            catch (JMSException jMSException) {
                _loggerIM.warning("MQJMSRA_EC2001: Error resetting property " + string + " to " + map.get(string) + " " + jMSException.toString());
            }
        }
    }

    protected void startMessageConsumer() throws Exception {
    }

    public void stopMessageConsumer() throws Exception {
        if (this.isRADirect) {
            this.stopDirectMessageConsumer();
        } else {
            this.stopRemoteMessageConsumer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopRemoteMessageConsumer() throws Exception {
        this.stopping = true;
        EndpointConsumer endpointConsumer = this;
        synchronized (endpointConsumer) {
            if (this.msgConsumer != null) {
                try {
                    if (this.msgListener != null) {
                        XASessionImpl xASessionImpl = this.xas;
                        xASessionImpl._stopFromRA();
                        this.msgListener.waitForAllOnMessageRunners();
                        this.msgListener.releaseOnMessageRunners();
                        this.xas.close();
                    }
                }
                catch (JMSException jMSException) {
                    ResourceException resourceException = new ResourceException("MQRA:EC:Error on closing MessageConsumer");
                    resourceException.initCause((Throwable)jMSException);
                    throw resourceException;
                }
            }
            if (this.xac != null) {
                try {
                    this.xac.close();
                }
                catch (JMSException jMSException) {
                    ResourceException resourceException = new ResourceException("MQRA:EC:Error closing JMS Connection");
                    resourceException.initCause((Throwable)jMSException);
                    throw resourceException;
                }
            }
        }
    }

    private void updateFactoryConsumerTables(MessageEndpointFactory messageEndpointFactory, ActivationSpec activationSpec) {
        this.cID = this.ra.addEndpointConsumer(this);
        this.fID = this.ra.addMessageFactory(messageEndpointFactory);
        this.ra.addFactorytoConsumerLink(this.fID, this.cID);
    }

    private void setDestinationType() throws NotSupportedException {
        String string = this.aSpec.getDestination();
        try {
            if (this.aSpec._isDestTypeQueueSet()) {
                this.destination = new Queue(string);
                this.destinationType = 1;
            } else if (this.aSpec._isDestTypeTopicSet()) {
                this.destination = new Topic(string);
                this.destinationType = 2;
            }
        }
        catch (JMSException jMSException) {
            NotSupportedException notSupportedException = new NotSupportedException("MQRA:EC:Invalid Destination-" + string);
            notSupportedException.initCause((Throwable)jMSException);
            throw notSupportedException;
        }
    }

    private void setIsDurable() throws NotSupportedException {
        if (this.aSpec._isDurableSet()) {
            String string = this.subscriptionName;
            if (string == null || string != null && string.length() <= 0) {
                throw new NotSupportedException("MQRA:EC:Need Valid SubscriptionName-" + string);
            }
            String string2 = this.clientId;
            if (string2 == null || string2 != null && string2.length() <= 0) {
                throw new NotSupportedException("MQRA:EC:Need Valid ClientID-" + string2);
            }
            this.isDurable = true;
        }
    }

    protected void createDirectMessageConsumer() throws NotSupportedException {
        JMSService jMSService = this.ra._getJMSService();
        this.dcf = new DirectConnectionFactory(jMSService, null);
        try {
            this.dc = (DirectConnection)this.dcf._createConnection(this.username, this.password);
            if (this.clientId != null) {
                this.dc._setClientID(this.clientId);
            }
            this.ds = (DirectSession)this.dc.createSession(false, 2);
            this.ds._setMDBSession(true);
            this.msgConsumer = this.isDurable ? this.ds.createDurableSubscriber((javax.jms.Topic)this.destination, this.subscriptionName, this.selector, false) : this.ds.createConsumer(this.destination, this.selector);
            this.msgListener = new MessageListener(this, this.endpointFactory, this.aSpec, this.noAckDelivery, this.isRADirect);
            this.msgConsumer.setMessageListener((javax.jms.MessageListener)this.msgListener);
            this.dc.start();
            this.updateFactoryConsumerTables(this.endpointFactory, this.aSpec);
        }
        catch (JMSException jMSException) {
            if (this.dc != null) {
                try {
                    this.dc.close();
                }
                catch (JMSException jMSException2) {
                    // empty catch block
                }
                this.dc = null;
            }
            NotSupportedException notSupportedException = new NotSupportedException("MQRA:EC:Error creating Direct Message Consumer:\n" + jMSException.getMessage());
            notSupportedException.initCause((Throwable)jMSException);
            throw notSupportedException;
        }
    }

    protected void startDirectConsumer() throws NotSupportedException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stopDirectMessageConsumer() throws Exception {
        this.stopping = true;
        EndpointConsumer endpointConsumer = this;
        synchronized (endpointConsumer) {
            if (this.msgConsumer != null) {
                try {
                    if (this.msgListener != null) {
                        this.ds._stop();
                        this.msgListener.waitForAllOnMessageRunners();
                        this.msgListener.releaseOnMessageRunners();
                    }
                }
                catch (JMSException jMSException) {
                    ResourceException resourceException = new ResourceException("MQRA:EC:Error on closing Direct MessageConsumer");
                    resourceException.initCause((Throwable)jMSException);
                    throw resourceException;
                }
            }
            if (this.dc != null) {
                try {
                    this.dc.close();
                }
                catch (JMSException jMSException) {
                    ResourceException resourceException = new ResourceException("MQRA:EC:Error closing DircetConnection");
                    resourceException.initCause((Throwable)jMSException);
                    throw resourceException;
                }
            }
        }
    }
}

