/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.webservices;

import com.sun.enterprise.deployment.ServiceReferenceDescriptor;
import com.sun.enterprise.deployment.WebServiceEndpoint;
import com.sun.enterprise.deployment.runtime.common.MessageSecurityBindingDescriptor;
import com.sun.enterprise.security.SecurityContext;
import com.sun.enterprise.security.audit.AuditManager;
import com.sun.enterprise.security.jauth.AuthException;
import com.sun.enterprise.security.jauth.ServerAuthContext;
import com.sun.enterprise.security.jmac.provider.ClientAuthConfig;
import com.sun.enterprise.security.jmac.provider.ServerAuthConfig;
import com.sun.enterprise.security.web.integration.WebPrincipal;
import com.sun.enterprise.security.webservices.ClientPipeCreator;
import com.sun.enterprise.security.webservices.MessageLayerClientHandler;
import com.sun.enterprise.security.webservices.ServletSystemHandlerDelegate;
import com.sun.enterprise.security.webservices.WebServiceSecurity;
import com.sun.enterprise.web.WebModule;
import com.sun.logging.LogDomains;
import com.sun.web.security.RealmAdapter;
import com.sun.xml.rpc.spi.runtime.StreamingHandler;
import com.sun.xml.rpc.spi.runtime.SystemHandlerDelegate;
import com.sun.xml.ws.assembler.ClientPipelineHook;
import java.lang.ref.WeakReference;
import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.xml.namespace.QName;
import javax.xml.rpc.handler.HandlerInfo;
import javax.xml.rpc.handler.soap.SOAPMessageContext;
import javax.xml.soap.SOAPMessage;
import org.apache.catalina.util.Base64;
import org.glassfish.webservices.Ejb2RuntimeEndpointInfo;
import org.glassfish.webservices.EjbRuntimeEndpointInfo;
import org.glassfish.webservices.SecurityService;
import org.glassfish.webservices.WebServiceContextImpl;
import org.glassfish.webservices.monitoring.AuthenticationListener;
import org.glassfish.webservices.monitoring.Endpoint;
import org.glassfish.webservices.monitoring.WebServiceEngineImpl;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Singleton;

@Service
@Scoped(value=Singleton.class)
public class SecurityServiceImpl
implements SecurityService {
    @Inject
    private AuditManager auditManager;
    protected static final Logger _logger = LogDomains.getLogger(SecurityServiceImpl.class, (String)"javax.enterprise.system.core.security");
    private static final String AUTHORIZATION_HEADER = "authorization";
    private static ThreadLocal<WeakReference<SOAPMessage>> req = new ThreadLocal();

    public Object mergeSOAPMessageSecurityPolicies(MessageSecurityBindingDescriptor desc) {
        try {
            ServerAuthConfig serverAuthConfig = ServerAuthConfig.getConfig("SOAP", desc, null);
            return serverAuthConfig;
        }
        catch (AuthException ae) {
            _logger.log(Level.SEVERE, "EJB Webservice security configuration Failure", ae);
            return null;
        }
    }

    public boolean doSecurity(HttpServletRequest hreq, EjbRuntimeEndpointInfo epInfo, String realmName, WebServiceContextImpl context) {
        boolean authenticated = false;
        try {
            if (hreq.getUserPrincipal() == null) {
                this.resetSecurityContext();
            }
            if (context != null) {
                context.setUserPrincipal(null);
            }
            WebServiceEndpoint endpoint = epInfo.getEndpoint();
            String method = hreq.getMethod();
            String rawAuthInfo = hreq.getHeader(AUTHORIZATION_HEADER);
            if (method.equals("GET") || !endpoint.hasAuthMethod()) {
                authenticated = true;
                boolean bl = true;
                return bl;
            }
            WebPrincipal webPrincipal = null;
            String endpointName = endpoint.getEndpointName();
            if (endpoint.hasBasicAuth() || rawAuthInfo != null) {
                if (rawAuthInfo == null) {
                    this.sendAuthenticationEvents(false, hreq.getRequestURI(), null);
                    authenticated = false;
                    boolean bl = false;
                    return bl;
                }
                String[] usernamePassword = this.parseUsernameAndPassword(rawAuthInfo);
                if (usernamePassword != null) {
                    webPrincipal = new WebPrincipal(usernamePassword[0], usernamePassword[1], SecurityContext.init());
                } else {
                    _logger.log(Level.WARNING, "BASIC AUTH username/password http header parsing error for " + endpointName);
                }
            } else {
                X509Certificate[] certs = (X509Certificate[])hreq.getAttribute("javax.servlet.request.X509Certificate");
                if (certs == null || certs.length < 1) {
                    certs = (X509Certificate[])hreq.getAttribute("org.apache.coyote.request.X509Certificate");
                }
                if (certs != null) {
                    webPrincipal = new WebPrincipal(certs, SecurityContext.init());
                } else {
                    _logger.log(Level.WARNING, "CLIENT CERT authentication error for " + endpointName);
                }
            }
            if (webPrincipal == null) {
                this.sendAuthenticationEvents(false, hreq.getRequestURI(), null);
                boolean certs = authenticated;
                return certs;
            }
            RealmAdapter ra = new RealmAdapter(realmName);
            authenticated = ra.authenticate(webPrincipal);
            if (!authenticated) {
                this.sendAuthenticationEvents(false, hreq.getRequestURI(), (Principal)webPrincipal);
                _logger.fine("authentication failed for " + endpointName);
            }
            this.sendAuthenticationEvents(true, hreq.getRequestURI(), (Principal)webPrincipal);
            if (epInfo instanceof Ejb2RuntimeEndpointInfo) {
                boolean bl = authenticated;
                return bl;
            }
            epInfo.prepareInvocation(false);
            WebServiceContextImpl ctxt = (WebServiceContextImpl)epInfo.getWebServiceContext();
            ctxt.setUserPrincipal((Principal)webPrincipal);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (this.auditManager != null && this.auditManager.isAuditOn()) {
                this.auditManager.ejbAsWebServiceInvocation(epInfo.getEndpoint().getEndpointName(), authenticated);
            }
        }
        return authenticated;
    }

    private String[] parseUsernameAndPassword(String rawAuthInfo) {
        String authString;
        String unencoded;
        int colon;
        String[] usernamePassword = null;
        if (rawAuthInfo != null && rawAuthInfo.startsWith("Basic ") && (colon = (unencoded = new String(Base64.decode((byte[])(authString = rawAuthInfo.substring(6).trim()).getBytes()))).indexOf(58)) > 0) {
            usernamePassword = new String[]{unencoded.substring(0, colon).trim(), unencoded.substring(colon + 1).trim()};
        }
        return usernamePassword;
    }

    private void sendAuthenticationEvents(boolean success, String url, Principal principal) {
        Endpoint endpoint = WebServiceEngineImpl.getInstance().getEndpoint(url);
        if (endpoint == null) {
            return;
        }
        for (AuthenticationListener listener : WebServiceEngineImpl.getInstance().getAuthListeners()) {
            if (success) {
                listener.authSucess(endpoint.getDescriptor().getBundleDescriptor(), endpoint, principal);
                continue;
            }
            listener.authFailure(endpoint.getDescriptor().getBundleDescriptor(), endpoint, principal);
        }
    }

    public void resetSecurityContext() {
        SecurityContext.setUnauthenticatedContext();
    }

    public SystemHandlerDelegate getSecurityHandler(WebServiceEndpoint endpoint) {
        if (!endpoint.hasAuthMethod()) {
            try {
                ServerAuthConfig config = ServerAuthConfig.getConfig("SOAP", endpoint.getMessageSecurityBinding(), null);
                if (config != null) {
                    return new ServletSystemHandlerDelegate(config, endpoint);
                }
            }
            catch (Exception e) {
                _logger.log(Level.SEVERE, "Servlet Webservice security configuration Failure", e);
            }
        }
        return null;
    }

    public boolean validateRequest(Object serverAuthConfig, StreamingHandler implementor, com.sun.xml.rpc.spi.runtime.SOAPMessageContext context) {
        ServerAuthConfig authConfig = (ServerAuthConfig)serverAuthConfig;
        if (authConfig != null) {
            ServerAuthContext sAC = authConfig.getAuthContext(implementor, context.getMessage());
            req.set(new WeakReference<SOAPMessage>(context.getMessage()));
            if (sAC != null) {
                try {
                    return WebServiceSecurity.validateRequest((SOAPMessageContext)context, sAC);
                }
                catch (AuthException ex) {
                    _logger.log(Level.SEVERE, ex.getMessage(), ex);
                    if (req.get() != null) {
                        req.get().clear();
                        req.set(null);
                    }
                    throw new RuntimeException(ex);
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void secureResponse(Object serverAuthConfig, StreamingHandler implementor, com.sun.xml.rpc.spi.runtime.SOAPMessageContext msgContext) {
        block7: {
            if (serverAuthConfig != null) {
                ServerAuthConfig config = (ServerAuthConfig)serverAuthConfig;
                SOAPMessage reqmsg = req.get() != null ? (SOAPMessage)req.get().get() : msgContext.getMessage();
                try {
                    ServerAuthContext sAC = config.getAuthContext(implementor, reqmsg);
                    if (sAC == null) break block7;
                    try {
                        WebServiceSecurity.secureResponse((SOAPMessageContext)msgContext, sAC);
                    }
                    catch (AuthException ex) {
                        _logger.log(Level.SEVERE, null, ex);
                        throw new RuntimeException(ex);
                    }
                }
                finally {
                    if (req.get() != null) {
                        req.get().clear();
                        req.set(null);
                    }
                }
            }
        }
    }

    public HandlerInfo getMessageSecurityHandler(MessageSecurityBindingDescriptor binding, QName serviceName) {
        HandlerInfo rvalue = null;
        try {
            ClientAuthConfig config = ClientAuthConfig.getConfig("SOAP", binding, null);
            if (config != null) {
                QName[] headers = config.getMechanisms();
                HashMap<String, Object> properties = new HashMap<String, Object>();
                properties.put("com.sun.enterprise.security.jmac.provider.ClientAuthConfig", config);
                properties.put("javax.xml.ws.wsdl.service", serviceName);
                rvalue = new HandlerInfo(MessageLayerClientHandler.class, properties, headers);
            }
        }
        catch (AuthException ex) {
            _logger.log(Level.SEVERE, null, ex);
            throw new RuntimeException(ex);
        }
        return rvalue;
    }

    public ClientPipelineHook getClientPipelineHook(ServiceReferenceDescriptor ref) {
        return new ClientPipeCreator(ref);
    }

    public Principal getUserPrincipal(boolean isWeb) {
        SecurityContext ctx = SecurityContext.getCurrent();
        if (ctx == null) {
            return null;
        }
        if (ctx.didServerGenerateCredentials() && isWeb) {
            return null;
        }
        return ctx.getCallerPrincipal();
    }

    public boolean isUserInRole(WebModule webModule, Principal principal, String servletName, String role) {
        if (webModule.getRealm() instanceof RealmAdapter) {
            RealmAdapter realmAdapter = (RealmAdapter)webModule.getRealm();
            return realmAdapter.hasRole(servletName, principal, role);
        }
        return false;
    }
}

