/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.jdbc;

import com.sun.messaging.jmq.jmsserver.FaultInjection;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.persist.HABrokerInfo;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.BaseDAOImpl;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.DBManager;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.StoreSessionDAO;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.Util;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class StoreSessionDAOImpl
extends BaseDAOImpl
implements StoreSessionDAO {
    protected String tableName;
    protected String insertSQL;
    protected String updateIsCurrentSQL;
    protected String takeoverSQL;
    protected String deleteSQL;
    protected String deleteByBrokerSQL;
    protected String deleteInactiveByBrokerSQL;
    protected String selectSQL;
    protected String selectAllSQL;
    protected String selectAllOldSessionsSQL;
    protected String selectCurrentSessionSQL;
    protected String selectPreviousSessionSQL;
    protected String selectIDsByBrokerSQL;
    private volatile long localStoreSessionID = 0L;
    private FaultInjection fi = FaultInjection.getInjection();

    StoreSessionDAOImpl() throws BrokerException {
        DBManager dBManager = DBManager.getDBManager();
        this.tableName = dBManager.getTableName("MQSES41");
        this.insertSQL = new StringBuffer(128).append("INSERT INTO ").append(this.tableName).append(" ( ").append("ID").append(", ").append("BROKER_ID").append(", ").append("IS_CURRENT").append(", ").append("CREATED_BY").append(", ").append("CREATED_TS").append(") VALUES ( ?, ?, ?, ?, ? )").toString();
        this.updateIsCurrentSQL = new StringBuffer(128).append("UPDATE ").append(this.tableName).append(" SET ").append("IS_CURRENT").append(" = ? ").append(" WHERE ").append("ID").append(" = ?").toString();
        this.takeoverSQL = new StringBuffer(128).append("UPDATE ").append(this.tableName).append(" SET ").append("BROKER_ID").append(" = ?, ").append("CREATED_TS").append(" = ?, ").append("IS_CURRENT").append(" = 0").append(" WHERE ").append("BROKER_ID").append(" = ?").toString();
        this.deleteSQL = new StringBuffer(128).append("DELETE FROM ").append(this.tableName).append(" WHERE ").append("ID").append(" = ?").toString();
        this.deleteByBrokerSQL = new StringBuffer(128).append("DELETE FROM ").append(this.tableName).append(" WHERE ").append("BROKER_ID").append(" = ?").toString();
        this.deleteInactiveByBrokerSQL = new StringBuffer(128).append("DELETE FROM ").append(this.tableName).append(" WHERE ").append("ID").append(" = ?").append(" AND NOT EXISTS (").append("SELECT 1 FROM ").append(dBManager.getTableName("MQMSG41")).append(" WHERE ").append("STORE_SESSION_ID").append(" = ?").append(" UNION ").append("SELECT 1 FROM ").append(dBManager.getTableName("MQTXN41")).append(" WHERE ").append("STORE_SESSION_ID").append(" = ?").append(")").toString();
        this.selectSQL = new StringBuffer(128).append("SELECT ").append("BROKER_ID").append(", ").append("IS_CURRENT").append(", ").append("CREATED_BY").append(", ").append("CREATED_TS").append(" FROM ").append(this.tableName).append(" WHERE ").append("ID").append(" = ?").toString();
        this.selectAllSQL = new StringBuffer(128).append("SELECT ").append("ID").append(", ").append("BROKER_ID").append(", ").append("IS_CURRENT").append(", ").append("CREATED_BY").append(", ").append("CREATED_TS").append(" FROM ").append(this.tableName).append(" ORDER BY ").append("BROKER_ID").append(", ").append("CREATED_TS").toString();
        this.selectAllOldSessionsSQL = new StringBuffer(128).append("SELECT ").append("ID").append(", ").append("CREATED_TS").append(", ").append("BROKER_ID").append(" FROM ").append(this.tableName).append(" WHERE ").append("IS_CURRENT").append(" = 0").toString();
        this.selectCurrentSessionSQL = new StringBuffer(128).append("SELECT ").append("ID").append(" FROM ").append(this.tableName).append(" WHERE ").append("BROKER_ID").append(" = ?").append(" AND ").append("IS_CURRENT").append(" = 1").toString();
        this.selectPreviousSessionSQL = new StringBuffer(128).append("SELECT sTbl.").append("ID").append(", sTbl.").append("CREATED_TS").append(" FROM ").append(this.tableName).append(" sTbl, ").append(dBManager.getTableName("MQBKR41")).append(" bTbl WHERE bTbl.").append("ID").append(" = ?").append(" AND bTbl.").append("ID").append(" = sTbl.").append("CREATED_BY").append(" AND bTbl.").append("TAKEOVER_BROKER").append(" = sTbl.").append("BROKER_ID").append(" ORDER BY sTbl.").append("CREATED_TS").append(" DESC").toString();
        this.selectIDsByBrokerSQL = new StringBuffer(128).append("SELECT ").append("ID").append(" FROM ").append(this.tableName).append(" WHERE ").append("BROKER_ID").append(" = ?").toString();
    }

    public final String getTableNamePrefix() {
        return "MQSES41";
    }

    public final String getTableName() {
        return this.tableName;
    }

    public long insert(Connection connection, String string, long l, boolean bl) throws BrokerException {
        long l2;
        block19: {
            Exception exception;
            PreparedStatement preparedStatement;
            block18: {
                if (l == 0L) {
                    throw new BrokerException("B3044 Unexpected store session uid " + l + " to add for broker " + string);
                }
                boolean bl2 = false;
                preparedStatement = null;
                String string2 = null;
                exception = null;
                try {
                    DBManager dBManager = DBManager.getDBManager();
                    if (connection == null) {
                        connection = dBManager.getConnection(false);
                        bl2 = true;
                    }
                    long l3 = 0L;
                    string2 = this.selectCurrentSessionSQL;
                    preparedStatement = connection.prepareStatement(string2);
                    preparedStatement.setString(1, string);
                    ResultSet resultSet = preparedStatement.executeQuery();
                    if (resultSet.next()) {
                        l3 = resultSet.getLong(1);
                        if (bl) {
                            throw new BrokerException("Unexpected current ID " + l3 + " already exists in table " + this.tableName + " for broker " + string);
                        }
                        if (resultSet.next()) {
                            throw new BrokerException("Unexpected more than 1 current ID " + l3 + ", " + resultSet.getLong(1) + " exists in table " + this.tableName + " for broker " + string);
                        }
                        if (l3 == 0L) {
                            throw new BrokerException("Unexpected current ID value " + l3 + " stored in table " + this.tableName + " for broker " + string);
                        }
                    }
                    resultSet.close();
                    preparedStatement.close();
                    if (l3 == 0L) {
                        this.insert(connection, string, l, 1, string, System.currentTimeMillis());
                        l3 = l;
                    }
                    if (bl2) {
                        connection.commit();
                    }
                    l2 = l3;
                    Object var17_16 = null;
                    if (!bl2) break block18;
                }
                catch (Exception exception2) {
                    try {
                        exception = exception2;
                        try {
                            if (connection != null && !connection.getAutoCommit()) {
                                connection.rollback();
                            }
                        }
                        catch (SQLException sQLException) {
                            this.logger.log(32, "B4080", sQLException);
                        }
                        if (exception2 instanceof BrokerException) {
                            throw (BrokerException)exception2;
                        }
                        Exception exception3 = exception2 instanceof SQLException ? DBManager.wrapSQLException("[" + string2 + "]", (SQLException)exception2) : exception2;
                        throw new BrokerException(this.br.getKString("B4276", String.valueOf(l)), exception3);
                    }
                    catch (Throwable throwable) {
                        Object var17_17 = null;
                        if (bl2) {
                            Util.close(null, preparedStatement, connection, exception);
                        } else {
                            Util.close(null, preparedStatement, null, exception);
                        }
                        throw throwable;
                    }
                }
                Util.close(null, preparedStatement, connection, exception);
                break block19;
            }
            Util.close(null, preparedStatement, null, exception);
        }
        return l2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void insert(Connection connection, String string, long l, int n, String string2, long l2) throws BrokerException {
        Exception exception;
        PreparedStatement preparedStatement;
        block12: {
            boolean bl = false;
            preparedStatement = null;
            exception = null;
            try {
                try {
                    if (connection == null) {
                        connection = DBManager.getDBManager().getConnection(true);
                        bl = true;
                    }
                    preparedStatement = connection.prepareStatement(this.insertSQL);
                    preparedStatement.setLong(1, l);
                    preparedStatement.setString(2, string);
                    preparedStatement.setInt(3, n);
                    preparedStatement.setString(4, string2);
                    preparedStatement.setLong(5, l2);
                    preparedStatement.executeUpdate();
                }
                catch (Exception exception2) {
                    Exception exception3;
                    exception = exception2;
                    try {
                        if (connection != null && !connection.getAutoCommit()) {
                            connection.rollback();
                        }
                    }
                    catch (SQLException sQLException) {
                        this.logger.log(32, "B4080[" + this.insertSQL + "]", sQLException);
                    }
                    if (exception2 instanceof BrokerException) {
                        throw (BrokerException)exception2;
                    }
                    if (exception2 instanceof SQLException) {
                        exception3 = DBManager.wrapSQLException("[" + this.insertSQL + "]", (SQLException)exception2);
                        throw new BrokerException(this.br.getKString("B4276", String.valueOf(l)), exception3);
                    }
                    exception3 = exception2;
                    throw new BrokerException(this.br.getKString("B4276", String.valueOf(l)), exception3);
                }
                Object var15_10 = null;
                if (!bl) break block12;
            }
            catch (Throwable throwable) {
                Object var15_11 = null;
                if (bl) {
                    Util.close(null, preparedStatement, connection, exception);
                    throw throwable;
                }
                Util.close(null, preparedStatement, null, exception);
                throw throwable;
            }
            Util.close(null, preparedStatement, connection, exception);
            return;
        }
        Util.close(null, preparedStatement, null, exception);
    }

    public List takeover(Connection connection, String string, String string2) throws BrokerException {
        ArrayList<Long> arrayList = new ArrayList<Long>();
        String string3 = null;
        PreparedStatement preparedStatement = null;
        Exception exception = null;
        try {
            try {
                if (this.fi.FAULT_INJECTION) {
                    this.fi.checkFaultAndThrowBrokerException("ha.takeover.switch_ss.exception", null);
                    this.fi.checkFaultAndExit("ha.takeover.switch_ss.halt", null, 2, false);
                }
                string3 = this.selectIDsByBrokerSQL;
                preparedStatement = connection.prepareStatement(string3);
                preparedStatement.setString(1, string2);
                ResultSet resultSet = preparedStatement.executeQuery();
                while (resultSet.next()) {
                    long l = resultSet.getLong(1);
                    arrayList.add(l);
                }
                resultSet.close();
                preparedStatement.close();
                preparedStatement = connection.prepareStatement(this.takeoverSQL);
                preparedStatement.setString(1, string);
                preparedStatement.setLong(2, System.currentTimeMillis());
                preparedStatement.setString(3, string2);
                int n = preparedStatement.executeUpdate();
                if (n != arrayList.size()) {
                    throw new BrokerException(this.br.getKString("B3174", string2));
                }
                Object var12_14 = null;
            }
            catch (Exception exception2) {
                exception = exception2;
                try {
                    if (connection != null && !connection.getAutoCommit()) {
                        connection.rollback();
                    }
                }
                catch (SQLException sQLException) {
                    this.logger.log(32, "B4080", sQLException);
                }
                if (exception2 instanceof BrokerException) {
                    throw (BrokerException)exception2;
                }
                Exception exception3 = exception2 instanceof SQLException ? DBManager.wrapSQLException("[" + this.takeoverSQL + "]", (SQLException)exception2) : exception2;
                throw new BrokerException(this.br.getKString("B3174", string2), exception3);
            }
        }
        catch (Throwable throwable) {
            Object var12_15 = null;
            Util.close(null, preparedStatement, null, exception);
            throw throwable;
        }
        Util.close(null, preparedStatement, null, exception);
        return arrayList;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void delete(Connection connection, long l) throws BrokerException {
        Exception exception;
        PreparedStatement preparedStatement;
        block12: {
            boolean bl = false;
            preparedStatement = null;
            exception = null;
            try {
                try {
                    if (connection == null) {
                        connection = DBManager.getDBManager().getConnection(true);
                        bl = true;
                    }
                    preparedStatement = connection.prepareStatement(this.deleteSQL);
                    preparedStatement.setLong(1, l);
                    preparedStatement.executeUpdate();
                }
                catch (Exception exception2) {
                    Exception exception3;
                    exception = exception2;
                    try {
                        if (connection != null && !connection.getAutoCommit()) {
                            connection.rollback();
                        }
                    }
                    catch (SQLException sQLException) {
                        this.logger.log(32, "B4080[" + this.deleteSQL + "]", sQLException);
                    }
                    if (exception2 instanceof BrokerException) {
                        throw (BrokerException)exception2;
                    }
                    if (exception2 instanceof SQLException) {
                        exception3 = DBManager.wrapSQLException("[" + this.deleteSQL + "]", (SQLException)exception2);
                        throw new BrokerException(this.br.getKString("B4277", String.valueOf(l)), exception3);
                    }
                    exception3 = exception2;
                    throw new BrokerException(this.br.getKString("B4277", String.valueOf(l)), exception3);
                }
                Object var10_6 = null;
                if (!bl) break block12;
            }
            catch (Throwable throwable) {
                Object var10_7 = null;
                if (bl) {
                    Util.close(null, preparedStatement, connection, exception);
                    throw throwable;
                }
                Util.close(null, preparedStatement, null, exception);
                throw throwable;
            }
            Util.close(null, preparedStatement, connection, exception);
            return;
        }
        Util.close(null, preparedStatement, null, exception);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void deleteByBrokerID(Connection connection, String string) throws BrokerException {
        Exception exception;
        PreparedStatement preparedStatement;
        block12: {
            boolean bl = false;
            preparedStatement = null;
            exception = null;
            try {
                try {
                    if (connection == null) {
                        connection = DBManager.getDBManager().getConnection(true);
                        bl = true;
                    }
                    preparedStatement = connection.prepareStatement(this.deleteByBrokerSQL);
                    preparedStatement.setString(1, string);
                    preparedStatement.executeUpdate();
                }
                catch (Exception exception2) {
                    Exception exception3;
                    exception = exception2;
                    try {
                        if (connection != null && !connection.getAutoCommit()) {
                            connection.rollback();
                        }
                    }
                    catch (SQLException sQLException) {
                        this.logger.log(32, "B4080[" + this.deleteByBrokerSQL + "]", sQLException);
                    }
                    if (exception2 instanceof BrokerException) {
                        throw (BrokerException)exception2;
                    }
                    if (exception2 instanceof SQLException) {
                        exception3 = DBManager.wrapSQLException("[" + this.deleteByBrokerSQL + "]", (SQLException)exception2);
                        throw new BrokerException(this.br.getKString("B4280", string), exception3);
                    }
                    exception3 = exception2;
                    throw new BrokerException(this.br.getKString("B4280", string), exception3);
                }
                Object var9_6 = null;
                if (!bl) break block12;
            }
            catch (Throwable throwable) {
                Object var9_7 = null;
                if (bl) {
                    Util.close(null, preparedStatement, connection, exception);
                    throw throwable;
                }
                Util.close(null, preparedStatement, null, exception);
                throw throwable;
            }
            Util.close(null, preparedStatement, connection, exception);
            return;
        }
        Util.close(null, preparedStatement, null, exception);
    }

    public void deleteAll(Connection connection) throws BrokerException {
        if (Globals.getHAEnabled()) {
            return;
        }
        super.deleteAll(connection);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void deleteInactiveStoreSession(Connection connection) throws BrokerException {
        Exception exception;
        PreparedStatement preparedStatement;
        block12: {
            boolean bl = false;
            preparedStatement = null;
            exception = null;
            try {
                try {
                    String string;
                    long l;
                    if (connection == null) {
                        connection = DBManager.getDBManager().getConnection(true);
                        bl = true;
                    }
                    HashMap<Long, String> hashMap = new HashMap<Long, String>();
                    long l2 = System.currentTimeMillis();
                    preparedStatement = connection.prepareStatement(this.selectAllOldSessionsSQL);
                    ResultSet resultSet = preparedStatement.executeQuery();
                    while (resultSet.next()) {
                        long l3 = resultSet.getLong(1);
                        l = resultSet.getLong(2);
                        string = resultSet.getString(3);
                        if (l2 <= l + 1800000L) continue;
                        hashMap.put(new Long(l3), string);
                    }
                    resultSet.close();
                    if (!hashMap.isEmpty()) {
                        preparedStatement.close();
                        preparedStatement = connection.prepareStatement(this.deleteInactiveByBrokerSQL);
                        for (Map.Entry entry : hashMap.entrySet()) {
                            l = (Long)entry.getKey();
                            string = (String)entry.getValue();
                            try {
                                preparedStatement.setLong(1, l);
                                preparedStatement.setLong(2, l);
                                preparedStatement.setLong(3, l);
                                if (preparedStatement.executeUpdate() <= 0) continue;
                                this.logger.log(8, this.br.getString("B1254", String.valueOf(l), string));
                            }
                            catch (SQLException sQLException) {
                                SQLException sQLException2 = DBManager.wrapSQLException("[" + this.deleteInactiveByBrokerSQL + "]", sQLException);
                                this.logger.logStack(32, "B4279", l, string, sQLException2);
                            }
                        }
                    }
                    Object var17_16 = null;
                    if (!bl) break block12;
                }
                catch (Exception exception2) {
                    exception = exception2;
                    if (!(exception2 instanceof BrokerException)) throw new BrokerException(this.br.getKString("B4166", this.selectAllOldSessionsSQL), exception2);
                    throw (BrokerException)exception2;
                }
            }
            catch (Throwable throwable) {
                Object var17_17 = null;
                if (bl) {
                    Util.close(null, preparedStatement, connection, exception);
                    throw throwable;
                }
                Util.close(null, preparedStatement, null, exception);
                throw throwable;
            }
            Util.close(null, preparedStatement, connection, exception);
            return;
        }
        Util.close(null, preparedStatement, null, exception);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long getStoreSession(Connection connection, String string) throws BrokerException {
        long l;
        boolean bl;
        block14: {
            Exception exception;
            ResultSet resultSet;
            PreparedStatement preparedStatement;
            block13: {
                DBManager dBManager = DBManager.getDBManager();
                bl = dBManager.getBrokerID().equals(string);
                if (bl && this.localStoreSessionID > 0L) {
                    return this.localStoreSessionID;
                }
                l = 0L;
                boolean bl2 = false;
                preparedStatement = null;
                resultSet = null;
                exception = null;
                try {
                    try {
                        if (connection == null) {
                            connection = dBManager.getConnection(true);
                            bl2 = true;
                        }
                        preparedStatement = connection.prepareStatement(this.selectCurrentSessionSQL);
                        preparedStatement.setString(1, string);
                        resultSet = preparedStatement.executeQuery();
                        if (resultSet.next()) {
                            l = resultSet.getLong(1);
                        }
                    }
                    catch (Exception exception2) {
                        Exception exception3;
                        exception = exception2;
                        try {
                            if (connection != null && !connection.getAutoCommit()) {
                                connection.rollback();
                            }
                        }
                        catch (SQLException sQLException) {
                            this.logger.log(32, "B4080", sQLException);
                        }
                        if (exception2 instanceof BrokerException) {
                            throw (BrokerException)exception2;
                        }
                        if (exception2 instanceof SQLException) {
                            exception3 = DBManager.wrapSQLException("[" + this.selectCurrentSessionSQL + "]", (SQLException)exception2);
                            throw new BrokerException(this.br.getKString("B4281", string), exception3);
                        }
                        exception3 = exception2;
                        throw new BrokerException(this.br.getKString("B4281", string), exception3);
                    }
                    Object var14_10 = null;
                    if (!bl2) break block13;
                }
                catch (Throwable throwable) {
                    Object var14_11 = null;
                    if (bl2) {
                        Util.close(resultSet, preparedStatement, connection, exception);
                        throw throwable;
                    }
                    Util.close(resultSet, preparedStatement, null, exception);
                    throw throwable;
                }
                Util.close(resultSet, preparedStatement, connection, exception);
                break block14;
            }
            Util.close(resultSet, preparedStatement, null, exception);
        }
        if (!bl) return l;
        if (this.localStoreSessionID != 0L) return l;
        this.localStoreSessionID = l;
        return l;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getStoreSessionOwner(Connection connection, long l) throws BrokerException {
        Exception exception;
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        String string;
        block13: {
            string = null;
            boolean bl = false;
            preparedStatement = null;
            resultSet = null;
            exception = null;
            try {
                try {
                    if (connection == null) {
                        connection = DBManager.getDBManager().getConnection(true);
                        bl = true;
                    }
                    preparedStatement = connection.prepareStatement(this.selectSQL);
                    preparedStatement.setLong(1, l);
                    resultSet = preparedStatement.executeQuery();
                    if (resultSet.next()) {
                        string = resultSet.getString("BROKER_ID");
                    }
                }
                catch (Exception exception2) {
                    Exception exception3;
                    exception = exception2;
                    try {
                        if (connection != null && !connection.getAutoCommit()) {
                            connection.rollback();
                        }
                    }
                    catch (SQLException sQLException) {
                        this.logger.log(32, "B4080[" + this.selectSQL + "]", sQLException);
                    }
                    if (exception2 instanceof BrokerException) {
                        throw (BrokerException)exception2;
                    }
                    if (exception2 instanceof SQLException) {
                        exception3 = DBManager.wrapSQLException("[" + this.selectSQL + "]", (SQLException)exception2);
                        throw new BrokerException(this.br.getKString("B4278", String.valueOf(l)), exception3);
                    }
                    exception3 = exception2;
                    throw new BrokerException(this.br.getKString("B4278", String.valueOf(l)), exception3);
                }
                Object var12_8 = null;
                if (!bl) break block13;
            }
            catch (Throwable throwable) {
                Object var12_9 = null;
                if (bl) {
                    Util.close(resultSet, preparedStatement, connection, exception);
                    throw throwable;
                }
                Util.close(resultSet, preparedStatement, null, exception);
                throw throwable;
            }
            Util.close(resultSet, preparedStatement, connection, exception);
            return string;
        }
        Util.close(resultSet, preparedStatement, null, exception);
        return string;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getStoreSessionCreator(Connection connection, long l) throws BrokerException {
        Exception exception;
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        String string;
        block13: {
            string = null;
            boolean bl = false;
            preparedStatement = null;
            resultSet = null;
            exception = null;
            try {
                try {
                    if (connection == null) {
                        connection = DBManager.getDBManager().getConnection(true);
                        bl = true;
                    }
                    preparedStatement = connection.prepareStatement(this.selectSQL);
                    preparedStatement.setLong(1, l);
                    resultSet = preparedStatement.executeQuery();
                    if (resultSet.next()) {
                        string = resultSet.getString("CREATED_BY");
                    }
                }
                catch (Exception exception2) {
                    Exception exception3;
                    exception = exception2;
                    try {
                        if (connection != null && !connection.getAutoCommit()) {
                            connection.rollback();
                        }
                    }
                    catch (SQLException sQLException) {
                        this.logger.log(32, "B4080[" + this.selectSQL + "]", sQLException);
                    }
                    if (exception2 instanceof BrokerException) {
                        throw (BrokerException)exception2;
                    }
                    if (exception2 instanceof SQLException) {
                        exception3 = DBManager.wrapSQLException("[" + this.selectSQL + "]", (SQLException)exception2);
                        throw new BrokerException(this.br.getKString("B4278", String.valueOf(l)), exception3);
                    }
                    exception3 = exception2;
                    throw new BrokerException(this.br.getKString("B4278", String.valueOf(l)), exception3);
                }
                Object var12_8 = null;
                if (!bl) break block13;
            }
            catch (Throwable throwable) {
                Object var12_9 = null;
                if (bl) {
                    Util.close(resultSet, preparedStatement, connection, exception);
                    throw throwable;
                }
                Util.close(resultSet, preparedStatement, null, exception);
                throw throwable;
            }
            Util.close(resultSet, preparedStatement, connection, exception);
            return string;
        }
        Util.close(resultSet, preparedStatement, null, exception);
        return string;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Map getAllStoreSessions(Connection connection) throws BrokerException {
        Exception exception;
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        HashMap<String, ArrayList<HABrokerInfo.StoreSession>> hashMap;
        block14: {
            hashMap = new HashMap<String, ArrayList<HABrokerInfo.StoreSession>>();
            boolean bl = false;
            preparedStatement = null;
            resultSet = null;
            exception = null;
            try {
                try {
                    if (connection == null) {
                        connection = DBManager.getDBManager().getConnection(true);
                        bl = true;
                    }
                    preparedStatement = connection.prepareStatement(this.selectAllSQL);
                    resultSet = preparedStatement.executeQuery();
                    while (resultSet.next()) {
                        long l = resultSet.getLong(1);
                        String string = resultSet.getString(2);
                        int n = resultSet.getInt(3);
                        String string2 = resultSet.getString(4);
                        long l2 = resultSet.getLong(5);
                        ArrayList<HABrokerInfo.StoreSession> arrayList = (ArrayList<HABrokerInfo.StoreSession>)hashMap.get(string);
                        if (arrayList == null) {
                            arrayList = new ArrayList<HABrokerInfo.StoreSession>();
                            hashMap.put(string, arrayList);
                        }
                        arrayList.add(new HABrokerInfo.StoreSession(l, string, n, string2, l2));
                    }
                    Object var16_14 = null;
                    if (!bl) break block14;
                }
                catch (Exception exception2) {
                    Exception exception3;
                    exception = exception2;
                    try {
                        if (connection != null && !connection.getAutoCommit()) {
                            connection.rollback();
                        }
                    }
                    catch (SQLException sQLException) {
                        this.logger.log(32, "B4080[" + this.selectAllSQL + "]", sQLException);
                    }
                    if (exception2 instanceof BrokerException) {
                        throw (BrokerException)exception2;
                    }
                    if (exception2 instanceof SQLException) {
                        exception3 = DBManager.wrapSQLException("[" + this.selectAllSQL + "]", (SQLException)exception2);
                        throw new BrokerException(this.br.getKString("B4283"), exception3);
                    }
                    exception3 = exception2;
                    throw new BrokerException(this.br.getKString("B4283"), exception3);
                }
            }
            catch (Throwable throwable) {
                Object var16_15 = null;
                if (bl) {
                    Util.close(resultSet, preparedStatement, connection, exception);
                    throw throwable;
                }
                Util.close(resultSet, preparedStatement, null, exception);
                throw throwable;
            }
            Util.close(resultSet, preparedStatement, connection, exception);
            return hashMap;
        }
        Util.close(resultSet, preparedStatement, null, exception);
        return hashMap;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List getStoreSessionsByBroker(Connection connection, String string) throws BrokerException {
        Exception exception;
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        ArrayList<Long> arrayList;
        block13: {
            arrayList = new ArrayList<Long>();
            boolean bl = false;
            preparedStatement = null;
            resultSet = null;
            exception = null;
            try {
                try {
                    if (connection == null) {
                        connection = DBManager.getDBManager().getConnection(true);
                        bl = true;
                    }
                    preparedStatement = connection.prepareStatement(this.selectIDsByBrokerSQL);
                    preparedStatement.setString(1, string);
                    resultSet = preparedStatement.executeQuery();
                    while (resultSet.next()) {
                        long l = resultSet.getLong(1);
                        arrayList.add(l);
                    }
                    Object var11_10 = null;
                    if (!bl) break block13;
                }
                catch (Exception exception2) {
                    Exception exception3;
                    exception = exception2;
                    try {
                        if (connection != null && !connection.getAutoCommit()) {
                            connection.rollback();
                        }
                    }
                    catch (SQLException sQLException) {
                        this.logger.log(32, "B4080[" + this.selectIDsByBrokerSQL + "]", sQLException);
                    }
                    if (exception2 instanceof BrokerException) {
                        throw (BrokerException)exception2;
                    }
                    if (exception2 instanceof SQLException) {
                        exception3 = DBManager.wrapSQLException("[" + this.selectIDsByBrokerSQL + "]", (SQLException)exception2);
                        throw new BrokerException(this.br.getKString("B4282", string), exception3);
                    }
                    exception3 = exception2;
                    throw new BrokerException(this.br.getKString("B4282", string), exception3);
                }
            }
            catch (Throwable throwable) {
                Object var11_11 = null;
                if (bl) {
                    Util.close(resultSet, preparedStatement, connection, exception);
                    throw throwable;
                }
                Util.close(resultSet, preparedStatement, null, exception);
                throw throwable;
            }
            Util.close(resultSet, preparedStatement, connection, exception);
            return arrayList;
        }
        Util.close(resultSet, preparedStatement, null, exception);
        return arrayList;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isCurrent(Connection connection, long l) throws BrokerException {
        Exception exception;
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        boolean bl;
        block13: {
            bl = false;
            boolean bl2 = false;
            preparedStatement = null;
            resultSet = null;
            exception = null;
            try {
                try {
                    if (connection == null) {
                        connection = DBManager.getDBManager().getConnection(true);
                        bl2 = true;
                    }
                    preparedStatement = connection.prepareStatement(this.selectSQL);
                    preparedStatement.setLong(1, l);
                    resultSet = preparedStatement.executeQuery();
                    if (resultSet.next() && resultSet.getInt("IS_CURRENT") == 1) {
                        bl = true;
                    }
                }
                catch (Exception exception2) {
                    Exception exception3;
                    exception = exception2;
                    try {
                        if (connection != null && !connection.getAutoCommit()) {
                            connection.rollback();
                        }
                    }
                    catch (SQLException sQLException) {
                        this.logger.log(32, "B4080[" + this.selectSQL + "]", sQLException);
                    }
                    if (exception2 instanceof BrokerException) {
                        throw (BrokerException)exception2;
                    }
                    if (exception2 instanceof SQLException) {
                        exception3 = DBManager.wrapSQLException("[" + this.selectSQL + "]", (SQLException)exception2);
                        throw new BrokerException(this.br.getKString("B4278", String.valueOf(l)), exception3);
                    }
                    exception3 = exception2;
                    throw new BrokerException(this.br.getKString("B4278", String.valueOf(l)), exception3);
                }
                Object var12_8 = null;
                if (!bl2) break block13;
            }
            catch (Throwable throwable) {
                Object var12_9 = null;
                if (bl2) {
                    Util.close(resultSet, preparedStatement, connection, exception);
                    throw throwable;
                }
                Util.close(resultSet, preparedStatement, null, exception);
                throw throwable;
            }
            Util.close(resultSet, preparedStatement, connection, exception);
            return bl;
        }
        Util.close(resultSet, preparedStatement, null, exception);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public HashMap getDebugInfo(Connection connection) {
        StringBuffer stringBuffer;
        HashMap<String, String> hashMap;
        block17: {
            hashMap = new HashMap<String, String>();
            stringBuffer = new StringBuffer(512);
            boolean bl = false;
            PreparedStatement preparedStatement = null;
            ResultSet resultSet = null;
            Exception exception = null;
            if (connection == null) {
                connection = DBManager.getDBManager().getConnection(true);
                bl = true;
            }
            preparedStatement = connection.prepareStatement(this.selectAllSQL);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                long l = resultSet.getLong(5);
                stringBuffer.append("(").append("sessionID=").append(resultSet.getLong(1)).append(", brokerID=").append(resultSet.getString(2)).append(", isCurrent=").append(resultSet.getInt(3) == 1).append(", createdBy=").append(resultSet.getString(4)).append(", createdTS=").append(l).append(l > 0L ? " [" + new Date(l) + "]" : "").append(")").append(BrokerResources.NL);
            }
            Object var11_10 = null;
            try {
                if (bl) {
                    Util.close(resultSet, preparedStatement, connection, exception);
                    break block17;
                }
                Util.close(resultSet, preparedStatement, null, exception);
            }
            catch (BrokerException brokerException) {
                this.logger.log(32, brokerException.getMessage(), brokerException.getCause());
            }
            break block17;
            {
                catch (Exception exception2) {
                    exception = exception2;
                    try {
                        if (connection != null && !connection.getAutoCommit()) {
                            connection.rollback();
                        }
                    }
                    catch (SQLException sQLException) {
                        this.logger.log(32, "B4080[" + this.selectAllSQL + "]", sQLException);
                    }
                    this.logger.log(32, "B4166", (Object)this.selectAllSQL, (Throwable)exception2);
                    Object var11_11 = null;
                    try {
                        if (bl) {
                            Util.close(resultSet, preparedStatement, connection, exception);
                            break block17;
                        }
                        Util.close(resultSet, preparedStatement, null, exception);
                    }
                    catch (BrokerException brokerException) {
                        this.logger.log(32, brokerException.getMessage(), brokerException.getCause());
                    }
                }
            }
            catch (Throwable throwable) {
                Object var11_12 = null;
                try {
                    if (bl) {
                        Util.close(resultSet, preparedStatement, connection, exception);
                    } else {
                        Util.close(resultSet, preparedStatement, null, exception);
                    }
                }
                catch (BrokerException brokerException) {
                    this.logger.log(32, brokerException.getMessage(), brokerException.getCause());
                }
                throw throwable;
            }
        }
        hashMap.put("Store Session(" + this.tableName + ")", stringBuffer.toString());
        return hashMap;
    }
}

