/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.registry.uddi.infomodel;

import com.sun.xml.registry.uddi.infomodel.RegistryObjectImpl;
import com.sun.xml.registry.uddi.infomodel.SpecificationLinkImpl;
import com.sun.xml.registry.uddi.infomodel.URIValidatorImpl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.ResourceBundle;
import javax.xml.registry.InvalidRequestException;
import javax.xml.registry.JAXRException;
import javax.xml.registry.UnexpectedObjectException;
import javax.xml.registry.infomodel.Service;
import javax.xml.registry.infomodel.ServiceBinding;
import javax.xml.registry.infomodel.SpecificationLink;

public class ServiceBindingImpl
extends RegistryObjectImpl
implements ServiceBinding,
Serializable {
    private String accessURI;
    private ServiceBinding targetBinding;
    private Service parentService;
    private ArrayList specificationLinks;
    private URIValidatorImpl validator = new URIValidatorImpl();

    public ServiceBindingImpl() {
        this.specificationLinks = new ArrayList();
    }

    public String getAccessURI() throws JAXRException {
        if (this.accessURI == null) {
            this.getObject();
        }
        return this.accessURI;
    }

    public void setAccessURI(String string2) throws JAXRException {
        if (this.targetBinding != null) {
            throw new InvalidRequestException(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("ServiceBindingImpl:TargetBinding_already_set"));
        }
        this.getObject();
        this.validator.validate(string2);
        this.accessURI = string2;
        this.setIsModified(true);
    }

    public ServiceBinding getTargetBinding() throws JAXRException {
        if (this.targetBinding == null) {
            this.getObject();
        }
        return this.targetBinding;
    }

    public void setTargetBinding(ServiceBinding serviceBinding) throws JAXRException {
        if (this.accessURI != null) {
            throw new InvalidRequestException(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("ServiceBindingImpl:AccessURI_already_set"));
        }
        this.getObject();
        this.targetBinding = serviceBinding;
        this.setIsModified(true);
    }

    public Service getService() throws JAXRException {
        if (this.parentService == null) {
            this.getObject();
        }
        return this.parentService;
    }

    public void setService(Service service) {
        this.parentService = service;
    }

    public Collection getSpecificationLinks() throws JAXRException {
        if (this.specificationLinks.size() == 0) {
            this.getObject();
        }
        return (Collection)this.specificationLinks.clone();
    }

    public void addSpecificationLink(SpecificationLink specificationLink) throws JAXRException {
        if (specificationLink != null) {
            this.getObject();
            ((SpecificationLinkImpl)specificationLink).setServiceBinding(this);
            this.specificationLinks.add(specificationLink);
            this.setIsModified(true);
        }
    }

    public void addSpecificationLinks(Collection collection) throws JAXRException {
        if (collection == null) {
            return;
        }
        this.getObject();
        Iterator iterator = collection.iterator();
        try {
            while (iterator.hasNext()) {
                ((SpecificationLinkImpl)iterator.next()).setServiceBinding(this);
            }
        }
        catch (ClassCastException classCastException) {
            throw new UnexpectedObjectException(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("ServiceBindingImpl:Objects_in_collection_must_be_SpecificationLinks"), classCastException);
        }
        this.specificationLinks.addAll(collection);
        this.setIsModified(true);
    }

    public void removeSpecificationLink(SpecificationLink specificationLink) throws JAXRException {
        if (specificationLink != null) {
            this.getObject();
            this.specificationLinks.remove(specificationLink);
            this.setIsModified(true);
        }
    }

    public void removeSpecificationLinks(Collection collection) throws JAXRException {
        if (collection != null) {
            this.getObject();
            this.specificationLinks.removeAll(collection);
            this.setIsModified(true);
        }
    }

    public void setSpecificationLinks(Collection collection) throws JAXRException {
        if (collection == null) {
            this.specificationLinks = new ArrayList();
        } else {
            this.getObject();
            this.specificationLinks = new ArrayList(collection);
        }
    }

    public void setValidateURI(boolean bl) {
        this.validator.setValidateURI(bl);
    }

    public boolean getValidateURI() {
        return this.validator.getValidateURI();
    }

    int getSequenceId(SpecificationLink specificationLink) {
        return this.specificationLinks.indexOf(specificationLink);
    }
}

