/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.metadata.cache;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.Set;
import javax.enterprise.util.Nonbinding;
import javax.inject.Qualifier;
import org.jboss.weld.exceptions.WeldException;
import org.jboss.weld.introspector.WeldMethod;
import org.jboss.weld.logging.Category;
import org.jboss.weld.logging.LoggerFactory;
import org.jboss.weld.logging.messages.MetadataMessage;
import org.jboss.weld.metadata.cache.AnnotationModel;
import org.jboss.weld.resources.ClassTransformer;
import org.jboss.weld.util.reflection.Reflections;
import org.slf4j.cal10n.LocLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QualifierModel<T extends Annotation>
extends AnnotationModel<T> {
    private static final LocLogger log = LoggerFactory.loggerFactory().getLogger(Category.REFLECTION);
    private static final Set<Class<? extends Annotation>> META_ANNOTATIONS = Collections.singleton(Qualifier.class);
    private Set<WeldMethod<?, ?>> nonBindingMembers;

    public QualifierModel(Class<T> type, ClassTransformer transformer) {
        super(type, transformer);
    }

    @Override
    protected void init() {
        super.init();
        this.initNonBindingMembers();
        this.checkArrayAndAnnotationValuedMembers();
    }

    private void checkArrayAndAnnotationValuedMembers() {
        for (WeldMethod<?, ?> annotatedMethod : this.getAnnotatedAnnotation().getMembers()) {
            if (!Reflections.isArrayType(annotatedMethod.getJavaClass()) && !Annotation.class.isAssignableFrom(annotatedMethod.getJavaClass()) || this.nonBindingMembers.contains(annotatedMethod)) continue;
            this.valid = false;
            log.debug(MetadataMessage.NON_BINDING_MEMBER_TYPE, annotatedMethod);
        }
    }

    @Override
    protected Set<Class<? extends Annotation>> getMetaAnnotationTypes() {
        return META_ANNOTATIONS;
    }

    public boolean hasNonBindingMembers() {
        return this.nonBindingMembers.size() > 0;
    }

    public Set<WeldMethod<?, ?>> getNonBindingMembers() {
        return this.nonBindingMembers;
    }

    protected void initNonBindingMembers() {
        this.nonBindingMembers = this.getAnnotatedAnnotation().getMembers(Nonbinding.class);
    }

    public boolean isEqual(Annotation instance, Annotation other) {
        if (instance.annotationType().equals(this.getRawType()) && other.annotationType().equals(this.getRawType())) {
            for (WeldMethod<?, ?> annotatedMethod : this.getAnnotatedAnnotation().getMembers()) {
                if (this.nonBindingMembers.contains(annotatedMethod)) continue;
                try {
                    Object thatValue;
                    Object thisValue = annotatedMethod.invoke(instance, new Object[0]);
                    if (thisValue.equals(thatValue = annotatedMethod.invoke(other, new Object[0]))) continue;
                    return false;
                }
                catch (IllegalArgumentException e) {
                    throw new WeldException(e);
                }
                catch (IllegalAccessException e) {
                    throw new WeldException(e);
                }
                catch (InvocationTargetException e) {
                    throw new WeldException(e);
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public String toString() {
        return (this.isValid() ? "Valid" : "Invalid") + " qualifer model for " + this.getRawType() + " with non-binding members " + this.getNonBindingMembers();
    }
}

