/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admingui.common.handlers;

import com.sun.jsftemplating.layout.descriptors.handler.HandlerContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.management.Attribute;
import javax.management.ObjectName;
import org.glassfish.admin.amx.core.AMXProxy;
import org.glassfish.admin.amx.intf.config.JavaConfig;
import org.glassfish.admingui.common.util.GuiUtil;
import org.glassfish.admingui.common.util.V3AMX;

public class InstanceHandler {
    private static final String PROPERTY_VALUE = "Value";

    public static void getDebugInfo(HandlerContext handlerCtx) {
        String debugOptions = (String)handlerCtx.getInputValue("debugOptions");
        String debugPort = "";
        StringTokenizer tokens = new StringTokenizer(debugOptions, ",");
        String doption = "";
        while (tokens.hasMoreTokens()) {
            int pos;
            doption = tokens.nextToken().trim();
            if (!doption.startsWith("address") || (pos = doption.indexOf("=")) < 0) continue;
            debugPort = doption.substring(pos + 1).trim();
            break;
        }
        Boolean debugEnabled = (Boolean)handlerCtx.getInputValue("debugEnabled");
        String msg = "true".equals("" + debugEnabled) ? GuiUtil.getMessage("inst.debugEnabled") + debugPort : GuiUtil.getMessage("inst.notEnabled");
        handlerCtx.setOutputValue("debugInfo", (Object)msg);
    }

    public static void getProfilerAttrs(HandlerContext handlerCtx) {
        ObjectName objName = null;
        Boolean edit = false;
        try {
            JavaConfig amx = V3AMX.getInstance().getConfig("server-config").getJava();
            objName = (ObjectName)amx.attributesMap().get("Profiler");
            if (objName != null) {
                edit = true;
            }
            handlerCtx.setOutputValue("edit", (Object)edit);
            handlerCtx.setOutputValue("objectName", (Object)objName);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            handlerCtx.setOutputValue("edit", (Object)false);
        }
    }

    public static void getJvmOptionsValues(HandlerContext handlerCtx) {
        try {
            String objectNameStr = (String)handlerCtx.getInputValue("objectNameStr");
            AMXProxy amx = V3AMX.getInstance().getProxyFactory().getProxy(new ObjectName(objectNameStr));
            Object[] options = (String[])amx.attributesMap().get("JvmOptions");
            handlerCtx.setOutputValue("result", GuiUtil.convertArrayToListOfMap(options, PROPERTY_VALUE));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            handlerCtx.setOutputValue("result", new HashMap());
        }
    }

    public static void saveJvmOptionValues(HandlerContext handlerCtx) {
        ArrayList<String> newList = new ArrayList<String>();
        try {
            String objectNameStr = (String)handlerCtx.getInputValue("objectNameStr");
            ObjectName objectName = new ObjectName(objectNameStr);
            List options = (List)handlerCtx.getInputValue("options");
            for (Map oneRow : options) {
                String value = (String)oneRow.get(PROPERTY_VALUE);
                if (GuiUtil.isEmpty(value)) continue;
                newList.add(value);
            }
            V3AMX.setAttribute(objectName, new Attribute("JvmOptions", newList.toArray(new String[0])));
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public static void restartDomain(HandlerContext handlerCtx) {
        V3AMX.getInstance().getRuntime().restartDomain();
    }

    public static void stopDomain(HandlerContext handlerCtx) {
        V3AMX.getInstance().getDomainRoot().stopDomain();
    }

    public static void getJvmReport(HandlerContext handlerCtx) {
        String type = (String)handlerCtx.getInputValue("type");
        if (type == null || type.equals("")) {
            type = "summary";
        }
        try {
            String report = V3AMX.getInstance().getRuntime().getJVMReport(type);
            handlerCtx.setOutputValue("report", (Object)report);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            handlerCtx.setOutputValue("report", (Object)"");
        }
    }
}

