/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.uc.admingui;

import com.sun.jsftemplating.layout.descriptors.handler.HandlerContext;
import com.sun.pkg.client.Fmri;
import com.sun.pkg.client.Image;
import com.sun.pkg.client.LicenseAction;
import com.sun.pkg.client.Manifest;
import com.sun.pkg.client.SystemInfo;
import com.sun.pkg.client.Version;
import java.io.File;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.glassfish.admingui.common.util.GuiUtil;
import org.glassfish.admingui.common.util.V3AMXUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpdateCenterHandlers {
    private static final String CATEGORY = "info.classification";
    private static final String DESC_LONG = "description_long";
    private static final String PKG_DESC = "pkg.description";
    private static final String PKG_SUMMARY = "pkg.summary";
    private static final String DESC = "description";
    private static final String UPDATE_COUNT = "__gui_uc_update_count";
    private static final String CATALOG_REFRESHED = "__gui_uc_catalog_refreshed";
    private static final String UCDIR = "__gui_uc_installation_dir";
    private static final String USER_OK = "__gui_uc_userok";
    private static final String BUNDLE = "org.glassfish.updatecenter.admingui.Strings";
    private static final int MB = 0x100000;

    public static void getInstalledPath(HandlerContext handlerCtx) {
        Image image = UpdateCenterHandlers.getUpdateCenterImage();
        handlerCtx.setOutputValue("result", image == null ? GuiUtil.getMessage((String)BUNDLE, (String)"updateCenter.NoImageDirectory") : image.getRootDirectory());
    }

    public static void getAuthority(HandlerContext handlerCtx) {
        Image image = UpdateCenterHandlers.getUpdateCenterImage();
        handlerCtx.setOutputValue("result", (Object)(image == null ? "" : image.getPreferredAuthorityName()));
    }

    public static void getPkgDetailsInfo(HandlerContext handlerCtx) {
        String fmriStr = (String)handlerCtx.getInputValue("fmriStr");
        if (fmriStr == null) {
            handlerCtx.setOutputValue("details", new HashMap());
            return;
        }
        Fmri fmri = new Fmri(fmriStr);
        HashMap<String, Object> details = new HashMap<String, Object>();
        Image img = UpdateCenterHandlers.getUpdateCenterImage();
        try {
            details.put("pkgName", fmri.getName());
            details.put("uid", fmri.toString());
            details.put("version", UpdateCenterHandlers.getPkgVersion(fmri.getVersion()));
            details.put("date", fmri.getVersion().getPublishDate());
            details.put("auth", (String)handlerCtx.getInputValue("auth"));
            details.put("url", fmri.getURLPath());
            if (img != null) {
                Manifest manifest = img.getManifest(fmri);
                details.put("category", UpdateCenterHandlers.getCategory(manifest));
                details.put("bytes", "" + manifest.getPackageSize());
                details.put("pkgSize", UpdateCenterHandlers.getPkgSize(manifest));
                String desc = manifest.getAttribute(PKG_DESC);
                if (GuiUtil.isEmpty((String)desc) && GuiUtil.isEmpty((String)(desc = manifest.getAttribute(DESC_LONG))) && GuiUtil.isEmpty((String)(desc = manifest.getAttribute(PKG_SUMMARY)))) {
                    desc = manifest.getAttribute(DESC);
                }
                details.put("desc", desc);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        handlerCtx.setOutputValue("details", details);
    }

    private static String getCategory(Manifest manifest) {
        String attr = manifest.getAttribute(CATEGORY);
        int index = attr.indexOf(":");
        return index == -1 ? attr : attr.substring(index + 1);
    }

    public static void getUcList(HandlerContext handlerCtx) {
        GuiUtil.setSessionValue((String)USER_OK, (Object)Boolean.TRUE);
        ArrayList result = new ArrayList();
        try {
            Image img = UpdateCenterHandlers.getUpdateCenterImage();
            if (img == null) {
                handlerCtx.setOutputValue("result", result);
                return;
            }
            String state = (String)handlerCtx.getInputValue("state");
            if (state.equals("update")) {
                handlerCtx.setOutputValue("result", (Object)UpdateCenterHandlers.getUpdateDisplayList(img, false));
                return;
            }
            List<Fmri> displayList = null;
            if (state.equals("installed")) {
                displayList = UpdateCenterHandlers.getInstalledList(img);
            } else if (state.equals("addOn")) {
                displayList = UpdateCenterHandlers.getAddOnList(img);
            }
            for (Fmri fmri : displayList) {
                HashMap<String, Object> oneRow = new HashMap<String, Object>();
                try {
                    Manifest manifest = img.getManifest(fmri);
                    oneRow.put("selected", false);
                    oneRow.put("fmri", fmri);
                    oneRow.put("fmriStr", fmri.toString());
                    UpdateCenterHandlers.putInfo(oneRow, "pkgName", fmri.getName());
                    UpdateCenterHandlers.putInfo(oneRow, "version", UpdateCenterHandlers.getPkgVersion(fmri.getVersion()));
                    UpdateCenterHandlers.putInfo(oneRow, "newVersion", "");
                    UpdateCenterHandlers.putInfo(oneRow, "category", UpdateCenterHandlers.getCategory(manifest));
                    UpdateCenterHandlers.putInfo(oneRow, "pkgSize", UpdateCenterHandlers.getPkgSize(manifest));
                    oneRow.put("size", manifest.getPackageSize());
                    UpdateCenterHandlers.putInfo(oneRow, "auth", fmri.getAuthority());
                    String tooltip = manifest.getAttribute(PKG_SUMMARY);
                    if (GuiUtil.isEmpty((String)tooltip)) {
                        tooltip = manifest.getAttribute(DESC);
                    }
                    UpdateCenterHandlers.putInfo(oneRow, "tooltip", tooltip);
                    result.add(oneRow);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        catch (Exception ex1) {
            ex1.printStackTrace();
        }
        handlerCtx.setOutputValue("result", result);
    }

    public static void getAuthList(HandlerContext handlerCtx) {
        ArrayList result = new ArrayList();
        try {
            Image image = UpdateCenterHandlers.getUpdateCenterImage();
            if (image == null) {
                handlerCtx.setOutputValue("result", result);
                return;
            }
            String[] auths = image.getAuthorityNames();
            for (int i = 0; i < auths.length; ++i) {
                HashMap<String, String> oneRow = new HashMap<String, String>();
                oneRow.put("authName", auths[i]);
                result.add(oneRow);
            }
        }
        catch (Exception ex1) {
            ex1.printStackTrace();
        }
        handlerCtx.setOutputValue("result", result);
    }

    public static void getProxyInfo(HandlerContext handlerCtx) {
        InetSocketAddress address;
        Proxy proxy = SystemInfo.getProxy();
        if (proxy != null && (address = (InetSocketAddress)proxy.address()) != null) {
            handlerCtx.setOutputValue("connection", (Object)"useProxy");
            handlerCtx.setOutputValue("host", (Object)address.getHostName());
            handlerCtx.setOutputValue("port", (Object)address.getPort());
            return;
        }
        handlerCtx.setOutputValue("connection", (Object)"direct");
        handlerCtx.setOutputValue("host", (Object)"");
        handlerCtx.setOutputValue("port", (Object)"");
    }

    public static void setProxyInfo(HandlerContext handlerCtx) {
        String connection = (String)handlerCtx.getInputValue("connection");
        String host = (String)handlerCtx.getInputValue("host");
        String port = (String)handlerCtx.getInputValue("port");
        try {
            Image image = UpdateCenterHandlers.getUpdateCenterImage();
            if (connection.equals("useProxy")) {
                int portNo = Integer.parseInt(port);
                InetSocketAddress address = new InetSocketAddress(host, portNo);
                image.setProxy(new Proxy(Proxy.Type.HTTP, address));
                String url = "http://" + host + ":" + portNo;
                Properties prop = new Properties();
                prop.setProperty("proxy.URL", url);
                SystemInfo.initUpdateToolProps((Properties)prop);
            } else {
                image.setProxy(null);
                Properties prop = new Properties();
                prop.setProperty("proxy.URL", "");
                SystemInfo.initUpdateToolProps((Properties)prop);
            }
        }
        catch (Exception ex) {
            GuiUtil.handleException((HandlerContext)handlerCtx, (Throwable)ex);
        }
    }

    private static void putInfo(Map oneRow, String key, String value) {
        oneRow.put(key, GuiUtil.isEmpty((String)value) ? "" : value);
    }

    private static List<Fmri> getInstalledList(Image image) {
        List fList = image.getInventory(null, false);
        ArrayList<Fmri> result = new ArrayList<Fmri>();
        for (Image.FmriState fs : fList) {
            result.add(fs.fmri);
        }
        return result;
    }

    private static List<Fmri> getAddOnList(Image image) {
        ArrayList<String> installed = new ArrayList<String>();
        for (Image.FmriState each : image.getInventory(null, false)) {
            installed.add(each.fmri.getName());
        }
        String pAuth = image.getPreferredAuthorityName();
        HashMap<String, Fmri> pMap = new HashMap<String, Fmri>();
        ArrayList<Fmri> allList = new ArrayList<Fmri>();
        for (Image.FmriState each : image.getInventory(null, true)) {
            Fmri fmri = each.fmri;
            if (each.upgradable || each.installed || installed.contains(fmri.getName())) continue;
            allList.add(fmri);
            if (!fmri.getAuthority().equals(pAuth)) continue;
            pMap.put(fmri.getName(), fmri);
        }
        ArrayList<Fmri> result = new ArrayList<Fmri>();
        for (Fmri test : allList) {
            if (pMap.get(test.getName()) == null) {
                result.add(test);
                continue;
            }
            if (!test.getAuthority().equals(pAuth)) continue;
            result.add(test);
        }
        return result;
    }

    private static List getUpdateDisplayList(Image image, boolean countOnly) {
        ArrayList<Serializable> result;
        block8: {
            List installed = image.getInventory(null, false);
            HashMap<String, Fmri> updateListMap = new HashMap<String, Fmri>();
            ArrayList<String> nameList = new ArrayList<String>();
            for (Image.FmriState fs : installed) {
                if (!fs.upgradable) continue;
                Fmri fmri = fs.fmri;
                updateListMap.put(fmri.getName(), fmri);
                nameList.add(fmri.getName());
            }
            result = new ArrayList<Serializable>();
            String[] pkgsName = nameList.toArray(new String[nameList.size()]);
            try {
                Image.ImagePlan ip = image.makeInstallPlan(pkgsName);
                Fmri[] proposed = ip.getProposedFmris();
                if (countOnly) {
                    result.add(new Integer(proposed.length));
                    return result;
                }
                for (Fmri newPkg : proposed) {
                    HashMap<String, Object> oneRow = new HashMap<String, Object>();
                    try {
                        String name = newPkg.getName();
                        Fmri oldPkg = (Fmri)updateListMap.get(name);
                        Manifest manifest = image.getManifest(newPkg);
                        int changedSize = manifest.getPackageSize() - image.getManifest(oldPkg).getPackageSize();
                        oneRow.put("selected", false);
                        oneRow.put("fmri", newPkg);
                        oneRow.put("fmriStr", newPkg.toString());
                        UpdateCenterHandlers.putInfo(oneRow, "pkgName", name);
                        UpdateCenterHandlers.putInfo(oneRow, "newVersion", UpdateCenterHandlers.getPkgVersion(newPkg.getVersion()));
                        UpdateCenterHandlers.putInfo(oneRow, "version", UpdateCenterHandlers.getPkgVersion(oldPkg.getVersion()));
                        UpdateCenterHandlers.putInfo(oneRow, "category", UpdateCenterHandlers.getCategory(manifest));
                        UpdateCenterHandlers.putInfo(oneRow, "pkgSize", UpdateCenterHandlers.convertSizeForDispay(changedSize));
                        oneRow.put("size", changedSize);
                        UpdateCenterHandlers.putInfo(oneRow, "auth", newPkg.getAuthority());
                        String tooltip = manifest.getAttribute(PKG_SUMMARY);
                        if (GuiUtil.isEmpty((String)tooltip)) {
                            tooltip = manifest.getAttribute(DESC);
                        }
                        UpdateCenterHandlers.putInfo(oneRow, "tooltip", tooltip);
                        result.add(oneRow);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                if (!countOnly) break block8;
                ArrayList<Integer> tmpL = new ArrayList<Integer>();
                tmpL.add(new Integer(-1));
                return tmpL;
            }
        }
        return result;
    }

    public static void updateCenterProcess(HandlerContext handlerCtx) {
        List obj;
        Image image = UpdateCenterHandlers.getUpdateCenterImage();
        boolean install = false;
        String action = (String)handlerCtx.getInputValue("action");
        if (action.equals("install")) {
            install = true;
        }
        if ((obj = (List)handlerCtx.getInputValue("selectedRows")) == null) {
            System.out.println("updateCenterProcess: No row selected for ");
            return;
        }
        List selectedRows = obj;
        ArrayList<Fmri> fList = new ArrayList<Fmri>();
        try {
            for (Map oneRow : selectedRows) {
                fList.add((Fmri)oneRow.get("fmri"));
            }
            if (install) {
                image.installPackages(fList);
                UpdateCenterHandlers.updateCountInSession(image);
            } else {
                image.uninstallPackages(fList);
            }
            GuiUtil.setSessionValue((String)"restartRequired", (Object)Boolean.TRUE);
        }
        catch (Exception ex) {
            GuiUtil.handleException((HandlerContext)handlerCtx, (Throwable)ex);
            ex.printStackTrace();
        }
    }

    public static void getLicenseText(HandlerContext handlerCtx) {
        List obj = (List)handlerCtx.getInputValue("selectedRows");
        Image image = UpdateCenterHandlers.getUpdateCenterImage();
        List selectedRows = obj;
        try {
            StringBuffer allLicense = new StringBuffer();
            for (Map oneRow : selectedRows) {
                Fmri fmri = (Fmri)oneRow.get("fmri");
                allLicense.append(UpdateCenterHandlers.getLicense(image, fmri));
            }
            handlerCtx.setOutputValue("license", (Object)("" + allLicense));
            handlerCtx.setOutputValue("hasLicense", (Object)(allLicense.length() > 0 ? 1 : 0));
        }
        catch (Exception ex) {
            GuiUtil.handleException((HandlerContext)handlerCtx, (Throwable)ex);
        }
    }

    public static void getUpdateComponentCount(HandlerContext handlerCtx) {
        Boolean userOK = (Boolean)GuiUtil.getSessionValue((String)USER_OK);
        if (userOK == null) {
            boolean donotping;
            SystemInfo.UpdateCheckFrequency userPreference = SystemInfo.getUpdateCheckFrequency();
            boolean bl = donotping = userPreference == SystemInfo.UpdateCheckFrequency.NEVER;
            if (donotping) {
                GuiUtil.getLogger().info("UpdateCheckFrequency is set to NEVER by user.  Component update count not performed. ");
                GuiUtil.setSessionValue((String)USER_OK, (Object)Boolean.FALSE);
                handlerCtx.setOutputValue("count", (Object)-1);
                return;
            }
            GuiUtil.setSessionValue((String)USER_OK, (Object)Boolean.TRUE);
        } else if (!userOK.booleanValue()) {
            handlerCtx.setOutputValue("count", (Object)-1);
            return;
        }
        Integer countInt = (Integer)GuiUtil.getSessionValue((String)UPDATE_COUNT);
        if (countInt == null) {
            Image image = UpdateCenterHandlers.getUpdateCenterImage();
            countInt = UpdateCenterHandlers.updateCountInSession(image);
        }
        GuiUtil.getLogger().info("Update Component count = " + countInt);
        handlerCtx.setOutputValue("count", (Object)countInt);
    }

    private static Integer updateCountInSession(Image image) {
        Integer countInt = new Integer(-1);
        if (image != null) {
            List list = UpdateCenterHandlers.getUpdateDisplayList(image, true);
            countInt = (Integer)list.get(0);
        } else {
            GuiUtil.getLogger().warning("Error in getting update component list, cannot get image.");
        }
        GuiUtil.setSessionValue((String)UPDATE_COUNT, (Object)countInt);
        return countInt;
    }

    private static String getLicense(Image img, Fmri fmri) {
        StringBuffer licenseText = new StringBuffer();
        try {
            Manifest manifest = img.getManifest(fmri);
            List lla = manifest.getActionsByType(LicenseAction.class);
            for (LicenseAction la : lla) {
                licenseText.append("============= ").append(la.getName()).append(" ================\n");
                licenseText.append(fmri.toString());
                licenseText.append("\n\n");
                licenseText.append(la.getText());
                licenseText.append("\n\n");
            }
            return "" + licenseText;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    private static String getPkgVersion(Version version) {
        String dotSequence = version.getRelease().toString();
        String branch = version.getBranch().toString();
        return GuiUtil.isEmpty((String)branch) ? dotSequence : dotSequence + "-" + branch;
    }

    private static String getPkgSize(Manifest manifest) {
        int size = manifest.getPackageSize();
        return UpdateCenterHandlers.convertSizeForDispay(size);
    }

    private static String convertSizeForDispay(int size) {
        String sizep = size <= 0x100000 ? size / 1024 + GuiUtil.getMessage((String)BUNDLE, (String)"sizeKB") : size / 0x100000 + GuiUtil.getMessage((String)BUNDLE, (String)"sizeMB");
        return sizep;
    }

    private static String getPkgDate(Version version) {
        int begin = version.toString().indexOf(":");
        int end = version.toString().indexOf("T");
        String dateStr = version.toString().substring(begin + 1, end);
        String result = dateStr.substring(0, 4) + "/" + dateStr.substring(4, 6) + "/" + dateStr.substring(6, 8);
        return result;
    }

    private static Image getUpdateCenterImage() {
        String ucDir = (String)GuiUtil.getSessionValue((String)UCDIR);
        if (ucDir == null) {
            String installDir = V3AMXUtil.getInstallDir();
            ucDir = new File(installDir).getParent();
            GuiUtil.setSessionValue((String)UCDIR, (Object)ucDir);
        }
        Image image = null;
        try {
            image = new Image(new File(ucDir));
            UpdateCenterHandlers.refreshCatalog(image);
        }
        catch (Exception ex) {
            System.out.println("Cannot create update center Image for " + ucDir + "; Update Center functionality will not be available in Admin Console ");
        }
        return image;
    }

    private static synchronized void refreshCatalog(Image image) {
        try {
            if (GuiUtil.getSessionValue((String)CATALOG_REFRESHED) == null) {
                GuiUtil.setSessionValue((String)CATALOG_REFRESHED, (Object)"TRUE");
                image.refreshCatalogs();
            }
        }
        catch (Exception ex) {
            System.out.println("Cannot refresh Catalog : " + ex.getMessage());
        }
    }
}

