/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.plugin.common;

import org.jvnet.hk2.config.Attribute;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.Configured;
import org.jvnet.hk2.config.DuckTyped;
import org.jvnet.hk2.config.Element;

@Configured
public interface EnvEntry
extends ConfigBeanProxy {
    @Element
    public String getDescription();

    public void setDescription(String var1);

    @Element(required=true, key=true)
    public String getEnvEntryName();

    public void setEnvEntryName(String var1);

    @Element(required=true)
    public String getEnvEntryType();

    public void setEnvEntryType(String var1);

    @Element(required=true)
    public String getEnvEntryValue();

    public void setEnvEntryValue(String var1);

    @Attribute(dataType=Boolean.class, defaultValue="false")
    public String getIgnoreDescriptorItem();

    public void setIgnoreDescriptorItem(String var1);

    @DuckTyped
    public void validateValue();

    public static class Duck {
        public static void validateValue(EnvEntry me) {
            String type = me.getEnvEntryType();
            String value = me.getEnvEntryValue();
            Util.validateValue(type, value);
        }
    }

    public static class Util {
        public static void validateValue(String type, String value) {
            if (type == null) {
                throw new IllegalArgumentException("type");
            }
            if (value == null) {
                throw new IllegalArgumentException("value");
            }
            if (type.equals("java.lang.Boolean")) {
                Boolean.parseBoolean(value);
            } else if (type.equals("java.lang.Byte")) {
                Byte.parseByte(value);
            } else if (type.equals("java.lang.Character")) {
                if (value.length() > 1) {
                    throw new IllegalArgumentException("length(\"" + value + "\") > 1");
                }
            } else if (type.equals("java.lang.Double")) {
                Double.parseDouble(value);
            } else if (type.equals("java.lang.Float")) {
                Float.parseFloat(value);
            } else if (type.equals("java.lang.Integer")) {
                Integer.parseInt(value);
            } else if (type.equals("java.lang.Long")) {
                Long.parseLong(value);
            } else if (type.equals("java.lang.Short")) {
                Short.parseShort(value);
            } else if (!type.equals("java.lang.String")) {
                throw new IllegalArgumentException(type);
            }
        }
    }
}

