/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hk2.osgiadapter;

import com.sun.enterprise.module.ModuleDefinition;
import com.sun.enterprise.module.common_impl.DirectoryBasedRepository;
import java.io.File;
import java.io.IOException;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Level;
import org.jvnet.hk2.osgiadapter.Logger;
import org.jvnet.hk2.osgiadapter.OSGiModuleDefinition;

public class OSGiDirectoryBasedRepository
extends DirectoryBasedRepository {
    public OSGiDirectoryBasedRepository(String name, File repository) {
        super(name, repository);
    }

    public OSGiDirectoryBasedRepository(String name, File repository, boolean isTimerThreadDaemon) {
        super(name, repository, isTimerThreadDaemon);
    }

    protected ModuleDefinition loadJar(File jar) throws IOException {
        assert (jar.isFile());
        Manifest m = new JarFile(jar).getManifest();
        if (m != null && m.getMainAttributes().getValue("Bundle-SymbolicName") != null) {
            Logger.logger.logp(Level.FINE, "OSGiDirectoryBasedRepository", "loadJar", "{0} is an OSGi bundle", new Object[]{jar});
            return this.newModuleDefinition(jar, null);
        }
        return null;
    }

    protected ModuleDefinition newModuleDefinition(File jar, Attributes attr) throws IOException {
        return new OSGiModuleDefinition(jar);
    }
}

