/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.management.jesmf;

import com.sun.cmm.ResourceType;
import com.sun.cmm.cim.ImplementationInfo;
import com.sun.cmm.cim.InfoFormat;
import com.sun.cmm.cim.OperationalStatus;
import com.sun.messaging.jmq.io.MQAddress;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.config.BrokerConfig;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.management.agent.Agent;
import com.sun.messaging.jmq.jmsserver.management.agent.JesmfManager;
import com.sun.messaging.jmq.jmsserver.management.jesmf.JesmfNames;
import com.sun.messaging.jmq.jmsserver.management.jesmf.delegate.CP_MQDestinationQueueStatsDelegate;
import com.sun.messaging.jmq.jmsserver.management.jesmf.delegate.CP_MQDestinationStatsDelegate;
import com.sun.messaging.jmq.jmsserver.management.jesmf.delegate.CP_MQDestinationTopicStatsDelegate;
import com.sun.messaging.jmq.jmsserver.management.jesmf.delegate.CP_MQServiceAccessURIStatsDelegate;
import com.sun.messaging.jmq.jmsserver.management.jesmf.delegate.CP_MQStatsDelegate;
import com.sun.messaging.jmq.jmsserver.management.jesmf.delegate.CP_ThreadPoolStatsDelegate;
import com.sun.messaging.jmq.jmsserver.management.mbeans.BrokerMonitor;
import com.sun.messaging.jmq.jmsserver.management.mbeans.DestinationConfig;
import com.sun.messaging.jmq.jmsserver.management.mbeans.DestinationMonitor;
import com.sun.messaging.jmq.jmsserver.management.mbeans.ServiceConfig;
import com.sun.messaging.jmq.jmsserver.management.mbeans.ServiceMonitor;
import com.sun.messaging.jmq.jmsserver.management.util.DestinationUtil;
import com.sun.messaging.jmq.jmsserver.management.util.MQAddressUtil;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.DBManager;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.util.log.Logger;
import com.sun.mfwk.instrum.me.CIM_ManagedElementInstrum;
import com.sun.mfwk.instrum.me.CMM_ApplicationSystemInstrum;
import com.sun.mfwk.instrum.me.CMM_JDBCRemoteServiceAccessPointInstrum;
import com.sun.mfwk.instrum.me.CMM_LDAPRemoteServiceAccessPointInstrum;
import com.sun.mfwk.instrum.me.CMM_LogicalComponentInstrum;
import com.sun.mfwk.instrum.me.CMM_ObjectInstrum;
import com.sun.mfwk.instrum.me.CMM_SWRFileInstrum;
import com.sun.mfwk.instrum.me.CMM_ServiceAccessURIInstrum;
import com.sun.mfwk.instrum.me.CMM_ThreadPoolInstrum;
import com.sun.mfwk.instrum.me.MfManagedElementInstrumException;
import com.sun.mfwk.instrum.me.settings.CMM_ApplicationSystemSettingInstrum;
import com.sun.mfwk.instrum.me.settings.CMM_LogicalComponentSettingInstrum;
import com.sun.mfwk.instrum.me.settings.CMM_MQDestinationQueueSettingInstrum;
import com.sun.mfwk.instrum.me.settings.CMM_MQDestinationTopicSettingInstrum;
import com.sun.mfwk.instrum.me.settings.CMM_ThreadPoolSettingInstrum;
import com.sun.mfwk.instrum.me.statistics.CMM_ApplicationSystemStatsInstrum;
import com.sun.mfwk.instrum.relations.MfRelationInstrum;
import com.sun.mfwk.instrum.server.MfExtendedManagedElementServer;
import com.sun.mfwk.instrum.server.MfManagedElementInfo;
import com.sun.mfwk.instrum.server.MfManagedElementServerFactory;
import com.sun.mfwk.instrum.server.MfManagedElementType;
import com.sun.mfwk.instrum.server.MfRelationInfo;
import com.sun.mfwk.instrum.server.MfRelationType;
import java.io.Serializable;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.management.remote.JMXServiceURL;

public class JesmfManagerImpl
implements JesmfManager {
    private static boolean DEBUG = Globals.getConfig().getBooleanProperty("imq.jesmf.debug.all");
    private static final String JESMF_PROPBASE = "imq.jesmf.";
    private static final String ENABLED = "imq.jesmf.enabled";
    private static final String RMIREGISTRY_USE = "imq.jesmf.rmiregistry.use";
    private static final String JESMF_CONFIG_PROPBASE = "imq.jesmf.config.";
    private static final String JESMF_CONTEXT_PROPBASE = "imq.jesmf.context.";
    private MfExtendedManagedElementServer mfMEServer = null;
    private CMM_ApplicationSystemInstrum mqAppSystem = null;
    private CMM_ApplicationSystemSettingInstrum mqAppSystemSetting = null;
    private CMM_ApplicationSystemStatsInstrum mqAppSystemStats = null;
    private CMM_ObjectInstrum authSvc = null;
    private Map jesmfObjects = Collections.synchronizedMap(new HashMap());
    private Logger logger = Globals.getLogger();
    private BrokerResources rb = Globals.getBrokerResources();
    private BrokerConfig config = Globals.getConfig();
    private boolean active = false;
    private Agent agent = null;

    public void initialize(Agent agent) {
        Serializable serializable;
        Object var2_2 = null;
        if (!this.jesmfSupportEnabled()) {
            this.logger.log(8, this.rb.getString("B1316"));
            return;
        }
        if (agent == null) {
            this.logger.log(8, this.rb.getString("B1317"));
            return;
        }
        this.agent = agent;
        try {
            serializable = Class.forName("com.sun.mfwk.instrum.me.settings.CMM_MQDestinationQueueSettingInstrum");
        }
        catch (Exception exception) {
            this.logger.log(8, this.rb.getString("B1314"));
            return;
        }
        try {
            this.mfMEServer = (MfExtendedManagedElementServer)MfManagedElementServerFactory.makeManagedElementServer();
            serializable = new Properties();
            this.mergeWithJesmfPropertiesFromBrokerConfig((Properties)serializable);
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            hashtable.put("ProductPrefix", JesmfNames.getProductPrefixCtxKey());
            hashtable.put("ProductCodeName", JesmfNames.getProductCodeNameCtxKey());
            hashtable.put("ProductName", JesmfNames.getProductNameCtxKey());
            hashtable.put("ProductCollectionId", JesmfNames.getProductCollectionIdCtxKey());
            if (DEBUG) {
                this.logger.log(4, "PRODUCT_PREFIX_CTX_KEY: " + JesmfNames.getProductPrefixCtxKey());
                this.logger.log(4, "PRODUCT_CODE_NAME_CTX_KEY: " + JesmfNames.getProductCodeNameCtxKey());
                this.logger.log(4, "PRODUCT_NAME_CTX_KEY: " + JesmfNames.getProductNameCtxKey());
                this.logger.log(4, "PRODUCT_COLLECTIONID_CTX_KEY: " + JesmfNames.getProductCollectionIdCtxKey());
            }
            this.mergeWithJesmfContextFromBrokerConfig(hashtable);
            if (DEBUG) {
                this.logger.log(4, "JESMF: MfManagedElementServer config properties used: " + ((Properties)serializable).toString());
                this.logger.log(4, "JESMF: MfManagedElementServer context data used: " + hashtable.toString());
            }
            this.mfMEServer.initialize(serializable, hashtable);
            this.mfMEServer.start();
            MfManagedElementInfo mfManagedElementInfo = this.mfMEServer.makeManagedElementInfo();
            mfManagedElementInfo.setType(MfManagedElementType.CMM_APPLICATION_SYSTEM);
            mfManagedElementInfo.setName(this.config.getProperty("imq.instancename"));
            this.mqAppSystem = (CMM_ApplicationSystemInstrum)this.mfMEServer.createManagedElement(mfManagedElementInfo);
            this.mqAppSystem.setCaption("A single MQ broker instance: " + this.mqAppSystem.getName());
            this.mqAppSystem.setDescription(JesmfNames.getProductNameCtxKey());
            this.storeCMMObject((CMM_ObjectInstrum)this.mqAppSystem, mfManagedElementInfo.getType());
            HashSet<OperationalStatus> hashSet = new HashSet<OperationalStatus>();
            HashSet<String> hashSet2 = new HashSet<String>();
            hashSet.add(OperationalStatus.OK);
            hashSet2.add(OperationalStatus.OK.toString());
            this.mqAppSystem.setOperationalStatus(hashSet);
            this.mqAppSystem.setStatusDescriptions(hashSet2);
            this.mqAppSystem.setPrimaryOwnerName(Globals.getPrimaryOwnerName());
            this.mqAppSystem.setPrimaryOwnerContact(Globals.getPrimaryOwnerContact());
            this.mqAppSystem.setRoles(Globals.getBrokerAdminDefinedRoles());
            MfRelationInfo mfRelationInfo = this.mfMEServer.makeRelationInfo();
            mfManagedElementInfo.setType(MfManagedElementType.CMM_APPLICATION_SYSTEM_SETTING);
            mfManagedElementInfo.setName(this.config.getProperty("imq.instancename"));
            mfRelationInfo.setType(MfRelationType.CMM_SCOPED_SETTING);
            MfRelationInstrum mfRelationInstrum = this.mfMEServer.createRelationToNewManagedElement((CIM_ManagedElementInstrum)this.mqAppSystem, mfRelationInfo, mfManagedElementInfo);
            this.mqAppSystemSetting = (CMM_ApplicationSystemSettingInstrum)mfRelationInstrum.getDestination();
            this.mqAppSystemSetting.setCaption("A single MQ broker instance: " + this.mqAppSystemSetting.getName());
            this.mqAppSystemSetting.setDescription(JesmfNames.getProductNameCtxKey());
            this.mqAppSystemSetting.setConfigurationDirectory(Globals.getInstanceDir());
            this.mqAppSystemSetting.setDirectoryName(Globals.getInstanceDir());
            this.storeCMMObject((CMM_ObjectInstrum)this.mqAppSystemSetting, mfManagedElementInfo.getType());
            mfRelationInfo = this.mfMEServer.makeRelationInfo();
            mfManagedElementInfo.setType(MfManagedElementType.CMM_APPLICATION_SYSTEM_STATS);
            mfManagedElementInfo.setName(this.config.getProperty("imq.instancename"));
            mfRelationInfo.setType(MfRelationType.CMM_ELEMENT_STATISTICAL_DATA);
            MfRelationInstrum mfRelationInstrum2 = this.mfMEServer.createRelationToNewManagedElement((CIM_ManagedElementInstrum)this.mqAppSystem, mfRelationInfo, mfManagedElementInfo);
            this.mqAppSystemStats = (CMM_ApplicationSystemStatsInstrum)mfRelationInstrum2.getDestination();
            this.mqAppSystemStats.setCaption("A single MQ broker instance: " + this.mqAppSystemSetting.getName());
            this.mqAppSystemStats.setDescription(JesmfNames.getProductNameCtxKey());
            this.mqAppSystemStats.setFailedOutboundAssociations(0L);
            this.mqAppSystemStats.setInboundAssociations(0L);
            this.mqAppSystemStats.setOutboundAssociations(0L);
            this.mqAppSystemStats.setRejectedInboundAssociations(0L);
            this.mqAppSystemStats.setSampleInterval(0L);
            this.storeCMMObject((CMM_ObjectInstrum)this.mqAppSystemStats, mfManagedElementInfo.getType());
            this.registerPersistenceStore();
            this.registerUserRepository();
            this.mfMEServer.publish();
            this.active = true;
        }
        catch (Throwable throwable) {
            this.logger.log(16, this.rb.getString("B2209"));
        }
    }

    public void stop() {
        if (!this.isActive()) {
            return;
        }
        if (this.mfMEServer != null) {
            try {
                this.mfMEServer.stop();
                this.active = false;
                this.mfMEServer = null;
            }
            catch (Throwable throwable) {
                this.logger.log(16, this.rb.getString("B2210", throwable.toString()));
            }
        }
    }

    public boolean isActive() {
        return this.active;
    }

    public void registerPortmapper() {
        if (!this.isActive()) {
            return;
        }
        try {
            Object object;
            MfManagedElementInfo mfManagedElementInfo = this.mfMEServer.makeManagedElementInfo();
            MfRelationInfo mfRelationInfo = this.mfMEServer.makeRelationInfo();
            mfManagedElementInfo.setType(MfManagedElementType.CMM_SERVICE_ACCESS_URI);
            mfManagedElementInfo.setName(JesmfNames.getPortMapper());
            mfRelationInfo.setType(MfRelationType.CMM_HOSTED_ACCESS_POINT);
            MfRelationInstrum mfRelationInstrum = this.mfMEServer.createRelationToNewManagedElement((CIM_ManagedElementInstrum)this.mqAppSystem, mfRelationInfo, mfManagedElementInfo);
            CMM_ServiceAccessURIInstrum cMM_ServiceAccessURIInstrum = (CMM_ServiceAccessURIInstrum)mfRelationInstrum.getDestination();
            cMM_ServiceAccessURIInstrum.setDescription("MQ PortMapper");
            cMM_ServiceAccessURIInstrum.setCaption("MQ PortMapper");
            this.storeCMMObject((CMM_ObjectInstrum)cMM_ServiceAccessURIInstrum, mfManagedElementInfo.getType());
            BrokerMonitor brokerMonitor = this.agent.getBrokerMonitorMBean();
            if (brokerMonitor != null && (object = brokerMonitor.getMQAddress()) != null) {
                cMM_ServiceAccessURIInstrum.setLabeledURI(object.toString());
                if (this.mqAppSystemSetting != null) {
                    this.mqAppSystemSetting.setURL(object.toString());
                }
            }
            object = new HashSet();
            HashSet<String> hashSet = new HashSet<String>();
            ((HashSet)object).add(OperationalStatus.OK);
            hashSet.add(OperationalStatus.OK.toString());
            cMM_ServiceAccessURIInstrum.setOperationalStatus((Set)object);
            cMM_ServiceAccessURIInstrum.setStatusDescriptions(hashSet);
        }
        catch (Throwable throwable) {
            this.logger.log(16, "Problem detected when registering JESMF objects for portmapper.", throwable);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void unregisterPortmapper() {
        if (!this.isActive()) {
            return;
        }
        try {
            CMM_ServiceAccessURIInstrum cMM_ServiceAccessURIInstrum = (CMM_ServiceAccessURIInstrum)this.getCMMObject(JesmfNames.getPortMapper(), MfManagedElementType.CMM_SERVICE_ACCESS_URI);
            if (cMM_ServiceAccessURIInstrum == null) return;
        }
        catch (Throwable throwable) {
            this.logger.log(16, "Problem detected when unregistering JESMF object for portmapper.", throwable);
        }
    }

    public void portMapperPortUpdated(Integer n, Integer n2) {
        if (!this.isActive()) {
            return;
        }
        try {
            MQAddress mQAddress;
            BrokerMonitor brokerMonitor;
            CMM_ServiceAccessURIInstrum cMM_ServiceAccessURIInstrum = (CMM_ServiceAccessURIInstrum)this.getCMMObject(JesmfNames.getPortMapper(), MfManagedElementType.CMM_SERVICE_ACCESS_URI);
            if (cMM_ServiceAccessURIInstrum != null && (brokerMonitor = this.agent.getBrokerMonitorMBean()) != null && (mQAddress = MQAddressUtil.getPortMapperMQAddress(n2)) != null) {
                cMM_ServiceAccessURIInstrum.setLabeledURI(mQAddress.toString());
            }
        }
        catch (Throwable throwable) {
            this.logger.log(16, "Problem detected when updating JESMF object for portmapper.", throwable);
        }
    }

    public void registerService(String string) {
        if (!this.isActive()) {
            return;
        }
        try {
            MfManagedElementInfo mfManagedElementInfo = this.mfMEServer.makeManagedElementInfo();
            MfRelationInfo mfRelationInfo = this.mfMEServer.makeRelationInfo();
            mfManagedElementInfo.setType(MfManagedElementType.CMM_SERVICE_ACCESS_URI);
            mfManagedElementInfo.setName(string);
            mfRelationInfo.setType(MfRelationType.CMM_HOSTED_ACCESS_POINT);
            MfRelationInstrum mfRelationInstrum = this.mfMEServer.createRelationToNewManagedElement((CIM_ManagedElementInstrum)this.mqAppSystem, mfRelationInfo, mfManagedElementInfo);
            CMM_ServiceAccessURIInstrum cMM_ServiceAccessURIInstrum = (CMM_ServiceAccessURIInstrum)mfRelationInstrum.getDestination();
            cMM_ServiceAccessURIInstrum.setDescription("MQ Connection service");
            cMM_ServiceAccessURIInstrum.setCaption("MQ Connection service");
            this.storeCMMObject((CMM_ObjectInstrum)cMM_ServiceAccessURIInstrum, mfManagedElementInfo.getType());
            CP_MQServiceAccessURIStatsDelegate cP_MQServiceAccessURIStatsDelegate = new CP_MQServiceAccessURIStatsDelegate(string);
            mfRelationInfo.setType(MfRelationType.CMM_ELEMENT_STATISTICAL_DATA);
            this.mfMEServer.createRelationToNewManagedElement((CMM_ObjectInstrum)cMM_ServiceAccessURIInstrum, mfRelationInfo, (CMM_ObjectInstrum)cP_MQServiceAccessURIStatsDelegate);
            this.storeDelegateObject(cP_MQServiceAccessURIStatsDelegate, CP_MQServiceAccessURIStatsDelegate.class);
            mfManagedElementInfo.setType(MfManagedElementType.CMM_THREAD_POOL_SETTING);
            mfManagedElementInfo.setName(string);
            mfRelationInfo.setType(MfRelationType.CMM_SCOPED_SETTING);
            mfRelationInstrum = this.mfMEServer.createRelationToNewManagedElement((CIM_ManagedElementInstrum)cMM_ServiceAccessURIInstrum, mfRelationInfo, mfManagedElementInfo);
            CMM_ThreadPoolSettingInstrum cMM_ThreadPoolSettingInstrum = (CMM_ThreadPoolSettingInstrum)mfRelationInstrum.getDestination();
            cMM_ThreadPoolSettingInstrum.setDescription("MQ Connection Service Thread Pool Setting");
            cMM_ThreadPoolSettingInstrum.setCaption("MQ Connection Service Thread Pool Setting");
            this.storeCMMObject((CMM_ObjectInstrum)cMM_ThreadPoolSettingInstrum, mfManagedElementInfo.getType());
            mfManagedElementInfo.setType(MfManagedElementType.CMM_THREAD_POOL);
            mfManagedElementInfo.setName(string);
            mfRelationInfo.setType(MfRelationType.CMM_RESOURCE_OF_SYSTEM);
            mfRelationInstrum = this.mfMEServer.createRelationToNewManagedElement((CIM_ManagedElementInstrum)this.mqAppSystem, mfRelationInfo, mfManagedElementInfo);
            CMM_ThreadPoolInstrum cMM_ThreadPoolInstrum = (CMM_ThreadPoolInstrum)mfRelationInstrum.getDestination();
            cMM_ThreadPoolInstrum.setDescription("MQ Connection Service Thread Pool");
            cMM_ThreadPoolInstrum.setCaption("MQ Connection Service Thread Pool");
            cMM_ThreadPoolInstrum.setImplementationInfo(ImplementationInfo.SOFTWARE_ONLY);
            this.storeCMMObject((CMM_ObjectInstrum)cMM_ThreadPoolInstrum, mfManagedElementInfo.getType());
            CP_ThreadPoolStatsDelegate cP_ThreadPoolStatsDelegate = new CP_ThreadPoolStatsDelegate(string);
            mfRelationInfo.setType(MfRelationType.CMM_ELEMENT_STATISTICAL_DATA);
            this.mfMEServer.createRelationToNewManagedElement((CMM_ObjectInstrum)cMM_ThreadPoolInstrum, mfRelationInfo, (CMM_ObjectInstrum)cP_ThreadPoolStatsDelegate);
            this.storeDelegateObject(cP_ThreadPoolStatsDelegate, CP_ThreadPoolStatsDelegate.class);
            mfRelationInfo.setType(MfRelationType.CMM_RELATED_STATISTICAL_DATA);
            mfRelationInstrum = this.mfMEServer.createRelation((CMM_ObjectInstrum)cP_ThreadPoolStatsDelegate, mfRelationInfo, (CMM_ObjectInstrum)cP_MQServiceAccessURIStatsDelegate);
            this.initServiceSetting(string);
            this.serviceStateChanged(string);
        }
        catch (Throwable throwable) {
            this.logger.log(16, "Problem detected when registering JESMF objects for service: " + string, throwable);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void unregisterService(String string) {
        if (!this.isActive()) {
            return;
        }
        try {
            CP_ThreadPoolStatsDelegate cP_ThreadPoolStatsDelegate;
            CMM_ThreadPoolInstrum cMM_ThreadPoolInstrum;
            CMM_ThreadPoolSettingInstrum cMM_ThreadPoolSettingInstrum;
            CP_MQServiceAccessURIStatsDelegate cP_MQServiceAccessURIStatsDelegate;
            CMM_ServiceAccessURIInstrum cMM_ServiceAccessURIInstrum = (CMM_ServiceAccessURIInstrum)this.getCMMObject(string, MfManagedElementType.CMM_SERVICE_ACCESS_URI);
            if (cMM_ServiceAccessURIInstrum != null) {
                // empty if block
            }
            if ((cP_MQServiceAccessURIStatsDelegate = (CP_MQServiceAccessURIStatsDelegate)this.getDelegateObject(string, CP_MQServiceAccessURIStatsDelegate.class)) != null) {
                // empty if block
            }
            if ((cMM_ThreadPoolSettingInstrum = (CMM_ThreadPoolSettingInstrum)this.getCMMObject(string, MfManagedElementType.CMM_THREAD_POOL_SETTING)) != null) {
                // empty if block
            }
            if ((cMM_ThreadPoolInstrum = (CMM_ThreadPoolInstrum)this.getCMMObject(string, MfManagedElementType.CMM_THREAD_POOL)) != null) {
                // empty if block
            }
            if ((cP_ThreadPoolStatsDelegate = (CP_ThreadPoolStatsDelegate)this.getDelegateObject(string, CP_ThreadPoolStatsDelegate.class)) == null) return;
        }
        catch (Throwable throwable) {
            this.logger.log(16, "Problem detected when unregistering JESMF objects for service: " + string, throwable);
        }
    }

    public void registerDestination(Destination destination) {
        String string;
        String string2;
        Class clazz;
        MfManagedElementType mfManagedElementType;
        MfManagedElementType mfManagedElementType2;
        if (!this.isActive()) {
            return;
        }
        String string3 = JesmfNames.getDestinationReference(destination);
        if (!DestinationUtil.isVisibleDestination(destination)) {
            return;
        }
        if (destination.isTemporary()) {
            return;
        }
        DestinationMonitor destinationMonitor = this.agent.getDestinationMonitorMBean(destination.getDestinationName(), destination.isQueue() ? "q" : "t");
        if (destination.isQueue()) {
            mfManagedElementType2 = MfManagedElementType.CMM_MQ_DESTINATION_QUEUE;
            mfManagedElementType = MfManagedElementType.CMM_MQ_DESTINATION_QUEUE_SETTING;
            clazz = CP_MQDestinationQueueStatsDelegate.class;
            string2 = "MQ Queue Destination";
            string = "MQ Queue Destination Setting";
        } else {
            mfManagedElementType2 = MfManagedElementType.CMM_MQ_DESTINATION_TOPIC;
            mfManagedElementType = MfManagedElementType.CMM_MQ_DESTINATION_TOPIC_SETTING;
            clazz = CP_MQDestinationTopicStatsDelegate.class;
            string2 = "MQ Topic Destination";
            string = "MQ Topic Destination Setting";
        }
        try {
            CMM_LogicalComponentSettingInstrum cMM_LogicalComponentSettingInstrum;
            CP_MQStatsDelegate cP_MQStatsDelegate;
            MfRelationInstrum mfRelationInstrum;
            MfManagedElementInfo mfManagedElementInfo = this.mfMEServer.makeManagedElementInfo();
            MfRelationInfo mfRelationInfo = this.mfMEServer.makeRelationInfo();
            CMM_LogicalComponentInstrum cMM_LogicalComponentInstrum = (CMM_LogicalComponentInstrum)this.getCMMObject(string3, mfManagedElementType2);
            if (cMM_LogicalComponentInstrum == null) {
                mfManagedElementInfo.setType(mfManagedElementType2);
                mfManagedElementInfo.setName(string3);
                mfRelationInfo.setType(MfRelationType.CMM_APPLICATION_SYSTEM_LOGICAL_COMPONENT);
                mfRelationInstrum = this.mfMEServer.createRelationToNewManagedElement((CIM_ManagedElementInstrum)this.mqAppSystem, mfRelationInfo, mfManagedElementInfo);
                cMM_LogicalComponentInstrum = (CMM_LogicalComponentInstrum)mfRelationInstrum.getDestination();
                cMM_LogicalComponentInstrum.setDescription(string2);
                cMM_LogicalComponentInstrum.setCaption(string2);
                this.storeCMMObject((CMM_ObjectInstrum)cMM_LogicalComponentInstrum, mfManagedElementInfo.getType());
            }
            if ((cP_MQStatsDelegate = this.getDelegateObject(string3, clazz)) == null) {
                cP_MQStatsDelegate = destination.isQueue() ? new CP_MQDestinationQueueStatsDelegate(string3) : new CP_MQDestinationTopicStatsDelegate(string3);
                mfRelationInfo.setType(MfRelationType.CMM_ELEMENT_STATISTICAL_DATA);
                this.mfMEServer.createRelationToNewManagedElement((CMM_ObjectInstrum)cMM_LogicalComponentInstrum, mfRelationInfo, (CMM_ObjectInstrum)cP_MQStatsDelegate);
                this.storeDelegateObject(cP_MQStatsDelegate, clazz);
            }
            if ((cMM_LogicalComponentSettingInstrum = (CMM_LogicalComponentSettingInstrum)this.getCMMObject(string3, mfManagedElementType)) == null) {
                mfManagedElementInfo.setType(mfManagedElementType);
                mfManagedElementInfo.setName(string3);
                mfRelationInfo.setType(MfRelationType.CMM_SCOPED_SETTING);
                mfRelationInstrum = this.mfMEServer.createRelationToNewManagedElement((CIM_ManagedElementInstrum)cMM_LogicalComponentInstrum, mfRelationInfo, mfManagedElementInfo);
                cMM_LogicalComponentSettingInstrum = (CMM_LogicalComponentSettingInstrum)mfRelationInstrum.getDestination();
                cMM_LogicalComponentSettingInstrum.setDescription(string);
                cMM_LogicalComponentSettingInstrum.setCaption(string);
                this.storeCMMObject((CMM_ObjectInstrum)cMM_LogicalComponentSettingInstrum, mfManagedElementInfo.getType());
            }
            this.initDestinationSetting(cMM_LogicalComponentSettingInstrum, destination);
            this.initDestinationStats(cP_MQStatsDelegate, destination);
            this.destinationStateChanged(destination);
        }
        catch (Throwable throwable) {
            this.logger.log(16, "Problem detected when registering JESMF object for destination " + (destination.isQueue() ? "Queue:" : "Topic:") + destination.getDestinationName(), throwable);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void unregisterDestination(Destination destination) {
        Class clazz;
        MfManagedElementType mfManagedElementType;
        MfManagedElementType mfManagedElementType2;
        String string = JesmfNames.getDestinationReference(destination);
        if (destination.isTemporary()) {
            return;
        }
        if (destination.isQueue()) {
            mfManagedElementType2 = MfManagedElementType.CMM_MQ_DESTINATION_QUEUE;
            mfManagedElementType = MfManagedElementType.CMM_MQ_DESTINATION_QUEUE_SETTING;
            clazz = CP_MQDestinationQueueStatsDelegate.class;
        } else {
            mfManagedElementType2 = MfManagedElementType.CMM_MQ_DESTINATION_TOPIC;
            mfManagedElementType = MfManagedElementType.CMM_MQ_DESTINATION_TOPIC_SETTING;
            clazz = CP_MQDestinationTopicStatsDelegate.class;
        }
        try {
            CMM_LogicalComponentSettingInstrum cMM_LogicalComponentSettingInstrum;
            CP_MQStatsDelegate cP_MQStatsDelegate;
            CMM_LogicalComponentInstrum cMM_LogicalComponentInstrum = (CMM_LogicalComponentInstrum)this.getCMMObject(string, mfManagedElementType2);
            if (cMM_LogicalComponentInstrum != null) {
                // empty if block
            }
            if ((cP_MQStatsDelegate = this.getDelegateObject(string, clazz)) != null) {
                if (cP_MQStatsDelegate instanceof CP_MQDestinationStatsDelegate) {
                    CP_MQDestinationStatsDelegate cP_MQDestinationStatsDelegate = (CP_MQDestinationStatsDelegate)cP_MQStatsDelegate;
                    cP_MQDestinationStatsDelegate.setDestinationMonitorMBean(null);
                } else {
                    this.logger.log(16, "JesmfManager.unregisterDestination(): destination stats object is not of type " + CP_MQDestinationStatsDelegate.class.getName());
                }
            }
            if ((cMM_LogicalComponentSettingInstrum = (CMM_LogicalComponentSettingInstrum)this.getCMMObject(string, mfManagedElementType)) == null) return;
        }
        catch (Throwable throwable) {
            this.logger.log(16, "Problem detected when unregistering JESMF object for destination " + (destination.isQueue() ? "Queue:" : "Topic:") + destination.getDestinationName(), throwable);
        }
    }

    public void serviceStateChanged(String string) {
        CMM_ServiceAccessURIInstrum cMM_ServiceAccessURIInstrum = (CMM_ServiceAccessURIInstrum)this.getCMMObject(string, MfManagedElementType.CMM_SERVICE_ACCESS_URI);
        CMM_ThreadPoolInstrum cMM_ThreadPoolInstrum = (CMM_ThreadPoolInstrum)this.getCMMObject(string, MfManagedElementType.CMM_THREAD_POOL);
        ServiceMonitor serviceMonitor = this.agent.getServiceMonitorMBean(string);
        if (serviceMonitor == null) {
            return;
        }
        HashSet<OperationalStatus> hashSet = new HashSet<OperationalStatus>();
        HashSet<String> hashSet2 = new HashSet<String>();
        int n = serviceMonitor.getState();
        switch (n) {
            case 2: {
                hashSet.add(OperationalStatus.DORMANT);
                hashSet2.add(serviceMonitor.getStateLabel());
                break;
            }
            case 1: {
                hashSet.add(OperationalStatus.DORMANT);
                hashSet2.add(serviceMonitor.getStateLabel());
                break;
            }
            case 0: {
                hashSet.add(OperationalStatus.OK);
                hashSet2.add(serviceMonitor.getStateLabel());
                break;
            }
            default: {
                hashSet.add(OperationalStatus.UNKNOWN);
                hashSet2.add(OperationalStatus.UNKNOWN.toString());
            }
        }
        try {
            if (cMM_ServiceAccessURIInstrum != null) {
                cMM_ServiceAccessURIInstrum.setOperationalStatus(hashSet);
                cMM_ServiceAccessURIInstrum.setStatusDescriptions(hashSet2);
            }
            if (cMM_ThreadPoolInstrum != null) {
                cMM_ThreadPoolInstrum.setOperationalStatus(hashSet);
                cMM_ThreadPoolInstrum.setStatusDescriptions(hashSet2);
            }
        }
        catch (Throwable throwable) {
            this.logger.log(16, "Problem detected when updating operationl status of JESMF object for service " + string, throwable);
        }
    }

    public void serviceAttrUpdated(String string, String string2, Object object, Object object2) {
        ServiceConfig serviceConfig = this.agent.getServiceConfigMBean(string);
        ServiceMonitor serviceMonitor = this.agent.getServiceMonitorMBean(string);
        if (serviceConfig == null || serviceMonitor == null) {
            return;
        }
        CMM_ThreadPoolSettingInstrum cMM_ThreadPoolSettingInstrum = (CMM_ThreadPoolSettingInstrum)this.getCMMObject(string, MfManagedElementType.CMM_THREAD_POOL_SETTING);
        CMM_ServiceAccessURIInstrum cMM_ServiceAccessURIInstrum = (CMM_ServiceAccessURIInstrum)this.getCMMObject(string, MfManagedElementType.CMM_SERVICE_ACCESS_URI);
        CMM_ThreadPoolInstrum cMM_ThreadPoolInstrum = (CMM_ThreadPoolInstrum)this.getCMMObject(string, MfManagedElementType.CMM_THREAD_POOL);
        try {
            if (string2.equals("MaxThreads")) {
                if (cMM_ThreadPoolSettingInstrum != null) {
                    cMM_ThreadPoolSettingInstrum.setMaxThreadPoolSize(serviceConfig.getMaxThreads().longValue());
                }
            } else if (string2.equals("MinThreads")) {
                if (cMM_ThreadPoolSettingInstrum != null) {
                    cMM_ThreadPoolSettingInstrum.setMinThreadPoolSize(serviceConfig.getMinThreads().longValue());
                }
            } else if (string2.equals("Port")) {
                this.updateServiceLabeledURI(string, (Integer)object2);
            }
        }
        catch (Throwable throwable) {
            this.logger.log(16, "Problem detected when updating attribute of JESMF object for service " + string, throwable);
            this.logger.log(16, "The attribute updated is: " + string2);
        }
    }

    public void destinationStateChanged(Destination destination) {
        MfManagedElementType mfManagedElementType;
        if (destination.isQueue()) {
            mfManagedElementType = MfManagedElementType.CMM_MQ_DESTINATION_QUEUE;
            MfManagedElementType mfManagedElementType2 = MfManagedElementType.CMM_MQ_DESTINATION_QUEUE_SETTING;
        } else {
            mfManagedElementType = MfManagedElementType.CMM_MQ_DESTINATION_TOPIC;
            MfManagedElementType mfManagedElementType3 = MfManagedElementType.CMM_MQ_DESTINATION_TOPIC_SETTING;
        }
        CMM_LogicalComponentInstrum cMM_LogicalComponentInstrum = (CMM_LogicalComponentInstrum)this.getCMMObject(JesmfNames.getDestinationReference(destination), mfManagedElementType);
        if (cMM_LogicalComponentInstrum == null) {
            return;
        }
        DestinationMonitor destinationMonitor = this.agent.getDestinationMonitorMBean(destination.getDestinationName(), destination.isQueue() ? "q" : "t");
        if (destinationMonitor == null) {
            return;
        }
        HashSet<OperationalStatus> hashSet = new HashSet<OperationalStatus>();
        HashSet<String> hashSet2 = new HashSet<String>();
        int n = destinationMonitor.getState();
        switch (n) {
            case 0: {
                hashSet.add(OperationalStatus.OK);
                hashSet2.add(destinationMonitor.getStateLabel());
                break;
            }
            case 3: {
                hashSet.add(OperationalStatus.DORMANT);
                hashSet2.add(destinationMonitor.getStateLabel());
                break;
            }
            case 1: {
                hashSet.add(OperationalStatus.DORMANT);
                hashSet2.add(destinationMonitor.getStateLabel());
                break;
            }
            case 2: {
                hashSet.add(OperationalStatus.DORMANT);
                hashSet2.add(destinationMonitor.getStateLabel());
                break;
            }
            default: {
                hashSet.add(OperationalStatus.UNKNOWN);
                hashSet2.add(OperationalStatus.UNKNOWN.toString());
            }
        }
        try {
            cMM_LogicalComponentInstrum.setOperationalStatus(hashSet);
            cMM_LogicalComponentInstrum.setStatusDescriptions(hashSet2);
        }
        catch (Throwable throwable) {
            this.logger.log(16, "Problem detected when updating operationl status of JESMF object of type " + MfManagedElementType.CMM_LOGICAL_COMPONENT + " for destination " + destination.toString(), throwable);
        }
    }

    public void destinationAttrUpdated(Destination destination, int n, Object object, Object object2) {
        MfManagedElementType mfManagedElementType;
        CMM_MQDestinationQueueSettingInstrum cMM_MQDestinationQueueSettingInstrum = null;
        CMM_MQDestinationTopicSettingInstrum cMM_MQDestinationTopicSettingInstrum = null;
        boolean bl = false;
        if (destination.isQueue()) {
            mfManagedElementType = MfManagedElementType.CMM_MQ_DESTINATION_QUEUE_SETTING;
            cMM_MQDestinationQueueSettingInstrum = (CMM_MQDestinationQueueSettingInstrum)this.getCMMObject(JesmfNames.getDestinationReference(destination), mfManagedElementType);
            if (cMM_MQDestinationQueueSettingInstrum == null) {
                bl = true;
            }
        } else {
            mfManagedElementType = MfManagedElementType.CMM_MQ_DESTINATION_TOPIC_SETTING;
            cMM_MQDestinationTopicSettingInstrum = (CMM_MQDestinationTopicSettingInstrum)this.getCMMObject(JesmfNames.getDestinationReference(destination), mfManagedElementType);
            if (cMM_MQDestinationTopicSettingInstrum == null) {
                bl = true;
            }
        }
        if (bl) {
            return;
        }
        String string = DestinationUtil.getAttrNameFromDestinationInfoAttr(n);
        object2 = DestinationUtil.convertAttrValueInternaltoExternal(n, object2);
        try {
            if (string.equals("ConsumerFlowLimit")) {
                long l;
                Long l2 = (Long)object2;
                long l3 = l = l2 == -1L ? Long.MAX_VALUE : l2;
                if (destination.isQueue()) {
                    cMM_MQDestinationQueueSettingInstrum.setConsumerFlowLimit(l);
                } else {
                    cMM_MQDestinationTopicSettingInstrum.setConsumerFlowLimit(l);
                }
            } else if (string.equals("LimitBehavior")) {
                String string2 = (String)object2;
                if (destination.isQueue()) {
                    cMM_MQDestinationQueueSettingInstrum.setLimitBehavior(string2);
                } else {
                    cMM_MQDestinationTopicSettingInstrum.setLimitBehavior(string2);
                }
            } else if (string.equals("LocalDeliveryPreferred")) {
                Boolean bl2 = (Boolean)object2;
                if (destination.isQueue()) {
                    cMM_MQDestinationQueueSettingInstrum.setLocalDeliveryPreferred(bl2.booleanValue());
                } else {
                    cMM_MQDestinationTopicSettingInstrum.setLocalDeliveryPreferred(bl2.booleanValue());
                }
            } else if (string.equals("MaxBytesPerMsg")) {
                long l;
                Long l4 = (Long)object2;
                long l5 = l = l4 == -1L ? Long.MAX_VALUE : l4;
                if (destination.isQueue()) {
                    cMM_MQDestinationQueueSettingInstrum.setMaxBytesPerMsg(l);
                } else {
                    cMM_MQDestinationTopicSettingInstrum.setMaxBytesPerMsg(l);
                }
            } else if (string.equals("MaxNumActiveConsumers")) {
                int n2;
                Integer n3 = (Integer)object2;
                int n4 = n2 = n3 == -1 ? Integer.MAX_VALUE : n3;
                if (destination.isQueue()) {
                    cMM_MQDestinationQueueSettingInstrum.setMaxNumActiveConsumers(n2);
                } else {
                    cMM_MQDestinationTopicSettingInstrum.setMaxNumActiveConsumers(n2);
                }
            } else if (string.equals("MaxNumBackupConsumers")) {
                int n5;
                Integer n6 = (Integer)object2;
                int n7 = n5 = n6 == -1 ? Integer.MAX_VALUE : n6;
                if (destination.isQueue()) {
                    cMM_MQDestinationQueueSettingInstrum.setMaxNumBackupConsumers(n5);
                } else {
                    cMM_MQDestinationTopicSettingInstrum.setMaxNumBackupConsumers(n5);
                }
            } else if (string.equals("MaxNumMsgs")) {
                long l;
                Long l6 = (Long)object2;
                long l7 = l = l6 == -1L ? Long.MAX_VALUE : l6;
                if (destination.isQueue()) {
                    cMM_MQDestinationQueueSettingInstrum.setMaxNumMsgs(l);
                } else {
                    cMM_MQDestinationTopicSettingInstrum.setMaxNumMsgs(l);
                }
            } else if (string.equals("MaxNumProducers")) {
                int n8;
                Integer n9 = (Integer)object2;
                int n10 = n8 = n9 == -1 ? Integer.MAX_VALUE : n9;
                if (destination.isQueue()) {
                    cMM_MQDestinationQueueSettingInstrum.setMaxNumProducers(n8);
                } else {
                    cMM_MQDestinationTopicSettingInstrum.setMaxNumProducers(n8);
                }
            } else if (string.equals("MaxTotalMsgBytes")) {
                long l;
                Long l8 = (Long)object2;
                long l9 = l = l8 == -1L ? Long.MAX_VALUE : l8;
                if (destination.isQueue()) {
                    cMM_MQDestinationQueueSettingInstrum.setMaxTotalMsgBytes(l);
                } else {
                    cMM_MQDestinationTopicSettingInstrum.setMaxTotalMsgBytes(l);
                }
            } else if (string.equals("UseDMQ")) {
                Boolean bl3 = (Boolean)object2;
                if (destination.isQueue()) {
                    cMM_MQDestinationQueueSettingInstrum.setUseDMQ(bl3.booleanValue());
                } else {
                    cMM_MQDestinationTopicSettingInstrum.setUseDMQ(bl3.booleanValue());
                }
            }
        }
        catch (Throwable throwable) {
            this.logger.log(16, "Problem detected when updating JESMF object of type" + mfManagedElementType + " for destination " + destination.toString(), throwable);
            this.logger.log(16, "The attribute updated is: " + string);
        }
    }

    private void registerPersistenceStore() {
        CMM_SWRFileInstrum cMM_SWRFileInstrum = null;
        String string = null;
        string = this.config.getProperty("imq.persist.store");
        try {
            HashSet<OperationalStatus> hashSet = new HashSet<OperationalStatus>();
            HashSet<String> hashSet2 = new HashSet<String>();
            hashSet.add(OperationalStatus.OK);
            hashSet2.add(OperationalStatus.OK.toString());
            MfManagedElementInfo mfManagedElementInfo = this.mfMEServer.makeManagedElementInfo();
            MfRelationInfo mfRelationInfo = this.mfMEServer.makeRelationInfo();
            mfManagedElementInfo.setName(JesmfNames.getPersistenceStore());
            if (string.equals("file")) {
                mfManagedElementInfo.setType(MfManagedElementType.CMM_SWR_FILE);
                mfRelationInfo.setType(MfRelationType.CMM_RESOURCE_OF_SYSTEM);
                MfRelationInstrum mfRelationInstrum = this.mfMEServer.createRelationToNewManagedElement((CIM_ManagedElementInstrum)this.mqAppSystem, mfRelationInfo, mfManagedElementInfo);
                CMM_SWRFileInstrum cMM_SWRFileInstrum2 = (CMM_SWRFileInstrum)mfRelationInstrum.getDestination();
                cMM_SWRFileInstrum2.setCaption("File based persistence store for MQ broker");
                cMM_SWRFileInstrum2.setDescription("File based persistence store for MQ broker");
                cMM_SWRFileInstrum2.setOperationalStatus(hashSet);
                cMM_SWRFileInstrum2.setStatusDescriptions(hashSet2);
                cMM_SWRFileInstrum2.setResourceType(ResourceType.DATABASE);
                cMM_SWRFileInstrum2.setImplementationInfo(ImplementationInfo.SOFTWARE_ONLY);
                cMM_SWRFileInstrum = cMM_SWRFileInstrum2;
            } else if (string.equals("jdbc")) {
                DBManager dBManager = DBManager.getDBManager();
                String string2 = null;
                String string3 = null;
                String string4 = null;
                if (dBManager != null) {
                    string2 = dBManager.getOpenDBURL();
                    string3 = dBManager.getUser();
                    string4 = dBManager.getDriver();
                }
                mfManagedElementInfo.setType(MfManagedElementType.CMM_JDBC_REMOTE_SERVICE_ACCESS_POINT);
                mfRelationInfo.setType(MfRelationType.CMM_HOSTED_ACCESS_POINT);
                MfRelationInstrum mfRelationInstrum = this.mfMEServer.createRelationToNewManagedElement((CIM_ManagedElementInstrum)this.mqAppSystem, mfRelationInfo, mfManagedElementInfo);
                CMM_JDBCRemoteServiceAccessPointInstrum cMM_JDBCRemoteServiceAccessPointInstrum = (CMM_JDBCRemoteServiceAccessPointInstrum)mfRelationInstrum.getDestination();
                cMM_JDBCRemoteServiceAccessPointInstrum.setDescription("JDBC based persistence store for MQ broker");
                cMM_JDBCRemoteServiceAccessPointInstrum.setCaption("JDBC based persistence store for MQ broker");
                if (string2 != null) {
                    cMM_JDBCRemoteServiceAccessPointInstrum.setAccessInfo(string2);
                }
                cMM_JDBCRemoteServiceAccessPointInstrum.setInfoFormat(InfoFormat.URL);
                if (string3 != null) {
                    cMM_JDBCRemoteServiceAccessPointInstrum.setUserName(string3);
                }
                if (string4 != null) {
                    cMM_JDBCRemoteServiceAccessPointInstrum.setJDBCDriver(string4);
                }
                cMM_JDBCRemoteServiceAccessPointInstrum.setOperationalStatus(hashSet);
                cMM_JDBCRemoteServiceAccessPointInstrum.setStatusDescriptions(hashSet2);
                cMM_SWRFileInstrum = cMM_JDBCRemoteServiceAccessPointInstrum;
            } else {
                this.logger.log(16, "JESMF: Unknown MQ persistent store type: " + string);
            }
            if (cMM_SWRFileInstrum != null) {
                this.storeCMMObject((CMM_ObjectInstrum)cMM_SWRFileInstrum, mfManagedElementInfo.getType());
            }
        }
        catch (Throwable throwable) {
            this.logger.log(16, "Problem detected when registering JESMF objects for persistence store.", throwable);
        }
    }

    private void registerUserRepository() {
        CMM_SWRFileInstrum cMM_SWRFileInstrum = null;
        String string = null;
        string = this.config.getProperty("imq.authentication.basic.user_repository");
        try {
            HashSet<OperationalStatus> hashSet = new HashSet<OperationalStatus>();
            HashSet<String> hashSet2 = new HashSet<String>();
            hashSet.add(OperationalStatus.OK);
            hashSet2.add(OperationalStatus.OK.toString());
            MfManagedElementInfo mfManagedElementInfo = this.mfMEServer.makeManagedElementInfo();
            MfRelationInfo mfRelationInfo = this.mfMEServer.makeRelationInfo();
            mfManagedElementInfo.setName(JesmfNames.getUserRepository());
            if (string.equals("file")) {
                mfManagedElementInfo.setType(MfManagedElementType.CMM_SWR_FILE);
                mfRelationInfo.setType(MfRelationType.CMM_RESOURCE_OF_SYSTEM);
                MfRelationInstrum mfRelationInstrum = this.mfMEServer.createRelationToNewManagedElement((CIM_ManagedElementInstrum)this.mqAppSystem, mfRelationInfo, mfManagedElementInfo);
                CMM_SWRFileInstrum cMM_SWRFileInstrum2 = (CMM_SWRFileInstrum)mfRelationInstrum.getDestination();
                cMM_SWRFileInstrum2.setDescription("File based user repository for MQ broker");
                cMM_SWRFileInstrum2.setCaption("File based user repository for MQ broker");
                cMM_SWRFileInstrum2.setOperationalStatus(hashSet);
                cMM_SWRFileInstrum2.setStatusDescriptions(hashSet2);
                cMM_SWRFileInstrum2.setResourceType(ResourceType.DATABASE);
                cMM_SWRFileInstrum2.setImplementationInfo(ImplementationInfo.SOFTWARE_ONLY);
                cMM_SWRFileInstrum = cMM_SWRFileInstrum2;
            } else if (string.equals("ldap")) {
                mfManagedElementInfo.setType(MfManagedElementType.CMM_LDAP_REMOTE_SERVICE_ACCESS_POINT);
                mfRelationInfo.setType(MfRelationType.CMM_HOSTED_ACCESS_POINT);
                MfRelationInstrum mfRelationInstrum = this.mfMEServer.createRelationToNewManagedElement((CIM_ManagedElementInstrum)this.mqAppSystem, mfRelationInfo, mfManagedElementInfo);
                CMM_LDAPRemoteServiceAccessPointInstrum cMM_LDAPRemoteServiceAccessPointInstrum = (CMM_LDAPRemoteServiceAccessPointInstrum)mfRelationInstrum.getDestination();
                cMM_LDAPRemoteServiceAccessPointInstrum.setDescription("LDAP based user repository for MQ broker");
                cMM_LDAPRemoteServiceAccessPointInstrum.setCaption("LDAP based user repository for MQ broker");
                String string2 = this.config.getProperty("imq.user_repository.ldap.server");
                if (string2 != null) {
                    cMM_LDAPRemoteServiceAccessPointInstrum.setAccessInfo(string2);
                    cMM_LDAPRemoteServiceAccessPointInstrum.setInfoFormat(InfoFormat.URL);
                }
                if ((string2 = this.config.getProperty("imq.user_repository.ldap.principal")) != null) {
                    cMM_LDAPRemoteServiceAccessPointInstrum.setUserName(string2);
                }
                if ((string2 = this.config.getProperty("imq.user_repository.ldap.base")) != null) {
                    cMM_LDAPRemoteServiceAccessPointInstrum.setBase(string2);
                }
                if ((string2 = this.config.getProperty("imq.user_repository.ldap.grpbase")) != null) {
                    cMM_LDAPRemoteServiceAccessPointInstrum.setGroupBase(string2);
                }
                cMM_LDAPRemoteServiceAccessPointInstrum.setOperationalStatus(hashSet);
                cMM_LDAPRemoteServiceAccessPointInstrum.setStatusDescriptions(hashSet2);
                cMM_SWRFileInstrum = cMM_LDAPRemoteServiceAccessPointInstrum;
            } else if (string.equals("jaas")) {
                this.logger.log(16, "MQ User repository type jaas not supported for JESMF.");
            } else {
                this.logger.log(16, "JESMF: Unknown MQ user repository type: " + string);
            }
            if (cMM_SWRFileInstrum != null) {
                this.storeCMMObject((CMM_ObjectInstrum)cMM_SWRFileInstrum, mfManagedElementInfo.getType());
            }
        }
        catch (Throwable throwable) {
            this.logger.log(16, "Problem detected when registering JESMF objects for user repository", throwable);
        }
    }

    private void initDestinationSetting(CMM_LogicalComponentSettingInstrum cMM_LogicalComponentSettingInstrum, Destination destination) {
        DestinationConfig destinationConfig = this.agent.getDestinationConfigMBean(destination.getDestinationName(), destination.isQueue() ? "q" : "t");
        MfManagedElementType mfManagedElementType = null;
        if (destinationConfig == null) {
            return;
        }
        try {
            if (destination.isQueue()) {
                CMM_MQDestinationQueueSettingInstrum cMM_MQDestinationQueueSettingInstrum = (CMM_MQDestinationQueueSettingInstrum)cMM_LogicalComponentSettingInstrum;
                mfManagedElementType = MfManagedElementType.CMM_MQ_DESTINATION_QUEUE_SETTING;
                long l = destinationConfig.getConsumerFlowLimit();
                cMM_MQDestinationQueueSettingInstrum.setConsumerFlowLimit(l == -1L ? Long.MAX_VALUE : l);
                l = destinationConfig.getMaxBytesPerMsg();
                cMM_MQDestinationQueueSettingInstrum.setMaxBytesPerMsg(l == -1L ? Long.MAX_VALUE : l);
                l = destinationConfig.getMaxTotalMsgBytes();
                cMM_MQDestinationQueueSettingInstrum.setMaxTotalMsgBytes(l == -1L ? Long.MAX_VALUE : l);
                l = destinationConfig.getMaxNumMsgs();
                cMM_MQDestinationQueueSettingInstrum.setMaxNumMsgs(l == -1L ? Long.MAX_VALUE : l);
                int n = destinationConfig.getMaxNumActiveConsumers();
                cMM_MQDestinationQueueSettingInstrum.setMaxNumActiveConsumers(n == -1 ? Integer.MAX_VALUE : n);
                n = destinationConfig.getMaxNumBackupConsumers();
                cMM_MQDestinationQueueSettingInstrum.setMaxNumBackupConsumers(n == -1 ? Integer.MAX_VALUE : n);
                n = destinationConfig.getMaxNumProducers();
                cMM_MQDestinationQueueSettingInstrum.setMaxNumProducers(n == -1 ? Integer.MAX_VALUE : n);
                cMM_MQDestinationQueueSettingInstrum.setLocalOnly(destinationConfig.getLocalOnly().booleanValue());
                cMM_MQDestinationQueueSettingInstrum.setLimitBehavior(destinationConfig.getLimitBehavior());
                cMM_MQDestinationQueueSettingInstrum.setLocalDeliveryPreferred(destinationConfig.getLocalDeliveryPreferred().booleanValue());
                cMM_MQDestinationQueueSettingInstrum.setUseDMQ(destinationConfig.getUseDMQ().booleanValue());
                cMM_MQDestinationQueueSettingInstrum.setType(destination.isQueue() ? "q" : "t");
            } else {
                CMM_MQDestinationTopicSettingInstrum cMM_MQDestinationTopicSettingInstrum = (CMM_MQDestinationTopicSettingInstrum)cMM_LogicalComponentSettingInstrum;
                mfManagedElementType = MfManagedElementType.CMM_MQ_DESTINATION_TOPIC_SETTING;
                long l = destinationConfig.getConsumerFlowLimit();
                cMM_MQDestinationTopicSettingInstrum.setConsumerFlowLimit(l == -1L ? Long.MAX_VALUE : l);
                l = destinationConfig.getMaxBytesPerMsg();
                cMM_MQDestinationTopicSettingInstrum.setMaxBytesPerMsg(l == -1L ? Long.MAX_VALUE : l);
                l = destinationConfig.getMaxTotalMsgBytes();
                cMM_MQDestinationTopicSettingInstrum.setMaxTotalMsgBytes(l == -1L ? Long.MAX_VALUE : l);
                l = destinationConfig.getMaxNumMsgs();
                cMM_MQDestinationTopicSettingInstrum.setMaxNumMsgs(l == -1L ? Long.MAX_VALUE : l);
                int n = destinationConfig.getMaxNumProducers();
                cMM_MQDestinationTopicSettingInstrum.setMaxNumProducers(n == -1 ? Integer.MAX_VALUE : n);
                cMM_MQDestinationTopicSettingInstrum.setLocalOnly(destinationConfig.getLocalOnly().booleanValue());
                cMM_MQDestinationTopicSettingInstrum.setLimitBehavior(destinationConfig.getLimitBehavior());
                cMM_MQDestinationTopicSettingInstrum.setLocalDeliveryPreferred(destinationConfig.getLocalDeliveryPreferred().booleanValue());
                cMM_MQDestinationTopicSettingInstrum.setUseDMQ(destinationConfig.getUseDMQ().booleanValue());
                cMM_MQDestinationTopicSettingInstrum.setType(destination.isQueue() ? "q" : "t");
            }
        }
        catch (Throwable throwable) {
            this.logger.log(16, "Problem detected while initializing JESMF object of type " + mfManagedElementType.toString() + " for destination " + destination.toString(), throwable);
        }
    }

    private void initDestinationStats(CP_MQStatsDelegate cP_MQStatsDelegate, Destination destination) {
        DestinationMonitor destinationMonitor = this.agent.getDestinationMonitorMBean(destination.getDestinationName(), destination.isQueue() ? "q" : "t");
        Class clazz = null;
        if (destinationMonitor == null) {
            return;
        }
        clazz = destination.isQueue() ? CP_MQDestinationQueueStatsDelegate.class : CP_MQDestinationTopicStatsDelegate.class;
        try {
            if (cP_MQStatsDelegate instanceof CP_MQDestinationStatsDelegate) {
                CP_MQDestinationStatsDelegate cP_MQDestinationStatsDelegate = (CP_MQDestinationStatsDelegate)cP_MQStatsDelegate;
                cP_MQDestinationStatsDelegate.setDestinationMonitorMBean(destinationMonitor);
            } else {
                this.logger.log(16, "JesmfManager.initDestinationStats(): destination stats object is not of type " + CP_MQDestinationStatsDelegate.class.getName());
            }
        }
        catch (Throwable throwable) {
            this.logger.log(16, "Problem detected while initializing JESMF object of type " + clazz.toString() + " for destination " + destination.toString(), throwable);
        }
    }

    private void initServiceSetting(String string) {
        Object object;
        ServiceConfig serviceConfig = this.agent.getServiceConfigMBean(string);
        ServiceMonitor serviceMonitor = this.agent.getServiceMonitorMBean(string);
        if (serviceConfig == null || serviceMonitor == null) {
            return;
        }
        CMM_ThreadPoolSettingInstrum cMM_ThreadPoolSettingInstrum = (CMM_ThreadPoolSettingInstrum)this.getCMMObject(string, MfManagedElementType.CMM_THREAD_POOL_SETTING);
        CMM_ServiceAccessURIInstrum cMM_ServiceAccessURIInstrum = (CMM_ServiceAccessURIInstrum)this.getCMMObject(string, MfManagedElementType.CMM_SERVICE_ACCESS_URI);
        CMM_ThreadPoolInstrum cMM_ThreadPoolInstrum = (CMM_ThreadPoolInstrum)this.getCMMObject(string, MfManagedElementType.CMM_THREAD_POOL);
        try {
            if (cMM_ThreadPoolSettingInstrum != null) {
                object = serviceConfig.getMaxThreads();
                if (object != null) {
                    cMM_ThreadPoolSettingInstrum.setMaxThreadPoolSize(((Integer)object).longValue());
                }
                if ((object = serviceConfig.getMinThreads()) != null) {
                    cMM_ThreadPoolSettingInstrum.setMinThreadPoolSize(((Integer)object).longValue());
                }
            }
        }
        catch (Throwable throwable) {
            this.logger.log(16, "Problem detected while initializing JESMF object of type " + MfManagedElementType.CMM_THREAD_POOL_SETTING + " for service " + string, throwable);
        }
        try {
            if (cMM_ServiceAccessURIInstrum != null) {
                this.initServiceLabeledURI(string);
            }
        }
        catch (Throwable throwable) {
            this.logger.log(16, "Problem detected while initializing JESMF object of type " + MfManagedElementType.CMM_THREAD_POOL_SETTING + " for service " + string, throwable);
        }
        try {
            if (cMM_ThreadPoolInstrum != null && (object = serviceConfig.getThreadPoolModel()) != null) {
                if (((String)object).equalsIgnoreCase("shared")) {
                    cMM_ThreadPoolInstrum.setShareable(true);
                } else {
                    cMM_ThreadPoolInstrum.setShareable(false);
                }
            }
        }
        catch (Throwable throwable) {
            this.logger.log(16, "Problem detected while initializing JESMF object of type " + MfManagedElementType.CMM_THREAD_POOL + " for service " + string, throwable);
        }
    }

    private void initServiceLabeledURI(String string) throws MfManagedElementInstrumException {
        CMM_ServiceAccessURIInstrum cMM_ServiceAccessURIInstrum = (CMM_ServiceAccessURIInstrum)this.getCMMObject(string, MfManagedElementType.CMM_SERVICE_ACCESS_URI);
        if (cMM_ServiceAccessURIInstrum == null) {
            return;
        }
        ServiceConfig serviceConfig = this.agent.getServiceConfigMBean(string);
        if (serviceConfig == null) {
            return;
        }
        Integer n = null;
        try {
            n = serviceConfig.getPort();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (n == null) {
            return;
        }
        MQAddress mQAddress = null;
        if (n == 0) {
            BrokerMonitor brokerMonitor = this.agent.getBrokerMonitorMBean();
            if (brokerMonitor != null) {
                Integer n2 = null;
                try {
                    n2 = brokerMonitor.getPort();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (n2 != null) {
                    mQAddress = MQAddressUtil.getServiceMQAddress(string, n2, false);
                }
            }
        } else {
            ServiceMonitor serviceMonitor = this.agent.getServiceMonitorMBean(string);
            if (serviceMonitor == null) {
                return;
            }
            Integer n3 = serviceMonitor.getPort();
            mQAddress = MQAddressUtil.getServiceMQAddress(string, n3, true);
        }
        if (mQAddress != null) {
            cMM_ServiceAccessURIInstrum.setLabeledURI(mQAddress.toString());
        }
    }

    private void updateServiceLabeledURI(String string, Integer n) throws MfManagedElementInstrumException {
        CMM_ServiceAccessURIInstrum cMM_ServiceAccessURIInstrum = (CMM_ServiceAccessURIInstrum)this.getCMMObject(string, MfManagedElementType.CMM_SERVICE_ACCESS_URI);
        if (cMM_ServiceAccessURIInstrum == null) {
            return;
        }
        ServiceConfig serviceConfig = this.agent.getServiceConfigMBean(string);
        if (serviceConfig == null) {
            return;
        }
        MQAddress mQAddress = null;
        if (n == 0) {
            BrokerMonitor brokerMonitor = this.agent.getBrokerMonitorMBean();
            if (brokerMonitor != null) {
                Integer n2 = null;
                try {
                    n2 = brokerMonitor.getPort();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (n2 != null) {
                    mQAddress = MQAddressUtil.getServiceMQAddress(string, n2, false);
                }
            }
        } else {
            mQAddress = MQAddressUtil.getServiceMQAddress(string, n, true);
        }
        if (mQAddress != null) {
            cMM_ServiceAccessURIInstrum.setLabeledURI(mQAddress.toString());
        }
    }

    private String getObjectReferenceName(String string, String string2) {
        return string2 + "_" + string;
    }

    private void storeDelegateObject(CP_MQStatsDelegate cP_MQStatsDelegate, Class clazz) {
        if (cP_MQStatsDelegate == null) {
            this.logger.log(16, "Null object passed in to JesmfManager.storeDelegateObject()");
            return;
        }
        this.storeObject((Object)cP_MQStatsDelegate, cP_MQStatsDelegate.getName(), clazz.getName());
    }

    private void storeCMMObject(CMM_ObjectInstrum cMM_ObjectInstrum, MfManagedElementType mfManagedElementType) {
        if (cMM_ObjectInstrum == null) {
            this.logger.log(16, "Null object passed in to JesmfManager.storeCMMObject()");
            return;
        }
        this.storeObject(cMM_ObjectInstrum, cMM_ObjectInstrum.getName(), mfManagedElementType.toString());
    }

    private void storeObject(Object object, String string, String string2) {
        if (object == null) {
            this.logger.log(16, "Null object passed in to JesmfManager.storeObject()");
            return;
        }
        String string3 = this.getObjectReferenceName(string, string2);
        if (this.jesmfObjects.get(string3) != null) {
            this.logger.log(16, "JESMF object with reference name " + string + " already exists in JesmfManager.");
            return;
        }
        this.jesmfObjects.put(string3, object);
    }

    private CP_MQStatsDelegate getDelegateObject(String string, Class clazz) {
        Object object = this.getObject(string, clazz.getName());
        if (object == null) {
            return null;
        }
        if (!(object instanceof CP_MQStatsDelegate)) {
            this.logger.log(16, "JESMF object with reference name " + string + " is not of type CP_MQStatsDelegate. It is of type: " + object);
            return null;
        }
        return (CP_MQStatsDelegate)((Object)object);
    }

    private CMM_ObjectInstrum getCMMObject(String string, MfManagedElementType mfManagedElementType) {
        Object object = this.getObject(string, mfManagedElementType.toString());
        if (object == null) {
            return null;
        }
        if (!(object instanceof CMM_ObjectInstrum)) {
            this.logger.log(16, "JESMF object with reference name " + string + " is not of type CMM_ObjectInstrum. It is of type: " + object);
            return null;
        }
        return (CMM_ObjectInstrum)object;
    }

    private Object getObject(String string, String string2) {
        String string3 = this.getObjectReferenceName(string, string2);
        return this.jesmfObjects.get(string3);
    }

    private Properties mergeWithJesmfPropertiesFromBrokerConfig(Properties properties) {
        Object object;
        Object object2;
        if (properties == null) {
            properties = new Properties();
        }
        if (this.useRmiRegistry()) {
            try {
                object2 = this.agent.getDefaultJMXUrlPathBase() + "jesmf";
                object = new JMXServiceURL("rmi", null, 0, (String)object2);
                properties.setProperty("PrivateConnectorServerUrl", ((JMXServiceURL)object).toString());
            }
            catch (Exception exception) {
                this.logger.log(16, "Caught exception while trying to set JMX URL for JESMF configuration property PrivateConnectorServerUrl: " + exception.toString(), (Throwable)exception);
            }
        }
        object2 = this.config.propertyNames();
        while (object2.hasMoreElements()) {
            object = (String)object2.nextElement();
            String string = this.config.getProperty((String)object);
            if (!((String)object).startsWith(JESMF_CONFIG_PROPBASE)) continue;
            String string2 = ((String)object).substring(JESMF_CONFIG_PROPBASE.length());
            properties.setProperty(string2, string);
        }
        return properties;
    }

    private Hashtable mergeWithJesmfContextFromBrokerConfig(Hashtable hashtable) {
        if (hashtable == null) {
            hashtable = new Hashtable<String, String>();
        }
        Enumeration<?> enumeration = this.config.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = this.config.getProperty(string);
            if (!string.startsWith(JESMF_CONTEXT_PROPBASE)) continue;
            String string3 = string.substring(JESMF_CONTEXT_PROPBASE.length());
            hashtable.put(string3, string2);
        }
        return hashtable;
    }

    private boolean jesmfSupportEnabled() {
        return this.config.getBooleanProperty(ENABLED, true);
    }

    private boolean useRmiRegistry() {
        return this.config.getBooleanProperty(RMIREGISTRY_USE);
    }
}

