/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsservice;

import com.sun.messaging.jmq.jmsservice.Destination;
import com.sun.messaging.jmq.jmsservice.EnumConverter;
import com.sun.messaging.jmq.jmsservice.JMSPacketBody;
import com.sun.messaging.jmq.jmsservice.JMSPacketProperties;
import com.sun.messaging.jmq.jmsservice.ReverseEnumMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JMSServiceReply {
    private JMSPacketProperties _replyProps = null;
    private JMSPacketBody _replyBody = null;
    private Status _status;

    public JMSServiceReply(Map<? extends String, ? extends Object> map, JMSPacketBody jMSPacketBody) {
        this._replyProps = map != null ? new JMSPacketProperties(map) : new JMSPacketProperties();
        this._replyBody = jMSPacketBody;
        this.setStatus();
    }

    public Status getStatus() {
        return this._status;
    }

    public JMSPacketProperties getProperties() {
        return this._replyProps;
    }

    public boolean getBooleanProp(String string) throws NoSuchFieldException {
        String string2 = "JMSServiceReply has no return property values";
        if (this._replyProps != null) {
            try {
                return (Boolean)this._replyProps.get(string);
            }
            catch (Exception exception) {
                string2 = "JMSServiceReply is missing boolean property -" + string;
            }
        }
        throw new NoSuchFieldException(string2);
    }

    public int getIntProp(String string) throws NoSuchFieldException {
        String string2 = "JMSServiceReply has no return property values";
        if (this._replyProps != null) {
            try {
                return (Integer)this._replyProps.get(string);
            }
            catch (Exception exception) {
                string2 = "JMSServiceReply is missing int property -" + string;
            }
        }
        throw new NoSuchFieldException(string2);
    }

    public long getLongProp(String string) throws NoSuchFieldException {
        String string2 = "JMSServiceReply has no return property values";
        if (this._replyProps != null) {
            try {
                Long l = (Long)this._replyProps.get(string);
                return l;
            }
            catch (Exception exception) {
                string2 = "JMSServiceReply is missing long property -" + string;
            }
        }
        throw new NoSuchFieldException(string2);
    }

    public String getStringProp(String string) throws NoSuchFieldException {
        String string2 = "JMSServiceReply has no return property values";
        if (this._replyProps != null) {
            try {
                return (String)this._replyProps.get(string);
            }
            catch (Exception exception) {
                string2 = "JMSServiceReply is missing string property -" + string;
            }
        }
        throw new NoSuchFieldException(string2);
    }

    public String getJMQVersion() throws NoSuchFieldException {
        return this.getStringProp("JMQVersion");
    }

    public long getJMQConnectionID() throws NoSuchFieldException {
        return this.getLongProp("JMQConnectionID");
    }

    public boolean getJMQHA() {
        boolean bl = false;
        try {
            bl = this.getBooleanProp("JMQHA");
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        return bl;
    }

    public String getJMQClusterID() {
        String string = null;
        try {
            string = this.getStringProp("JMQClusterID");
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        return string;
    }

    public long getJMQMaxMsgBytes() throws NoSuchFieldException {
        return this.getLongProp("JMQMaxMsgBytes");
    }

    public String getJMQBrokerList() {
        String string = null;
        try {
            string = this.getStringProp("JMQBrokerList");
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        return string;
    }

    public long getJMQSessionID() throws NoSuchFieldException {
        return this.getLongProp("JMQSessionID");
    }

    public String getJMQDestination() {
        String string = null;
        try {
            string = this.getStringProp("JMQDestination");
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        return string;
    }

    public Destination.Type getJMQDestType() throws NoSuchFieldException {
        int n = this.getIntProp("JMQDestType");
        if (n == 1) {
            return Destination.Type.QUEUE;
        }
        return Destination.Type.TOPIC;
    }

    public boolean getJMQCanCreate() {
        boolean bl = false;
        try {
            bl = this.getBooleanProp("JMQCanCreate");
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        return bl;
    }

    public long getJMQProducerID() throws NoSuchFieldException {
        return this.getLongProp("JMQProducerID");
    }

    public long getJMQConsumerID() throws NoSuchFieldException {
        return this.getLongProp("JMQConsumerID");
    }

    public long getJMQTransactionID() throws NoSuchFieldException {
        return this.getLongProp("JMQTransactionID");
    }

    private void setStatus() {
        this._status = Status.UNKNOWN;
        try {
            if (this._replyProps != null) {
                try {
                    this._status = (Status)this._replyProps.get("JMQStatus");
                }
                catch (ClassCastException classCastException) {
                    Integer n = (Integer)this._replyProps.get("JMQStatus");
                    int n2 = n;
                    this._status = Status.UNKNOWN.convert(n2);
                }
            }
        }
        catch (Exception exception) {
            System.err.println("JMSServiceReply:setStatus:Exception:" + exception.getMessage());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Status implements EnumConverter<Status>
    {
        OK(200),
        CREATED(201),
        MULTIPLE_CHOICES(300),
        MOVED_PERMENANTLY(301),
        NOT_MODIFIED(304),
        BAD_REQUEST(400),
        UNATUHORIZED(401),
        PAYMENT_REQUIRED(402),
        FORBIDDEN(403),
        NOT_FOUND(404),
        NOT_ALLOWED(405),
        TIMEOUT(408),
        CONFLICT(409),
        PRECONDITION_FAILED(412),
        INVALID_LOGIN(413),
        RESOURCE_FULL(414),
        ENTITY_TOO_LARGE(423),
        ERROR(500),
        NOT_IMPLEMENTED(501),
        UNAVAILABLE(503),
        BAD_VERSION(505),
        UNKNOWN(999);

        private static ReverseEnumMap<Status> map;
        private final int _statusCode;

        private Status(int n2) {
            this._statusCode = n2;
        }

        public int getStatusCode() {
            return this._statusCode;
        }

        @Override
        public int convert() {
            return this._statusCode;
        }

        @Override
        public Status convert(int n) {
            return map.get(n);
        }

        static {
            map = new ReverseEnumMap<Status>(Status.class);
        }
    }
}

