/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.util;

import com.sun.webui.jsf.util.ThemeUtilities;
import com.sun.webui.theme.Theme;
import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.json.JSONException;
import org.json.JSONObject;

public class JavaScriptUtilities {
    public static final int INDENT_FACTOR = 4;

    public static String getDojoConfig(boolean debug, boolean parseWidgets) {
        Theme theme = JavaScriptUtilities.getTheme();
        StringBuffer buff = new StringBuffer(256);
        try {
            JSONObject json = new JSONObject();
            json.put("isDebug", debug).put("debugAtAllCosts", debug).put("parseWidgets", parseWidgets);
            buff.append("djConfig=").append(json.toString(4)).append(";\n");
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return buff.toString();
    }

    public static String getModuleConfig(boolean writeIncludes) {
        Theme theme = JavaScriptUtilities.getTheme();
        StringBuffer buff = new StringBuffer(256);
        buff.append("dojo.hostenv.setModulePrefix(\"").append(JavaScriptUtilities.getTheme().getJSString("modulePrefix")).append("\", \"").append(theme.getPathToJSFile("modulePath")).append("\");\n").append(JavaScriptUtilities.getModule("*")).append("\n");
        if (writeIncludes) {
            buff.append(JavaScriptUtilities.getModule("widget.*")).append("\n").append(JavaScriptUtilities.getModule("widget.jsfx.*")).append("\n").append("dojo.hostenv.writeIncludes();").append("\n");
        }
        return buff.toString();
    }

    public static void renderDojoInclude(UIComponent component, ResponseWriter writer) throws IOException {
        JavaScriptUtilities.renderJavaScriptInclude(component, writer, "dojo");
    }

    public static void renderGlobalInclude(UIComponent component, ResponseWriter writer) throws IOException {
        String[] javascripts = JavaScriptUtilities.getTheme().getGlobalJSFiles();
        if (javascripts == null) {
            return;
        }
        for (int i = 0; i < javascripts.length; ++i) {
            String file = javascripts[i];
            if (file == null) continue;
            writer.startElement("script", component);
            writer.writeAttribute("type", (Object)"text/javascript", null);
            writer.writeURIAttribute("src", (Object)file.toString(), null);
            writer.endElement("script");
            writer.write("\n");
        }
    }

    public static void renderJsfxInclude(UIComponent component, ResponseWriter writer) throws IOException {
        JavaScriptUtilities.renderJavaScriptInclude(component, writer, "jsfx");
    }

    public static void renderJsonInclude(UIComponent component, ResponseWriter writer) throws IOException {
        JavaScriptUtilities.renderJavaScriptInclude(component, writer, "json");
    }

    public static void renderPrototypeInclude(UIComponent component, ResponseWriter writer) throws IOException {
        JavaScriptUtilities.renderJavaScriptInclude(component, writer, "prototype");
    }

    public static String getDomNode(FacesContext context, UIComponent component) {
        StringBuffer buff = new StringBuffer(128);
        buff.append("document.getElementById('").append(component.getClientId(context)).append("')");
        return buff.toString();
    }

    public static String getModule(String name) {
        StringBuffer buff = new StringBuffer(128);
        buff.append("dojo.require('").append(JavaScriptUtilities.getModuleName(name)).append("');");
        return buff.toString();
    }

    public static String getModuleName(String name) {
        StringBuffer buff = new StringBuffer(128);
        buff.append(JavaScriptUtilities.getTheme().getJSString("modulePrefix")).append(".").append(name);
        return buff.toString();
    }

    public static String getNamespace(String name) {
        StringBuffer buff = new StringBuffer(128);
        buff.append(JavaScriptUtilities.getTheme().getJSString("modulePrefix")).append(":").append(name);
        return buff.toString();
    }

    public static void renderJavaScript(UIComponent component, ResponseWriter writer, String js) throws IOException {
        if (js == null) {
            return;
        }
        writer.startElement("script", component);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.write("\n");
        writer.write(js);
        writer.endElement("script");
        writer.write("\n");
    }

    private static Theme getTheme() {
        return ThemeUtilities.getTheme(FacesContext.getCurrentInstance());
    }

    private static void renderJavaScriptInclude(UIComponent component, ResponseWriter writer, String file) throws IOException {
        if (file == null) {
            return;
        }
        String jsFile = JavaScriptUtilities.getTheme().getPathToJSFile(file);
        if (jsFile == null) {
            return;
        }
        writer.startElement("script", component);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.writeURIAttribute("src", (Object)jsFile, null);
        writer.endElement("script");
        writer.write("\n");
    }
}

