/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.file;

import com.sun.messaging.jmq.io.VRFileRAF;
import com.sun.messaging.jmq.io.VRecordRAF;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.data.BaseTransaction;
import com.sun.messaging.jmq.jmsserver.data.TransactionUID;
import com.sun.messaging.jmq.jmsserver.data.TransactionWorkFactory;
import com.sun.messaging.jmq.jmsserver.persist.Store;
import com.sun.messaging.jmq.jmsserver.persist.file.PreparedTxnStore;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.IOException;
import java.nio.ByteBuffer;

class TransactionWorkInfo {
    static final short PENDING = -1;
    static final short DONE = 0;
    private static final int BYTE_SIZE = 1;
    private static final int SHORT_SIZE = 2;
    private static final int INT_SIZE = 4;
    private static final int LONG_SIZE = 8;
    private static final int ENTRY_SIZE = 12;
    private Logger logger = Globals.getLogger();
    private BrokerResources br = Globals.getBrokerResources();
    private BaseTransaction msg;
    private TransactionUID tid;
    private int txnDataSize;
    private PreparedTxnStore parent = null;
    private VRecordRAF vrecord = null;

    TransactionWorkInfo(PreparedTxnStore preparedTxnStore, byte[] byArray, byte[] byArray2) throws IOException {
        this.parent = preparedTxnStore;
        try {
            BaseTransaction baseTransaction;
            this.msg = baseTransaction = TransactionWorkFactory.readFromBytes(byArray);
            this.tid = baseTransaction.getTid();
        }
        catch (BrokerException brokerException) {
            brokerException.printStackTrace();
            throw new IOException(brokerException.getMessage());
        }
        catch (IOException iOException) {
            this.logger.log(32, this.parent.storeName + ":failed to parse message from byte array", iOException);
            throw iOException;
        }
    }

    TransactionWorkInfo(PreparedTxnStore preparedTxnStore, VRecordRAF vRecordRAF) throws IOException {
        this.parent = preparedTxnStore;
        this.vrecord = vRecordRAF;
        try {
            BaseTransaction baseTransaction;
            this.msg = baseTransaction = this.parseTransactionWork(vRecordRAF);
            this.tid = baseTransaction.getTid();
        }
        catch (IOException iOException) {
            this.parent.getVRFile().free(this.vrecord);
            throw iOException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TransactionWorkInfo(PreparedTxnStore preparedTxnStore, VRFileRAF vRFileRAF, BaseTransaction baseTransaction, byte[] byArray, boolean bl) throws IOException {
        Object object;
        this.parent = preparedTxnStore;
        this.tid = baseTransaction.getTid();
        this.txnDataSize = byArray.length;
        int n = 4 + this.txnDataSize + 4;
        if (bl && Store.getDEBUG_SYNC()) {
            object = "TransactionWorkInfor sync() " + this.tid;
            this.logger.log(4, (String)object);
        }
        if (!Globals.isMinimizeWrites()) {
            object = vRFileRAF;
            synchronized (object) {
                this.vrecord = (VRecordRAF)vRFileRAF.allocate(n);
                this.vrecord.setCookie((short)-1);
                this.vrecord.writeInt(this.txnDataSize);
                this.vrecord.write(byArray);
                this.vrecord.setCookie((short)0);
                if (bl) {
                    this.vrecord.force();
                }
            }
        }
        object = vRFileRAF;
        synchronized (object) {
            ByteBuffer byteBuffer = ByteBuffer.allocate(n + 4);
            byteBuffer.putShort((short)2);
            byteBuffer.putShort((short)0);
            byteBuffer.putInt(this.txnDataSize);
            byteBuffer.put(byArray);
            byte[] byArray2 = byteBuffer.array();
            this.vrecord = (VRecordRAF)vRFileRAF.allocateAndWrite(n, byArray2);
            if (bl) {
                this.vrecord.force();
            }
        }
    }

    TransactionWorkInfo(PreparedTxnStore preparedTxnStore, BaseTransaction baseTransaction, byte[] byArray, boolean bl) throws IOException {
        this.parent = preparedTxnStore;
        this.tid = baseTransaction.getTid();
        if (byArray != null) {
            this.txnDataSize = byArray.length;
        }
        this.parent.writeData(this.tid, byArray, null, bl);
    }

    synchronized BaseTransaction getMessage() throws IOException {
        if (this.msg == null) {
            if (this.vrecord != null) {
                try {
                    return this.parseTransactionWork(this.vrecord);
                }
                catch (IOException iOException) {
                    this.logger.log(32, this.parent.storeName + ":failed to parse message from vrecord(" + this.vrecord + ")", iOException);
                    throw iOException;
                }
            }
            try {
                byte[] byArray = this.parent.loadData(this.tid);
                return this.parseTransactionWork(byArray);
            }
            catch (IOException iOException) {
                this.logger.log(32, this.parent.storeName + ":failed to parse message from byte array", iOException);
                throw iOException;
            }
        }
        BaseTransaction baseTransaction = this.msg;
        this.msg = null;
        return baseTransaction;
    }

    int getSize() {
        return this.txnDataSize;
    }

    TransactionUID getID() {
        return this.tid;
    }

    synchronized void free(boolean bl) throws IOException {
        if (bl && Store.getDEBUG_SYNC()) {
            String string = "TransactionWorkInfo free sync() " + this.getID();
            this.logger.log(4, string);
        }
        if (this.vrecord != null) {
            this.parent.getVRFile().free(this.vrecord);
            if (bl) {
                this.parent.getVRFile().force();
            }
            this.vrecord = null;
        } else {
            this.parent.removeData(this.tid, bl);
        }
        this.tid = null;
    }

    private BaseTransaction parseTransactionWork(byte[] byArray) throws IOException {
        try {
            BaseTransaction baseTransaction = TransactionWorkFactory.readFromBytes(byArray);
            return baseTransaction;
        }
        catch (Throwable throwable) {
            this.logger.log(32, this.parent.storeName + ":failed to parse message(size=" + this.txnDataSize + ") ", throwable);
            IOException iOException = new IOException(throwable.toString());
            iOException.setStackTrace(throwable.getStackTrace());
            throw iOException;
        }
    }

    private BaseTransaction parseTransactionWork(VRecordRAF vRecordRAF) throws IOException {
        try {
            vRecordRAF.rewind();
            this.txnDataSize = vRecordRAF.readInt();
            byte[] byArray = new byte[this.txnDataSize];
            vRecordRAF.read(byArray);
            BaseTransaction baseTransaction = TransactionWorkFactory.readFromBytes(byArray);
            return baseTransaction;
        }
        catch (Throwable throwable) {
            this.logger.log(32, this.parent.storeName + ":failed to parse message(size=" + this.txnDataSize + ") from vrecord(" + vRecordRAF + ")", throwable);
            IOException iOException = new IOException(throwable.toString());
            iOException.setStackTrace(throwable.getStackTrace());
            throw iOException;
        }
    }

    synchronized void updateState(int n, boolean bl) throws IOException, BrokerException {
        long l = 9L;
        this.writeIntAtOffset(l, n, bl);
    }

    synchronized void updateCompletion(int n, boolean bl) throws IOException, BrokerException {
        long l = 13L;
        this.writeIntAtOffset(l, n, bl);
    }

    void writeIntAtOffset(long l, int n, boolean bl) throws IOException, BrokerException {
        if (bl && Store.getDEBUG_SYNC()) {
            String string = "TransactionWorkInfo sync() " + this.tid;
            this.logger.log(4, string);
        }
        if (this.vrecord != null) {
            long l2 = 4L + l;
            this.vrecord.writeInt((int)l2, n);
            if (bl) {
                this.vrecord.force();
            }
        } else if (!this.parent.writeAttachmentData(this.tid, l, true, n, bl)) {
            this.logger.log(32, "B3007", (Object)this.tid, this.parent.storeName);
            throw new BrokerException(this.br.getString("B3007", this.tid, this.parent.storeName));
        }
    }
}

