/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist;

import com.sun.messaging.bridge.service.DupKeyException;
import com.sun.messaging.bridge.service.JMSBridgeStore;
import com.sun.messaging.bridge.service.KeyNotFoundException;
import com.sun.messaging.bridge.service.UpdateOpaqueDataCallback;
import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.io.SysMessageID;
import com.sun.messaging.jmq.jmsserver.Broker;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.cluster.BrokerState;
import com.sun.messaging.jmq.jmsserver.config.BrokerConfig;
import com.sun.messaging.jmq.jmsserver.core.BrokerAddress;
import com.sun.messaging.jmq.jmsserver.core.Consumer;
import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.jmsserver.data.BaseTransaction;
import com.sun.messaging.jmq.jmsserver.data.ClusterTransaction;
import com.sun.messaging.jmq.jmsserver.data.TransactionAcknowledgement;
import com.sun.messaging.jmq.jmsserver.data.TransactionBroker;
import com.sun.messaging.jmq.jmsserver.data.TransactionList;
import com.sun.messaging.jmq.jmsserver.data.TransactionState;
import com.sun.messaging.jmq.jmsserver.data.TransactionUID;
import com.sun.messaging.jmq.jmsserver.persist.HABrokerInfo;
import com.sun.messaging.jmq.jmsserver.persist.LoadException;
import com.sun.messaging.jmq.jmsserver.persist.TakeoverLockException;
import com.sun.messaging.jmq.jmsserver.persist.TakeoverStoreInfo;
import com.sun.messaging.jmq.jmsserver.persist.TransactionInfo;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.service.TakingoverTracker;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.jmsservice.BrokerEvent;
import com.sun.messaging.jmq.util.UID;
import com.sun.messaging.jmq.util.log.Logger;
import com.sun.messaging.jmq.util.txnlog.TransactionLogWriter;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Store
implements JMSBridgeStore {
    public static final String STORE_PROP_PREFIX = "imq.persist.store";
    public static final String CREATE_STORE_PROP = "imq.persist.storecreate.all";
    public static final String REMOVE_STORE_PROP = "imq.persist.storeremove.all";
    public static final String RESET_STORE_PROP = "imq.persist.storereset.all";
    public static final String RESET_MESSAGE_PROP = "imq.persist.storereset.messages";
    public static final String RESET_INTEREST_PROP = "imq.persist.storereset.durables";
    public static final String UPGRADE_NOBACKUP_PROP = "imq.persist.storeupgrade.nobackup";
    public static final String FILE_STORE_TYPE = "file";
    public static final String JDBC_STORE_TYPE = "jdbc";
    public static final String INMEMORY_STORE_TYPE = "inmemory";
    private static boolean DEBUG = false;
    private static boolean DEBUG_SYNC = Globals.getConfig().getBooleanProperty("imq.persist.store.debug.sync") || DEBUG;
    public static final int INTEREST_STATE_ROUTED = 0;
    public static final int INTEREST_STATE_DELIVERED = 1;
    public static final int INTEREST_STATE_ACKNOWLEDGED = 2;
    public static final Logger logger = Globals.getLogger();
    public static final BrokerResources br = Globals.getBrokerResources();
    public static final BrokerConfig config = Globals.getConfig();
    private boolean closed = false;
    private Object closedLock = new Object();
    private int inprogressCount = 0;
    private Object inprogressLock = new Object();
    private ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    public Lock txnLogSharedLock = this.lock.readLock();
    public Lock txnLogExclusiveLock = this.lock.writeLock();
    protected boolean createStore = config.getBooleanProperty("imq.persist.storecreate.all", false);
    protected boolean resetStore = false;
    protected boolean resetMessage = false;
    protected boolean resetInterest = false;
    protected boolean removeStore = config.getBooleanProperty("imq.persist.storeremove.all", false);
    protected boolean upgradeNoBackup = false;

    protected Store() {
        this.resetStore = config.getBooleanProperty(RESET_STORE_PROP, false);
        this.resetMessage = config.getBooleanProperty(RESET_MESSAGE_PROP, false);
        this.resetInterest = config.getBooleanProperty(RESET_INTEREST_PROP, false);
        this.upgradeNoBackup = config.getBooleanProperty(UPGRADE_NOBACKUP_PROP, false);
        if (this.removeStore) {
            logger.logToAll(8, "B1095");
        } else {
            if (this.resetStore) {
                logger.logToAll(8, "B1059");
            } else {
                if (this.resetMessage) {
                    logger.logToAll(8, "B1083");
                }
                if (this.resetInterest) {
                    logger.logToAll(8, "B1084");
                }
            }
            if (!this.resetStore && (this.resetMessage || this.resetInterest)) {
                logger.logToAll(8, "B1085");
            } else if (!this.resetStore) {
                logger.logToAll(8, "B1060");
            }
        }
    }

    public static boolean getDEBUG() {
        return DEBUG;
    }

    public static boolean getDEBUG_SYNC() {
        return DEBUG_SYNC;
    }

    public abstract int getStoreVersion();

    public void init() throws BrokerException {
    }

    public List<BaseTransaction> getIncompleteTransactions(int n) {
        return null;
    }

    public void rollbackAllTransactions() {
    }

    public abstract void storeMessage(DestinationUID var1, Packet var2, ConsumerUID[] var3, int[] var4, boolean var5) throws IOException, BrokerException;

    public abstract void storeMessage(DestinationUID var1, Packet var2, boolean var3) throws IOException, BrokerException;

    public void removeMessage(DestinationUID destinationUID, SysMessageID sysMessageID, boolean bl) throws IOException, BrokerException {
        this.removeMessage(destinationUID, sysMessageID, bl, false);
    }

    public abstract void removeMessage(DestinationUID var1, SysMessageID var2, boolean var3, boolean var4) throws IOException, BrokerException;

    public abstract void moveMessage(Packet var1, DestinationUID var2, DestinationUID var3, ConsumerUID[] var4, int[] var5, boolean var6) throws IOException, BrokerException;

    public abstract void removeAllMessages(Destination var1, boolean var2) throws IOException, BrokerException;

    public abstract Enumeration messageEnumeration(Destination var1) throws BrokerException;

    public void closeEnumeration(Enumeration enumeration) {
    }

    public boolean hasMessageBeenAcked(SysMessageID sysMessageID) throws BrokerException {
        throw new UnsupportedOperationException("Operation not supported by the " + this.getStoreType() + " store");
    }

    public abstract boolean hasMessageBeenAcked(DestinationUID var1, SysMessageID var2) throws BrokerException;

    public int getMessageCount(String string) throws BrokerException {
        throw new UnsupportedOperationException("Operation not supported by the " + this.getStoreType() + " store");
    }

    public abstract HashMap getMessageStorageInfo(Destination var1) throws BrokerException;

    public abstract Packet getMessage(DestinationUID var1, String var2) throws BrokerException;

    public abstract Packet getMessage(DestinationUID var1, SysMessageID var2) throws BrokerException;

    public abstract void storeInterestStates(DestinationUID var1, SysMessageID var2, ConsumerUID[] var3, int[] var4, boolean var5, Packet var6) throws BrokerException;

    public void storeInterestStates(DestinationUID destinationUID, SysMessageID sysMessageID, ConsumerUID[] consumerUIDArray, int[] nArray, boolean bl) throws BrokerException {
        this.storeInterestStates(destinationUID, sysMessageID, consumerUIDArray, nArray, bl, null);
    }

    public abstract void updateInterestState(DestinationUID var1, SysMessageID var2, ConsumerUID var3, int var4, boolean var5, TransactionUID var6, boolean var7) throws BrokerException;

    public void updateInterestState(DestinationUID destinationUID, SysMessageID sysMessageID, ConsumerUID consumerUID, int n, boolean bl) throws BrokerException {
        this.updateInterestState(destinationUID, sysMessageID, consumerUID, n, bl, null, false);
    }

    public void updateInterestState(DestinationUID destinationUID, SysMessageID sysMessageID, ConsumerUID consumerUID, int n, int n2) throws BrokerException {
        throw new UnsupportedOperationException("Operation not supported by the " + this.getStoreType() + " store");
    }

    public abstract int getInterestState(DestinationUID var1, SysMessageID var2, ConsumerUID var3) throws BrokerException;

    public abstract HashMap getInterestStates(DestinationUID var1, SysMessageID var2) throws BrokerException;

    public abstract ConsumerUID[] getConsumerUIDs(DestinationUID var1, SysMessageID var2) throws BrokerException;

    public abstract void storeInterest(Consumer var1, boolean var2) throws IOException, BrokerException;

    public abstract void removeInterest(Consumer var1, boolean var2) throws IOException, BrokerException;

    public abstract Consumer[] getAllInterests() throws IOException, BrokerException;

    public abstract void storeDestination(Destination var1, boolean var2) throws IOException, BrokerException;

    public abstract void updateDestination(Destination var1, boolean var2) throws BrokerException;

    public void updateDestinationConnectedTime(Destination destination, long l) throws BrokerException {
        throw new UnsupportedOperationException("Operation not supported by the " + this.getStoreType() + " store");
    }

    public abstract void removeDestination(Destination var1, boolean var2) throws IOException, BrokerException;

    public void reapAutoCreatedDestinations() throws BrokerException {
        throw new UnsupportedOperationException("Operation not supported by the " + this.getStoreType() + " store");
    }

    public long getDestinationConnectedTime(Destination destination) throws BrokerException {
        throw new UnsupportedOperationException("Operation not supported by the " + this.getStoreType() + " store");
    }

    public abstract Destination getDestination(DestinationUID var1) throws IOException, BrokerException;

    public abstract Destination[] getAllDestinations() throws IOException, BrokerException;

    public abstract void storeTransaction(TransactionUID var1, TransactionState var2, boolean var3) throws IOException, BrokerException;

    public abstract void storeTransaction(TransactionUID var1, TransactionInfo var2, boolean var3) throws IOException, BrokerException;

    public abstract void storeClusterTransaction(TransactionUID var1, TransactionState var2, TransactionBroker[] var3, boolean var4) throws BrokerException;

    public abstract void storeRemoteTransaction(TransactionUID var1, TransactionState var2, TransactionAcknowledgement[] var3, BrokerAddress var4, boolean var5) throws BrokerException;

    public abstract void removeTransaction(TransactionUID var1, boolean var2) throws IOException, BrokerException;

    public abstract void removeTransaction(TransactionUID var1, boolean var2, boolean var3) throws IOException, BrokerException;

    public abstract void updateTransactionState(TransactionUID var1, TransactionState var2, boolean var3) throws IOException, BrokerException;

    public abstract void updateClusterTransaction(TransactionUID var1, TransactionBroker[] var2, boolean var3) throws BrokerException;

    public void updateClusterTransaction(TransactionUID transactionUID, TransactionBroker[] transactionBrokerArray, boolean bl, ClusterTransaction clusterTransaction) throws BrokerException {
        throw new UnsupportedOperationException("Operation not supported by the " + this.getStoreType() + " store");
    }

    public abstract void updateClusterTransactionBrokerState(TransactionUID var1, int var2, TransactionBroker var3, boolean var4) throws BrokerException;

    public void updateRemoteTransaction(TransactionUID transactionUID, TransactionAcknowledgement[] transactionAcknowledgementArray, BrokerAddress brokerAddress, boolean bl) throws BrokerException {
        throw new UnsupportedOperationException("Operation not supported by the " + this.getStoreType() + " store");
    }

    public abstract TransactionState getTransactionState(TransactionUID var1) throws BrokerException;

    public void updateTransactionAccessedTime(TransactionUID transactionUID, long l) throws BrokerException {
        throw new UnsupportedOperationException("Operation not supported by the " + this.getStoreType() + " store");
    }

    public long getTransactionAccessedTime(TransactionUID transactionUID) throws BrokerException {
        throw new UnsupportedOperationException("Operation not supported by the " + this.getStoreType() + " store");
    }

    public Collection getTransactions(String string) throws BrokerException {
        throw new UnsupportedOperationException("Operation not supported by the " + this.getStoreType() + " store");
    }

    public int[] getTransactionUsageInfo(TransactionUID transactionUID) throws BrokerException {
        throw new UnsupportedOperationException("Operation not supported by the " + this.getStoreType() + " store");
    }

    public abstract TransactionBroker[] getClusterTransactionBrokers(TransactionUID var1) throws BrokerException;

    public abstract BrokerAddress getRemoteTransactionHomeBroker(TransactionUID var1) throws BrokerException;

    public abstract TransactionInfo getTransactionInfo(TransactionUID var1) throws BrokerException;

    public abstract HashMap getAllTransactionStates() throws IOException, BrokerException;

    public abstract HashMap getAllRemoteTransactionStates() throws IOException, BrokerException;

    public void close() {
        this.close(true);
    }

    public abstract void close(boolean var1);

    public abstract void storeTransactionAck(TransactionUID var1, TransactionAcknowledgement var2, boolean var3) throws BrokerException;

    public abstract void removeTransactionAck(TransactionUID var1, boolean var2) throws BrokerException;

    public abstract TransactionAcknowledgement[] getTransactionAcks(TransactionUID var1) throws BrokerException;

    public abstract HashMap getAllTransactionAcks() throws BrokerException;

    public abstract void updateProperty(String var1, Object var2, boolean var3) throws BrokerException;

    public abstract Object getProperty(String var1) throws BrokerException;

    public abstract String[] getPropertyNames() throws BrokerException;

    public abstract Properties getAllProperties() throws BrokerException;

    public abstract void storeConfigChangeRecord(long var1, byte[] var3, boolean var4) throws BrokerException;

    public abstract ArrayList getConfigChangeRecordsSince(long var1) throws BrokerException;

    public abstract Object[] getAllConfigRecords() throws BrokerException;

    public abstract void clearAllConfigChangeRecords(boolean var1) throws BrokerException;

    public abstract void clearAll(boolean var1) throws BrokerException;

    public abstract void compactDestination(Destination var1) throws BrokerException;

    public abstract HashMap getStorageInfo(Destination var1) throws BrokerException;

    public abstract String getStoreType();

    public boolean isJDBCStore() {
        return true;
    }

    public abstract Hashtable getDebugState() throws BrokerException;

    public long getBrokerHeartbeat(String string) throws BrokerException {
        throw new UnsupportedOperationException("Operation not supported by the " + this.getStoreType() + " store");
    }

    public HashMap getAllBrokerHeartbeats() throws BrokerException {
        throw new UnsupportedOperationException("Operation not supported by the " + this.getStoreType() + " store");
    }

    public Long updateBrokerHeartbeat(String string) throws BrokerException {
        throw new UnsupportedOperationException("Operation not supported by the " + this.getStoreType() + " store");
    }

    public Long updateBrokerHeartbeat(String string, long l) throws BrokerException {
        throw new UnsupportedOperationException("Operation not supported by the " + this.getStoreType() + " store");
    }

    public void addBrokerInfo(String string, String string2, BrokerState brokerState, int n, long l, long l2) throws BrokerException {
        throw new UnsupportedOperationException("Operation not supported by the " + this.getStoreType() + " store");
    }

    public void addBrokerInfo(String string, String string2, String string3, BrokerState brokerState, int n, long l, long l2) throws BrokerException {
        throw new UnsupportedOperationException("Operation not supported by the " + this.getStoreType() + " store");
    }

    public UID updateBrokerInfo(String string, int n, Object object, Object object2) throws BrokerException {
        throw new UnsupportedOperationException("Operation not supported by the " + this.getStoreType() + " store");
    }

    public void removeInactiveStoreSession() throws BrokerException {
        throw new UnsupportedOperationException("Operation not supported by the " + this.getStoreType() + " store");
    }

    public HashMap getAllBrokerInfos() throws BrokerException {
        return this.getAllBrokerInfos(false);
    }

    public HashMap getAllBrokerInfos(boolean bl) throws BrokerException {
        throw new UnsupportedOperationException("Operation not supported by the " + this.getStoreType() + " store");
    }

    public HABrokerInfo getBrokerInfo(String string) throws BrokerException {
        throw new UnsupportedOperationException("Operation not supported by the " + this.getStoreType() + " store");
    }

    public HashMap getAllBrokerInfoByState(BrokerState brokerState) throws BrokerException {
        throw new UnsupportedOperationException("Operation not supported by the " + this.getStoreType() + " store");
    }

    public String getStoreSessionOwner(long l) throws BrokerException {
        throw new UnsupportedOperationException("Operation not supported by the " + this.getStoreType() + " store");
    }

    public boolean ifOwnStoreSession(long l, String string) throws BrokerException {
        throw new UnsupportedOperationException("Operation not supported by the " + this.getStoreType() + " store");
    }

    public String getStoreSessionCreator(long l) throws BrokerException {
        throw new UnsupportedOperationException("Operation not supported by the " + this.getStoreType() + " store");
    }

    public boolean updateBrokerState(String string, BrokerState brokerState, BrokerState brokerState2, boolean bl) throws BrokerException {
        throw new UnsupportedOperationException("Operation not supported by the " + this.getStoreType() + " store");
    }

    public BrokerState getBrokerState(String string) throws BrokerException {
        throw new UnsupportedOperationException("Operation not supported by the " + this.getStoreType() + " store");
    }

    public Object[] getAllBrokerStates() throws BrokerException {
        throw new UnsupportedOperationException("Operation not supported by the " + this.getStoreType() + " store");
    }

    public void getTakeOverLock(String string, String string2, long l, BrokerState brokerState, long l2, BrokerState brokerState2, boolean bl, TakingoverTracker takingoverTracker) throws TakeoverLockException, BrokerException {
        throw new UnsupportedOperationException("Operation not supported by the " + this.getStoreType() + " store");
    }

    public TakeoverStoreInfo takeOverBrokerStore(String string, String string2, TakingoverTracker takingoverTracker) throws TakeoverLockException, BrokerException {
        throw new UnsupportedOperationException("Operation not supported by the " + this.getStoreType() + " store");
    }

    public void syncDestination(Destination destination) throws BrokerException {
        throw new UnsupportedOperationException("Operation not supported by the " + this.getStoreType() + " store");
    }

    public void syncInterest(Consumer consumer) throws BrokerException {
        throw new UnsupportedOperationException("Operation not supported by the " + this.getStoreType() + " store");
    }

    public void syncTransaction(TransactionUID transactionUID) throws BrokerException {
        throw new UnsupportedOperationException("Operation not supported by the " + this.getStoreType() + " store");
    }

    public void syncConfigRecord() throws BrokerException {
        throw new UnsupportedOperationException("Operation not supported by the " + this.getStoreType() + " store");
    }

    public void sync() throws BrokerException {
        throw new UnsupportedOperationException("Operation not supported by the " + this.getStoreType() + " store");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void syncStore(TransactionLogWriter[] transactionLogWriterArray) throws IOException, BrokerException {
        Object object = this.closedLock;
        synchronized (object) {
            Object object2 = this.inprogressLock;
            synchronized (object2) {
                while (this.inprogressCount > 0) {
                    try {
                        this.inprogressLock.wait();
                    }
                    catch (Exception exception) {}
                }
            }
            this.syncDestination(null);
            this.syncTransaction(null);
            int n = transactionLogWriterArray.length;
            for (int i = 0; i < n; ++i) {
                transactionLogWriterArray[i].checkpoint();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void syncStoreOnCheckpoint() throws IOException, BrokerException {
        try {
            this.txnLogExclusiveLock.lock();
            this.syncDestination(null);
            this.syncTransaction(null);
            Object var2_1 = null;
            this.txnLogExclusiveLock.unlock();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.txnLogExclusiveLock.unlock();
            throw throwable;
        }
    }

    public boolean initTxnLogger() throws BrokerException {
        throw new UnsupportedOperationException("Operation not supported by the " + this.getStoreType() + " store");
    }

    public void logTxn(BaseTransaction baseTransaction) throws BrokerException {
        throw new UnsupportedOperationException("Operation not supported by the " + this.getStoreType() + " store");
    }

    public void logTxnCompletion(TransactionUID transactionUID, int n, int n2) throws BrokerException {
        throw new UnsupportedOperationException("Operation not supported by the " + this.getStoreType() + " store");
    }

    public void loggedCommitWrittenToMessageStore(TransactionUID transactionUID, int n) {
        throw new UnsupportedOperationException("Operation not supported by the " + this.getStoreType() + " store");
    }

    public void logTxn(int n, byte[] byArray) throws IOException {
        throw new UnsupportedOperationException("Operation not supported by the " + this.getStoreType() + " store");
    }

    public LoadException getLoadDestinationException() {
        return null;
    }

    public LoadException getLoadConsumerException() {
        return null;
    }

    public LoadException getLoadPropertyException() {
        return null;
    }

    public LoadException getLoadTransactionException() {
        return null;
    }

    public LoadException getLoadTransactionAckException() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setClosedAndWait() {
        Object object = this.closedLock;
        synchronized (object) {
            this.closed = true;
        }
        this.beforeWaitOnClose();
        object = this.inprogressLock;
        synchronized (object) {
            while (this.inprogressCount > 0) {
                try {
                    this.inprogressLock.wait();
                }
                catch (Exception exception) {}
            }
        }
    }

    protected void beforeWaitOnClose() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkClosedAndSetInProgress() throws BrokerException {
        Object object = this.closedLock;
        synchronized (object) {
            if (this.closed) {
                logger.log(32, "B3102");
                throw new BrokerException(br.getString("B3102"));
            }
            this.setInProgress(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setInProgress(boolean bl) {
        Object object = this.inprogressLock;
        synchronized (object) {
            this.inprogressCount = bl ? ++this.inprogressCount : --this.inprogressCount;
            if (this.inprogressCount == 0) {
                this.inprogressLock.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean closed() {
        Object object = this.closedLock;
        synchronized (object) {
            return this.closed;
        }
    }

    public boolean upgradeNoBackup() {
        return this.upgradeNoBackup;
    }

    protected boolean getConfirmation() throws BrokerException {
        try {
            String string = br.getString("B0029");
            String string2 = br.getString("B0026");
            String string3 = br.getString("B0027");
            Object[] objectArray = new String[]{string2, string3};
            System.out.print(br.getString("B0040", objectArray));
            System.out.flush();
            String string4 = new BufferedReader(new InputStreamReader(System.in)).readLine();
            if (!string2.equalsIgnoreCase(string4) && !string.equalsIgnoreCase(string4)) {
                System.err.println(br.getString("B1108"));
                Broker.getBroker().exit(1, br.getString("B1108"), BrokerEvent.Type.FATAL_ERROR);
            }
            return true;
        }
        catch (IOException iOException) {
            logger.log(32, iOException.toString());
            throw new BrokerException(iOException.toString(), iOException);
        }
    }

    public int doCheckpoint(boolean bl) {
        throw new UnsupportedOperationException("doCheckpoint method only implemented for FileStore");
    }

    @Override
    public void storeTMLogRecord(String string, byte[] byArray, String string2, boolean bl, java.util.logging.Logger logger) throws DupKeyException, Exception {
        throw new UnsupportedOperationException("Operation not supported by the " + this.getStoreType() + " store");
    }

    @Override
    public void updateTMLogRecord(String string, byte[] byArray, String string2, UpdateOpaqueDataCallback updateOpaqueDataCallback, boolean bl, boolean bl2, java.util.logging.Logger logger) throws DupKeyException, Exception {
        throw new UnsupportedOperationException("Operation not supported by the " + this.getStoreType() + " store");
    }

    @Override
    public void removeTMLogRecord(String string, String string2, boolean bl, java.util.logging.Logger logger) throws KeyNotFoundException, Exception {
        throw new UnsupportedOperationException("Operation not supported by the " + this.getStoreType() + " store");
    }

    @Override
    public byte[] getTMLogRecord(String string, String string2, java.util.logging.Logger logger) throws Exception {
        throw new UnsupportedOperationException("Operation not supported by the " + this.getStoreType() + " store");
    }

    @Override
    public long getTMLogRecordUpdatedTime(String string, String string2, java.util.logging.Logger logger) throws KeyNotFoundException, Exception {
        throw new UnsupportedOperationException("Operation not supported by the " + this.getStoreType() + " store");
    }

    @Override
    public long getTMLogRecordCreatedTime(String string, String string2, java.util.logging.Logger logger) throws KeyNotFoundException, Exception {
        throw new UnsupportedOperationException("Operation not supported by the " + this.getStoreType() + " store");
    }

    @Override
    public List getTMLogRecordsByName(String string, java.util.logging.Logger logger) throws Exception {
        throw new UnsupportedOperationException("Operation not supported by the " + this.getStoreType() + " store");
    }

    public List getTMLogRecordsByNameByBroker(String string, String string2, java.util.logging.Logger logger) throws Exception {
        throw new UnsupportedOperationException("Operation not supported by the " + this.getStoreType() + " store");
    }

    public List getNamesByBroker(String string, java.util.logging.Logger logger) throws Exception {
        throw new UnsupportedOperationException("Operation not supported by the " + this.getStoreType() + " store");
    }

    @Override
    public List getTMLogRecordKeysByName(String string, java.util.logging.Logger logger) throws Exception {
        throw new UnsupportedOperationException("Operation not supported by the " + this.getStoreType() + " store");
    }

    @Override
    public void addJMSBridge(String string, boolean bl, java.util.logging.Logger logger) throws DupKeyException, Exception {
        throw new UnsupportedOperationException("Operation not supported by the " + this.getStoreType() + " store");
    }

    @Override
    public List getJMSBridges(java.util.logging.Logger logger) throws Exception {
        throw new UnsupportedOperationException("Operation not supported by the " + this.getStoreType() + " store");
    }

    public List getJMSBridgesByBroker(String string, java.util.logging.Logger logger) throws Exception {
        throw new UnsupportedOperationException("Operation not supported by the " + this.getStoreType() + " store");
    }

    @Override
    public long getJMSBridgeUpdatedTime(String string, java.util.logging.Logger logger) throws KeyNotFoundException, Exception {
        throw new UnsupportedOperationException("Operation not supported by the " + this.getStoreType() + " store");
    }

    @Override
    public long getJMSBridgeCreatedTime(String string, java.util.logging.Logger logger) throws KeyNotFoundException, Exception {
        throw new UnsupportedOperationException("Operation not supported by the " + this.getStoreType() + " store");
    }

    @Override
    public void closeJMSBridgeStore() throws Exception {
        throw new UnsupportedOperationException("Operation not supported by the " + this.getStoreType() + " store");
    }

    public boolean isTxnConversionRequired() {
        return false;
    }

    public void convertTxnFormats(TransactionList transactionList) throws BrokerException, IOException {
    }
}

