/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Configs;
import com.sun.enterprise.config.serverbeans.MessageSecurityConfig;
import com.sun.enterprise.config.serverbeans.ProviderConfig;
import com.sun.enterprise.config.serverbeans.SecurityService;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.util.List;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@Service(name="list-message-security-providers")
@Scoped(value=PerLookup.class)
@I18n(value="list.message.security.provider")
public class ListMessageSecurityProvider
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(ListMessageSecurityProvider.class);
    @Param(optional=true)
    String target;
    @Param(name="layer", acceptableValues="SOAP,HttpServlet", optional=true)
    String authLayer;
    @Inject
    Configs configs;

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        List configList = this.configs.getConfig();
        Config config = (Config)configList.get(0);
        SecurityService secService = config.getSecurityService();
        report.getTopMessagePart().setMessage(localStrings.getLocalString("list.message.security.provider.success", "list-message-security-providers successful"));
        report.getTopMessagePart().setChildrenType("");
        for (MessageSecurityConfig msc : secService.getMessageSecurityConfig()) {
            ActionReport.MessagePart part;
            if (this.authLayer == null) {
                for (ProviderConfig pc : msc.getProviderConfig()) {
                    part = report.getTopMessagePart().addChild();
                    part.setMessage(pc.getProviderId());
                }
                continue;
            }
            if (!msc.getAuthLayer().equals(this.authLayer)) continue;
            for (ProviderConfig pc : msc.getProviderConfig()) {
                part = report.getTopMessagePart().addChild();
                part.setMessage(pc.getProviderId());
            }
        }
    }
}

