/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.io;

import com.sun.messaging.jmq.io.PortMapperEntry;
import com.sun.messaging.jmq.resources.SharedResources;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;

public class PortMapperTable {
    private static boolean DEBUG = false;
    public static final int PORTMAPPER_VERSION = 101;
    public static final String DOT = ".";
    public static final String NEWLINE = "\n";
    public static final String SPACE = " ";
    public static final byte NEWLINE_BYTE = 10;
    public static final byte DOT_BYTE = 46;
    public static final byte SPACE_BYTE = 32;
    private String brokerInstance = "???";
    private String brokerVersion = "???";
    private String version = "???";
    private Map table = null;

    public PortMapperTable() {
        try {
            Class<?> clazz = Class.forName("java.util.LinkedHashMap");
            Map map = (Map)clazz.newInstance();
            this.table = Collections.synchronizedMap(map);
        }
        catch (Throwable throwable) {
            this.table = Collections.synchronizedMap(new HashMap());
        }
        this.version = Integer.toString(101);
    }

    public void add(PortMapperEntry portMapperEntry) {
        this.table.remove(portMapperEntry.getName());
        this.table.put(portMapperEntry.getName(), portMapperEntry);
    }

    public PortMapperEntry get(String string) {
        return (PortMapperEntry)this.table.get(string);
    }

    public void remove(String string) {
        this.table.remove(string);
    }

    public void remove(PortMapperEntry portMapperEntry) {
        this.table.remove(portMapperEntry.getName());
    }

    public void setBrokerInstanceName(String string) {
        this.brokerInstance = string;
    }

    public void setBrokerVersion(String string) {
        this.brokerVersion = string;
    }

    public String getBrokerInstanceName() {
        return this.brokerInstance;
    }

    public String getVersion() {
        return this.version;
    }

    public String getBrokerVersion() {
        return this.brokerVersion;
    }

    public Map getServices() {
        return this.table;
    }

    public int getPortForService(String string) {
        PortMapperEntry portMapperEntry = (PortMapperEntry)this.table.get(string);
        if (portMapperEntry == null) {
            return -1;
        }
        return portMapperEntry.getPort();
    }

    public String toString() {
        return this.version + SPACE + this.brokerInstance + SPACE + this.brokerVersion + this.table.toString();
    }

    public void write(OutputStream outputStream) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("101 " + this.brokerInstance + SPACE + this.brokerVersion + NEWLINE);
        for (String string : this.table.keySet()) {
            PortMapperEntry portMapperEntry = (PortMapperEntry)this.table.get(string);
            stringBuffer.append(portMapperEntry.toString() + NEWLINE);
        }
        stringBuffer.append(".\n");
        outputStream.write(stringBuffer.toString().getBytes("ASCII"));
        outputStream.flush();
    }

    public void read(InputStream inputStream) throws IOException {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
        byte[] byArray = new byte[2048];
        int n = 0;
        if (DEBUG) {
            System.err.println(this.getClass().getName() + ".read():");
        }
        n = this.readLine(bufferedInputStream, byArray);
        StringTokenizer stringTokenizer = new StringTokenizer(new String(byArray, "ASCII"));
        this.version = stringTokenizer.nextToken();
        if (Integer.parseInt(this.version) != 101) {
            throw new IOException(SharedResources.getResources().getString("S4006", String.valueOf(this.version), String.valueOf(101)));
        }
        this.brokerInstance = stringTokenizer.nextToken();
        this.brokerVersion = stringTokenizer.nextToken();
        while ((n = this.readLine(bufferedInputStream, byArray)) > 0 && (n != 1 || byArray[0] != 46)) {
            PortMapperEntry portMapperEntry = PortMapperEntry.parse(new String(byArray, 0, n, "ASCII"));
            this.add(portMapperEntry);
        }
    }

    private int readLine(InputStream inputStream, byte[] byArray) throws IOException {
        int n = 0;
        int n2 = 0;
        n = inputStream.read();
        while (n != -1 && n != 10) {
            if (n2 < byArray.length) {
                byArray[n2] = (byte)n;
                ++n2;
            }
            n = inputStream.read();
        }
        if (DEBUG) {
            try {
                System.err.println(new String(byArray, 0, n2, "ASCII"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return n2;
    }
}

