/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.BrokerAddress;
import com.sun.messaging.jmq.jmsserver.data.TransactionBroker;
import com.sun.messaging.jmq.jmsserver.data.TransactionState;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.util.HashMap;

public class TransactionInfo
implements Cloneable,
Externalizable {
    static final long serialVersionUID = 5642215309770752611L;
    public static final int TXN_NOFLAG = 0;
    public static final int TXN_LOCAL = 1;
    public static final int TXN_CLUSTER = 2;
    public static final int TXN_REMOTE = 3;
    private int type = 0;
    private TransactionState state = null;
    private TransactionBroker[] txnBkrs = null;
    private BrokerAddress txnHomeBroker = null;
    private transient HashMap bkrMap = new HashMap();

    public TransactionInfo() {
    }

    public TransactionInfo(TransactionInfo transactionInfo) {
        this.type = transactionInfo.getType();
        this.state = new TransactionState(transactionInfo.getTransactionState());
        this.txnHomeBroker = transactionInfo.getTransactionHomeBroker();
        this.setTransactionBrokers(transactionInfo.getTransactionBrokers());
    }

    public TransactionInfo(TransactionState transactionState) {
        this(transactionState, null, null, 1);
    }

    public TransactionInfo(TransactionState transactionState, BrokerAddress brokerAddress, TransactionBroker[] transactionBrokerArray, int n) {
        if (transactionState == null) {
            throw new IllegalArgumentException("Null TransactionState specified");
        }
        this.type = n;
        this.state = transactionState;
        this.txnHomeBroker = brokerAddress;
        this.setTransactionBrokers(transactionBrokerArray);
    }

    public boolean isLocal() {
        return this.type == 1;
    }

    public boolean isRemote() {
        return this.type == 3;
    }

    public boolean isCluster() {
        return this.type == 2;
    }

    public void setType(int n) {
        this.type = n;
    }

    public int getType() {
        return this.type;
    }

    public TransactionState getTransactionState() {
        return this.state;
    }

    public int getTransactionStateValue() {
        return this.state.getState();
    }

    public void setTransactionBrokers(TransactionBroker[] transactionBrokerArray) {
        if (!this.bkrMap.isEmpty()) {
            this.bkrMap.clear();
        }
        if (transactionBrokerArray == null) {
            this.txnBkrs = null;
        } else {
            int n = transactionBrokerArray.length;
            this.txnBkrs = new TransactionBroker[n];
            for (int i = 0; i < n; ++i) {
                TransactionBroker transactionBroker;
                this.txnBkrs[i] = transactionBroker = (TransactionBroker)transactionBrokerArray[i].clone();
                this.bkrMap.put(transactionBroker.getBrokerAddress(), transactionBroker);
            }
            if (this.bkrMap.size() != n) {
                throw new IllegalArgumentException("Internal Error: duplicate TransactionBroker object found");
            }
        }
    }

    public TransactionBroker[] getTransactionBrokers() {
        return this.txnBkrs;
    }

    public BrokerAddress getTransactionHomeBroker() {
        return this.txnHomeBroker;
    }

    public void updateTransactionState(int n) throws BrokerException {
        this.state.setState(n);
    }

    public void updateBrokerState(TransactionBroker transactionBroker) throws BrokerException {
        TransactionBroker transactionBroker2 = (TransactionBroker)this.bkrMap.get(transactionBroker.getBrokerAddress());
        if (transactionBroker2 == null) {
            throw new BrokerException("TransactionBroker " + transactionBroker2 + " could not be found in the store", 404);
        }
        transactionBroker2.copyState(transactionBroker);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.type = objectInput.readInt();
        this.state = (TransactionState)objectInput.readObject();
        this.txnHomeBroker = (BrokerAddress)objectInput.readObject();
        this.txnBkrs = (TransactionBroker[])objectInput.readObject();
        this.bkrMap = new HashMap();
        if (this.txnBkrs != null) {
            for (int i = 0; i < this.txnBkrs.length; ++i) {
                TransactionBroker transactionBroker = this.txnBkrs[i];
                this.bkrMap.put(transactionBroker.getBrokerAddress(), transactionBroker);
            }
            if (this.bkrMap.size() != this.txnBkrs.length) {
                Globals.getLogger().log(16, "Internal Error: duplicate TransactionBroker object found");
            }
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.bkrMap = new HashMap();
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeInt(this.type);
        objectOutput.writeObject(this.state);
        objectOutput.writeObject(this.txnHomeBroker);
        objectOutput.writeObject(this.txnBkrs);
    }

    public Object clone() {
        try {
            TransactionInfo transactionInfo = (TransactionInfo)super.clone();
            if (this.state != null) {
                transactionInfo.state = new TransactionState(this.state);
            }
            if (this.txnBkrs != null) {
                transactionInfo.txnBkrs = (TransactionBroker[])this.txnBkrs.clone();
            }
            return transactionInfo;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new Error("This should never happen!");
        }
    }

    public String toString() {
        return new StringBuffer(128).append("TransactionInfo[type=").append(TransactionInfo.toString(this.type)).append(", state=").append(this.state).append(", home broker=").append(this.txnHomeBroker).append(", brokers=").append(this.txnBkrs).append("]").toString();
    }

    public static String toString(int n) {
        switch (n) {
            case 0: {
                return "TXN_NOFLAG";
            }
            case 1: {
                return "TXN_LOCAL";
            }
            case 2: {
                return "TXN_CLUSTER";
            }
            case 3: {
                return "TXN_REMOTE";
            }
        }
        return "INVALID TYPE " + n;
    }
}

