/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.mbeanserver;

import java.io.IOException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.RMIServerSocketFactory;
import java.rmi.server.RMISocketFactory;
import java.util.HashMap;
import java.util.Map;
import javax.management.MBeanServer;
import javax.management.remote.JMXAuthenticator;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXServiceURL;
import javax.management.remote.rmi.RMIConnection;
import javax.management.remote.rmi.RMIConnectorServer;
import javax.management.remote.rmi.RMIJRMPServerImpl;
import javax.security.auth.Subject;
import org.glassfish.admin.mbeanserver.BootAMXListener;
import org.glassfish.admin.mbeanserver.ConnectorStarter;
import org.glassfish.admin.mbeanserver.Util;
import org.jvnet.hk2.component.Habitat;

final class RMIConnectorStarter
extends ConnectorStarter {
    private final Registry mRegistry;
    private final boolean mBindToSingleIP;
    private volatile MyRMIJRMPServerImpl mMyServer;
    private final MyRMIServerSocketFactory mServerSocketFactory;
    public static final String RMI_HOSTNAME_PROP = "java.rmi.server.hostname";

    public RMIConnectorStarter(MBeanServer mbeanServer, String address, int port, String protocol, String authRealmName, boolean securityEnabled, Habitat habitat, BootAMXListener bootListener) throws UnknownHostException {
        super(mbeanServer, address, port, authRealmName, securityEnabled, habitat, bootListener);
        if (!"rmi_jrmp".equals(protocol)) {
            throw new IllegalArgumentException("JMXConnectorServer not yet supporting protocol: " + protocol);
        }
        boolean ENABLED = true;
        this.mBindToSingleIP = !address.equals("0.0.0.0") && !address.equals("");
        InetAddress inetAddr = RMIConnectorStarter.getAddress(address);
        this.mServerSocketFactory = this.mBindToSingleIP ? new MyRMIServerSocketFactory(inetAddr) : null;
        this.mRegistry = this.startRegistry(address, this.mPort);
    }

    private static InetAddress getAddress(String addrSpec) throws UnknownHostException {
        String actual = addrSpec;
        if (addrSpec.equals("localhost")) {
            actual = "127.0.0.1";
        }
        InetAddress addr = InetAddress.getByName(actual);
        return addr;
    }

    static String setupRMIHostname(String host) {
        return System.setProperty(RMI_HOSTNAME_PROP, host);
    }

    private static void restoreRMIHostname(String saved, String expectedValue) {
        if (saved == null) {
            System.clearProperty(RMI_HOSTNAME_PROP);
        } else {
            String temp = System.setProperty(RMI_HOSTNAME_PROP, saved);
            if (!temp.equals(expectedValue)) {
                throw new IllegalStateException("Something changed java.rmi.server.hostname to " + temp);
            }
        }
    }

    private static void debug(Object o) {
        System.out.println("" + o);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Registry startRegistry(String addr, int port) {
        Registry registry = null;
        if (this.mBindToSingleIP) {
            String saved = RMIConnectorStarter.setupRMIHostname(addr);
            try {
                Util.getLogger().info("Binding RMI port to single IP address = " + System.getProperty(RMI_HOSTNAME_PROP) + ", port " + port);
                registry = this._startRegistry(port);
            }
            finally {
                RMIConnectorStarter.restoreRMIHostname(saved, addr);
            }
        } else {
            Util.getLogger().info("Binding RMI port to *:" + port);
            registry = this._startRegistry(port);
        }
        return registry;
    }

    private Registry _startRegistry(int port) {
        System.setProperty("java.rmi.server.randomIDs", "true");
        try {
            return LocateRegistry.createRegistry(port, null, this.mServerSocketFactory);
        }
        catch (Exception e) {
            throw new RuntimeException("Port " + port + " is not available for the internal rmi registry. " + "This means that a call was made with the same port, without closing earlier " + "registry instance. This has to do with the system jmx connector configuration " + "in admin-service element of the configuration associated with this instance");
        }
    }

    public JMXConnectorServer start() throws MalformedURLException, IOException {
        String name = "jmxrmi";
        String hostname = this.hostname();
        HashMap<String, JMXAuthenticator> env = new HashMap<String, JMXAuthenticator>();
        JMXAuthenticator authenticator = this.getAccessController();
        if (authenticator != null) {
            env.put("jmx.remote.authenticator", authenticator);
        }
        String hostPort = hostname + ":" + this.mPort;
        String urlStr = "service:jmx:rmi://" + hostPort + "/jndi/rmi://" + hostPort + "/" + "jmxrmi";
        this.mJMXServiceURL = new JMXServiceURL(urlStr);
        if (this.mBindToSingleIP) {
            Object csf = null;
            Object ssf = null;
            this.mMyServer = new MyRMIJRMPServerImpl(this.mPort, env, (RMIServerSocketFactory)this.mServerSocketFactory, this.mAddress);
            this.mConnectorServer = new RMIConnectorServer(this.mJMXServiceURL, env, this.mMyServer, this.mMBeanServer);
        } else {
            this.mConnectorServer = JMXConnectorServerFactory.newJMXConnectorServer(this.mJMXServiceURL, env, this.mMBeanServer);
        }
        if (this.mBootListener != null) {
            this.mConnectorServer.addNotificationListener(this.mBootListener, null, this.mJMXServiceURL.toString());
        }
        this.mConnectorServer.start();
        return this.mConnectorServer;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class MyRMIJRMPServerImpl
    extends RMIJRMPServerImpl {
        private final String mBindToAddr;

        public MyRMIJRMPServerImpl(int port, Map<String, ?> env, RMIServerSocketFactory serverSocketFactory, String bindToAddr) throws IOException {
            super(port, null, serverSocketFactory, env);
            this.mBindToAddr = bindToAddr;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected synchronized void export(String host) throws IOException {
            String saved = RMIConnectorStarter.setupRMIHostname(this.mBindToAddr);
            try {
                super.export();
                System.out.println("MyRMIJRMPServerImpl: exported on address " + this.mBindToAddr);
            }
            finally {
                RMIConnectorStarter.restoreRMIHostname(saved, this.mBindToAddr);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected synchronized RMIConnection makeClient(String connectionId, Subject subject) throws IOException {
            String saved = RMIConnectorStarter.setupRMIHostname(this.mBindToAddr);
            try {
                Util.getLogger().fine("MyRMIJRMPServerImpl: makeClient on address = " + System.getProperty(RMIConnectorStarter.RMI_HOSTNAME_PROP));
                RMIConnection rMIConnection = super.makeClient(connectionId, subject);
                return rMIConnection;
            }
            finally {
                RMIConnectorStarter.restoreRMIHostname(saved, this.mBindToAddr);
            }
        }
    }

    public static final class MyRMIServerSocketFactory
    extends RMISocketFactory {
        private final InetAddress mAddress;

        public MyRMIServerSocketFactory(InetAddress addr) {
            this.mAddress = addr;
        }

        public ServerSocket createServerSocket(int port) throws IOException {
            int backlog = 5;
            ServerSocket s = new ServerSocket(port, 5, this.mAddress);
            return s;
        }

        public Socket createSocket(String host, int port) throws IOException {
            throw new IllegalStateException("MyRMIServerSocketFactory.createSocket");
        }
    }
}

