/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.multibroker.fullyconnected;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.license.LicenseBase;
import com.sun.messaging.jmq.jmsserver.multibroker.fullyconnected.ClusterImpl;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.service.ClusterDiscoveryService;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.net.MQServerSocketFactory;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.HashMap;
import javax.net.ServerSocketFactory;

class ClusterServiceListener
extends Thread {
    private static final BrokerResources br = Globals.getBrokerResources();
    private static final Logger logger = Globals.getLogger();
    ClusterImpl callback = null;
    boolean done = false;
    ServerSocket ss = null;
    private boolean nodelay;
    private boolean isSSL = false;
    private static ServerSocketFactory ssf = MQServerSocketFactory.getDefault();

    public ClusterServiceListener(ClusterImpl clusterImpl) throws IOException {
        this.callback = clusterImpl;
        this.setName("ClusterServiceListener");
        this.setDaemon(true);
        this.nodelay = clusterImpl.getTCPNodelay();
        if (clusterImpl.getTransport().equalsIgnoreCase("ssl")) {
            this.nodelay = clusterImpl.getSSLNodelay();
            this.isSSL = true;
            this.initSSLListener();
        } else {
            this.initTCPListener();
        }
        this.start();
    }

    private void initSSLListener() throws IOException {
        Object object;
        Object object2;
        if (ClusterImpl.DEBUG) {
            logger.log(8, "ClusterImpl.initSSLListener[nodelay=" + this.nodelay + ", inbufsz=" + this.callback.getSSLInputBufferSize() + ", outbufsz=" + this.callback.getSSLOutputBufferSize() + "]");
        }
        ServerSocketFactory serverSocketFactory = null;
        try {
            object2 = Globals.getCurrentLicense(null);
            if (!((LicenseBase)object2).getBooleanProperty("imq.enable_ssl", false)) {
                logger.log(32, "B3123", br.getString("B0073"));
                throw new BrokerException(br.getKString("B3123", br.getString("B0073")));
            }
            Class<?> clazz = Class.forName("com.sun.messaging.jmq.jmsserver.net.tls.TLSProtocol");
            if (ClusterImpl.DEBUG) {
                logger.log(4, "ClusterImpl.initSSLListener. Initializing SSLServerSocketFactory");
            }
            object = clazz.getMethod("getServerSocketFactory", null);
            serverSocketFactory = (ServerSocketFactory)((Method)object).invoke(null, null);
        }
        catch (Exception exception) {
            Throwable throwable = exception;
            if (exception instanceof InvocationTargetException) {
                throwable = exception.getCause();
                if (throwable == null) {
                    throwable = exception;
                }
                if (ClusterImpl.DEBUG && throwable != exception) {
                    logger.logStack(32, exception.getMessage(), exception);
                }
            }
            logger.logStack(32, throwable.getMessage(), throwable);
            throw new IOException(throwable.getMessage());
        }
        object2 = this.callback.getListenHost();
        int n = this.callback.getListenPort();
        object = null;
        if (ClusterImpl.DEBUG) {
            logger.log(4, "ClusterImpl.initSSLListener. Initializing ServerSocket");
        }
        if (object2 == null) {
            this.ss = serverSocketFactory.createServerSocket(n);
        } else {
            this.ss = serverSocketFactory.createServerSocket(n, 50, (InetAddress)object2);
            object = new HashMap();
            ((HashMap)object).put("hostname", ((InetAddress)object2).getHostName());
            ((HashMap)object).put("hostaddr", ((InetAddress)object2).getHostAddress());
        }
        Globals.getPortMapper().addService("cluster", "ssl", "CLUSTER", this.ss.getLocalPort(), (HashMap)object);
        ClusterDiscoveryService clusterDiscoveryService = Globals.getClusterDiscoveryService();
        if (clusterDiscoveryService != null) {
            clusterDiscoveryService.addService("cluster", "ssl", "CLUSTER", this.ss.getLocalPort(), object2 == null ? null : ((InetAddress)object2).getHostName());
        }
        if (ClusterImpl.DEBUG && this.ss != null) {
            logger.log(4, "ClusterImpl.initSSLListener: " + this.ss + " " + MQServerSocketFactory.serverSocketToString(this.ss));
        }
    }

    private void initTCPListener() throws IOException {
        if (ClusterImpl.DEBUG) {
            logger.log(8, "ClusterImpl.initTCPListener[TcpNoDelay=" + this.nodelay + ", inbufsz=" + this.callback.getTCPInputBufferSize() + ", outbufsz=" + this.callback.getTCPOutputBufferSize() + "]");
        }
        InetAddress inetAddress = this.callback.getListenHost();
        int n = this.callback.getListenPort();
        HashMap<String, String> hashMap = null;
        if (inetAddress == null) {
            this.ss = ssf.createServerSocket(n);
        } else {
            this.ss = ssf.createServerSocket(n, 50, inetAddress);
            hashMap = new HashMap<String, String>();
            hashMap.put("hostname", inetAddress.getHostName());
            hashMap.put("hostaddr", inetAddress.getHostAddress());
        }
        Globals.getPortMapper().addService("cluster", "tcp", "CLUSTER", this.ss.getLocalPort(), hashMap);
        ClusterDiscoveryService clusterDiscoveryService = Globals.getClusterDiscoveryService();
        if (clusterDiscoveryService != null) {
            clusterDiscoveryService.addService("cluster", "tcp", "CLUSTER", this.ss.getLocalPort(), inetAddress == null ? null : inetAddress.getHostName());
        }
        if (ClusterImpl.DEBUG && this.ss != null) {
            logger.log(4, "ClusterImpl.initTCPListener: " + this.ss + " " + MQServerSocketFactory.serverSocketToString(this.ss));
        }
    }

    public String getServerSocketString() {
        ServerSocket serverSocket = this.ss;
        if (serverSocket != null) {
            return serverSocket.getInetAddress() + ":" + serverSocket.getLocalPort();
        }
        return null;
    }

    public synchronized void shutdown() {
        this.done = true;
        try {
            this.ss.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (true) {
            Object object = this;
            synchronized (object) {
                if (this.done) {
                    break;
                }
            }
            try {
                object = this.ss.accept();
                try {
                    ((Socket)object).setTcpNoDelay(this.nodelay);
                }
                catch (SocketException socketException) {
                    logger.log(16, this.getClass().getSimpleName() + ".run(): [" + ((Socket)object).toString() + "]setTcpNoDelay(" + this.nodelay + "): " + socketException.toString(), socketException);
                }
                this.callback.acceptConnection((Socket)object, this.isSSL);
            }
            catch (Exception exception) {}
        }
    }
}

