/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.encoding;

import com.sun.corba.ee.impl.corba.TypeCodeImpl;
import com.sun.corba.ee.impl.encoding.BufferManagerRead;
import com.sun.corba.ee.impl.encoding.ByteBufferWithInfo;
import com.sun.corba.ee.impl.encoding.CDRInputStreamBase;
import com.sun.corba.ee.impl.encoding.CDRInputStream_1_0;
import com.sun.corba.ee.impl.logging.ORBUtilSystemException;
import com.sun.corba.ee.impl.orbutil.ORBUtility;
import com.sun.corba.ee.impl.util.JDKBridge;
import com.sun.corba.ee.impl.util.RepositoryId;
import com.sun.corba.ee.spi.ior.IOR;
import com.sun.corba.ee.spi.ior.IORFactories;
import com.sun.corba.ee.spi.ior.iiop.GIOPVersion;
import com.sun.corba.ee.spi.orb.ORB;
import com.sun.corba.ee.spi.presentation.rmi.PresentationDefaults;
import com.sun.corba.ee.spi.presentation.rmi.PresentationManager;
import com.sun.corba.ee.spi.presentation.rmi.StubAdapter;
import com.sun.org.omg.SendingContext.CodeBase;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.io.Serializable;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.rmi.RemoteException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.LinkedList;
import java.util.List;
import org.omg.CORBA.Any;
import org.omg.CORBA.AnySeqHolder;
import org.omg.CORBA.BooleanSeqHolder;
import org.omg.CORBA.CharSeqHolder;
import org.omg.CORBA.DoubleSeqHolder;
import org.omg.CORBA.FloatSeqHolder;
import org.omg.CORBA.LongLongSeqHolder;
import org.omg.CORBA.LongSeqHolder;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.Object;
import org.omg.CORBA.OctetSeqHolder;
import org.omg.CORBA.Principal;
import org.omg.CORBA.ShortSeqHolder;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.ULongLongSeqHolder;
import org.omg.CORBA.ULongSeqHolder;
import org.omg.CORBA.UShortSeqHolder;
import org.omg.CORBA.WCharSeqHolder;
import org.omg.CORBA.portable.BoxedValueHelper;
import org.omg.CORBA.portable.IDLEntity;

public class IDLJavaSerializationInputStream
extends CDRInputStreamBase {
    private ORB orb;
    private IDLObjectInputStream is;
    private IDLByteArrayInputStream bis;
    private BufferManagerRead bufferManager;
    private ByteBuffer byteBuffer;
    private boolean directRead;
    private boolean markOn;
    private int peekIndex;
    private int peekCount;
    private LinkedList<java.lang.Object> markedItemQ = new LinkedList();
    private boolean debug;
    protected ORBUtilSystemException wrapper;
    private static final List<IDLByteArrayInputStream> inputStreamPool = new LinkedList<IDLByteArrayInputStream>();
    private static byte[] streamHeader = new byte[4];

    IDLJavaSerializationInputStream(boolean directRead) {
        this.directRead = directRead;
    }

    @Override
    public void init(org.omg.CORBA.ORB orb, ByteBuffer byteBuffer, int bufSize, boolean littleEndian, BufferManagerRead bmgr) {
        this.orb = (ORB)orb;
        this.bufferManager = bmgr;
        byteBuffer.position(0).limit(bufSize);
        this.byteBuffer = byteBuffer;
        this.bis = IDLJavaSerializationInputStream.getOrCreateByteArrayInputStream(ORBUtility.getByteBufferArray(byteBuffer), this.orb);
        this.wrapper = this.orb.getLogWrapperTable().get_RPC_ENCODING_ORBUtil();
        if (!this.directRead) {
            this.initObjectInputStream();
        }
        this.debug = ((ORB)orb).transportDebugFlag;
        if (this.debug) {
            ORBUtility.dprint(this, "IDLJavaSerializationInputStream init");
        }
    }

    private static IDLByteArrayInputStream getOrCreateByteArrayInputStream(byte[] b, ORB orb) {
        IDLByteArrayInputStream bis = null;
        bis = IDLJavaSerializationInputStream.getInputStreamObjectFromPool();
        if (bis == null) {
            return new IDLByteArrayInputStream(b);
        }
        bis.init(b);
        return bis;
    }

    private void initObjectInputStream() {
        if (this.is != null) {
            throw this.wrapper.javaStreamInitFailed();
        }
        try {
            this.is = this.bis.getParent();
            if (this.is != null) {
                this.is.setOrb(this.orb);
                return;
            }
            this.bis.save();
            this.bis.init(streamHeader);
            this.is = new IDLObjectInputStream(this.bis, this.orb);
            this.bis.restore();
            this.bis.setParent(this.is);
        }
        catch (Exception e) {
            throw this.wrapper.javaStreamInitFailed(e);
        }
    }

    private java.lang.Object readFromMarkedItemQ() {
        if (!this.markOn && !this.markedItemQ.isEmpty()) {
            return this.markedItemQ.removeFirst();
        }
        if (this.markOn && !this.markedItemQ.isEmpty() && this.peekIndex < this.peekCount) {
            return this.markedItemQ.get(this.peekIndex++);
        }
        return null;
    }

    @Override
    public boolean read_boolean() {
        java.lang.Object obj = this.readFromMarkedItemQ();
        if (obj != null) {
            return (Boolean)obj;
        }
        try {
            boolean value = this.is.readBoolean();
            if (this.markOn) {
                this.markedItemQ.addLast(value);
            }
            return value;
        }
        catch (Exception e) {
            throw this.wrapper.javaSerializationException(e, (java.lang.Object)"read_boolean");
        }
    }

    @Override
    public char read_char() {
        java.lang.Object obj = this.readFromMarkedItemQ();
        if (obj != null) {
            return ((Character)obj).charValue();
        }
        try {
            char value = this.is.readChar();
            if (this.markOn) {
                this.markedItemQ.addLast(Character.valueOf(value));
            }
            return value;
        }
        catch (Exception e) {
            throw this.wrapper.javaSerializationException(e, (java.lang.Object)"read_char");
        }
    }

    @Override
    public char read_wchar() {
        return this.read_char();
    }

    @Override
    public byte read_octet() {
        java.lang.Object obj = this.readFromMarkedItemQ();
        if (obj != null) {
            return (Byte)obj;
        }
        try {
            byte value;
            if (this.directRead && this.bis.position() < 16) {
                byte b = (byte)this.bis.read();
                if (this.bis.position() == 16) {
                    this.initObjectInputStream();
                }
                value = b;
            } else {
                value = this.is.readByte();
            }
            if (this.markOn) {
                this.markedItemQ.addLast(value);
            }
            return value;
        }
        catch (Exception e) {
            throw this.wrapper.javaSerializationException(e, (java.lang.Object)"read_octet");
        }
    }

    @Override
    public short read_short() {
        java.lang.Object obj = this.readFromMarkedItemQ();
        if (obj != null) {
            return (Short)obj;
        }
        try {
            short value = this.is.readShort();
            if (this.markOn) {
                this.markedItemQ.addLast(value);
            }
            return value;
        }
        catch (Exception e) {
            throw this.wrapper.javaSerializationException(e, (java.lang.Object)"read_short");
        }
    }

    @Override
    public short read_ushort() {
        return this.read_short();
    }

    @Override
    public int read_long() {
        java.lang.Object obj = this.readFromMarkedItemQ();
        if (obj != null) {
            return (Integer)obj;
        }
        try {
            int value;
            if (this.directRead && this.bis.position() < 16) {
                int b1 = this.bis.read() << 24 & 0xFF000000;
                int b2 = this.bis.read() << 16 & 0xFF0000;
                int b3 = this.bis.read() << 8 & 0xFF00;
                int b4 = this.bis.read() << 0 & 0xFF;
                if (this.bis.position() == 16) {
                    this.initObjectInputStream();
                } else if (this.bis.position() > 16) {
                    this.wrapper.javaSerializationException("read_long");
                }
                value = b1 | b2 | b3 | b4;
            } else {
                value = this.is.readInt();
            }
            if (this.markOn) {
                this.markedItemQ.addLast(value);
            }
            return value;
        }
        catch (Exception e) {
            throw this.wrapper.javaSerializationException(e, (java.lang.Object)"read_long");
        }
    }

    @Override
    public int read_ulong() {
        return this.read_long();
    }

    @Override
    public long read_longlong() {
        java.lang.Object obj = this.readFromMarkedItemQ();
        if (obj != null) {
            return (Long)obj;
        }
        try {
            long value = this.is.readLong();
            if (this.markOn) {
                this.markedItemQ.addLast(value);
            }
            return value;
        }
        catch (Exception e) {
            throw this.wrapper.javaSerializationException(e, (java.lang.Object)"read_longlong");
        }
    }

    @Override
    public long read_ulonglong() {
        return this.read_longlong();
    }

    @Override
    public float read_float() {
        java.lang.Object obj = this.readFromMarkedItemQ();
        if (obj != null) {
            return ((Float)obj).floatValue();
        }
        try {
            float value = this.is.readFloat();
            if (this.markOn) {
                this.markedItemQ.addLast(Float.valueOf(value));
            }
            return value;
        }
        catch (Exception e) {
            throw this.wrapper.javaSerializationException(e, (java.lang.Object)"read_float");
        }
    }

    @Override
    public double read_double() {
        java.lang.Object obj = this.readFromMarkedItemQ();
        if (obj != null) {
            return (Double)obj;
        }
        try {
            double value = this.is.readDouble();
            if (this.markOn) {
                this.markedItemQ.addLast(value);
            }
            return value;
        }
        catch (Exception e) {
            throw this.wrapper.javaSerializationException(e, (java.lang.Object)"read_double");
        }
    }

    @Override
    public String read_string() {
        java.lang.Object obj = this.readFromMarkedItemQ();
        if (obj != null) {
            return (String)obj;
        }
        try {
            String value = this.is.readUTF();
            if (this.markOn) {
                this.markedItemQ.addLast(value);
            }
            return value;
        }
        catch (Exception e) {
            throw this.wrapper.javaSerializationException(e, (java.lang.Object)"read_string");
        }
    }

    @Override
    public String read_wstring() {
        java.lang.Object obj = this.readFromMarkedItemQ();
        if (obj != null) {
            return (String)obj;
        }
        try {
            String value = (String)this.is.readObject();
            if (this.markOn) {
                this.markedItemQ.addLast(value);
            }
            return value;
        }
        catch (Exception e) {
            throw this.wrapper.javaSerializationException(e, (java.lang.Object)"read_wstring");
        }
    }

    @Override
    public void read_boolean_array(boolean[] value, int offset, int length) {
        for (int i = 0; i < length; ++i) {
            value[i + offset] = this.read_boolean();
        }
    }

    @Override
    public void read_char_array(char[] value, int offset, int length) {
        for (int i = 0; i < length; ++i) {
            value[i + offset] = this.read_char();
        }
    }

    @Override
    public void read_wchar_array(char[] value, int offset, int length) {
        this.read_char_array(value, offset, length);
    }

    @Override
    public void read_octet_array(byte[] value, int offset, int length) {
        java.lang.Object obj = this.readFromMarkedItemQ();
        if (obj != null) {
            byte[] b = (byte[])obj;
            if (length != b.length) {
                throw this.wrapper.javaSerializationException("read_octet_array");
            }
            System.arraycopy(b, 0, value, offset, length);
            return;
        }
        try {
            int off = offset;
            int len = length;
            if (this.debug) {
                ORBUtility.dprint(this, "off: " + off + ", len: " + len);
            }
            while (len > 0) {
                int n = this.is.read(value, off, len);
                off += n;
                len -= n;
                if (!this.debug) continue;
                ORBUtility.dprint(this, "off: " + off + ", len: " + len);
            }
            if (this.markOn) {
                byte[] b = new byte[length];
                System.arraycopy(value, offset, b, 0, length);
                this.markedItemQ.addLast(b);
            }
        }
        catch (Exception e) {
            throw this.wrapper.javaSerializationException(e, (java.lang.Object)"read_octet_array");
        }
    }

    @Override
    public void read_short_array(short[] value, int offset, int length) {
        for (int i = 0; i < length; ++i) {
            value[i + offset] = this.read_short();
        }
    }

    @Override
    public void read_ushort_array(short[] value, int offset, int length) {
        this.read_short_array(value, offset, length);
    }

    @Override
    public void read_long_array(int[] value, int offset, int length) {
        for (int i = 0; i < length; ++i) {
            value[i + offset] = this.read_long();
        }
    }

    @Override
    public void read_ulong_array(int[] value, int offset, int length) {
        this.read_long_array(value, offset, length);
    }

    @Override
    public void read_longlong_array(long[] value, int offset, int length) {
        for (int i = 0; i < length; ++i) {
            value[i + offset] = this.read_longlong();
        }
    }

    @Override
    public void read_ulonglong_array(long[] value, int offset, int length) {
        this.read_longlong_array(value, offset, length);
    }

    @Override
    public void read_float_array(float[] value, int offset, int length) {
        for (int i = 0; i < length; ++i) {
            value[i + offset] = this.read_float();
        }
    }

    @Override
    public void read_double_array(double[] value, int offset, int length) {
        for (int i = 0; i < length; ++i) {
            value[i + offset] = this.read_double();
        }
    }

    @Override
    public Object read_Object() {
        return this.read_Object(null);
    }

    @Override
    public TypeCode read_TypeCode() {
        TypeCodeImpl tc = new TypeCodeImpl(this.orb);
        tc.read_value(this.parent);
        return tc;
    }

    @Override
    public Any read_any() {
        Any any = this.orb.create_any();
        TypeCodeImpl tc = new TypeCodeImpl(this.orb);
        try {
            tc.read_value(this.parent);
        }
        catch (MARSHAL ex) {
            if (tc.kind().value() != 29) {
                throw ex;
            }
            ex.printStackTrace();
        }
        any.read_value((org.omg.CORBA.portable.InputStream)this.parent, (TypeCode)tc);
        return any;
    }

    @Override
    public Principal read_Principal() {
        throw this.wrapper.giopVersionError();
    }

    @Override
    public BigDecimal read_fixed() {
        return (BigDecimal)this.read_value();
    }

    @Override
    public Object read_Object(Class clz) {
        IOR ior = IORFactories.makeIOR(this.orb, this.parent);
        if (ior.isNil()) {
            return null;
        }
        PresentationManager.StubFactoryFactory sff = ORB.getStubFactoryFactory();
        String codeBase = ior.getProfile().getCodebase();
        PresentationManager.StubFactory stubFactory = null;
        if (clz == null) {
            RepositoryId rid = RepositoryId.cache.getId(ior.getTypeId());
            String className = rid.getClassName();
            boolean isIDLInterface = rid.isIDLType();
            if (className == null || className.equals("")) {
                stubFactory = null;
            } else {
                try {
                    stubFactory = sff.createStubFactory(className, isIDLInterface, codeBase, null, null);
                }
                catch (Exception exc) {
                    stubFactory = null;
                }
            }
        } else if (StubAdapter.isStubClass(clz)) {
            stubFactory = PresentationDefaults.makeStaticStubFactory(clz);
        } else {
            boolean isIDL = IDLEntity.class.isAssignableFrom(clz);
            stubFactory = sff.createStubFactory(clz.getName(), isIDL, codeBase, clz, clz.getClassLoader());
        }
        return CDRInputStream_1_0.internalIORToObject(ior, stubFactory, this.orb);
    }

    @Override
    public org.omg.CORBA.ORB orb() {
        return this.orb;
    }

    @Override
    public Serializable read_value() {
        java.lang.Object obj = this.readFromMarkedItemQ();
        if (obj != null) {
            return (Serializable)obj;
        }
        try {
            Serializable value = (Serializable)this.is.readObject();
            if (this.markOn) {
                this.markedItemQ.addLast(value);
            }
            return value;
        }
        catch (Exception e) {
            throw this.wrapper.javaSerializationException(e, (java.lang.Object)"read_value");
        }
    }

    @Override
    public Serializable read_value(Class clz) {
        return this.read_value();
    }

    @Override
    public Serializable read_value(BoxedValueHelper factory) {
        return this.read_value();
    }

    @Override
    public Serializable read_value(String rep_id) {
        return this.read_value();
    }

    @Override
    public Serializable read_value(Serializable value) {
        return this.read_value();
    }

    @Override
    public java.lang.Object read_abstract_interface() {
        return this.read_abstract_interface(null);
    }

    @Override
    public java.lang.Object read_abstract_interface(Class clz) {
        boolean isObject = this.read_boolean();
        if (isObject) {
            return this.read_Object(clz);
        }
        return this.read_value();
    }

    @Override
    public void consumeEndian() {
        this.read_boolean();
    }

    @Override
    public int getPosition() {
        return this.bis.position();
    }

    @Override
    public java.lang.Object read_Abstract() {
        return this.read_abstract_interface();
    }

    @Override
    public Serializable read_Value() {
        return this.read_value();
    }

    @Override
    public void read_any_array(AnySeqHolder seq, int offset, int length) {
        this.read_any_array(seq.value, offset, length);
    }

    private final void read_any_array(Any[] value, int offset, int length) {
        for (int i = 0; i < length; ++i) {
            value[i + offset] = this.read_any();
        }
    }

    @Override
    public void read_boolean_array(BooleanSeqHolder seq, int offset, int length) {
        this.read_boolean_array(seq.value, offset, length);
    }

    @Override
    public void read_char_array(CharSeqHolder seq, int offset, int length) {
        this.read_char_array(seq.value, offset, length);
    }

    @Override
    public void read_wchar_array(WCharSeqHolder seq, int offset, int length) {
        this.read_wchar_array(seq.value, offset, length);
    }

    @Override
    public void read_octet_array(OctetSeqHolder seq, int offset, int length) {
        this.read_octet_array(seq.value, offset, length);
    }

    @Override
    public void read_short_array(ShortSeqHolder seq, int offset, int length) {
        this.read_short_array(seq.value, offset, length);
    }

    @Override
    public void read_ushort_array(UShortSeqHolder seq, int offset, int length) {
        this.read_ushort_array(seq.value, offset, length);
    }

    @Override
    public void read_long_array(LongSeqHolder seq, int offset, int length) {
        this.read_long_array(seq.value, offset, length);
    }

    @Override
    public void read_ulong_array(ULongSeqHolder seq, int offset, int length) {
        this.read_ulong_array(seq.value, offset, length);
    }

    @Override
    public void read_ulonglong_array(ULongLongSeqHolder seq, int offset, int length) {
        this.read_ulonglong_array(seq.value, offset, length);
    }

    @Override
    public void read_longlong_array(LongLongSeqHolder seq, int offset, int length) {
        this.read_longlong_array(seq.value, offset, length);
    }

    @Override
    public void read_float_array(FloatSeqHolder seq, int offset, int length) {
        this.read_float_array(seq.value, offset, length);
    }

    @Override
    public void read_double_array(DoubleSeqHolder seq, int offset, int length) {
        this.read_double_array(seq.value, offset, length);
    }

    @Override
    public String[] _truncatable_ids() {
        throw this.wrapper.giopVersionError();
    }

    @Override
    public void mark(int readLimit) {
        if (this.markOn) {
            throw this.wrapper.javaSerializationException("mark");
        }
        this.markOn = true;
        if (!this.markedItemQ.isEmpty()) {
            this.peekIndex = 0;
            this.peekCount = this.markedItemQ.size();
        }
    }

    @Override
    public void reset() {
        this.markOn = false;
        this.peekIndex = 0;
        this.peekCount = 0;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public CDRInputStreamBase dup() {
        if (this.markOn) {
            throw this.wrapper.javaSerializationException("dup() must not called when mark is on");
        }
        IDLJavaSerializationInputStream result = new IDLJavaSerializationInputStream(this.directRead);
        result.init((org.omg.CORBA.ORB)this.orb, this.byteBuffer, this.byteBuffer.limit(), false, null);
        result.setDupData(this.bis.position());
        return result;
    }

    void setDupData(int pos) {
        this.bis.position(pos);
    }

    @Override
    public BigDecimal read_fixed(short digits, short scale) {
        StringBuffer buffer = this.read_fixed_buffer();
        if (digits != buffer.length()) {
            throw this.wrapper.badFixed(digits, buffer.length());
        }
        buffer.insert(digits - scale, '.');
        return new BigDecimal(buffer.toString());
    }

    private StringBuffer read_fixed_buffer() {
        StringBuffer buffer = new StringBuffer(64);
        boolean wroteFirstDigit = false;
        boolean more = true;
        while (more) {
            byte doubleDigit = this.read_octet();
            int firstDigit = (doubleDigit & 0xF0) >> 4;
            int secondDigit = doubleDigit & 0xF;
            if (wroteFirstDigit || firstDigit != 0) {
                buffer.append(Character.forDigit(firstDigit, 10));
                wroteFirstDigit = true;
            }
            if (secondDigit == 12) {
                if (!wroteFirstDigit) {
                    return new StringBuffer("0.0");
                }
                more = false;
                continue;
            }
            if (secondDigit == 13) {
                buffer.insert(0, '-');
                more = false;
                continue;
            }
            buffer.append(Character.forDigit(secondDigit, 10));
            wroteFirstDigit = true;
        }
        return buffer;
    }

    @Override
    public boolean isLittleEndian() {
        throw this.wrapper.giopVersionError();
    }

    @Override
    void setHeaderPadding(boolean headerPadding) {
    }

    @Override
    public ByteBuffer getByteBuffer() {
        throw this.wrapper.giopVersionError();
    }

    @Override
    public void setByteBuffer(ByteBuffer byteBuffer) {
        throw this.wrapper.giopVersionError();
    }

    @Override
    public void setByteBufferWithInfo(ByteBufferWithInfo bbwi) {
        throw this.wrapper.giopVersionError();
    }

    @Override
    public int getBufferLength() {
        throw this.wrapper.giopVersionError();
    }

    @Override
    public void setBufferLength(int value) {
    }

    @Override
    public int getIndex() {
        return this.bis.position();
    }

    @Override
    public void setIndex(int value) {
        this.bis.position(value);
    }

    @Override
    public void orb(org.omg.CORBA.ORB orb) {
        orb = (ORB)orb;
    }

    @Override
    public BufferManagerRead getBufferManager() {
        return this.bufferManager;
    }

    @Override
    public GIOPVersion getGIOPVersion() {
        return GIOPVersion.V1_2;
    }

    @Override
    CodeBase getCodeBase() {
        return this.parent.getCodeBase();
    }

    @Override
    void alignOnBoundary(int octetBoundary) {
        throw this.wrapper.giopVersionError();
    }

    @Override
    void performORBVersionSpecificInit() {
    }

    @Override
    public void resetCodeSetConverters() {
    }

    @Override
    public void start_value() {
        throw this.wrapper.giopVersionError();
    }

    @Override
    public void end_value() {
        throw this.wrapper.giopVersionError();
    }

    @Override
    public int read() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int read(byte[] b) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public long skip(long n) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int available() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() throws IOException {
        if (this.bis == null) {
            return;
        }
        this.orb.getByteBufferPool().releaseByteBuffer(this.byteBuffer);
        this.is.skip(this.is.available());
        this.bis.clear();
        IDLJavaSerializationInputStream.putInputStreamObjectToPool(this.bis);
        this.bis = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void putInputStreamObjectToPool(IDLByteArrayInputStream value) {
        List<IDLByteArrayInputStream> list = inputStreamPool;
        synchronized (list) {
            inputStreamPool.add(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static IDLByteArrayInputStream getInputStreamObjectFromPool() {
        List<IDLByteArrayInputStream> list = inputStreamPool;
        synchronized (list) {
            if (inputStreamPool.size() != 0) {
                return inputStreamPool.remove(0);
            }
        }
        return null;
    }

    static {
        IDLJavaSerializationInputStream.streamHeader[1] = -19;
        IDLJavaSerializationInputStream.streamHeader[0] = -84;
        IDLJavaSerializationInputStream.streamHeader[3] = 5;
        IDLJavaSerializationInputStream.streamHeader[2] = 0;
    }

    static final class IDLByteArrayInputStream
    extends InputStream {
        private int pos;
        private byte[] buffer;
        private IDLObjectInputStream parent;
        private byte[] savedBuffer;
        private int savedPos;

        public IDLByteArrayInputStream(byte[] b) {
            this.buffer = b;
            this.pos = 0;
        }

        void init(byte[] b) {
            this.buffer = b;
            this.pos = 0;
        }

        void save() {
            this.savedBuffer = this.buffer;
            this.savedPos = this.pos;
        }

        void restore() {
            this.buffer = this.savedBuffer;
            this.pos = this.savedPos;
        }

        void clear() {
            this.buffer = null;
            this.pos = 0;
            this.savedBuffer = null;
            this.savedPos = 0;
        }

        int position() {
            return this.pos;
        }

        void position(int pos) {
            this.pos = pos;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            System.arraycopy(this.buffer, this.pos, b, off, len);
            this.pos += len;
            return len;
        }

        @Override
        public int read() throws IOException {
            return this.buffer[this.pos++] & 0xFF;
        }

        @Override
        public long skip(long n) throws IOException {
            return 0L;
        }

        void setParent(IDLObjectInputStream parent) {
            this.parent = parent;
        }

        IDLObjectInputStream getParent() {
            return this.parent;
        }
    }

    static final class IDLObjectInputStream
    extends ObjectInputStream {
        ORB orb;

        IDLObjectInputStream(InputStream out, ORB orb) throws IOException {
            super(out);
            this.orb = orb;
            AccessController.doPrivileged(new PrivilegedAction<java.lang.Object>(){

                @Override
                public java.lang.Object run() {
                    IDLObjectInputStream.this.enableResolveObject(true);
                    return null;
                }
            });
        }

        @Override
        protected final java.lang.Object resolveObject(java.lang.Object obj) throws IOException {
            try {
                if (StubAdapter.isStub(obj)) {
                    StubAdapter.connect(obj, (org.omg.CORBA.ORB)this.orb);
                }
            }
            catch (RemoteException re) {
                IOException ie = new IOException("resolveObject failed");
                ie.initCause(re);
                throw ie;
            }
            return obj;
        }

        protected Class resolveClass(ObjectStreamClass classDesc) throws IOException, ClassNotFoundException {
            String className = classDesc.getName();
            ClassLoader cLoader = Thread.currentThread().getContextClassLoader();
            return JDKBridge.loadClass(className, null, cLoader);
        }

        void setOrb(ORB orb) {
            this.orb = orb;
        }
    }
}

