/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.config;

import com.sun.grizzly.DefaultProtocolChain;
import com.sun.grizzly.DefaultProtocolChainInstanceHandler;
import com.sun.grizzly.ProtocolChain;
import com.sun.grizzly.arp.AsyncFilter;
import com.sun.grizzly.arp.DefaultAsyncHandler;
import com.sun.grizzly.config.ConfigAwareElement;
import com.sun.grizzly.config.ConfigProtocolFinderWrapper;
import com.sun.grizzly.config.ContainerStaticStreamAlgorithm;
import com.sun.grizzly.config.GrizzlyConfig;
import com.sun.grizzly.config.GrizzlyConfigException;
import com.sun.grizzly.config.GrizzlyServiceListener;
import com.sun.grizzly.config.Utils;
import com.sun.grizzly.config.WebProtocolHandler;
import com.sun.grizzly.config.dom.FileCache;
import com.sun.grizzly.config.dom.Http;
import com.sun.grizzly.config.dom.NetworkListener;
import com.sun.grizzly.config.dom.PortUnification;
import com.sun.grizzly.config.dom.Protocol;
import com.sun.grizzly.config.dom.ProtocolChainInstanceHandler;
import com.sun.grizzly.config.dom.ProtocolFilter;
import com.sun.grizzly.config.dom.ProtocolFinder;
import com.sun.grizzly.config.dom.ThreadPool;
import com.sun.grizzly.config.dom.Transport;
import com.sun.grizzly.filter.ReadFilter;
import com.sun.grizzly.http.HttpProtocolChain;
import com.sun.grizzly.http.SelectorThread;
import com.sun.grizzly.http.StatsThreadPool;
import com.sun.grizzly.portunif.CustomFilterChainProtocolHandler;
import com.sun.grizzly.portunif.PUPreProcessor;
import com.sun.grizzly.portunif.PUReadFilter;
import com.sun.grizzly.portunif.ProtocolHandler;
import com.sun.grizzly.tcp.Adapter;
import com.sun.grizzly.util.ExtendedThreadPool;
import com.sun.grizzly.util.WorkerThread;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.config.ConfigBeanProxy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GrizzlyEmbeddedHttp
extends SelectorThread {
    private final AtomicBoolean algorithmInitialized = new AtomicBoolean(false);
    private boolean isHttpSecured = false;
    public static String DEFAULT_ALGORITHM_CLASS_NAME = DEFAULT_ALGORITHM;
    protected static final ResourceBundle _rb = logger.getResourceBundle();
    private String defaultVirtualServer;
    private final GrizzlyServiceListener service;
    private int threadPoolTimeoutSeconds = 0;
    protected PUReadFilter puFilter;
    protected final List<com.sun.grizzly.portunif.ProtocolFinder> finders = new ArrayList<com.sun.grizzly.portunif.ProtocolFinder>();
    protected final List<ProtocolHandler> handlers = new ArrayList<ProtocolHandler>();
    protected final List<PUPreProcessor> preprocessors = new ArrayList<PUPreProcessor>();

    public GrizzlyEmbeddedHttp(GrizzlyServiceListener grizzlyServiceListener) {
        this.service = grizzlyServiceListener;
        this.setClassLoader(this.getClass().getClassLoader());
    }

    @Override
    protected void initAlgorithm() {
        if (!this.algorithmInitialized.getAndSet(true)) {
            this.algorithmClass = ContainerStaticStreamAlgorithm.class;
            defaultAlgorithmInstalled = true;
        }
    }

    @Override
    protected void initController() {
        super.initController();
        this.controller.setReadThreadsCount(this.readThreadsCount);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                GrizzlyEmbeddedHttp.this.stopEndpoint();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopEndpoint() {
        try {
            super.stopEndpoint();
        }
        catch (Throwable t) {
            logger.log(Level.SEVERE, "Unable to stop properly", t);
        }
        finally {
            try {
                if (this.selectorHandler != null && this.selectorHandler.getSelector() != null) {
                    this.selectorHandler.getSelector().close();
                }
            }
            catch (IOException ex) {}
        }
    }

    @Override
    protected void configureProtocolChain() {
        DefaultProtocolChainInstanceHandler instanceHandler = new DefaultProtocolChainInstanceHandler(){
            private final ConcurrentLinkedQueue<ProtocolChain> chains = new ConcurrentLinkedQueue();

            public ProtocolChain poll() {
                ProtocolChain protocolChain = this.chains.poll();
                if (protocolChain == null) {
                    protocolChain = new HttpProtocolChain();
                    ((HttpProtocolChain)protocolChain).enableRCM(GrizzlyEmbeddedHttp.this.rcmSupport);
                    GrizzlyEmbeddedHttp.this.configureFilters(protocolChain);
                }
                return protocolChain;
            }

            public boolean offer(ProtocolChain instance) {
                return this.chains.offer(instance);
            }
        };
        this.controller.setProtocolChainInstanceHandler(instanceHandler);
    }

    protected com.sun.grizzly.ProtocolFilter createReadFilter() {
        ReadFilter readFilter = new ReadFilter();
        readFilter.setContinuousExecution(Boolean.valueOf(System.getProperty("v3.grizzly.readFilter.continuousExecution", "false")));
        return readFilter;
    }

    public boolean isHttpSecured() {
        return this.isHttpSecured;
    }

    public void setHttpSecured(boolean httpSecured) {
        this.isHttpSecured = httpSecured;
    }

    public void configure(NetworkListener networkListener, Habitat habitat) {
        Transport transport = networkListener.findTransport();
        ThreadPool pool = networkListener.findThreadPool();
        this.setPort(Integer.parseInt(networkListener.getPort()));
        try {
            this.setAddress(InetAddress.getByName(networkListener.getAddress()));
        }
        catch (UnknownHostException e) {
            logger.log(Level.WARNING, "Invalid address for {0}: {1}", new Object[]{networkListener.getName(), networkListener.getAddress()});
        }
        this.configureTransport(transport);
        Protocol protocol = networkListener.findProtocol();
        boolean mayEnableComet = !"admin-listener".equalsIgnoreCase(networkListener.getName());
        this.configureProtocol(networkListener, protocol, habitat, mayEnableComet);
        this.configureThreadPool(networkListener, pool, this.getThreadPoolTimeoutSeconds());
    }

    protected void configureTransport(Transport transport) {
        String acceptorThreads = transport.getAcceptorThreads();
        try {
            int readController = Integer.parseInt(acceptorThreads) - 1;
            if (readController > 0) {
                this.setSelectorReadThreadsCount(readController);
            }
        }
        catch (NumberFormatException nfe) {
            logger.log(Level.WARNING, "pewebcontainer.invalid_acceptor_threads", new Object[]{acceptorThreads, transport.getName()});
        }
        this.setBufferSize(Integer.parseInt(transport.getBufferSizeBytes()));
        this.setSsBackLog(Integer.parseInt(transport.getMaxConnectionsCount()));
        this.setDisplayConfiguration(GrizzlyConfig.toBoolean(transport.getDisplayConfiguration()));
        this.setSelectorTimeout(Integer.parseInt(transport.getSelectorPollTimeoutMillis()));
        if (transport.getTcpNoDelay() != null) {
            this.setTcpNoDelay(GrizzlyConfig.toBoolean(transport.getTcpNoDelay()));
        }
    }

    protected com.sun.grizzly.ProtocolChainInstanceHandler configureProtocol(NetworkListener networkListener, Protocol protocol, Habitat habitat, boolean mayEnableComet) {
        if (protocol.getHttp() != null) {
            Http http = protocol.getHttp();
            this.configureHttpListenerProperty(http);
            this.configureKeepAlive(http);
            this.configureHttpProtocol(http);
            this.configureFileCache(http.getFileCache());
            this.defaultVirtualServer = http.getDefaultVirtualServer();
            if (mayEnableComet && (GrizzlyConfig.toBoolean(http.getCometSupportEnabled()) || Boolean.getBoolean("v3.grizzly.cometSupport"))) {
                this.configureComet(habitat);
            }
            this.threadPoolTimeoutSeconds = Integer.parseInt(http.getTimeoutSeconds());
        } else if (protocol.getPortUnification() != null) {
            PortUnification pu = protocol.getPortUnification();
            String puFilterClassname = pu.getClassname();
            if (puFilterClassname != null) {
                try {
                    this.puFilter = (PUReadFilter)this.newInstance(puFilterClassname);
                    GrizzlyEmbeddedHttp.configureElement(this.puFilter, pu);
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, "Can not initialize port unification filter: " + puFilterClassname + " default filter will be used instead", e);
                }
            }
            List<ProtocolFinder> findersConfig = pu.getProtocolFinder();
            for (ProtocolFinder finderConfig : findersConfig) {
                String finderClassname = finderConfig.getClassname();
                try {
                    com.sun.grizzly.portunif.ProtocolFinder protocolFinder = (com.sun.grizzly.portunif.ProtocolFinder)this.newInstance(finderClassname);
                    GrizzlyEmbeddedHttp.configureElement(protocolFinder, finderConfig);
                    Protocol subProtocol = finderConfig.findProtocol();
                    com.sun.grizzly.ProtocolChainInstanceHandler protocolChain = this.configureProtocol(networkListener, subProtocol, habitat, mayEnableComet);
                    String protocolName = subProtocol.getName();
                    this.finders.add(new ConfigProtocolFinderWrapper(protocolName, protocolFinder));
                    final String[] protocols = new String[]{protocolName};
                    if (protocolChain != null) {
                        this.handlers.add((ProtocolHandler)new CustomFilterChainProtocolHandler(protocolChain){

                            public String[] getProtocols() {
                                return protocols;
                            }

                            public ByteBuffer getByteBuffer() {
                                WorkerThread workerThread = (WorkerThread)Thread.currentThread();
                                if (workerThread.getSSLEngine() != null) {
                                    return workerThread.getInputBB();
                                }
                                return null;
                            }
                        });
                        continue;
                    }
                    this.handlers.add((ProtocolHandler)new WebProtocolHandler(protocolName));
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, "Can not initialize sub protocol. Finder: " + finderClassname, e);
                }
            }
            this.configurePortUnification();
        } else {
            ProtocolChainInstanceHandler pcihConfig = protocol.getProtocolChainInstanceHandler();
            if (pcihConfig == null) {
                logger.log(Level.WARNING, "Empty protocol declaration");
                return null;
            }
            ProtocolChain protocolChain = null;
            com.sun.grizzly.config.dom.ProtocolChain protocolChainConfig = pcihConfig.getProtocolChain();
            String protocolChainClassname = protocolChainConfig.getClassname();
            if (protocolChainClassname != null) {
                try {
                    protocolChain = (ProtocolChain)this.newInstance(protocolChainClassname);
                    GrizzlyEmbeddedHttp.configureElement(protocolChain, protocolChainConfig);
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, "Can not initialize protocol chain: " + protocolChainClassname + ". Default one will be used", e);
                }
            }
            if (protocolChain == null) {
                protocolChain = new DefaultProtocolChain();
            }
            for (ProtocolFilter protocolFilterConfig : protocolChainConfig.getProtocolFilter()) {
                String filterClassname = protocolFilterConfig.getClassname();
                try {
                    com.sun.grizzly.ProtocolFilter filter = (com.sun.grizzly.ProtocolFilter)this.newInstance(filterClassname);
                    GrizzlyEmbeddedHttp.configureElement(filter, protocolFilterConfig);
                    protocolChain.addFilter(filter);
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, "Can not initialize protocol filter: " + filterClassname, e);
                    throw new IllegalStateException("Can not initialize protocol filter: " + filterClassname);
                }
            }
            final ProtocolChain finalProtocolChain = protocolChain;
            DefaultProtocolChainInstanceHandler pcih = new DefaultProtocolChainInstanceHandler(){

                public boolean offer(ProtocolChain protocolChain) {
                    return true;
                }

                public ProtocolChain poll() {
                    return finalProtocolChain;
                }
            };
            return pcih;
        }
        return null;
    }

    protected void configurePortUnification() {
        this.configurePortUnification(this.finders, this.handlers, this.preprocessors);
    }

    @Override
    public void configurePortUnification(List<com.sun.grizzly.portunif.ProtocolFinder> protocolFinders, List<ProtocolHandler> protocolHandlers, List<PUPreProcessor> preProcessors) {
        if (this.puFilter != null) {
            this.puFilter.configure(protocolFinders, protocolHandlers, preProcessors);
        } else {
            super.configurePortUnification(protocolFinders, protocolHandlers, preProcessors);
        }
    }

    private final void configureComet(Habitat habitat) {
        AsyncFilter cometFilter = (AsyncFilter)habitat.getComponent(AsyncFilter.class, "comet");
        if (cometFilter != null) {
            this.setEnableAsyncExecution(true);
            this.asyncHandler = new DefaultAsyncHandler();
            this.asyncHandler.addAsyncFilter(cometFilter);
            this.setAsyncHandler(this.asyncHandler);
        }
    }

    private void configureFileCache(FileCache cache) {
        if (cache == null) {
            return;
        }
        boolean enabled = GrizzlyConfig.toBoolean(cache.getEnabled());
        this.setFileCacheIsEnabled(enabled);
        this.setLargeFileCacheEnabled(enabled);
        this.setSecondsMaxAge(Integer.parseInt(cache.getMaxAgeSeconds()));
        this.setMaxCacheEntries(Integer.parseInt(cache.getMaxFilesCount()));
        this.setMaxLargeCacheSize(Integer.parseInt(cache.getMaxCacheSizeBytes()));
    }

    private void configureHttpListenerProperty(Http http) throws NumberFormatException {
        try {
            this.setAdapter((Adapter)Class.forName(http.getAdapter()).newInstance());
        }
        catch (Exception e) {
            throw new GrizzlyConfigException(e.getMessage(), e);
        }
        this.setMaxKeepAliveRequests(Integer.parseInt(http.getMaxConnections()));
        this.setProperty("authPassthroughEnabled", GrizzlyConfig.toBoolean(http.getAuthPassThroughEnabled()));
        this.setMaxPostSize(Integer.parseInt(http.getMaxPostSizeBytes()));
        this.setCompression(http.getCompression());
        this.setCompressableMimeTypes(http.getCompressableMimeType());
        this.setSendBufferSize(Integer.parseInt(http.getSendBufferSizeBytes()));
        if (http.getNoCompressionUserAgents() != null) {
            this.setNoCompressionUserAgents(http.getNoCompressionUserAgents());
        }
        this.setCompressionMinSize(Integer.parseInt(http.getCompressionMinSizeBytes()));
        if (http.getRestrictedUserAgents() != null) {
            this.setRestrictedUserAgents(http.getRestrictedUserAgents());
        }
        this.enableRcmSupport(GrizzlyConfig.toBoolean(http.getRcmSupportEnabled()));
        this.setUploadTimeout(Integer.parseInt(http.getConnectionUploadTimeoutMillis()));
        this.setDisableUploadTimeout(GrizzlyConfig.toBoolean(http.getUploadTimeoutEnabled()));
        this.setProperty("chunking-enabled", GrizzlyConfig.toBoolean(http.getChunkingEnabled()));
        this.setProperty("uriEncoding", http.getUriEncoding());
        if (http.getTraceEnabled() != null) {
            this.setProperty("traceEnabled", GrizzlyConfig.toBoolean(http.getTraceEnabled()));
        }
    }

    private void configureHttpProtocol(Http http) {
        if (http == null) {
            return;
        }
        this.setForcedRequestType(http.getForcedResponseType());
        this.setDefaultResponseType(http.getDefaultResponseType());
        this.setMaxHttpHeaderSize(Integer.parseInt(http.getHeaderBufferLengthBytes()));
    }

    private void configureKeepAlive(Http http) {
        int timeoutInSeconds = 60;
        int maxConnections = 256;
        if (http != null) {
            String msg;
            try {
                timeoutInSeconds = Integer.parseInt(http.getTimeoutSeconds());
            }
            catch (NumberFormatException ex) {
                msg = _rb.getString("pewebcontainer.invalidKeepAliveTimeout");
                msg = MessageFormat.format(msg, http.getTimeoutSeconds(), Integer.toString(timeoutInSeconds));
                logger.log(Level.WARNING, msg, ex);
            }
            try {
                maxConnections = Integer.parseInt(http.getMaxConnections());
            }
            catch (NumberFormatException ex) {
                msg = _rb.getString("pewebcontainer.invalidKeepAliveMaxConnections");
                msg = MessageFormat.format(msg, http.getMaxConnections(), Integer.toString(maxConnections));
                logger.log(Level.WARNING, msg, ex);
            }
        }
        this.setKeepAliveTimeoutInSeconds(timeoutInSeconds);
        this.setMaxKeepAliveRequests(maxConnections);
    }

    private void configureThreadPool(NetworkListener networkListener, ThreadPool threadPool, int keepAlive) {
        if (threadPool == null) {
            return;
        }
        try {
            int maxQueueSize = Integer.parseInt(threadPool.getMaxQueueSize());
            int minThreads = Integer.parseInt(threadPool.getMinThreadPoolSize());
            int maxThreads = Integer.parseInt(threadPool.getMaxThreadPoolSize());
            int timeout = Integer.parseInt(threadPool.getIdleThreadTimeoutSeconds());
            String name = Utils.composeThreadPoolName(networkListener);
            this.setThreadPool(this.newThreadPool(name, minThreads, maxThreads, maxQueueSize, keepAlive < 0 ? Long.MAX_VALUE : (long)(keepAlive * 1000), TimeUnit.MILLISECONDS));
            this.setCoreThreads(minThreads);
            this.setMaxThreads(maxThreads);
            List<String> l = ManagementFactory.getRuntimeMXBean().getInputArguments();
            boolean debugMode = false;
            for (String s : l) {
                if (!s.trim().startsWith("-Xrunjdwp:")) continue;
                debugMode = true;
                break;
            }
            if (!debugMode && timeout > 0) {
                this.setTransactionTimeout(timeout * 1000);
            } else {
                this.setTransactionTimeout(-1);
            }
        }
        catch (NumberFormatException ex) {
            logger.log(Level.WARNING, " Invalid thread-pool attribute", ex);
        }
    }

    protected ExtendedThreadPool newThreadPool(String name, int minThreads, int maxThreads, int maxQueueSize, long timeout, TimeUnit timeunit) {
        return new StatsThreadPool(name, minThreads, maxThreads, maxQueueSize, timeout, timeunit);
    }

    protected int getThreadPoolTimeoutSeconds() {
        return this.threadPoolTimeoutSeconds;
    }

    public String getDefaultVirtualServer() {
        return this.defaultVirtualServer;
    }

    protected Object newInstance(String classname) throws Exception {
        return this.loadClass(classname).newInstance();
    }

    protected Class loadClass(String classname) throws ClassNotFoundException {
        Class<?> clazz = null;
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl != null) {
            try {
                clazz = cl.loadClass(classname);
            }
            catch (Exception cnfe) {
                // empty catch block
            }
        }
        if (clazz == null) {
            clazz = this.getClassLoader().loadClass(classname);
        }
        return clazz;
    }

    private static void configureElement(Object instance, ConfigBeanProxy configuration) {
        if (instance instanceof ConfigAwareElement) {
            ((ConfigAwareElement)instance).configure(configuration);
        }
    }
}

