/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admingui.common.handlers;

import com.sun.jsftemplating.layout.descriptors.handler.HandlerContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.glassfish.admin.amx.intf.config.ConnectorConnectionPool;
import org.glassfish.admin.amx.intf.config.ConnectorResource;
import org.glassfish.admin.amx.intf.config.Resources;
import org.glassfish.admingui.common.util.GuiUtil;
import org.glassfish.admingui.common.util.V3AMX;

public class JdbcTempHandler {
    public static final String REASON_FAILED_KEY = "ReasonFailedKey";
    private static final String CONN_DEFINITION_PROPS_KEY = "ConnDefinitionPropsKey";
    private static final String PING_CONNECTION_POOL_KEY = "PingConnectionPoolKey";
    private static final String FLUSH_CONNECTION_POOL_KEY = "FlushConnectionPoolKey";
    private static final String VALIDATION_TABLE_NAMES_KEY = "ValidationTableNamesKey";
    private static final String JDBC_DRIVER_CLASS_NAMES_KEY = "JdbcDriverClassNamesKey";
    private static final String DATABASE_VENDOR_NAMES_KEY = "DatabaseVendorNamesKey";
    private static final String DATA_SOURCE = "javax.sql.DataSource";
    private static final String XADATA_SOURCE = "javax.sql.XADataSource";
    private static final String CCDATA_SOURCE = "javax.sql.ConnectionPoolDataSource";
    private static final String DRIVER = "java.sql.Driver";
    private static final String JAVADB = "JavaDB";
    private static final String ORACLE = "Oracle";
    private static final String DERBY = "Derby";
    private static final String SYBASE = "Sybase";
    private static final String DB2 = "DB2";
    private static final String POINTBASE = "PointBase";
    private static final String POSTGRESQL = "PostgreSQL";
    private static final String INFORMIX = "Informix";
    private static final String CLOUDSCAPE = "Cloudscape";
    private static final String MSSQL = "Microsoft SQL Server";
    private static final String MYSQL = "MySQL";
    private static List resTypeList = new ArrayList();
    private static List dbVendorList = new ArrayList();

    public static void pingJdbcConnectionPool(HandlerContext handlerCtx) {
        String jndiName = (String)handlerCtx.getInputValue("jndiName");
        String warningMsg = (String)handlerCtx.getInputValue("wmsg");
        boolean showSuccess = false;
        String type = "warning";
        if (GuiUtil.isEmpty(warningMsg)) {
            showSuccess = true;
            warningMsg = GuiUtil.getMessage("msg.Error");
            type = "error";
        }
        try {
            Map statusMap = V3AMX.getInstance().getConnectorRuntime().pingJDBCConnectionPool(jndiName);
            if (((Boolean)statusMap.get(PING_CONNECTION_POOL_KEY)).booleanValue()) {
                if (showSuccess) {
                    GuiUtil.prepareAlert(handlerCtx, "success", GuiUtil.getMessage("msg.PingSucceed"), null);
                }
            } else {
                GuiUtil.prepareAlert(handlerCtx, type, warningMsg, statusMap.get(REASON_FAILED_KEY).toString());
            }
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public static void flushConnectionPool(HandlerContext handlerCtx) {
        String jndiName = (String)handlerCtx.getInputValue("jndiName");
        try {
            Map statusMap = V3AMX.getInstance().getConnectorRuntime().flushConnectionPool(jndiName);
            if (((Boolean)statusMap.get(FLUSH_CONNECTION_POOL_KEY)).booleanValue()) {
                GuiUtil.prepareAlert(handlerCtx, "success", GuiUtil.getMessage("msg.FlushSucceed"), null);
            } else {
                GuiUtil.prepareAlert(handlerCtx, "error", GuiUtil.getMessage("msg.Error"), statusMap.get(REASON_FAILED_KEY).toString());
            }
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public static void getTableNames(HandlerContext handlerCtx) {
        String name = (String)handlerCtx.getInputValue("name");
        ArrayList result = new ArrayList();
        Map tn = V3AMX.getInstance().getConnectorRuntime().getValidationTableNames(name);
        if (tn != null) {
            Set keys = (Set)tn.get(VALIDATION_TABLE_NAMES_KEY);
            if (keys != null) {
                Iterator iter = keys.iterator();
                while (iter.hasNext()) {
                    result.add(iter.next());
                }
            } else if (tn.get(REASON_FAILED_KEY) != null) {
                GuiUtil.getLogger().warning(tn.get(REASON_FAILED_KEY).toString());
            }
            handlerCtx.setOutputValue("result", result);
        }
    }

    public static void setJDBCPoolWizard(HandlerContext handlerCtx) {
        Boolean fromStep2 = (Boolean)handlerCtx.getInputValue("fromStep2");
        if (fromStep2 == null || !fromStep2.booleanValue()) {
            Map attrMap = (Map)handlerCtx.getInputValue("attrMap");
            Map<String, Object> sessionMap = handlerCtx.getFacesContext().getExternalContext().getSessionMap();
            sessionMap.put("wizardMap", attrMap);
            sessionMap.put("wizardPoolExtra", new HashMap());
        }
        handlerCtx.setOutputValue("ResTypeList", (Object)resTypeList);
        handlerCtx.setOutputValue("DBVendorList", (Object)dbVendorList);
    }

    public static void updateJDBCPoolWizardStep1(HandlerContext handlerCtx) {
        Map extra = (Map)handlerCtx.getFacesContext().getExternalContext().getSessionMap().get("wizardPoolExtra");
        String resType = (String)extra.get("ResType");
        String dbVendorBox = (String)extra.get("DBVendorBox");
        String dbVendorField = (String)extra.get("DBVendorField");
        String dbVendor = GuiUtil.isEmpty(dbVendorField) ? dbVendorBox : dbVendorField;
        extra.put("DBVendor", dbVendor);
        String previousResType = (String)extra.get("PreviousResType");
        String previousDB = (String)extra.get("PreviousDB");
        if (!resType.equals(previousResType) || !dbVendor.equals(previousDB)) {
            block12: {
                if (!GuiUtil.isEmpty(resType) && !GuiUtil.isEmpty(dbVendor)) {
                    ArrayList dsl = new ArrayList();
                    try {
                        String dslName;
                        String classname = "";
                        GuiUtil.getLogger().fine("======= getJdbcDriverClassNames(" + dbVendor + ", " + resType + ")");
                        Map dcn = V3AMX.getInstance().getConnectorRuntime().getJdbcDriverClassNames(dbVendor, resType);
                        GuiUtil.getLogger().fine("======= returns " + (dcn == null ? "NULL" : " Map of size " + dcn.size()));
                        if (dcn != null) {
                            dsl = new ArrayList((Set)dcn.get(JDBC_DRIVER_CLASS_NAMES_KEY));
                            GuiUtil.getLogger().fine("=======  # of items for JDBC_DRIVER_CLASS_NAMES_KEY  " + dsl.size());
                            for (int i = 0; i < dsl.size(); ++i) {
                                GuiUtil.getLogger().fine("classname[" + i + "] : " + dsl.get(i));
                            }
                        }
                        ArrayList noprops = new ArrayList();
                        String string = dslName = dsl != null && dsl.size() > 0 ? (String)dsl.get(0) : "";
                        if (resType.equals(DRIVER)) {
                            extra.put("DList", dsl);
                            extra.put("DSList", "");
                            extra.put("DatasourceClassnameField", "");
                            extra.put("dsClassname", Boolean.FALSE);
                        } else {
                            extra.put("DSList", dsl);
                            extra.put("DList", "");
                            extra.put("DriverClassnameField", "");
                            extra.put("dsClassname", Boolean.TRUE);
                            extra.put("DatasourceClassname", dslName);
                        }
                        GuiUtil.getLogger().fine("===== getConnectionDefinitionPropertiesAndDefaults(\"" + dslName + "\"," + resType + ")");
                        Map result = V3AMX.getInstance().getConnectorRuntime().getConnectionDefinitionPropertiesAndDefaults(dslName, resType);
                        if (result != null) {
                            Map props = (Map)result.get(CONN_DEFINITION_PROPS_KEY);
                            GuiUtil.getLogger().fine("=======  getConnectionDefinitionPropertiesAndDefaults returns # of properties: " + props.size());
                            handlerCtx.getFacesContext().getExternalContext().getSessionMap().put("wizardPoolProperties", GuiUtil.convertMapToListOfMap(props));
                            break block12;
                        }
                        GuiUtil.getLogger().fine("======= getConnectionDefinitionPropertiesAndDefaults returns NULL");
                        handlerCtx.getFacesContext().getExternalContext().getSessionMap().put("wizardPoolProperties", noprops);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                } else if (DRIVER.equals(resType)) {
                    extra.put("DatasourceClassnameField", "");
                    extra.put("dsClassname", Boolean.FALSE);
                } else {
                    extra.put("DatasourceClassnameField", "");
                    extra.put("dsClassname", Boolean.TRUE);
                }
            }
            extra.put("PreviousResType", resType);
            extra.put("PreviousDB", dbVendor);
        }
    }

    public static void updateJdbcConnectionPoolPropertiesTable(HandlerContext handlerCtx) {
        Map extra = (Map)handlerCtx.getFacesContext().getExternalContext().getSessionMap().get("wizardPoolExtra");
        String resType = (String)extra.get("ResType");
        String classname = (String)extra.get("DatasourceClassname");
        ArrayList noprops = new ArrayList();
        GuiUtil.getLogger().fine("===== getConnectionDefinitionPropertiesAndDefaults(\"" + classname + "\"," + resType + ")");
        Map result = V3AMX.getInstance().getConnectorRuntime().getConnectionDefinitionPropertiesAndDefaults(classname, resType);
        if (result != null) {
            Map props = (Map)result.get(CONN_DEFINITION_PROPS_KEY);
            GuiUtil.getLogger().fine("=======  getConnectionDefinitionPropertiesAndDefaults returns # of properties: " + props.size());
            handlerCtx.getFacesContext().getExternalContext().getSessionMap().put("wizardPoolProperties", GuiUtil.convertMapToListOfMap(props));
        } else {
            GuiUtil.getLogger().fine("======= getConnectionDefinitionPropertiesAndDefaults returns NULL");
            handlerCtx.getFacesContext().getExternalContext().getSessionMap().put("wizardPoolProperties", noprops);
        }
    }

    public static void updateJdbcConnectionPoolWizardStep2(HandlerContext handlerCtx) {
        Map extra = (Map)handlerCtx.getFacesContext().getExternalContext().getSessionMap().get("wizardPoolExtra");
        Map attrs = (Map)handlerCtx.getFacesContext().getExternalContext().getSessionMap().get("wizardMap");
        String resType = (String)extra.get("ResType");
        String classname = (String)extra.get("DatasourceClassname");
        String driver = (String)extra.get("DriverClassname");
        String name = (String)extra.get("Name");
        String classnamefield = (String)extra.get("DatasourceClassnameField");
        String driverfield = (String)extra.get("DriverClassnameField");
        attrs.put("Name", name);
        attrs.put("ResType", resType);
        if ("".equals(attrs.get("TransactionIsolationLevel"))) {
            attrs.remove("TransactionIsolationLevel");
        }
        if (!GuiUtil.isEmpty(classnamefield) || !GuiUtil.isEmpty(driverfield)) {
            attrs.put("DatasourceClassname", classnamefield);
            attrs.put("DriverClassname", driverfield);
        } else if (!GuiUtil.isEmpty(classname) || !GuiUtil.isEmpty(driver)) {
            attrs.put("DatasourceClassname", classname);
            attrs.put("DriverClassname", driver);
        } else {
            GuiUtil.handleError(handlerCtx, GuiUtil.getMessage("org.glassfish.jdbc.admingui.Strings", "msg.Error.classNameCannotBeEmpty"));
            return;
        }
    }

    public static void saveJdbcConnectionPool(HandlerContext handlerCtx) {
        try {
            List convertToFalse;
            List onlyUseAttrs;
            String objectNameStr = (String)handlerCtx.getInputValue("objectNameStr");
            HashMap<String, String> attrs = (HashMap<String, String>)handlerCtx.getInputValue("attrs");
            String resourceType = (String)attrs.get("ResType");
            if (resourceType.equals(DRIVER)) {
                attrs.put("DatasourceClassname", "");
            } else {
                attrs.put("DriverClassname", "");
            }
            List skipAttrs = (List)handlerCtx.getInputValue("skipAttrs");
            if (skipAttrs != null) {
                for (String sk : skipAttrs) {
                    if (!attrs.keySet().contains(sk)) continue;
                    attrs.remove(sk);
                }
            }
            if ((onlyUseAttrs = (List)handlerCtx.getInputValue("onlyUseAttrs")) != null) {
                HashMap<String, String> newAttrs = new HashMap<String, String>();
                for (String key : onlyUseAttrs) {
                    if (!attrs.keySet().contains(key)) continue;
                    newAttrs.put(key, (String)attrs.get(key));
                }
                attrs = newAttrs;
            }
            if ((convertToFalse = (List)handlerCtx.getInputValue("convertToFalse")) != null) {
                for (String sk : convertToFalse) {
                    if (!attrs.keySet().contains(sk) || attrs.get(sk) != null) continue;
                    attrs.remove(sk);
                    attrs.put(sk, "false");
                }
            }
            V3AMX.setAttributes(objectNameStr, (Map<String, Object>)attrs);
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public static void getJMSFactoriesTable(HandlerContext handlerCtx) {
        Resources resources = V3AMX.getInstance().getResources();
        Map conResources = resources.getConnectorResource();
        ArrayList result = new ArrayList();
        for (ConnectorResource cr : conResources.values()) {
            ConnectorConnectionPool ccPool;
            String poolName = cr.getPoolName();
            if (GuiUtil.isEmpty(poolName) || (ccPool = (ConnectorConnectionPool)resources.getConnectorConnectionPool().get(poolName)) == null || !ccPool.getResourceAdapterName().equals("jmsra")) continue;
            HashMap<String, Object> oneRow = new HashMap<String, Object>();
            oneRow.put("selected", false);
            oneRow.put("Name", poolName);
            oneRow.put("JndiName", cr.getName());
            oneRow.put("ConnectionDefinitionName", ccPool.getConnectionDefinitionName());
            oneRow.put("Description", GuiUtil.isEmpty(ccPool.getDescription()) ? "" : ccPool.getDescription());
            result.add(oneRow);
        }
        handlerCtx.setOutputValue("result", result);
    }

    static {
        dbVendorList = new ArrayList((Set)V3AMX.getInstance().getConnectorRuntime().getDatabaseVendorNames().get(DATABASE_VENDOR_NAMES_KEY));
        dbVendorList.add(0, "");
        resTypeList.add("");
        resTypeList.add(DATA_SOURCE);
        resTypeList.add(XADATA_SOURCE);
        resTypeList.add(CCDATA_SOURCE);
        resTypeList.add(DRIVER);
    }
}

