/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admingui.common.handlers;

import com.sun.jsftemplating.layout.descriptors.handler.HandlerContext;
import com.sun.jsftemplating.util.Util;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import javax.management.Attribute;
import javax.management.ObjectName;
import org.glassfish.admin.amx.base.Query;
import org.glassfish.admin.amx.config.AMXConfigProxy;
import org.glassfish.admin.amx.core.AMXProxy;
import org.glassfish.admin.amx.intf.config.AMXConfigHelper;
import org.glassfish.admin.amx.intf.config.Applications;
import org.glassfish.admin.amx.intf.config.ConfigTools;
import org.glassfish.admin.amx.intf.config.Property;
import org.glassfish.admin.amx.intf.config.Server;
import org.glassfish.admingui.common.util.GuiUtil;
import org.glassfish.admingui.common.util.V3AMX;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProxyHandlers {
    private static final String SNIFFER_EAR = "ear";
    public static final String PROPERTY_NAME = "Name";
    public static final String PROPERTY_VALUE = "Value";
    public static final String PROPERTY_DESC = "Description";
    public static final String JDBC_CONNECTION_POOL = "jdbc-connection-pool";
    public static final String CONNECTOR_CONNECTION_POOL = "connector-connection-pool";

    public static void getAmxProxy(HandlerContext handlerCtx) {
        String objectNameStr = (String)handlerCtx.getInputValue("objectNameStr");
        AMXProxy amx = V3AMX.objectNameToProxy(objectNameStr);
        handlerCtx.setOutputValue("result", (Object)amx);
    }

    public static void getChildrenTable(HandlerContext handlerCtx) {
        String objectNameStr = (String)handlerCtx.getInputValue("objectNameStr");
        String childType = (String)handlerCtx.getInputValue("childType");
        AMXProxy amx = V3AMX.objectNameToProxy(objectNameStr);
        List result = V3AMX.getChildrenMapForTableList(amx, childType, null);
        handlerCtx.setOutputValue("result", (Object)result);
    }

    public static void filterTable(HandlerContext handlerCtx) {
        List table = (List)handlerCtx.getInputValue("table");
        String key = (String)handlerCtx.getInputValue("key");
        String value = (String)handlerCtx.getInputValue("value");
        Boolean keep = (Boolean)handlerCtx.getInputValue("keep");
        if (key == null || "".equals(key)) {
            GuiUtil.getLogger().info("'attr' must be non-null, and non-blank");
        }
        if (value == null || "".equals(value)) {
            GuiUtil.getLogger().info("'value' must be non-null, and non-blank");
        }
        if (keep == null) {
            keep = Boolean.TRUE;
        }
        ArrayList<Map> results = new ArrayList<Map>();
        if (!keep.booleanValue()) {
            results.addAll(table);
        }
        for (Map child : table) {
            if (!value.equals(child.get(key))) continue;
            if (keep.booleanValue()) {
                results.add(child);
                continue;
            }
            results.remove(child);
        }
        handlerCtx.setOutputValue("table", results);
    }

    private static String getA(Map<String, Object> attrs, String key) {
        Object val = attrs.get(key);
        return val == null ? "" : val.toString();
    }

    public static void deleteChildren(HandlerContext handlerCtx) {
        String type = (String)handlerCtx.getInputValue("type");
        String objectNameStr = (String)handlerCtx.getInputValue("objectNameStr");
        String key = (String)handlerCtx.getInputValue("key");
        AMXConfigProxy amx = (AMXConfigProxy)V3AMX.objectNameToProxy(objectNameStr);
        List selectedRows = (List)handlerCtx.getInputValue("selectedRows");
        try {
            for (Map oneRow : selectedRows) {
                String Name2 = (String)oneRow.get(key);
                amx.removeChild(type, Name2);
            }
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public static void deleteCascade(HandlerContext handlerCtx) {
        try {
            String objectNameStr = (String)handlerCtx.getInputValue("objectNameStr");
            String type = (String)handlerCtx.getInputValue("type");
            String dependentType = (String)handlerCtx.getInputValue("dependentType");
            String dependentNameKey = PROPERTY_NAME;
            if (type.equals(JDBC_CONNECTION_POOL)) {
                dependentNameKey = "JndiName";
            }
            if (dependentType != null) {
                AMXConfigProxy amx = (AMXConfigProxy)V3AMX.objectNameToProxy(objectNameStr);
                List selectedRows = (List)handlerCtx.getInputValue("selectedRows");
                for (Map oneRow : selectedRows) {
                    String name = (String)oneRow.get(PROPERTY_NAME);
                    Map childrenMap = amx.childrenMap(dependentType);
                    Iterator itr = childrenMap.values().iterator();
                    ArrayList<String> dependencies = new ArrayList<String>();
                    while (itr.hasNext()) {
                        AMXProxy obj = (AMXProxy)itr.next();
                        String resourceName = (String)obj.attributesMap().get(dependentNameKey);
                        String poolName = (String)obj.attributesMap().get("PoolName");
                        if (!poolName.trim().equals(name.trim())) continue;
                        dependencies.add(resourceName);
                    }
                    for (int i = 0; i < dependencies.size(); ++i) {
                        AMXConfigProxy refAmx = (AMXConfigProxy)V3AMX.objectNameToProxy("amx:pp=/domain/servers,type=server,name=server");
                        String refType = "resource-ref";
                        String dependentName = (String)dependencies.get(i);
                        amx.removeChild(dependentType, dependentName);
                        refAmx.removeChild(refType, dependentName);
                    }
                    amx.removeChild(type, name);
                }
            }
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public static void deleteChild(HandlerContext handlerCtx) {
        String type = (String)handlerCtx.getInputValue("type");
        String name = (String)handlerCtx.getInputValue("name");
        String objectNameStr = (String)handlerCtx.getInputValue("objectNameStr");
        AMXConfigProxy amx = (AMXConfigProxy)V3AMX.objectNameToProxy(objectNameStr);
        try {
            if (GuiUtil.isEmpty(name)) {
                amx.removeChild(type);
            } else {
                amx.removeChild(type, name);
            }
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public static void getProxyAttrs(HandlerContext handlerCtx) {
        AMXProxy amx = null;
        try {
            String objectNameStr = (String)handlerCtx.getInputValue("objectNameStr");
            amx = V3AMX.getInstance().getProxyFactory().getProxy(new ObjectName(objectNameStr));
            AMXConfigHelper helper = new AMXConfigHelper((AMXConfigProxy)amx);
            Map attrs = helper.simpleAttributesMap();
            handlerCtx.setOutputValue("valueMap", (Object)attrs);
        }
        catch (Exception ex) {
            if (!(amx instanceof AMXConfigProxy)) {
                ProxyHandlers.getRuntimeProxyAttrs(handlerCtx);
                return;
            }
            ex.printStackTrace();
            handlerCtx.setOutputValue("valueMap", new HashMap());
        }
    }

    public static void getRuntimeProxyAttrs(HandlerContext handlerCtx) {
        try {
            String objectNameStr = (String)handlerCtx.getInputValue("objectNameStr");
            AMXProxy amx = V3AMX.getInstance().getProxyFactory().getProxy(new ObjectName(objectNameStr));
            Map attrs = amx.attributesMap();
            handlerCtx.setOutputValue("valueMap", (Object)attrs);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            handlerCtx.setOutputValue("valueMap", new HashMap());
        }
    }

    public static void getProxyAttribute(HandlerContext handlerCtx) {
        String objectNameStr = (String)handlerCtx.getInputValue("objectNameStr");
        String attrName = (String)handlerCtx.getInputValue("attrName");
        Object result = "";
        try {
            Object value;
            Object[] valArray;
            String index;
            AMXProxy amx = V3AMX.getInstance().getProxyFactory().getProxy(new ObjectName(objectNameStr));
            Object val = amx.attributesMap().get(attrName);
            result = val instanceof Object[] ? ((index = (String)handlerCtx.getInputValue("index")) == null ? val : ((valArray = (Object[])val).length <= 0 ? "" : ((value = valArray[Integer.parseInt(index)]) == null ? "" : value.toString()))) : (val == null ? "" : val.toString());
        }
        catch (Exception ex) {
            GuiUtil.getLogger().info("objectName=" + objectNameStr + ", attributeName=" + attrName);
            ex.printStackTrace();
        }
        handlerCtx.setOutputValue("value", result);
    }

    public static void getDefaultProxyAttrs(HandlerContext handlerCtx) {
        try {
            String parentName = (String)handlerCtx.getInputValue("parentObjectNameStr");
            String childType = (String)handlerCtx.getInputValue("childType");
            Map orig = (Map)handlerCtx.getInputValue("orig");
            AMXConfigProxy amx = (AMXConfigProxy)V3AMX.getInstance().getProxyFactory().getProxy(new ObjectName(parentName));
            Map defaultMap = amx.getDefaultValues(childType, true);
            if (orig == null) {
                handlerCtx.setOutputValue("valueMap", (Object)defaultMap);
                return;
            }
            for (String origKey : orig.keySet()) {
                String defaultV = (String)defaultMap.get(origKey);
                if (defaultV == null) continue;
                orig.put(origKey, defaultV);
            }
            handlerCtx.setOutputValue("valueMap", (Object)orig);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            handlerCtx.setOutputValue("valueMap", new HashMap());
        }
    }

    public static void proxyExist(HandlerContext handlerCtx) {
        try {
            String objectNameStr = (String)handlerCtx.getInputValue("objectNameStr");
            handlerCtx.setOutputValue("exist", (Object)ProxyHandlers.doesProxyExist(objectNameStr));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            handlerCtx.setOutputValue("exist", (Object)Boolean.FALSE);
        }
    }

    public static void saveBeanAttributes(HandlerContext handlerCtx) {
        try {
            List convertToFalse;
            List onlyUseAttrs;
            String objectNameStr = (String)handlerCtx.getInputValue("objectNameStr");
            if (!ProxyHandlers.doesProxyExist(objectNameStr)) {
                GuiUtil.handleError(handlerCtx, GuiUtil.getMessage("error.noSuchProxy"));
                return;
            }
            HashMap attrs = (HashMap)handlerCtx.getInputValue("attrs");
            List skipAttrs = (List)handlerCtx.getInputValue("skipAttrs");
            if (skipAttrs != null) {
                for (String sk : skipAttrs) {
                    if (!attrs.keySet().contains(sk)) continue;
                    attrs.remove(sk);
                }
            }
            if ((onlyUseAttrs = (List)handlerCtx.getInputValue("onlyUseAttrs")) != null) {
                HashMap newAttrs = new HashMap();
                for (String key : onlyUseAttrs) {
                    if (!attrs.keySet().contains(key)) continue;
                    newAttrs.put(key, attrs.get(key));
                }
                attrs = newAttrs;
            }
            if ((convertToFalse = (List)handlerCtx.getInputValue("convertToFalse")) != null) {
                for (String sk : convertToFalse) {
                    if (!attrs.keySet().contains(sk) || attrs.get(sk) != null) continue;
                    attrs.remove(sk);
                    attrs.put(sk, "false");
                }
            }
            V3AMX.setAttributes(objectNameStr, attrs);
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public static void updateStatus(HandlerContext handlerCtx) {
        String resType = (String)handlerCtx.getInputValue("resType");
        String status = (String)handlerCtx.getInputValue("enabled");
        List selectedRows = (List)handlerCtx.getInputValue("selectedRows");
        Attribute attr = new Attribute("Enabled", status);
        try {
            for (Map oneRow : selectedRows) {
                String resObjectName;
                String name = (String)oneRow.get(PROPERTY_NAME);
                Set resRefSet = V3AMX.getInstance().getDomainRoot().getQueryMgr().queryTypeName("resource-ref", name);
                for (AMXProxy ref : resRefSet) {
                    V3AMX.setAttribute(ref.objectName(), attr);
                }
                if (!"true".equals(status) || !V3AMX.getAttrsMap(resObjectName = ((AMXProxy)V3AMX.getInstance().getResources().childrenMap(resType).get(name)).objectName().toString()).containsKey("Enabled") || V3AMX.getAttribute(resObjectName, "Enabled").equals("true")) continue;
                V3AMX.setAttribute(resObjectName, attr);
            }
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public static void createProxy(HandlerContext handlerCtx) {
        String childType = (String)handlerCtx.getInputValue("childType");
        HashMap<String, Object> attrs = (HashMap<String, Object>)handlerCtx.getInputValue("attrs");
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        String parentObjectNameStr = (String)handlerCtx.getInputValue("parentObjectNameStr");
        try {
            AMXConfigProxy amx = (AMXConfigProxy)V3AMX.getInstance().getProxyFactory().getProxy(new ObjectName(parentObjectNameStr));
            List convertToFalse = (List)handlerCtx.getInputValue("convertToFalse");
            if (convertToFalse != null) {
                for (String sk : convertToFalse) {
                    if (!attrs.keySet().contains(sk) || attrs.get(sk) != null) continue;
                    attrs.put(sk, "false");
                }
            }
            List skipAttrs = (List)handlerCtx.getInputValue("skipAttrs");
            V3AMX.removeSpecifiedAttr(attrs, skipAttrs);
            List onlyUseAttrs = (List)handlerCtx.getInputValue("onlyUseAttrs");
            if (onlyUseAttrs != null) {
                HashMap newAttrs = new HashMap();
                for (String key : onlyUseAttrs) {
                    if (!attrs.keySet().contains(key)) continue;
                    newAttrs.put(key, attrs.get(key));
                }
                attrs = newAttrs;
            }
            V3AMX.removeElement(attrs);
            Set attrSet = attrs.entrySet();
            Iterator iter = attrSet.iterator();
            while (iter.hasNext()) {
                Map.Entry oneEntry = iter.next();
                Object val = oneEntry.getValue();
                if (val == null || !(val instanceof String) || !val.equals("")) continue;
                iter.remove();
            }
            AMXConfigProxy child = amx.createChild(childType, attrs);
            handlerCtx.setOutputValue("result", (Object)child.objectName().toString());
        }
        catch (Exception ex) {
            GuiUtil.getLogger().severe("CreateProxy failed.  parent=" + parentObjectNameStr + "; childType=" + childType + "; attrs =" + attrs);
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public static void getChildrenByType(HandlerContext handlerCtx) {
        try {
            String type = (String)handlerCtx.getInputValue("type");
            String parentObjectNameStr = (String)handlerCtx.getInputValue("parentObjectNameStr");
            ArrayList<String> result = new ArrayList<String>();
            AMXConfigProxy amx = (AMXConfigProxy)V3AMX.getInstance().getProxyFactory().getProxy(new ObjectName(parentObjectNameStr));
            Map childrenMap = amx.childrenMap(type);
            for (String key : childrenMap.keySet()) {
                result.add(Util.htmlEscape((String)key));
            }
            handlerCtx.setOutputValue("result", result);
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public static void getProxyNamesByType(HandlerContext handlerCtx) {
        try {
            String type = (String)handlerCtx.getInputValue("type");
            Boolean end = (Boolean)handlerCtx.getInputValue("end");
            ArrayList<String> result = new ArrayList<String>();
            Query query = V3AMX.getInstance().getDomainRoot().getQueryMgr();
            Set data = query.queryType(type);
            Iterator iter = data.iterator();
            String firstItem = "";
            String name = "";
            while (iter.hasNext()) {
                Map attr = ((AMXProxy)iter.next()).attributesMap();
                String obj = (String)attr.get(PROPERTY_NAME);
                name = end != false ? obj.substring(obj.lastIndexOf("/") + 1, obj.length()) : obj.substring(obj.indexOf("/") + 1, obj.lastIndexOf("/") == obj.indexOf("/") ? obj.length() : obj.lastIndexOf("/"));
                if (GuiUtil.isEmpty(firstItem)) {
                    firstItem = name;
                }
                result.add(name);
            }
            handlerCtx.setOutputValue("result", result);
            handlerCtx.setOutputValue("firstItem", (Object)firstItem);
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public static void getApplicationByType(HandlerContext handlerCtx) {
        String type = (String)handlerCtx.getInputValue("type");
        Applications amx = V3AMX.getInstance().getApplications();
        Map children = amx.childrenMap("application");
        ArrayList<String> result = new ArrayList<String>();
        for (AMXProxy oneChild : children.values()) {
            try {
                AMXConfigHelper helper = new AMXConfigHelper((AMXConfigProxy)oneChild);
                Map attrs = helper.simpleAttributesMap();
                for (String attrName : attrs.keySet()) {
                    if (!attrName.equals(PROPERTY_NAME)) continue;
                    String appName = ProxyHandlers.getA(attrs, PROPERTY_NAME);
                    Map module = V3AMX.getInstance().getApplication(appName).childrenMap("module");
                    for (AMXProxy oneModule : module.values()) {
                        AMXConfigHelper helperModule = new AMXConfigHelper((AMXConfigProxy)oneModule);
                        Map modattrs = helperModule.simpleAttributesMap();
                        for (String modName : modattrs.keySet()) {
                            if (!modName.equals("Children")) continue;
                            ObjectName[] engines = (ObjectName[])modattrs.get(modName);
                            for (int i = 0; i < engines.length; ++i) {
                                String enginename = engines[i].getKeyProperty("name");
                                if (!enginename.equals(type)) continue;
                                result.add(appName);
                            }
                        }
                    }
                }
            }
            catch (Exception ex) {
                GuiUtil.handleException(handlerCtx, ex);
            }
        }
        handlerCtx.setOutputValue("result", result);
    }

    public static void getApplicationBySnifferType(HandlerContext handlerCtx) {
        String type = (String)handlerCtx.getInputValue("type");
        Boolean fullName = (Boolean)handlerCtx.getInputValue("fullName");
        if (fullName == null) {
            fullName = true;
        }
        Applications amx = V3AMX.getInstance().getApplications();
        Map applications = amx.childrenMap("application");
        ArrayList<String> result = new ArrayList<String>();
        block0: for (AMXProxy oneApp : applications.values()) {
            Map modules = oneApp.childrenMap("module");
            for (AMXProxy oneModule : modules.values()) {
                Map engines = oneModule.childrenMap("engine");
                for (AMXProxy oneEngine : engines.values()) {
                    if (!oneEngine.getName().equals(type)) continue;
                    String appName = oneApp.getName();
                    if (fullName.booleanValue()) {
                        AMXProxy earSniffer = (AMXProxy)oneApp.childrenMap("engine").get(SNIFFER_EAR);
                        result.add(earSniffer == null ? appName : appName + "#" + oneModule.getName());
                        continue;
                    }
                    result.add(appName);
                    continue block0;
                }
            }
        }
        handlerCtx.setOutputValue("result", result);
    }

    public static void setProxyProperties(HandlerContext handlerCtx) {
        try {
            String objectNameStr = (String)handlerCtx.getInputValue("objectNameStr");
            Boolean systemProp = (Boolean)handlerCtx.getInputValue("systemProp");
            ObjectName objectName = new ObjectName(objectNameStr);
            List propertyList = (List)handlerCtx.getInputValue("propertyList");
            ArrayList newList = new ArrayList();
            HashSet<String> propertyNames = new HashSet<String>();
            ConfigTools configTools = (ConfigTools)V3AMX.getInstance().getDomainRoot().getExt().child(ConfigTools.class);
            if (propertyList.size() == 0) {
                if (systemProp != null && systemProp.booleanValue()) {
                    configTools.clearSystemProperties(objectName);
                } else {
                    configTools.clearProperties(objectName);
                }
            } else {
                for (Map oneRow : propertyList) {
                    HashMap<String, String> newRow = new HashMap<String, String>();
                    String name = (String)oneRow.get(PROPERTY_NAME);
                    String value = (String)oneRow.get(PROPERTY_VALUE);
                    if (GuiUtil.isEmpty(name) || GuiUtil.isEmpty(value)) continue;
                    if (propertyNames.contains(name)) {
                        GuiUtil.handleError(handlerCtx, GuiUtil.getMessage("msg.duplicatePropTableKey", new Object[]{name}));
                        return;
                    }
                    propertyNames.add(name);
                    if (value.equals("()")) {
                        value = "";
                    }
                    newRow.put(PROPERTY_NAME, name);
                    newRow.put(PROPERTY_VALUE, value);
                    String desc = (String)oneRow.get(PROPERTY_DESC);
                    if (!GuiUtil.isEmpty(desc)) {
                        newRow.put(PROPERTY_DESC, desc);
                    }
                    newList.add(newRow);
                }
                if (systemProp != null && systemProp.booleanValue()) {
                    configTools.setSystemProperties(objectName, newList, true);
                } else {
                    configTools.setProperties(objectName, newList, true);
                }
            }
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public static void updateProxyProperties(HandlerContext handlerCtx) {
        try {
            List propertyList = (List)handlerCtx.getInputValue("propertyList");
            ArrayList newList = new ArrayList();
            if (propertyList != null && propertyList.size() != 0) {
                for (Map oneRow : propertyList) {
                    HashMap<String, Object> newRow = new HashMap<String, Object>();
                    newRow.put("selected", false);
                    String name = (String)oneRow.get(PROPERTY_NAME);
                    if (GuiUtil.isEmpty(name)) continue;
                    String value = (String)oneRow.get(PROPERTY_VALUE);
                    if (GuiUtil.isEmpty(value)) {
                        value = "";
                    }
                    newRow.put(PROPERTY_NAME, name);
                    newRow.put(PROPERTY_VALUE, value);
                    String desc = (String)oneRow.get(PROPERTY_DESC);
                    if (!GuiUtil.isEmpty(desc)) {
                        desc = "";
                    }
                    newRow.put(PROPERTY_DESC, desc);
                    newList.add(newRow);
                }
            }
            handlerCtx.setOutputValue("TableList", newList);
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public static void getProxyProperties(HandlerContext handlerCtx) {
        String objectNameStr = (String)handlerCtx.getInputValue("objectNameStr");
        AMXProxy amx = V3AMX.objectNameToProxy(objectNameStr);
        Map children = amx.childrenMap(Property.class);
        HashMap<String, String> result = new HashMap<String, String>();
        for (Property oneChild : children.values()) {
            result.put(oneChild.getName(), oneChild.getValue());
        }
        handlerCtx.setOutputValue("result", result);
    }

    public static void propMapToList(HandlerContext handlerCtx) {
        Map propMap = (Map)handlerCtx.getInputValue("propMap");
        ArrayList convertToFalse = (ArrayList)handlerCtx.getInputValue("convertToFalse");
        if (convertToFalse == null) {
            convertToFalse = new ArrayList();
        }
        ArrayList result = new ArrayList();
        for (String name : propMap.keySet()) {
            String value = (String)propMap.get(name);
            HashMap<String, String> newRow = new HashMap<String, String>();
            newRow.put(PROPERTY_NAME, name);
            if (convertToFalse.contains(name)) {
                if (value == null) {
                    value = "false";
                }
                newRow.put(PROPERTY_VALUE, value);
                result.add(newRow);
                continue;
            }
            if (GuiUtil.isEmpty(value)) continue;
            newRow.put(PROPERTY_VALUE, value);
            result.add(newRow);
        }
        handlerCtx.setOutputValue("propList", result);
    }

    public static void getResourceRealStatus(HandlerContext handlerCtx) {
        List rows = (List)handlerCtx.getInputValue("rows");
        for (Map oneRow : rows) {
            String enabled = (String)oneRow.get("Enabled");
            String name = (String)oneRow.get(PROPERTY_NAME);
            if (enabled == null) continue;
            Set resRefSet = V3AMX.getInstance().getDomainRoot().getQueryMgr().queryTypeName("resource-ref", name);
            for (AMXProxy ref : resRefSet) {
                String refStatus = (String)ref.attributesMap().get("Enabled");
                if (refStatus.equals("true")) {
                    oneRow.put("Enabled", enabled);
                    continue;
                }
                oneRow.put("Enabled", false);
            }
        }
        handlerCtx.setOutputValue("result", (Object)rows);
    }

    public static void createResourceRef(HandlerContext handlerCtx) {
        String resourceName = (String)handlerCtx.getInputValue("resourceName");
        String enabled = (String)handlerCtx.getInputValue("enabled");
        if (enabled == null) {
            enabled = "true";
        }
        try {
            Server server = V3AMX.getInstance().getServer("server");
            HashMap<String, String> attrs = new HashMap<String, String>();
            attrs.put(PROPERTY_NAME, resourceName);
            attrs.put("Enabled", enabled);
            server.createChild("resource-ref", attrs);
        }
        catch (Exception ex) {
            GuiUtil.getLogger().log(Level.SEVERE, null, ex);
        }
    }

    public static Map getDefaultProxyAttrsMap(String parentObjectNameStr, String childType) {
        try {
            String parentName = parentObjectNameStr;
            String child = childType;
            AMXConfigProxy amx = (AMXConfigProxy)V3AMX.getInstance().getProxyFactory().getProxy(new ObjectName(parentName));
            Map valueMap = amx.getDefaultValues(child, true);
            return valueMap;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return new HashMap();
        }
    }

    public static boolean doesProxyExist(String objectNameStr) {
        try {
            ObjectName objName = new ObjectName(objectNameStr);
            return V3AMX.getInstance().getMbeanServerConnection().isRegistered(objName);
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static void getAmxRootInstance(HandlerContext handlerCtx) {
        handlerCtx.setOutputValue("amxRoot", (Object)V3AMX.getInstance());
    }
}

