/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.addressing.impl.policy;

import com.sun.xml.ws.addressing.impl.policy.LocalizationMessages;
import com.sun.xml.ws.api.addressing.AddressingVersion;
import com.sun.xml.ws.policy.AssertionSet;
import com.sun.xml.ws.policy.PolicyAssertion;
import com.sun.xml.ws.policy.privateutil.PolicyLogger;
import com.sun.xml.ws.policy.sourcemodel.AssertionData;
import com.sun.xml.ws.policy.spi.AssertionCreationException;
import com.sun.xml.ws.policy.spi.PolicyAssertionCreator;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.HashSet;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddressingPolicyAssertionCreator
implements PolicyAssertionCreator {
    private static HashSet<String> implementedAssertions = new HashSet();
    private static final String[] NS_SUPPORTED_LIST = new String[]{AddressingVersion.MEMBER.nsUri, AddressingVersion.W3C.nsUri};
    private static final PolicyLogger LOGGER = PolicyLogger.getLogger(AddressingPolicyAssertionCreator.class);

    @Override
    public String[] getSupportedDomainNamespaceURIs() {
        return NS_SUPPORTED_LIST;
    }

    protected Class<?> getClass(AssertionData assertionData) throws AssertionCreationException {
        LOGGER.entering(new Object[]{assertionData});
        try {
            String className = assertionData.getName().getLocalPart();
            Class<?> result = Class.forName("com.sun.xml.ws.addressing.impl.policy." + className);
            LOGGER.exiting();
            return result;
        }
        catch (ClassNotFoundException ex) {
            LOGGER.warning(LocalizationMessages.WSA_0001_UNKNOWN_ASSERTION(assertionData.toString()), ex);
            throw new AssertionCreationException(assertionData, (Throwable)ex);
        }
    }

    @Override
    public PolicyAssertion createAssertion(AssertionData assertionData, Collection<PolicyAssertion> nestedAssertions, AssertionSet nestedAlternative, PolicyAssertionCreator policyAssertionCreator) throws AssertionCreationException {
        String localName = assertionData.getName().getLocalPart();
        if (implementedAssertions.contains(localName)) {
            Class<?> cl = this.getClass(assertionData);
            Constructor<?> cons = null;
            try {
                cons = this.getConstructor(cl);
            }
            catch (NoSuchMethodException ex) {
                if (LOGGER.isLoggable(Level.SEVERE)) {
                    LOGGER.log(Level.SEVERE, LocalizationMessages.WSA_0002_ERROR_OBTAINING_CONSTRUCTOR(assertionData.getName()), ex);
                }
                throw new AssertionCreationException(assertionData, (Throwable)ex);
            }
            catch (SecurityException ex) {
                if (LOGGER.isLoggable(Level.SEVERE)) {
                    LOGGER.log(Level.SEVERE, LocalizationMessages.WSA_0002_ERROR_OBTAINING_CONSTRUCTOR(assertionData.getName()), ex);
                }
                throw new AssertionCreationException(assertionData, (Throwable)ex);
            }
            if (cons != null) {
                try {
                    return (PolicyAssertion)PolicyAssertion.class.cast(cons.newInstance(assertionData, nestedAssertions, nestedAlternative));
                }
                catch (IllegalArgumentException ex) {
                    if (LOGGER.isLoggable(Level.SEVERE)) {
                        LOGGER.log(Level.SEVERE, LocalizationMessages.WSA_0003_ERROR_INSTANTIATING(assertionData.getName()));
                    }
                    throw new AssertionCreationException(assertionData, (Throwable)ex);
                }
                catch (InvocationTargetException ex) {
                    if (LOGGER.isLoggable(Level.SEVERE)) {
                        LOGGER.log(Level.SEVERE, LocalizationMessages.WSA_0003_ERROR_INSTANTIATING(assertionData.getName()));
                    }
                    throw new AssertionCreationException(assertionData, (Throwable)ex);
                }
                catch (InstantiationException ex) {
                    if (LOGGER.isLoggable(Level.SEVERE)) {
                        LOGGER.log(Level.SEVERE, LocalizationMessages.WSA_0003_ERROR_INSTANTIATING(assertionData.getName()));
                    }
                    throw new AssertionCreationException(assertionData, (Throwable)ex);
                }
                catch (IllegalAccessException ex) {
                    if (LOGGER.isLoggable(Level.SEVERE)) {
                        LOGGER.log(Level.SEVERE, LocalizationMessages.WSA_0003_ERROR_INSTANTIATING(assertionData.getName()));
                    }
                    throw new AssertionCreationException(assertionData, (Throwable)ex);
                }
            }
            try {
                return (PolicyAssertion)cl.newInstance();
            }
            catch (InstantiationException ex) {
                if (LOGGER.isLoggable(Level.SEVERE)) {
                    LOGGER.log(Level.SEVERE, LocalizationMessages.WSA_0003_ERROR_INSTANTIATING(assertionData.getName()));
                }
                throw new AssertionCreationException(assertionData, (Throwable)ex);
            }
            catch (IllegalAccessException ex) {
                if (LOGGER.isLoggable(Level.SEVERE)) {
                    LOGGER.log(Level.SEVERE, LocalizationMessages.WSA_0003_ERROR_INSTANTIATING(assertionData.getName()));
                }
                throw new AssertionCreationException(assertionData, (Throwable)ex);
            }
        }
        return policyAssertionCreator.createAssertion(assertionData, nestedAssertions, nestedAlternative, policyAssertionCreator);
    }

    private <T> Constructor<T> getConstructor(Class<T> cl) throws NoSuchMethodException {
        return cl.getConstructor(AssertionData.class, Collection.class, AssertionSet.class);
    }

    static {
        implementedAssertions.add("Address");
        implementedAssertions.add("EndpointReference");
    }
}

