/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dbschema.jdbcimpl;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.TreeMap;
import org.netbeans.modules.dbschema.ColumnElement;
import org.netbeans.modules.dbschema.ColumnPairElement;
import org.netbeans.modules.dbschema.DBElement;
import org.netbeans.modules.dbschema.DBException;
import org.netbeans.modules.dbschema.DBIdentifier;
import org.netbeans.modules.dbschema.ForeignKeyElement;
import org.netbeans.modules.dbschema.IndexElement;
import org.netbeans.modules.dbschema.KeyElement;
import org.netbeans.modules.dbschema.SchemaElement;
import org.netbeans.modules.dbschema.TableElement;
import org.netbeans.modules.dbschema.UniqueKeyElement;
import org.netbeans.modules.dbschema.jdbcimpl.ColumnElementImpl;
import org.netbeans.modules.dbschema.jdbcimpl.ColumnPairElementImpl;
import org.netbeans.modules.dbschema.jdbcimpl.ConnectionProvider;
import org.netbeans.modules.dbschema.jdbcimpl.DBElementImpl;
import org.netbeans.modules.dbschema.jdbcimpl.DBElementsCollection;
import org.netbeans.modules.dbschema.jdbcimpl.DDLBridge;
import org.netbeans.modules.dbschema.jdbcimpl.ForeignKeyElementImpl;
import org.netbeans.modules.dbschema.jdbcimpl.IndexElementImpl;
import org.netbeans.modules.dbschema.jdbcimpl.UniqueKeyElementImpl;
import org.netbeans.modules.dbschema.util.IDEUtil;

public class TableElementImpl
extends DBElementImpl
implements TableElement.Impl {
    private DBElementsCollection columns = new DBElementsCollection(this, new ColumnElement[0]);
    private DBElementsCollection indexes;
    private DBElementsCollection keys;
    private transient DBElementsCollection columnPairs;
    private String table;
    private boolean isTable;

    public TableElementImpl() {
        this(null);
    }

    public TableElementImpl(String table) {
        super(table);
        String hc = String.valueOf(this.columns.hashCode());
        while (DBElementsCollection.instances.contains(hc)) {
            this.columns = new DBElementsCollection(this, new ColumnElement[0]);
            hc = String.valueOf(this.columns.hashCode());
        }
        DBElementsCollection.instances.add(hc);
        this.indexes = new DBElementsCollection(this, new IndexElement[0]);
        hc = String.valueOf(this.indexes.hashCode());
        while (DBElementsCollection.instances.contains(hc)) {
            this.indexes = new DBElementsCollection(this, new IndexElement[0]);
            hc = String.valueOf(this.indexes.hashCode());
        }
        DBElementsCollection.instances.add(hc);
        this.keys = new DBElementsCollection(this, new KeyElement[0]);
        hc = String.valueOf(this.keys.hashCode());
        while (DBElementsCollection.instances.contains(hc)) {
            this.keys = new DBElementsCollection(this, new KeyElement[0]);
            hc = String.valueOf(this.keys.hashCode());
        }
        DBElementsCollection.instances.add(hc);
        this.columnPairs = new DBElementsCollection(this, new ColumnPairElement[0]);
        hc = String.valueOf(this.columnPairs.hashCode());
        while (DBElementsCollection.instances.contains(hc)) {
            this.columnPairs = new DBElementsCollection(this, new ColumnPairElement[0]);
            hc = String.valueOf(this.columnPairs.hashCode());
        }
        DBElementsCollection.instances.add(hc);
        this.table = table;
    }

    public DBIdentifier getName() {
        if (this._name.getFullName() == null) {
            this._name.setFullName(((TableElement)this.element).getDeclaringSchema().getName().getFullName() + "." + this._name.getName());
        }
        return this._name;
    }

    public void setTableOrView(boolean isTable) throws DBException {
        this.isTable = isTable;
    }

    public boolean isTableOrView() {
        return this.isTable;
    }

    public void changeColumns(ColumnElement[] elems, int action) throws DBException {
        this.columns.changeElements(elems, action);
    }

    public ColumnElement[] getColumns() {
        DBElement[] dbe = this.columns.getElements();
        return Arrays.asList(dbe).toArray(new ColumnElement[dbe.length]);
    }

    public ColumnElement getColumn(DBIdentifier name) {
        return (ColumnElement)this.columns.find(name);
    }

    protected void initColumns(ConnectionProvider cp) {
        block18: {
            if (cp != null) {
                try {
                    ResultSet rs;
                    DatabaseMetaData dmd = cp.getDatabaseMetaData();
                    String shortTableName = this.getName().getName();
                    DDLBridge bridge = null;
                    if (IDEUtil.isIDERunning()) {
                        bridge = new DDLBridge(cp.getConnection(), cp.getSchema(), dmd);
                    }
                    if (bridge != null) {
                        bridge.getDriverSpecification().getColumns(shortTableName, "%");
                        rs = bridge.getDriverSpecification().getResultSet();
                    } else {
                        rs = dmd.getColumns(cp.getConnection().getCatalog(), cp.getSchema(), shortTableName, "%");
                    }
                    if (rs == null) break block18;
                    HashMap rset = new HashMap();
                    while (rs.next()) {
                        String colDec;
                        String colSize;
                        String colNull;
                        String colName;
                        String sqlTypeName;
                        int sqlType;
                        if (bridge != null) {
                            rset = bridge.getDriverSpecification().getRow();
                            Object type = rset.get(new Integer(5));
                            sqlType = type != null ? new Integer((String)rset.get(new Integer(5))) : 0;
                            sqlTypeName = (String)rset.get(new Integer(6));
                            colName = (String)rset.get(new Integer(4));
                            colNull = (String)rset.get(new Integer(11));
                            colSize = (String)rset.get(new Integer(7));
                            colDec = (String)rset.get(new Integer(9));
                            rset.clear();
                        } else {
                            sqlType = rs.getInt("DATA_TYPE");
                            sqlTypeName = rs.getString("TYPE_NAME").trim();
                            colName = rs.getString("COLUMN_NAME").trim();
                            colNull = Integer.toString(rs.getInt("NULLABLE"));
                            colSize = rs.getString("COLUMN_SIZE");
                            colDec = rs.getString("DECIMAL_DIGITS");
                        }
                        String dbProductName = dmd.getDatabaseProductName().trim();
                        if (dbProductName.indexOf("Oracle") != -1) {
                            if (sqlType == 11 || sqlType == 1111 && sqlTypeName.startsWith("TIMESTAMP")) {
                                sqlType = 93;
                            }
                            if (sqlType == 1111 && sqlTypeName.equals("FLOAT")) {
                                sqlType = 8;
                            }
                            if (sqlType == 1111 && sqlTypeName.equals("BLOB")) {
                                sqlType = 2004;
                            }
                            if (sqlType == 1111 && sqlTypeName.equals("CLOB")) {
                                sqlType = 2005;
                            }
                            if (sqlType == 1111 && sqlTypeName.equals("NVARCHAR2")) {
                                sqlType = 1;
                            }
                        }
                        if (dbProductName.indexOf("MySQL") != -1 && sqlType == 1111 && sqlTypeName.equalsIgnoreCase("BIT")) {
                            sqlType = -7;
                        }
                        try {
                            new Integer(colSize);
                        }
                        catch (NumberFormatException exc) {
                            colSize = Integer.toString(Integer.MAX_VALUE);
                        }
                        ColumnElementImpl cei = new ColumnElementImpl(colName, Integer.toString(sqlType), colNull, colSize, colDec);
                        ColumnElement ce = new ColumnElement(cei, (TableElement)this.element);
                        ColumnElement[] c = new ColumnElement[]{ce};
                        this.changeColumns(c, 1);
                    }
                    rs.close();
                }
                catch (Exception exc) {
                    if (!Boolean.getBoolean("netbeans.debug.exceptions")) break block18;
                    exc.printStackTrace();
                }
            }
        }
    }

    public void changeIndexes(IndexElement[] elems, int action) throws DBException {
        this.indexes.changeElements(elems, action);
    }

    public IndexElement[] getIndexes() {
        DBElement[] dbe = this.indexes.getElements();
        return Arrays.asList(dbe).toArray(new IndexElement[dbe.length]);
    }

    public IndexElement getIndex(DBIdentifier name) {
        return (IndexElement)this.indexes.find(name);
    }

    protected void initIndexes(ConnectionProvider cp) {
        this.initIndexes(cp, null);
    }

    protected void initIndexes(ConnectionProvider cp, String tbl) {
        block14: {
            if (cp != null) {
                try {
                    String name;
                    ResultSet rs;
                    DatabaseMetaData dmd = cp.getDatabaseMetaData();
                    String shortTableName = tbl == null ? this.getName().getName() : tbl;
                    DDLBridge bridge = null;
                    if (IDEUtil.isIDERunning()) {
                        bridge = new DDLBridge(cp.getConnection(), cp.getSchema(), dmd);
                    }
                    if (bridge != null) {
                        bridge.getDriverSpecification().getIndexInfo(shortTableName, false, true);
                        rs = bridge.getDriverSpecification().getResultSet();
                    } else {
                        rs = dmd.getIndexInfo(cp.getConnection().getCatalog(), cp.getSchema(), shortTableName, false, true);
                    }
                    LinkedList<String> idxs = new LinkedList<String>();
                    if (rs != null) {
                        HashMap rset = new HashMap();
                        while (rs.next()) {
                            boolean unq;
                            String columnName;
                            if (bridge != null) {
                                rset = bridge.getDriverSpecification().getRow();
                                name = (String)rset.get(new Integer(6));
                                columnName = (String)rset.get(new Integer(9));
                                String uniqueStr = (String)rset.get(new Integer(4));
                                unq = uniqueStr != null && !uniqueStr.equals("0") && !uniqueStr.equalsIgnoreCase("false") && !uniqueStr.equalsIgnoreCase("f");
                                rset.clear();
                            } else {
                                name = rs.getString("INDEX_NAME");
                                columnName = rs.getString("COLUMN_NAME");
                                if (columnName != null) {
                                    columnName = columnName.trim();
                                }
                                unq = rs.getBoolean("NON_UNIQUE");
                            }
                            if (columnName != null && columnName.length() >= 2 && columnName.startsWith("\"") && columnName.endsWith("\"")) {
                                columnName = columnName.substring(1, columnName.length() - 1);
                            }
                            if (name == null) continue;
                            name = name.trim();
                            if (unq) {
                                idxs.add(name + "." + columnName + ".false");
                                continue;
                            }
                            idxs.add(name + "." + columnName + ".true");
                        }
                        rs.close();
                    }
                    for (int i = 0; i < idxs.size(); ++i) {
                        String info = idxs.get(i).toString();
                        int start = info.indexOf(46);
                        int end = info.lastIndexOf(46);
                        name = info.substring(0, start);
                        boolean unique = info.substring(end + 1).equals("true");
                        if (this.indexes.find(DBIdentifier.create(name)) != null) continue;
                        IndexElementImpl iei = new IndexElementImpl(this, name, unique);
                        IndexElement[] ie = new IndexElement[]{new IndexElement(iei, (TableElement)this.element)};
                        iei.initColumns(idxs);
                        this.changeIndexes(ie, 1);
                    }
                }
                catch (Exception exc) {
                    if (!Boolean.getBoolean("netbeans.debug.exceptions")) break block14;
                    exc.printStackTrace();
                }
            }
        }
    }

    public void changeKeys(KeyElement[] elems, int action) throws DBException {
        this.keys.changeElements(elems, action);
    }

    public KeyElement[] getKeys() {
        DBElement[] dbe = this.keys.getElements();
        return Arrays.asList(dbe).toArray(new KeyElement[dbe.length]);
    }

    public KeyElement getKey(DBIdentifier name) {
        return (KeyElement)this.keys.find(name);
    }

    protected void initKeys(ConnectionProvider cp) {
        this.initKeys(cp, 0);
    }

    protected void initKeys(ConnectionProvider cp, int id) {
        this.initKeys(cp, id, null);
    }

    protected void initKeys(ConnectionProvider cp, int id, String tbl) {
        block6: {
            if (cp != null) {
                try {
                    boolean relatedTablesProvided;
                    String shortTableName = tbl == null ? this.getName().getName() : tbl;
                    DDLBridge bridge = null;
                    if (IDEUtil.isIDERunning()) {
                        bridge = new DDLBridge(cp.getConnection(), cp.getSchema(), cp.getDatabaseMetaData());
                    }
                    boolean bl = relatedTablesProvided = id != 3;
                    if (id != 1) {
                        this.initFKs(cp, bridge, shortTableName, relatedTablesProvided);
                    }
                    if (id != 2) {
                        this.initPK(cp, bridge, shortTableName);
                    }
                }
                catch (Exception exc) {
                    if (!Boolean.getBoolean("netbeans.debug.exceptions")) break block6;
                    exc.printStackTrace();
                }
            }
        }
    }

    private void initFKs(ConnectionProvider cp, DDLBridge bridge, String shortTableName, boolean expectRelatedTables) throws SQLException, DBException {
        ResultSet rs;
        if (bridge != null) {
            bridge.getDriverSpecification().getImportedKeys(shortTableName);
            rs = bridge.getDriverSpecification().getResultSet();
        } else {
            rs = cp.getDatabaseMetaData().getImportedKeys(cp.getConnection().getCatalog(), cp.getSchema(), shortTableName);
        }
        if (rs != null) {
            HashMap rset = new HashMap();
            while (rs.next()) {
                SchemaElement se;
                TableElement fte;
                String pkColName;
                String pkTableName;
                String fkColName;
                String name;
                String s2;
                String c2;
                String s1;
                String c1;
                if (bridge != null) {
                    rset = bridge.getDriverSpecification().getRow();
                    c1 = (String)rset.get(new Integer(1));
                    s1 = (String)rset.get(new Integer(2));
                    c2 = (String)rset.get(new Integer(5));
                    s2 = (String)rset.get(new Integer(6));
                    name = (String)rset.get(new Integer(12));
                    fkColName = (String)rset.get(new Integer(8));
                    pkTableName = (String)rset.get(new Integer(3));
                    pkColName = (String)rset.get(new Integer(4));
                    rset.clear();
                } else {
                    c1 = rs.getString("PKTABLE_CAT");
                    s1 = rs.getString("PKTABLE_SCHEM");
                    c2 = rs.getString("FKTABLE_CAT");
                    s2 = rs.getString("FKTABLE_SCHEM");
                    name = rs.getString("FK_NAME");
                    fkColName = rs.getString("FKCOLUMN_NAME").trim();
                    pkTableName = rs.getString("PKTABLE_NAME").trim();
                    pkColName = rs.getString("PKCOLUMN_NAME").trim();
                }
                if (!this.comp(c1, c2) || !this.comp(s1, s2)) continue;
                name = name == null || name.trim().equals("") ? "GENERATED_FK_" + pkTableName : name.trim();
                ColumnElement lce = this.getColumn(DBIdentifier.create(fkColName));
                if (lce == null || (fte = (se = ((TableElement)this.element).getDeclaringSchema()).getTable(DBIdentifier.create(pkTableName))) == null && !expectRelatedTables) continue;
                ColumnElement fce = fte.getColumn(DBIdentifier.create(pkColName));
                ColumnPairElementImpl cpei = new ColumnPairElementImpl(lce.getName().getFullName() + ";" + fce.getName().getFullName());
                ColumnPairElement cpe = new ColumnPairElement(cpei, lce, fce, (TableElement)this.element);
                this.changeColumnPairs(new ColumnPairElement[]{cpe}, 1);
                ForeignKeyElement fk = (ForeignKeyElement)this.keys.find(DBIdentifier.create(name));
                if (fk != null) {
                    fk.addColumnPair(cpe);
                    continue;
                }
                ForeignKeyElementImpl fkei = new ForeignKeyElementImpl(this, name);
                ForeignKeyElement fke = new ForeignKeyElement(fkei, (TableElement)this.element);
                fke.addColumnPair(cpe);
                this.changeKeys(new ForeignKeyElement[]{fke}, 1);
            }
            rs.close();
        }
    }

    private void initPK(ConnectionProvider cp, DDLBridge bridge, String shortTableName) throws SQLException, DBException {
        IndexElement[] iearr = this.getIndexes();
        if (iearr != null) {
            ResultSet rs;
            for (int i = 0; i < iearr.length; ++i) {
                if (!iearr[i].isUnique()) continue;
                UniqueKeyElementImpl ukei = new UniqueKeyElementImpl(iearr[i].getName().getName(), false);
                UniqueKeyElement uke = new UniqueKeyElement(ukei, (TableElement)this.element, iearr[i]);
                uke.setColumns(iearr[i].getColumns());
                this.changeKeys(new UniqueKeyElement[]{uke}, 1);
            }
            UniqueKeyElement[] ukes = ((TableElement)this.element).getUniqueKeys();
            if (bridge != null) {
                bridge.getDriverSpecification().getPrimaryKeys(shortTableName);
                rs = bridge.getDriverSpecification().getResultSet();
            } else {
                rs = cp.getDatabaseMetaData().getPrimaryKeys(cp.getConnection().getCatalog(), cp.getSchema(), shortTableName);
            }
            TreeMap<Object, String> cols = new TreeMap<Object, String>();
            if (rs != null) {
                HashMap rset = new HashMap();
                while (rs.next()) {
                    String colName;
                    Object keySeq;
                    if (bridge != null) {
                        rset = bridge.getDriverSpecification().getRow();
                        keySeq = rset.get(new Integer(5));
                        colName = (String)rset.get(new Integer(4));
                        rset.clear();
                    } else {
                        keySeq = rs.getObject("KEY_SEQ");
                        colName = rs.getString("COLUMN_NAME").trim();
                    }
                    cols.put(keySeq, colName);
                }
                rs.close();
            }
            boolean primary = false;
            if (cols != null && cols.size() > 0) {
                primary = true;
            }
            if (primary) {
                if (ukes == null || ukes.length == 0) {
                    String indexName = "primary_key_index";
                    int i = 1;
                    while (((TableElement)this.element).getIndex(DBIdentifier.create(indexName)) != null) {
                        indexName = indexName + i;
                        ++i;
                    }
                    LinkedList<String> idxs = new LinkedList<String>();
                    Iterator it = cols.values().iterator();
                    while (it.hasNext()) {
                        idxs.add(indexName + "." + it.next() + ".false");
                    }
                    IndexElementImpl iei = new IndexElementImpl(this, indexName, true);
                    IndexElement ie = new IndexElement(iei, (TableElement)this.element);
                    iei.initColumns(idxs);
                    this.changeIndexes(new IndexElement[]{ie}, 1);
                    UniqueKeyElementImpl ukei = new UniqueKeyElementImpl(ie.getName().getName(), true);
                    UniqueKeyElement uke = new UniqueKeyElement(ukei, (TableElement)this.element, ie);
                    uke.setColumns(ie.getColumns());
                    this.changeKeys(new UniqueKeyElement[]{uke}, 1);
                } else if (ukes.length == 1) {
                    ukes[0].setPrimaryKey(primary);
                } else {
                    Object[] o = cols.values().toArray();
                    for (int i = 0; i < ukes.length; ++i) {
                        ColumnElement[] ces = ukes[i].getColumns();
                        if (ces.length != o.length) continue;
                        boolean equals = true;
                        for (int j = 0; j < ces.length; ++j) {
                            if (o[j].toString().equals(ces[j].getName().getName())) continue;
                            equals = false;
                            break;
                        }
                        if (!equals) continue;
                        ukes[i].setPrimaryKey(primary);
                        break;
                    }
                }
            }
        }
    }

    public ColumnPairElement[] getColumnPairs() {
        DBElement[] dbe = this.columnPairs.getElements();
        return Arrays.asList(dbe).toArray(new ColumnPairElement[dbe.length]);
    }

    public ColumnPairElement getColumnPair(DBIdentifier name) {
        ColumnPairElement cpe = (ColumnPairElement)this.columnPairs.find(name);
        if (cpe == null) {
            try {
                String fullName = name.getFullName();
                if (fullName == null) {
                    return null;
                }
                int pos = fullName.indexOf(";");
                String firstHalf = fullName.substring(0, pos);
                String secondHalf = fullName.substring(pos + 1);
                ColumnElement lce = this.getColumn(DBIdentifier.create(firstHalf));
                pos = secondHalf.lastIndexOf(".");
                TableElement te = ((TableElement)this.element).getDeclaringSchema().getTable(DBIdentifier.create(secondHalf.substring(0, pos)));
                if (te == null) {
                    return null;
                }
                ColumnElement fce = te.getColumn(DBIdentifier.create(secondHalf));
                if (lce == null || fce == null) {
                    return null;
                }
                ColumnPairElementImpl cpei = new ColumnPairElementImpl(lce.getName().getFullName() + ";" + fce.getName().getFullName());
                cpe = new ColumnPairElement(cpei, lce, fce, (TableElement)this.element);
                this.changeColumnPairs(new ColumnPairElement[]{cpe}, 1);
            }
            catch (DBException exc) {
                exc.printStackTrace();
                return null;
            }
        }
        return cpe;
    }

    public void changeColumnPairs(ColumnPairElement[] pairs, int action) throws DBException {
        this.columnPairs.changeElements(pairs, action);
    }

    public DBElementsCollection getColumnCollection() {
        return this.columns;
    }

    public void setColumnCollection(DBElementsCollection collection) {
        this.columns = collection;
    }

    public DBElementsCollection getIndexCollection() {
        return this.indexes;
    }

    public void setIndexCollection(DBElementsCollection collection) {
        this.indexes = collection;
    }

    public DBElementsCollection getKeyCollection() {
        return this.keys;
    }

    public void setKeyCollection(DBElementsCollection collection) {
        this.keys = collection;
    }
}

