/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.iiop.security;

import com.sun.corba.ee.org.omg.CSIIOP.AS_ContextSec;
import com.sun.corba.ee.org.omg.CSIIOP.CompoundSecMech;
import com.sun.corba.ee.org.omg.CSIIOP.SAS_ContextSec;
import com.sun.corba.ee.org.omg.CSIIOP.TLS_SEC_TRANS;
import com.sun.corba.ee.org.omg.CSIIOP.TransportAddress;
import com.sun.corba.ee.spi.ior.IOR;
import com.sun.corba.ee.spi.ior.iiop.IIOPAddress;
import com.sun.corba.ee.spi.ior.iiop.IIOPProfileTemplate;
import com.sun.corba.ee.spi.transport.SocketInfo;
import com.sun.enterprise.common.iiop.security.AnonCredential;
import com.sun.enterprise.common.iiop.security.GSSUPName;
import com.sun.enterprise.common.iiop.security.SecurityContext;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbIORConfigurationDescriptor;
import com.sun.enterprise.iiop.security.CSIV2TaggedComponentInfo;
import com.sun.enterprise.iiop.security.ConnectionContext;
import com.sun.enterprise.iiop.security.ConnectionExecutionContext;
import com.sun.enterprise.iiop.security.GSSUtils;
import com.sun.enterprise.iiop.security.IORToSocketInfoImpl;
import com.sun.enterprise.iiop.security.InvalidIdentityTokenException;
import com.sun.enterprise.iiop.security.InvalidMechanismException;
import com.sun.enterprise.iiop.security.Lookups;
import com.sun.enterprise.iiop.security.SecServerRequestInterceptor;
import com.sun.enterprise.iiop.security.SecurityMechanismException;
import com.sun.enterprise.iiop.security.ServerConnectionContext;
import com.sun.enterprise.security.SecurityServicesUtil;
import com.sun.enterprise.security.auth.login.LoginContextDriver;
import com.sun.enterprise.security.auth.login.common.LoginException;
import com.sun.enterprise.security.auth.login.common.PasswordCredential;
import com.sun.enterprise.security.auth.login.common.X509CertificateCredential;
import com.sun.enterprise.security.auth.realm.Realm;
import com.sun.enterprise.security.common.ClientSecurityContext;
import com.sun.enterprise.security.ssl.SSLUtils;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.Utility;
import com.sun.logging.LogDomains;
import java.net.Socket;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import org.glassfish.api.admin.ProcessEnvironment;
import org.glassfish.api.invocation.ComponentInvocation;
import org.glassfish.api.invocation.InvocationManager;
import org.glassfish.enterprise.iiop.api.GlassFishORBHelper;
import org.glassfish.enterprise.iiop.api.ProtocolManager;
import org.ietf.jgss.Oid;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PostConstruct;
import org.jvnet.hk2.component.Singleton;
import org.omg.CORBA.ORB;
import sun.security.x509.X500Name;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
@Scoped(value=Singleton.class)
public final class SecurityMechanismSelector
implements PostConstruct {
    private static final Logger _logger = LogDomains.getLogger(SecurityMechanismSelector.class, (String)"javax.enterprise.system.core.security");
    public static final String CLIENT_CONNECTION_CONTEXT = "ClientConnContext";
    public static final String SERVER_CONNECTION_CONTEXT = "ServerConnContext";
    private Set corbaIORDescSet = null;
    private boolean sslRequired = false;
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(SecServerRequestInterceptor.class);
    private ProtocolManager protocolMgr = null;
    private SSLUtils sslUtils = null;
    private GlassFishORBHelper orbHelper;
    private ORB orb = null;
    private CSIV2TaggedComponentInfo ctc = null;
    private InvocationManager invMgr = null;
    @Inject
    private Habitat habitat;
    @Inject
    private ProcessEnvironment processEnv;
    private static final String traceIORsProperty = "com.sun.enterprise.iiop.security.traceIORS";
    private static final boolean _traceIORs = Boolean.getBoolean("com.sun.enterprise.iiop.security.traceIORS");
    private static final Hashtable<Integer, String> assocOptions = new Hashtable();
    private static final Hashtable<Integer, String> identityTokenTypes;

    @Override
    public void postConstruct() {
        try {
            String clientAuthReq;
            this.orbHelper = Lookups.getGlassFishORBHelper(this.habitat);
            this.sslUtils = this.habitat.getComponent(SSLUtils.class);
            this.invMgr = this.habitat.getComponent(InvocationManager.class);
            String s = this.orbHelper.getCSIv2Props().getProperty("com.sun.CSIV2.ssl.client.required");
            if (s != null && s.equals("true")) {
                this.sslRequired = true;
            }
            this.corbaIORDescSet = new HashSet();
            EjbIORConfigurationDescriptor iorDesc = new EjbIORConfigurationDescriptor();
            EjbIORConfigurationDescriptor iorDesc2 = new EjbIORConfigurationDescriptor();
            String serverSslReqd = this.orbHelper.getCSIv2Props().getProperty("com.sun.CSIV2.ssl.server.required");
            if (serverSslReqd != null && serverSslReqd.equals("true")) {
                iorDesc.setIntegrity("REQUIRED");
                iorDesc.setConfidentiality("REQUIRED");
                iorDesc2.setIntegrity("REQUIRED");
                iorDesc2.setConfidentiality("REQUIRED");
            }
            if ((clientAuthReq = this.orbHelper.getCSIv2Props().getProperty("com.sun.CSIV2.client.auth.required")) != null && clientAuthReq.equals("true")) {
                iorDesc.setEstablishTrustInClient("REQUIRED");
                iorDesc2.setAuthMethodRequired(true);
                this.getCorbaIORDescSet().add(iorDesc2);
            }
            this.getCorbaIORDescSet().add(iorDesc);
        }
        catch (Exception e) {
            _logger.log(Level.SEVERE, "iiop.Exception", e);
        }
    }

    public static ServerConnectionContext getServerConnectionContext() {
        Hashtable h = ConnectionExecutionContext.getContext();
        ServerConnectionContext scc = (ServerConnectionContext)h.get(SERVER_CONNECTION_CONTEXT);
        return scc;
    }

    public static void setServerConnectionContext(ServerConnectionContext scc) {
        Hashtable h = ConnectionExecutionContext.getContext();
        h.put(SERVER_CONNECTION_CONTEXT, scc);
    }

    public ConnectionContext getClientConnectionContext() {
        Hashtable h = ConnectionExecutionContext.getContext();
        ConnectionContext scc = (ConnectionContext)h.get(CLIENT_CONNECTION_CONTEXT);
        return scc;
    }

    public void setClientConnectionContext(ConnectionContext scc) {
        Hashtable h = ConnectionExecutionContext.getContext();
        h.put(CLIENT_CONNECTION_CONTEXT, scc);
    }

    public SocketInfo getSSLPort(IOR ior, ConnectionContext ctx) {
        SocketInfo info = null;
        CompoundSecMech mechanism = null;
        try {
            mechanism = this.selectSecurityMechanism(ior);
        }
        catch (SecurityMechanismException sme) {
            throw new RuntimeException(sme.getMessage());
        }
        ctx.setIOR(ior);
        ctx.setMechanism(mechanism);
        TLS_SEC_TRANS ssl = null;
        if (mechanism != null) {
            ssl = this.getCtc().getSSLInformation(mechanism);
        }
        if (ssl == null) {
            if (this.isSslRequired()) {
                IIOPProfileTemplate templ = (IIOPProfileTemplate)ior.getProfile().getTaggedProfileTemplate();
                IIOPAddress addr = templ.getPrimaryAddress();
                info = IORToSocketInfoImpl.createSocketInfo("SecurityMechanismSelector1", "SSL", addr.getHost(), this.orbHelper.getORBPort(this.orbHelper.getORB()));
                return info;
            }
            return null;
        }
        short targetRequires = ssl.target_requires;
        short targetSupports = ssl.target_supports;
        if (SecurityMechanismSelector.isSet(targetRequires, 2) || SecurityMechanismSelector.isSet(targetRequires, 4) || SecurityMechanismSelector.isSet(targetRequires, 64)) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "Target requires SSL");
            }
            ctx.setSSLUsed(true);
            String type = "SSL";
            if (SecurityMechanismSelector.isSet(targetRequires, 64)) {
                type = "SSL_MUTUALAUTH";
                ctx.setSSLClientAuthenticationOccurred(true);
            }
            short sslport = ssl.addresses[0].port;
            int ssl_port = Utility.shortToInt((short)sslport);
            String host_name = ssl.addresses[0].host_name;
            info = IORToSocketInfoImpl.createSocketInfo("SecurityMechanismSelector2", type, host_name, ssl_port);
            return info;
        }
        if (SecurityMechanismSelector.isSet(targetSupports, 2) || SecurityMechanismSelector.isSet(targetSupports, 4) || SecurityMechanismSelector.isSet(targetSupports, 64)) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "Target supports SSL");
            }
            if (this.isSslRequired()) {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, "Client is configured to require SSL for the target");
                }
                ctx.setSSLUsed(true);
                short sslport = ssl.addresses[0].port;
                String host_name = ssl.addresses[0].host_name;
                int ssl_port = Utility.shortToInt((short)sslport);
                info = IORToSocketInfoImpl.createSocketInfo("SecurityMechanismSelector3", "SSL", host_name, ssl_port);
                return info;
            }
            return null;
        }
        if (this.isSslRequired()) {
            throw new RuntimeException("SSL required by client but not supported by server.");
        }
        return null;
    }

    public ORB getOrb() {
        return this.orb;
    }

    public void setOrb(ORB val) {
        this.orb = val;
    }

    public synchronized CSIV2TaggedComponentInfo getCtc() {
        if (this.ctc == null) {
            this.ctc = new CSIV2TaggedComponentInfo(this.orbHelper.getORB(), this.habitat);
        }
        return this.ctc;
    }

    public List<SocketInfo> getSSLPorts(IOR ior, ConnectionContext ctx) {
        CompoundSecMech mechanism = null;
        try {
            mechanism = this.selectSecurityMechanism(ior);
        }
        catch (SecurityMechanismException sme) {
            throw new RuntimeException(sme.getMessage());
        }
        ctx.setIOR(ior);
        ctx.setMechanism(mechanism);
        TLS_SEC_TRANS ssl = null;
        if (mechanism != null) {
            ssl = this.getCtc().getSSLInformation(mechanism);
        }
        if (ssl == null) {
            if (this.isSslRequired()) {
                IIOPProfileTemplate templ = (IIOPProfileTemplate)ior.getProfile().getTaggedProfileTemplate();
                IIOPAddress addr = templ.getPrimaryAddress();
                SocketInfo info = IORToSocketInfoImpl.createSocketInfo("SecurityMechanismSelector1", "SSL", addr.getHost(), this.orbHelper.getORBPort(this.orbHelper.getORB()));
                ArrayList<SocketInfo> sInfos = new ArrayList<SocketInfo>();
                sInfos.add(info);
                return sInfos;
            }
            return null;
        }
        short targetRequires = ssl.target_requires;
        short targetSupports = ssl.target_supports;
        if (SecurityMechanismSelector.isSet(targetRequires, 2) || SecurityMechanismSelector.isSet(targetRequires, 4) || SecurityMechanismSelector.isSet(targetRequires, 64)) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "Target requires SSL");
            }
            ctx.setSSLUsed(true);
            String type = "SSL";
            if (SecurityMechanismSelector.isSet(targetRequires, 64)) {
                type = "SSL_MUTUALAUTH";
                ctx.setSSLClientAuthenticationOccurred(true);
            }
            ArrayList<SocketInfo> socketInfos = new ArrayList<SocketInfo>();
            for (int addressIndex = 0; addressIndex < ssl.addresses.length; ++addressIndex) {
                short sslport = ssl.addresses[addressIndex].port;
                int ssl_port = Utility.shortToInt((short)sslport);
                String host_name = ssl.addresses[addressIndex].host_name;
                SocketInfo sInfo = IORToSocketInfoImpl.createSocketInfo("SecurityMechanismSelector2", type, host_name, ssl_port);
                socketInfos.add(sInfo);
            }
            return socketInfos;
        }
        if (SecurityMechanismSelector.isSet(targetSupports, 2) || SecurityMechanismSelector.isSet(targetSupports, 4) || SecurityMechanismSelector.isSet(targetSupports, 64)) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "Target supports SSL");
            }
            if (this.isSslRequired()) {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, "Client is configured to require SSL for the target");
                }
                ctx.setSSLUsed(true);
                ArrayList<SocketInfo> socketInfos = new ArrayList<SocketInfo>();
                for (int addressIndex = 0; addressIndex < ssl.addresses.length; ++addressIndex) {
                    short sslport = ssl.addresses[addressIndex].port;
                    int ssl_port = Utility.shortToInt((short)sslport);
                    String host_name = ssl.addresses[addressIndex].host_name;
                    SocketInfo sInfo = IORToSocketInfoImpl.createSocketInfo("SecurityMechanismSelector3", "SSL", host_name, ssl_port);
                    socketInfos.add(sInfo);
                }
                return socketInfos;
            }
            return null;
        }
        if (this.isSslRequired()) {
            throw new RuntimeException("SSL required by client but not supported by server.");
        }
        return null;
    }

    public SecurityContext selectSecurityContext(IOR ior) throws InvalidIdentityTokenException, InvalidMechanismException, SecurityMechanismException {
        SecurityContext context = null;
        ConnectionContext cc = new ConnectionContext();
        if (SecurityMechanismSelector.traceIORs()) {
            _logger.info("\nCSIv2 Mechanism List:" + this.getSecurityMechanismString(this.ctc, ior));
        }
        this.getSSLPort(ior, cc);
        this.setClientConnectionContext(cc);
        CompoundSecMech mechanism = cc.getMechanism();
        if (mechanism == null) {
            return null;
        }
        boolean sslUsed = cc.getSSLUsed();
        boolean clientAuthOccurred = cc.getSSLClientAuthenticationOccurred();
        if (this.isNotServerOrACC()) {
            context = this.getSecurityContextForAppClient(null, sslUsed, clientAuthOccurred, mechanism);
            return context;
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "SSL used:" + sslUsed + " SSL Mutual auth:" + clientAuthOccurred);
        }
        ComponentInvocation ci = null;
        context = this.isACC() ? this.getSecurityContextForAppClient(ci, sslUsed, clientAuthOccurred, mechanism) : this.getSecurityContextForWebOrEJB(ci, sslUsed, clientAuthOccurred, mechanism);
        return context;
    }

    public SecurityContext getSecurityContextForAppClient(ComponentInvocation ci, boolean sslUsed, boolean clientAuthOccurred, CompoundSecMech mechanism) throws InvalidMechanismException, InvalidIdentityTokenException, SecurityMechanismException {
        return this.sendUsernameAndPassword(ci, sslUsed, clientAuthOccurred, mechanism);
    }

    public SecurityContext getSecurityContextForWebOrEJB(ComponentInvocation ci, boolean sslUsed, boolean clientAuthOccurred, CompoundSecMech mechanism) throws InvalidMechanismException, InvalidIdentityTokenException, SecurityMechanismException {
        SecurityContext ctx = null;
        ctx = !sslUsed ? this.propagateIdentity(false, ci, mechanism) : this.propagateIdentity(clientAuthOccurred, ci, mechanism);
        return ctx;
    }

    Object getSSLSocketInfo(Object ior) {
        ConnectionContext ctx = new ConnectionContext();
        List<SocketInfo> socketInfo = this.getSSLPorts((IOR)ior, ctx);
        this.setClientConnectionContext(ctx);
        return socketInfo;
    }

    private boolean isMechanismSupported(SAS_ContextSec sas) {
        byte[][] mechanisms = sas.supported_naming_mechanisms;
        byte[] mechSupported = GSSUtils.getMechanism();
        if (mechSupported == null) {
            return false;
        }
        if (mechanisms[0].length != mechSupported.length) {
            return false;
        }
        for (int i = 0; i < mechanisms[0].length; ++i) {
            if (mechanisms[0][i] == mechSupported[i]) continue;
            return false;
        }
        return true;
    }

    public boolean isIdentityTypeSupported(SAS_ContextSec sas) {
        int ident_token = sas.supported_identity_types;
        int value = ident_token & 0xF;
        return value != 0;
    }

    private SecurityContext sendUsernameAndPassword(ComponentInvocation ci, boolean sslUsed, boolean clientAuthOccurred, CompoundSecMech mechanism) throws SecurityMechanismException {
        SecurityContext ctx = null;
        if (mechanism == null) {
            return null;
        }
        AS_ContextSec asContext = mechanism.as_context_mech;
        if (SecurityMechanismSelector.isSet(asContext.target_requires, 64) || SecurityMechanismSelector.isSet(mechanism.target_requires, 64) && !clientAuthOccurred) {
            ctx = this.getUsernameAndPassword(ci, mechanism);
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "Sending Username/Password");
            }
        } else {
            return null;
        }
        return ctx;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private SecurityContext propagateIdentity(boolean clientAuth, ComponentInvocation ci, CompoundSecMech mechanism) throws InvalidIdentityTokenException, InvalidMechanismException, SecurityMechanismException {
        SecurityContext ctx = null;
        if (mechanism == null) {
            return null;
        }
        AS_ContextSec asContext = mechanism.as_context_mech;
        SAS_ContextSec sasContext = mechanism.sas_context_mech;
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "SAS CONTEXT's target_requires=" + sasContext.target_requires);
            _logger.log(Level.FINE, "SAS CONTEXT's target_supports=" + sasContext.target_supports);
        }
        if (SecurityMechanismSelector.isSet(asContext.target_requires, 64)) {
            ctx = this.getUsernameAndPassword(ci, mechanism);
            if (ctx.authcls != null) return ctx;
            String errmsg = localStrings.getLocalString("securitymechansimselector.runas_cannot_propagate_username_password", "Cannot propagate username/password required by target when using run as identity");
            _logger.log(Level.SEVERE, "iiop.runas_error", errmsg);
            throw new SecurityMechanismException(errmsg);
        }
        if (SecurityMechanismSelector.isSet(sasContext.target_supports, 1024) || SecurityMechanismSelector.isSet(sasContext.target_requires, 1024)) {
            if (!this.isIdentityTypeSupported(sasContext)) {
                String errmsg = localStrings.getLocalString("securitymechanismselector.invalid_identity_type", "The given identity token is unsupported.");
                throw new InvalidIdentityTokenException(errmsg);
            }
            if (sasContext.target_supports != 1024) return this.getIdentity();
            if (this.isMechanismSupported(sasContext)) return this.getIdentity();
            String errmsg = localStrings.getLocalString("securitymechanismselector.invalid_mechanism", "The given mechanism type is unsupported.");
            _logger.log(Level.SEVERE, "iiop.unsupported_type_error", errmsg);
            throw new InvalidMechanismException(errmsg);
        }
        if (!SecurityMechanismSelector.isSet(asContext.target_supports, 64)) return null;
        if (!clientAuth) return null;
        ctx = this.getUsernameAndPassword(ci, mechanism);
        if (ctx.authcls != null) return ctx;
        return null;
    }

    private SecurityContext getUsernameAndPassword(ComponentInvocation ci, CompoundSecMech mechanism) throws SecurityMechanismException {
        try {
            ClientSecurityContext sc;
            Subject s = null;
            if (this.isNotServerOrACC()) {
                sc = ClientSecurityContext.getCurrent();
                if (sc == null) {
                    return null;
                }
                s = sc.getSubject();
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, "SUBJECT:" + s);
                }
            } else {
                s = this.isACC() ? ((sc = ClientSecurityContext.getCurrent()) == null ? LoginContextDriver.doClientLogin((int)1, (CallbackHandler)SecurityServicesUtil.getInstance().getCallbackHandler()) : sc.getSubject()) : this.getSubjectFromSecurityCurrent();
            }
            SecurityContext ctx = new SecurityContext();
            final Subject sub = s;
            ctx.subject = s;
            Set privateCredSet = (Set)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return sub.getPrivateCredentials();
                }
            });
            if (privateCredSet.isEmpty()) {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, "no private credential run as mode");
                }
                ctx.authcls = null;
                ctx.identcls = GSSUPName.class;
            } else {
                AS_ContextSec asContext = mechanism.as_context_mech;
                byte[] target_name = asContext.target_name;
                byte[] _realm = null;
                _realm = target_name == null || target_name.length == 0 ? Realm.getDefaultRealm().getBytes() : GSSUtils.importName(GSSUtils.GSSUP_MECH_OID, target_name);
                final String realm_name = new String(_realm);
                final Iterator it = privateCredSet.iterator();
                while (it.hasNext()) {
                    AccessController.doPrivileged(new PrivilegedAction(){

                        public Object run() {
                            PasswordCredential pc = (PasswordCredential)it.next();
                            pc.setRealm(realm_name);
                            return null;
                        }
                    });
                }
                ctx.authcls = PasswordCredential.class;
            }
            return ctx;
        }
        catch (LoginException le) {
            throw le;
        }
        catch (Exception e) {
            _logger.log(Level.SEVERE, "iiop.user_password_exception", e);
            return null;
        }
    }

    private SecurityContext getIdentity() throws SecurityMechanismException {
        Subject s;
        SecurityContext ctx;
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Getting PRINCIPAL/DN from TLS");
        }
        final SecurityContext sCtx = ctx = new SecurityContext();
        com.sun.enterprise.security.SecurityContext scontext = com.sun.enterprise.security.SecurityContext.getCurrent();
        if (scontext == null || scontext.didServerGenerateCredentials()) {
            sCtx.identcls = AnonCredential.class;
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    Subject sub;
                    sCtx.subject = sub = new Subject();
                    sCtx.subject.getPublicCredentials().add(new AnonCredential());
                    return null;
                }
            });
            return sCtx;
        }
        ctx.subject = s = this.getSubjectFromSecurityCurrent();
        final Subject sub = s;
        Set<Object> credSet = (Set<Object>)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return sub.getPrivateCredentials(PasswordCredential.class);
            }
        });
        if (credSet.size() == 1) {
            Subject subj;
            ctx.identcls = GSSUPName.class;
            final Set<Object> cs = credSet;
            ctx.subject = subj = (Subject)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    Subject ss = new Subject();
                    Iterator iter = cs.iterator();
                    PasswordCredential pc = (PasswordCredential)iter.next();
                    GSSUPName gssname = new GSSUPName(pc.getUser(), pc.getRealm());
                    ss.getPublicCredentials().add(gssname);
                    return ss;
                }
            });
            return ctx;
        }
        credSet = s.getPublicCredentials();
        if (credSet.size() != 1) {
            _logger.log(Level.SEVERE, "iiop.principal_error");
            return null;
        }
        Iterator<Object> credIter = credSet.iterator();
        if (credIter.hasNext()) {
            Object o = credIter.next();
            ctx.identcls = o instanceof GSSUPName ? GSSUPName.class : (o instanceof X500Name ? X500Name.class : X509CertificateCredential.class);
        } else {
            _logger.log(Level.SEVERE, "iiop.credential_error");
            return null;
        }
        return ctx;
    }

    private Subject getSubjectFromSecurityCurrent() throws SecurityMechanismException {
        com.sun.enterprise.security.SecurityContext sc = null;
        sc = com.sun.enterprise.security.SecurityContext.getCurrent();
        if (sc == null) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, " SETTING GUEST ---");
            }
            sc = com.sun.enterprise.security.SecurityContext.init();
        }
        if (sc == null) {
            throw new SecurityMechanismException("Could not find  security information");
        }
        Subject s = sc.getSubject();
        if (s == null) {
            throw new SecurityMechanismException("Could not find  subject information in the security context.");
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Subject in security current:" + s);
        }
        return s;
    }

    public CompoundSecMech selectSecurityMechanism(IOR ior) throws SecurityMechanismException {
        CompoundSecMech[] mechList = this.getCtc().getSecurityMechanisms(ior);
        CompoundSecMech mech = this.selectSecurityMechanism(mechList);
        return mech;
    }

    private CompoundSecMech selectSecurityMechanism(CompoundSecMech[] mechList) throws SecurityMechanismException {
        if (mechList == null || mechList.length == 0) {
            return null;
        }
        CompoundSecMech mech = null;
        for (int i = 0; i < mechList.length; ++i) {
            mech = mechList[i];
            boolean useMech = this.useMechanism(mech);
            if (!useMech) continue;
            return mech;
        }
        throw new SecurityMechanismException("Cannot use any of the  target's supported mechanisms");
    }

    private boolean useMechanism(CompoundSecMech mech) {
        boolean val = true;
        TLS_SEC_TRANS tls = this.getCtc().getSSLInformation(mech);
        if (tls == null) {
            return true;
        }
        short targetRequires = tls.target_requires;
        if (SecurityMechanismSelector.isSet(targetRequires, 64) && !this.sslUtils.isKeyAvailable()) {
            val = false;
        }
        return val;
    }

    private byte[] getTargetName(Subject subj) {
        byte[] tgt_name = new byte[]{};
        final Subject sub = subj;
        final Set credset = (Set)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return sub.getPrivateCredentials(PasswordCredential.class);
            }
        });
        if (credset.size() == 1) {
            tgt_name = (byte[])AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    Iterator iter = credset.iterator();
                    PasswordCredential pc = (PasswordCredential)iter.next();
                    return pc.getTargetName();
                }
            });
        }
        return tgt_name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean evaluate_client_conformance_ssl(EjbIORConfigurationDescriptor iordesc, boolean ssl_used, X509Certificate[] certchain) {
        try {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "SecurityMechanismSelector.evaluate_client_conformance_ssl->:");
            }
            boolean ssl_required = false;
            boolean ssl_supported = false;
            int ssl_target_requires = 0;
            int ssl_target_supports = 0;
            ssl_target_requires = this.getCtc().getTargetRequires(iordesc);
            ssl_target_supports = this.getCtc().getTargetSupports(iordesc);
            ssl_required = SecurityMechanismSelector.isSet(ssl_target_requires, 2) || SecurityMechanismSelector.isSet(ssl_target_requires, 4) || SecurityMechanismSelector.isSet(ssl_target_requires, 64);
            ssl_supported = ssl_target_supports != 0;
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "SecurityMechanismSelector.evaluate_client_conformance_ssl: " + SecurityMechanismSelector.isSet(ssl_target_requires, 2) + " " + SecurityMechanismSelector.isSet(ssl_target_requires, 4) + " " + SecurityMechanismSelector.isSet(ssl_target_requires, 64) + " " + ssl_required + " " + ssl_supported + " " + ssl_used);
            }
            if (ssl_used) {
                if (!ssl_required && !ssl_supported) {
                    boolean bl = false;
                    return bl;
                }
            } else if (ssl_required) {
                boolean bl = false;
                return bl;
            }
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "SecurityMechanismSelector.evaluate_client_conformance_ssl: " + certchain + " " + SecurityMechanismSelector.isSet(ssl_target_requires, 64) + " " + SecurityMechanismSelector.isSet(ssl_target_supports, 64));
            }
            if (certchain != null) {
                if (!SecurityMechanismSelector.isSet(ssl_target_requires, 64) && !SecurityMechanismSelector.isSet(ssl_target_supports, 64)) {
                    boolean bl = false;
                    return bl;
                }
            } else if (SecurityMechanismSelector.isSet(ssl_target_requires, 64)) {
                boolean bl = false;
                return bl;
            }
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "SecurityMechanismSelector.evaluate_client_conformance_ssl: true");
            }
            boolean bl = true;
            return bl;
        }
        finally {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "SecurityMechanismSelector.evaluate_client_conformance_ssl<-:");
            }
        }
    }

    private boolean evaluate_client_conformance_ascontext(SecurityContext ctx, EjbIORConfigurationDescriptor iordesc, String realmName) {
        boolean client_authenticated = false;
        AS_ContextSec ascontext = null;
        try {
            ascontext = this.getCtc().createASContextSec(iordesc, realmName);
        }
        catch (Exception e) {
            _logger.log(Level.SEVERE, "iiop.createcontextsec_exception", e);
            return false;
        }
        if (ascontext == null) {
            return false;
        }
        client_authenticated = ctx != null && ctx.authcls != null && ctx.subject != null;
        if (client_authenticated) {
            if (!SecurityMechanismSelector.isSet(ascontext.target_requires, 64) && !SecurityMechanismSelector.isSet(ascontext.target_supports, 64)) {
                return false;
            }
            byte[] client_tgtname = this.getTargetName(ctx.subject);
            if (ascontext.target_name.length != client_tgtname.length) {
                return false;
            }
            for (int i = 0; i < ascontext.target_name.length; ++i) {
                if (ascontext.target_name[i] == client_tgtname[i]) continue;
                return false;
            }
        } else if (SecurityMechanismSelector.isSet(ascontext.target_requires, 64)) {
            return false;
        }
        return true;
    }

    private boolean evaluate_client_conformance_sascontext(SecurityContext ctx, EjbIORConfigurationDescriptor iordesc) {
        boolean caller_propagated = false;
        SAS_ContextSec sascontext = null;
        try {
            sascontext = this.getCtc().createSASContextSec(iordesc);
        }
        catch (Exception e) {
            _logger.log(Level.SEVERE, "iiop.createcontextsec_exception", e);
            return false;
        }
        if (sascontext == null) {
            return false;
        }
        caller_propagated = ctx != null && ctx.identcls != null && ctx.subject != null;
        if (caller_propagated) {
            return SecurityMechanismSelector.isSet(sascontext.target_supports, 1024);
        }
        return true;
    }

    private boolean evaluate_client_conformance(SecurityContext ctx, byte[] object_id, boolean ssl_used, X509Certificate[] certchain) {
        if (object_id == null) {
            return true;
        }
        if (this.protocolMgr == null) {
            this.protocolMgr = this.orbHelper.getProtocolManager();
        }
        if (this.protocolMgr == null) {
            return true;
        }
        EjbDescriptor ejbDesc = this.protocolMgr.getEjbDescriptor(object_id);
        Set iorDescSet = null;
        iorDescSet = ejbDesc != null ? ejbDesc.getIORConfigurationDescriptors() : this.getCorbaIORDescSet();
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "SecurityMechanismSelector.evaluate_client_conformance: iorDescSet: " + iorDescSet);
        }
        if (iorDescSet.isEmpty()) {
            return true;
        }
        boolean checkSkipped = false;
        for (EjbIORConfigurationDescriptor iorDesc : iorDescSet) {
            if (this.skip_client_conformance(iorDesc)) {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, "SecurityMechanismSelector.evaluate_client_conformance: skip_client_conformance");
                }
                checkSkipped = true;
                continue;
            }
            if (!this.evaluate_client_conformance_ssl(iorDesc, ssl_used, certchain)) {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, "SecurityMechanismSelector.evaluate_client_conformance: evaluate_client_conformance_ssl");
                }
                checkSkipped = false;
                continue;
            }
            String realmName = "default";
            if (ejbDesc != null && ejbDesc.getApplication() != null) {
                realmName = ejbDesc.getApplication().getRealm();
            }
            if (realmName == null) {
                realmName = iorDesc.getRealmName();
            }
            if (realmName == null) {
                realmName = "default";
            }
            if (!this.evaluate_client_conformance_ascontext(ctx, iorDesc, realmName)) {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, "SecurityMechanismSelector.evaluate_client_conformance: evaluate_client_conformance_ascontext");
                }
                checkSkipped = false;
                continue;
            }
            if (!this.evaluate_client_conformance_sascontext(ctx, iorDesc)) {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, "SecurityMechanismSelector.evaluate_client_conformance: evaluate_client_conformance_sascontext");
                }
                checkSkipped = false;
                continue;
            }
            return true;
        }
        return checkSkipped;
    }

    private boolean skip_client_conformance(EjbIORConfigurationDescriptor ior) {
        String none = "NONE";
        if (ior == null) {
            return false;
        }
        if (!none.equalsIgnoreCase(ior.getIntegrity())) {
            return false;
        }
        if (!none.equalsIgnoreCase(ior.getConfidentiality())) {
            return false;
        }
        if (!none.equalsIgnoreCase(ior.getEstablishTrustInClient())) {
            return false;
        }
        if (ior.isAuthMethodRequired()) {
            return false;
        }
        return none.equalsIgnoreCase(ior.getCallerPropagation());
    }

    public SecurityContext evaluateTrust(SecurityContext ctx, byte[] object_id) throws SecurityMechanismException {
        X509Certificate[] certChain;
        boolean ssl_used;
        Socket socket;
        SecurityContext ssc;
        block11: {
            ssc = null;
            socket = null;
            ssl_used = false;
            certChain = null;
            ServerConnectionContext scc = SecurityMechanismSelector.getServerConnectionContext();
            if (scc != null && (socket = scc.getSocket()) != null && socket instanceof SSLSocket) {
                ssl_used = true;
                SSLSocket sslSock = (SSLSocket)socket;
                SSLSession sslSession = sslSock.getSession();
                try {
                    certChain = (X509Certificate[])sslSession.getPeerCertificates();
                }
                catch (Exception e) {
                    if (!_logger.isLoggable(Level.FINE)) break block11;
                    _logger.log(Level.FINE, "iiop.cannot_get_peercert", e);
                }
            }
        }
        if (socket == null && ctx == null) {
            return null;
        }
        if (!this.evaluate_client_conformance(ctx, object_id, ssl_used, certChain)) {
            String msg = "Trust evaluation failed because ";
            msg = msg + "client does not conform to configured security policies";
            throw new SecurityMechanismException(msg);
        }
        if (ctx == null) {
            if (socket == null || !ssl_used || certChain == null) {
                return null;
            }
            ssc = new SecurityContext();
            X500Name x500Name = (X500Name)certChain[0].getSubjectDN();
            ssc.subject = new Subject();
            ssc.subject.getPublicCredentials().add(x500Name);
            ssc.identcls = X500Name.class;
            ssc.authcls = null;
            return ssc;
        }
        ssc = ctx;
        Class authCls = ctx.authcls;
        Class identCls = ctx.identcls;
        ssc.subject = ctx.subject;
        ssc.authcls = null;
        ssc.identcls = null;
        if (identCls != null) {
            ssc.identcls = identCls;
        } else if (authCls != null) {
            ssc.authcls = authCls;
        } else {
            ssc.identcls = AnonCredential.class;
        }
        return ssc;
    }

    private static boolean isSet(int val1, int val2) {
        return (val1 & val2) == val2;
    }

    public Set getCorbaIORDescSet() {
        return this.corbaIORDescSet;
    }

    public boolean isSslRequired() {
        return this.sslRequired;
    }

    private boolean isNotServerOrACC() {
        return this.processEnv.getProcessType().equals((Object)ProcessEnvironment.ProcessType.Other);
    }

    private boolean isACC() {
        return this.processEnv.getProcessType().equals((Object)ProcessEnvironment.ProcessType.ACC);
    }

    public static boolean traceIORs() {
        return _traceIORs;
    }

    public String getSecurityMechanismString(CSIV2TaggedComponentInfo tCI, IOR ior) {
        String typeId = ior.getTypeId();
        CompoundSecMech[] mechList = tCI.getSecurityMechanisms(ior);
        return SecurityMechanismSelector.getSecurityMechanismString(tCI, mechList, typeId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getSecurityMechanismString(CSIV2TaggedComponentInfo tCI, CompoundSecMech[] list, String name) {
        StringBuffer b = new StringBuffer();
        b.append("\ntypeId: " + name == null ? "null" : name);
        try {
            for (int i = 0; list != null && i < list.length; ++i) {
                Integer j;
                SAS_ContextSec sasContext;
                AS_ContextSec asContext;
                CompoundSecMech m = list[i];
                b.append("\nCSIv2 CompoundSecMech[" + i + "]\n\tTarget Requires:");
                Enumeration<Integer> keys = assocOptions.keys();
                while (keys.hasMoreElements()) {
                    Integer j2 = keys.nextElement();
                    if (!SecurityMechanismSelector.isSet(m.target_requires, j2)) continue;
                    b.append("\n\t\t" + assocOptions.get(j2));
                }
                TLS_SEC_TRANS ssl = tCI.getSSLInformation(m);
                if (ssl != null) {
                    Integer j3;
                    b.append("\n\tTLS_SEC_TRANS\n\t\tTarget Requires:");
                    keys = assocOptions.keys();
                    while (keys.hasMoreElements()) {
                        j3 = keys.nextElement();
                        if (!SecurityMechanismSelector.isSet(ssl.target_requires, j3)) continue;
                        b.append("\n\t\t\t" + assocOptions.get(j3));
                    }
                    b.append("\n\t\tTarget Supports:");
                    keys = assocOptions.keys();
                    while (keys.hasMoreElements()) {
                        j3 = keys.nextElement();
                        if (!SecurityMechanismSelector.isSet(ssl.target_supports, j3)) continue;
                        b.append("\n\t\t\t" + assocOptions.get(j3));
                    }
                    TransportAddress[] aList = ssl.addresses;
                    for (int j4 = 0; j4 < aList.length; ++j4) {
                        TransportAddress a = aList[j4];
                        b.append("\n\t\tAddress[" + j4 + "] Host Name: " + a.host_name + " port: " + a.port);
                    }
                }
                if ((asContext = m.as_context_mech) != null) {
                    b.append("\n\tAS_ContextSec\n\t\tTarget Requires:");
                    keys = assocOptions.keys();
                    while (keys.hasMoreElements()) {
                        Integer j5 = keys.nextElement();
                        if (!SecurityMechanismSelector.isSet(asContext.target_requires, j5)) continue;
                        b.append("\n\t\t\t" + assocOptions.get(j5));
                    }
                    b.append("\n\t\tTarget Supports:");
                    keys = assocOptions.keys();
                    while (keys.hasMoreElements()) {
                        Integer j6 = keys.nextElement();
                        if (!SecurityMechanismSelector.isSet(asContext.target_supports, j6)) continue;
                        b.append("\n\t\t\t" + assocOptions.get(j6));
                    }
                    try {
                        if (asContext.client_authentication_mech.length > 0) {
                            Oid oid = new Oid(asContext.client_authentication_mech);
                            b.append("\n\t\tclient_auth_mech_OID:" + oid);
                        } else {
                            b.append("\n\t\tclient_auth_mech_OID: undefined");
                        }
                    }
                    catch (Exception e) {
                        b.append("\n\t\tclient_auth_mech_OID: (invalid)" + e.getMessage());
                    }
                    finally {
                        b.append("\n\t\ttarget_name:" + new String(asContext.target_name));
                    }
                }
                if ((sasContext = m.sas_context_mech) == null) continue;
                b.append("\n\tSAS_ContextSec\n\t\tTarget Requires:");
                keys = assocOptions.keys();
                while (keys.hasMoreElements()) {
                    j = keys.nextElement();
                    if (!SecurityMechanismSelector.isSet(sasContext.target_requires, j)) continue;
                    b.append("\n\t\t\t" + assocOptions.get(j));
                }
                b.append("\n\t\tTarget Supports:");
                keys = assocOptions.keys();
                while (keys.hasMoreElements()) {
                    j = keys.nextElement();
                    if (!SecurityMechanismSelector.isSet(sasContext.target_supports, j)) continue;
                    b.append("\n\t\t\t" + assocOptions.get(j));
                }
                b.append("\n\t\tprivilege authorities:" + Arrays.toString(sasContext.privilege_authorities));
                byte[][] nameTypes = sasContext.supported_naming_mechanisms;
                for (int j7 = 0; j7 < nameTypes.length; ++j7) {
                    try {
                        if (nameTypes[j7].length > 0) {
                            Oid oid = new Oid(nameTypes[j7]);
                            b.append("\n\t\tSupported Naming Mechanim[" + j7 + "]: " + oid);
                            continue;
                        }
                        b.append("\n\t\tSupported Naming Mechanim[" + j7 + "]:  undefined");
                        continue;
                    }
                    catch (Exception e) {
                        b.append("\n\t\tSupported Naming Mechanism[" + j7 + "]: (invalid)" + e.getMessage());
                    }
                }
                b.append("\n\t\tsupported Identity Types:");
                long map = sasContext.supported_identity_types;
                keys = identityTokenTypes.keys();
                while (keys.hasMoreElements()) {
                    Integer j8 = keys.nextElement();
                    if (!SecurityMechanismSelector.isSet(sasContext.supported_identity_types, j8)) continue;
                    b.append("\n\t\t\t" + identityTokenTypes.get(j8));
                    map -= (long)j8.intValue();
                }
                if (map <= 0L) continue;
                b.append("\n\t\t\tcustom bits set: " + map);
            }
            b.append("\n\n");
        }
        catch (Exception e) {
            e.printStackTrace();
            return "Unexpected exception during IOR tracing - unset Property: com.sun.enterprise.iiop.security.traceIORS";
        }
        return b.toString();
    }

    static {
        assocOptions.put(2, "Integrity");
        assocOptions.put(4, "Confidentiality");
        assocOptions.put(32, "EstablishTrustInTarget");
        assocOptions.put(64, "EstablishTrustInClient");
        assocOptions.put(1024, "IdentityAssertion");
        assocOptions.put(2048, "DelegationByClient");
        identityTokenTypes = new Hashtable();
        identityTokenTypes.put(1, "Anonymous");
        identityTokenTypes.put(2, "PrincipalName");
        identityTokenTypes.put(4, "X509CertChain");
        identityTokenTypes.put(8, "DistinguishedName");
    }
}

