/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.admin.apps.console;

import com.sun.messaging.jmq.admin.apps.console.ObjStoreCObj;
import com.sun.messaging.jmq.admin.apps.console.ObjStoreDialog;
import com.sun.messaging.jmq.admin.apps.console.ObjStoreListCObj;
import com.sun.messaging.jmq.admin.apps.console.event.ObjAdminEvent;
import com.sun.messaging.jmq.admin.objstore.ObjStore;
import com.sun.messaging.jmq.admin.objstore.ObjStoreAttrs;
import com.sun.messaging.jmq.admin.resources.AdminConsoleResources;
import com.sun.messaging.jmq.admin.util.Globals;
import java.awt.Frame;
import java.util.Enumeration;
import javax.swing.JOptionPane;

public class ObjStorePropsDialog
extends ObjStoreDialog {
    private static AdminConsoleResources acr = Globals.getAdminConsoleResources();
    private static String[] close;
    private ObjStoreCObj osCObj;

    public ObjStorePropsDialog(Frame frame, ObjStoreListCObj objStoreListCObj) {
        super(frame, acr.getString("A1309"), 113, objStoreListCObj);
        this.setHelpId("object_store_properties");
    }

    public void doOK() {
        String string = null;
        string = this.osText.getText();
        if ((string = string.trim()).equals("")) {
            JOptionPane.showOptionDialog(this, acr.getString("A3004"), acr.getString("A1309") + ": " + acr.getString("A1218", "A3004"), 0, 0, null, close, close[0]);
            this.osText.requestFocus();
            return;
        }
        ObjStoreAttrs objStoreAttrs = this.constructAttrs(string);
        if (objStoreAttrs == null) {
            return;
        }
        ObjAdminEvent objAdminEvent = new ObjAdminEvent(this, 2);
        objAdminEvent.setObjStoreID(string);
        objAdminEvent.setObjStore(this.osCObj.getObjStore());
        objAdminEvent.setObjStoreAttrs(objStoreAttrs);
        objAdminEvent.setConnectAttempt(false);
        objAdminEvent.setOKAction(true);
        this.fireAdminEventDispatched(objAdminEvent);
    }

    public void doApply() {
    }

    public void doReset() {
    }

    public void doCancel() {
        this.hide();
    }

    public void doClose() {
        this.hide();
    }

    public void doClear() {
    }

    public void show(ObjStoreCObj objStoreCObj) {
        this.osCObj = objStoreCObj;
        ObjStore objStore = objStoreCObj.getObjStore();
        this.checkBox.setSelected(true);
        ObjStoreAttrs objStoreAttrs = objStore.getObjStoreAttrs();
        this.jndiProps.clear();
        if (objStoreAttrs != null) {
            Enumeration enumeration = objStoreAttrs.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                this.jndiProps.setProperty(string, (String)objStoreAttrs.get(string));
            }
            this.model.fireTableRowsInserted(0, objStoreAttrs.size() - 1);
            if (objStoreAttrs.size() >= 1) {
                this.table.setRowSelectionInterval(0, 0);
            }
        } else {
            this.comboBox.setSelectedIndex(0);
            this.delButton.setEnabled(false);
            this.chgButton.setEnabled(false);
            this.model.fireTableDataChanged();
            this.valueText.requestFocus();
        }
        this.osText.setText(objStore.getID());
        if (objStore.isOpen()) {
            this.setEditable(false);
        } else {
            this.setEditable(true);
        }
        super.show();
    }

    private ObjStoreAttrs constructAttrs(String string) {
        ObjStore objStore = this.osCObj.getObjStore();
        String string2 = objStore.getID();
        if (!string2.equals(string) && this.osMgr != null && this.osMgr.getStore(string) != null) {
            JOptionPane.showOptionDialog(this, acr.getString("A3002", string), acr.getString("A1309") + ": " + acr.getString("A1218", "A3002"), 0, 0, null, close, close[0]);
            this.osText.requestFocus();
            this.osText.selectAll();
            return null;
        }
        ObjStoreAttrs objStoreAttrs = new ObjStoreAttrs(string, string);
        if (this.jndiProps == null) {
            return objStoreAttrs;
        }
        if (this.checkMandatoryProps() == 0) {
            return null;
        }
        Enumeration<?> enumeration = this.jndiProps.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string3 = (String)enumeration.nextElement();
            objStoreAttrs.put(string3, this.jndiProps.getProperty(string3));
        }
        return objStoreAttrs;
    }

    protected void setEditable(boolean bl) {
        if (bl) {
            this.okButton.setVisible(true);
            this.closeButton.setVisible(false);
            this.cancelButton.setVisible(true);
            this.buttonPanel.doLayout();
        } else {
            this.okButton.setVisible(false);
            this.closeButton.setVisible(true);
            this.cancelButton.setVisible(false);
            this.buttonPanel.doLayout();
        }
        super.setEditable(bl);
    }

    static {
        String[] stringArray = new String[1];
        stringArray[0] = acr.getString("A1081");
        close = stringArray;
    }
}

