/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.auth.usermgr;

import com.sun.messaging.jmq.Version;
import com.sun.messaging.jmq.jmsserver.Broker;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.auth.file.JMQFileUserRepository;
import com.sun.messaging.jmq.jmsserver.auth.usermgr.CmdRunner;
import com.sun.messaging.jmq.jmsserver.auth.usermgr.HelpPrinter;
import com.sun.messaging.jmq.jmsserver.auth.usermgr.Output;
import com.sun.messaging.jmq.jmsserver.auth.usermgr.UserMgrException;
import com.sun.messaging.jmq.jmsserver.auth.usermgr.UserMgrOptionParser;
import com.sun.messaging.jmq.jmsserver.auth.usermgr.UserMgrOptions;
import com.sun.messaging.jmq.jmsserver.auth.usermgr.UserMgrProperties;
import com.sun.messaging.jmq.jmsserver.auth.usermgr.UserMgrUtils;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.util.FileUtil;
import com.sun.messaging.jmq.util.options.BadNameValueArgException;
import com.sun.messaging.jmq.util.options.InvalidBasePropNameException;
import com.sun.messaging.jmq.util.options.InvalidHardCodedValueException;
import com.sun.messaging.jmq.util.options.MissingArgException;
import com.sun.messaging.jmq.util.options.OptionException;
import com.sun.messaging.jmq.util.options.UnrecognizedOptionException;
import java.io.File;
import java.io.IOException;
import java.util.Properties;

public class UserMgr
implements UserMgrOptions {
    private static BrokerResources br = Globals.getBrokerResources();

    public static void main(String[] stringArray) {
        Object object;
        int n = 0;
        boolean bl = true;
        if (UserMgr.silentModeOptionSpecified(stringArray)) {
            Output.setSilentMode(true);
        }
        if (UserMgr.createInstanceSpecified(stringArray)) {
            bl = false;
        }
        if (UserMgr.shortHelpOptionSpecified(stringArray)) {
            object = new HelpPrinter();
            ((HelpPrinter)object).printShortHelp();
            System.exit(0);
        } else if (UserMgr.longHelpOptionSpecified(stringArray)) {
            object = new HelpPrinter();
            ((HelpPrinter)object).printLongHelp();
            System.exit(0);
        }
        if (UserMgr.versionOptionSpecified(stringArray)) {
            UserMgr.printBanner();
            UserMgr.printVersion();
            System.exit(0);
        }
        object = null;
        try {
            object = UserMgrOptionParser.parseArgs(stringArray);
        }
        catch (OptionException optionException) {
            UserMgr.handleArgsParsingExceptions(optionException);
            System.exit(1);
        }
        try {
            UserMgr.checkInstance((UserMgrProperties)object, bl);
            UserMgr.checkOptions((UserMgrProperties)object);
        }
        catch (UserMgrException userMgrException) {
            UserMgr.handleCheckOptionsExceptions(userMgrException);
            System.exit(1);
        }
        CmdRunner cmdRunner = new CmdRunner((UserMgrProperties)object);
        n = cmdRunner.runCommands();
        System.exit(n);
    }

    private static void checkOptions(UserMgrProperties userMgrProperties) throws UserMgrException {
        String string = userMgrProperties.getCommand();
        if (string == null) {
            UserMgrException userMgrException = new UserMgrException(0);
            userMgrException.setProperties(userMgrProperties);
            throw userMgrException;
        }
        if (string.equals("add")) {
            UserMgr.checkAdd(userMgrProperties);
        } else if (string.equals("delete")) {
            UserMgr.checkDelete(userMgrProperties);
        } else if (string.equals("list")) {
            UserMgr.checkList(userMgrProperties);
        } else if (string.equals("update")) {
            UserMgr.checkUpdate(userMgrProperties);
        } else if (string.equals(".exists")) {
            UserMgr.checkExists(userMgrProperties);
        } else if (string.equals(".getgroup")) {
            UserMgr.checkGetGroup(userMgrProperties);
        } else if (string.equals(".getgroupsize")) {
            UserMgr.checkGetGroupSize(userMgrProperties);
        } else if (string.equals("encode")) {
            UserMgr.checkEncode(userMgrProperties);
        } else if (string.equals("decode")) {
            UserMgr.checkDecode(userMgrProperties);
        } else {
            UserMgrException userMgrException = new UserMgrException(1);
            userMgrException.setProperties(userMgrProperties);
            throw userMgrException;
        }
    }

    private static void checkAdd(UserMgrProperties userMgrProperties) throws UserMgrException {
        UserMgr.promptForUserName(userMgrProperties);
        UserMgr.checkUserName(userMgrProperties);
        UserMgr.promptForPassword(userMgrProperties);
        UserMgr.checkPassword(userMgrProperties);
        String string = userMgrProperties.getRole();
        if (string != null) {
            UserMgr.checkRole(userMgrProperties);
        }
        UserMgr.checkNoActiveInAdd(userMgrProperties);
    }

    private static void checkDelete(UserMgrProperties userMgrProperties) throws UserMgrException {
        UserMgr.checkUserName(userMgrProperties);
    }

    private static void checkList(UserMgrProperties userMgrProperties) throws UserMgrException {
    }

    private static void checkUpdate(UserMgrProperties userMgrProperties) throws UserMgrException {
        UserMgr.checkUserName(userMgrProperties);
        UserMgr.checkPasswordOrActive(userMgrProperties);
    }

    private static void checkExists(UserMgrProperties userMgrProperties) throws UserMgrException {
        UserMgr.checkUserName(userMgrProperties);
    }

    private static void checkGetGroup(UserMgrProperties userMgrProperties) throws UserMgrException {
        UserMgr.checkUserName(userMgrProperties);
    }

    private static void checkGetGroupSize(UserMgrProperties userMgrProperties) throws UserMgrException {
        UserMgr.checkRole(userMgrProperties);
    }

    private static void checkEncode(UserMgrProperties userMgrProperties) throws UserMgrException {
        UserMgr.checkSrc(userMgrProperties);
    }

    private static void checkDecode(UserMgrProperties userMgrProperties) throws UserMgrException {
        UserMgr.checkSrc(userMgrProperties);
    }

    private static String checkPassword(UserMgrProperties userMgrProperties) throws UserMgrException {
        String string = userMgrProperties.getPassword();
        String string2 = userMgrProperties.getPassfile();
        if (string == null && string2 == null) {
            UserMgrException userMgrException = new UserMgrException(2);
            userMgrException.setProperties(userMgrProperties);
            throw userMgrException;
        }
        return string;
    }

    private static void checkPasswordOrActive(UserMgrProperties userMgrProperties) throws UserMgrException {
        String string = userMgrProperties.getPassword();
        String string2 = userMgrProperties.getPassfile();
        String string3 = userMgrProperties.getActiveValue();
        if (string2 == null && string == null && string3 == null) {
            UserMgrException userMgrException = new UserMgrException(15);
            userMgrException.setProperties(userMgrProperties);
            throw userMgrException;
        }
        if (string3 == null) {
            return;
        }
        if (string3.equalsIgnoreCase("t") || string3.equalsIgnoreCase(Boolean.TRUE.toString())) {
            userMgrProperties.setActiveValue(Boolean.TRUE.toString());
            return;
        }
        if (string3.equalsIgnoreCase("f") || string3.equalsIgnoreCase(Boolean.FALSE.toString())) {
            userMgrProperties.setActiveValue(Boolean.FALSE.toString());
            return;
        }
        UserMgrException userMgrException = new UserMgrException(17);
        userMgrException.setProperties(userMgrProperties);
        throw userMgrException;
    }

    private static void checkNoActiveInAdd(UserMgrProperties userMgrProperties) throws UserMgrException {
        String string = userMgrProperties.getActiveValue();
        if (string == null) {
            return;
        }
        UserMgrException userMgrException = new UserMgrException(19);
        userMgrException.setProperties(userMgrProperties);
        throw userMgrException;
    }

    private static void checkSrc(UserMgrProperties userMgrProperties) throws UserMgrException {
        String string = userMgrProperties.getSrc();
        if (string == null) {
            UserMgrException userMgrException = new UserMgrException(24);
            userMgrException.setProperties(userMgrProperties);
            throw userMgrException;
        }
    }

    private static String promptForUserName(UserMgrProperties userMgrProperties) throws UserMgrException {
        String string = userMgrProperties.getUserName();
        if (string != null) {
            return string;
        }
        string = UserMgrUtils.getUserInput(userMgrProperties, br.getString("B1061"));
        userMgrProperties.setUserName(string);
        return string;
    }

    private static void promptForPassword(UserMgrProperties userMgrProperties) throws UserMgrException {
        String string = userMgrProperties.getPassword();
        String string2 = userMgrProperties.getPassfile();
        if (string2 != null) {
            return;
        }
        if (string != null) {
            return;
        }
        string = UserMgrUtils.getPasswordInput(userMgrProperties, br.getString("B1062"));
        userMgrProperties.setPassword(string);
    }

    private static void warnForPassword(UserMgrProperties userMgrProperties) throws UserMgrException {
        String string = userMgrProperties.getPassword();
        if (string == null) {
            return;
        }
        Output.stdErrPrintln(br.getString("B2088", "-p"));
        Output.stdErrPrintln("");
    }

    private static String checkUserName(UserMgrProperties userMgrProperties) throws UserMgrException {
        String string = userMgrProperties.getUserName();
        if (string == null) {
            UserMgrException userMgrException = new UserMgrException(4);
            userMgrException.setProperties(userMgrProperties);
            throw userMgrException;
        }
        if (string.length() == 0) {
            UserMgrException userMgrException = new UserMgrException(23);
            userMgrException.setProperties(userMgrProperties);
            throw userMgrException;
        }
        if (!UserMgr.isValidUserName(string)) {
            UserMgrException userMgrException = new UserMgrException(16);
            userMgrException.setProperties(userMgrProperties);
            throw userMgrException;
        }
        return string;
    }

    private static void checkInstance(UserMgrProperties userMgrProperties, boolean bl) throws UserMgrException {
        File file;
        String string = userMgrProperties.getInstance();
        String string2 = userMgrProperties.getCommand();
        if (string2 != null && (string2.equals("encode") || string2.equals("decode"))) {
            return;
        }
        if (string == null) {
            string = "imqbroker";
            userMgrProperties.setInstance(string);
        }
        Properties properties = new Properties(System.getProperties());
        properties.put("imq.instancename", string);
        Globals.init(properties, false, false);
        String string3 = Globals.getInstanceEtcDir();
        File file2 = new File(string3);
        if (!file2.exists()) {
            if (bl) {
                UserMgrException userMgrException = new UserMgrException(21);
                userMgrException.setProperties(userMgrProperties);
                throw userMgrException;
            }
            try {
                Broker.initializePasswdFile();
            }
            catch (IOException iOException) {
                UserMgrException userMgrException = new UserMgrException(25, (Throwable)iOException);
                userMgrException.setProperties(userMgrProperties);
                throw userMgrException;
            }
        }
        if (!(file = JMQFileUserRepository.getPasswordFile(Globals.getConfig())).exists()) {
            UserMgrException userMgrException = new UserMgrException(7);
            userMgrException.setProperties(userMgrProperties);
            userMgrException.setPasswordFile(FileUtil.getCanonicalPath((String)file.toString()));
            throw userMgrException;
        }
        userMgrProperties.setPasswordFile(FileUtil.getCanonicalPath((String)file.toString()));
    }

    private static boolean isValidUserName(String string) {
        if (string == null) {
            return false;
        }
        for (int i = 0; i < OPTION_USERNAME_INVALID_CHARS.length; ++i) {
            if (string.indexOf(OPTION_USERNAME_INVALID_CHARS[i]) == -1) continue;
            return false;
        }
        return true;
    }

    private static String checkRole(UserMgrProperties userMgrProperties) throws UserMgrException {
        String string = userMgrProperties.getRole();
        if (string == null) {
            UserMgrException userMgrException = new UserMgrException(5);
            userMgrException.setProperties(userMgrProperties);
            throw userMgrException;
        }
        for (int i = 0; i < OPTION_ROLE_VALID_VALUES.length; ++i) {
            if (!string.equals(OPTION_ROLE_VALID_VALUES[i])) continue;
            return string;
        }
        UserMgrException userMgrException = new UserMgrException(6);
        userMgrException.setProperties(userMgrProperties);
        throw userMgrException;
    }

    private static void printBanner() {
        Version version = new Version();
        Output.stdOutPrintln(version.getBanner(false));
    }

    private static boolean shortHelpOptionSpecified(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals("-h") && !stringArray[i].equals("-help")) continue;
            return true;
        }
        return false;
    }

    private static boolean longHelpOptionSpecified(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals("-H") && !stringArray[i].equals("-Help")) continue;
            return true;
        }
        return false;
    }

    private static boolean versionOptionSpecified(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals("-v") && !stringArray[i].equals("-version")) continue;
            return true;
        }
        return false;
    }

    private static boolean silentModeOptionSpecified(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals("-s")) continue;
            return true;
        }
        return false;
    }

    private static boolean createInstanceSpecified(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals("-c")) continue;
            return true;
        }
        return false;
    }

    private static void printVersion() {
        Version version = new Version();
        Output.stdOutPrintln(version.getVersion());
        Output.stdOutPrintln(br.getString("B1003") + System.getProperty("java.version") + " " + System.getProperty("java.vendor") + " " + System.getProperty("java.home"));
    }

    private static void handleArgsParsingExceptions(OptionException optionException) {
        String string = optionException.getOption();
        if (optionException instanceof UnrecognizedOptionException) {
            Output.stdErrPrintln(br.getString("B3045"), br.getKString("B3029", string));
        } else if (optionException instanceof InvalidBasePropNameException) {
            Output.stdErrPrintln(br.getString("B3044"), br.getKString("B3030", string));
        } else if (optionException instanceof InvalidHardCodedValueException) {
            Output.stdErrPrintln(br.getString("B3044"), br.getKString("B3031", string));
        } else if (optionException instanceof MissingArgException) {
            Output.stdErrPrintln(br.getString("B3045"), br.getKString("B3032", string));
        } else if (optionException instanceof BadNameValueArgException) {
            BadNameValueArgException badNameValueArgException = (BadNameValueArgException)optionException;
            String string2 = badNameValueArgException.getArg();
            Output.stdErrPrintln(br.getString("B3045"), br.getKString("B3033", string2, string));
        } else {
            Output.stdErrPrintln(br.getString("B3045"), br.getKString("B3034"));
        }
    }

    private static void handleCheckOptionsExceptions(UserMgrException userMgrException) {
        UserMgrProperties userMgrProperties = userMgrException.getProperties();
        String string = userMgrProperties.getCommand();
        String string2 = userMgrProperties.getRole();
        String string3 = userMgrProperties.getUserName();
        String string4 = userMgrProperties.getActiveValue();
        int n = userMgrException.getType();
        switch (n) {
            case 0: {
                UserMgr.printBanner();
                HelpPrinter helpPrinter = new HelpPrinter();
                helpPrinter.printShortHelp();
                break;
            }
            case 1: {
                Output.stdErrPrintln(br.getString("B3045"), br.getKString("B3036", userMgrProperties.getCommand()));
                break;
            }
            case 2: {
                Output.stdErrPrintln(br.getString("B3045"), br.getKString("B3038", "-passfile", "-p"));
                break;
            }
            case 15: {
                Output.stdErrPrintln(br.getString("B3045"), br.getKString("B3039"));
                break;
            }
            case 17: {
                Output.stdErrPrintln(br.getString("B3045"), br.getKString("B3089", string4));
                break;
            }
            case 6: {
                Output.stdErrPrintln(br.getString("B3045"), br.getKString("B3040", string, string2));
                Output.stdErrPrintln(br.getString("B3041"));
                for (int i = 0; i < OPTION_ROLE_VALID_VALUES.length; ++i) {
                    Output.stdErrPrintln("\t" + OPTION_ROLE_VALID_VALUES[i]);
                }
                break;
            }
            case 4: {
                Output.stdErrPrintln(br.getString("B3045"), br.getKString("B3042", "-u"));
                break;
            }
            case 5: {
                Output.stdErrPrintln(br.getString("B3045"), br.getKString("B3043", "-g"));
                break;
            }
            case 16: {
                Output.stdErrPrintln(br.getString("B3045"), br.getKString("B3067", string3));
                break;
            }
            case 18: {
                Output.stdErrPrintln(br.getString("B3045"), br.getKString("B3090"));
                break;
            }
            case 19: {
                Output.stdErrPrintln(br.getString("B3045"), br.getKString("B3110"));
                break;
            }
            case 21: {
                Output.stdErrPrintln(br.getString("B3045"), br.getKString("B3137", userMgrProperties.getInstance()));
                break;
            }
            case 7: {
                Output.stdErrPrintln(br.getString("B3044"), br.getKString("B3046", userMgrException.getPasswordFile()));
                break;
            }
            case 23: {
                Output.stdErrPrintln(br.getString("B3045"), br.getKString("B3166"));
                break;
            }
            case 24: {
                Output.stdErrPrintln(br.getString("B3045"), ": The source file to encode/decode was not specified.\nPlease specify it using the -src option.");
                break;
            }
            case 25: {
                Output.stdErrPrintln(br.getString("B3045"), br.getKString("B3243"));
                break;
            }
            default: {
                Output.stdErrPrintln(br.getString("B3045"), br.getKString("B3037"));
            }
        }
    }
}

