/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.management.util;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.Consumer;
import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.jmsserver.core.PacketReference;
import com.sun.messaging.jmq.jmsserver.core.Subscription;
import com.sun.messaging.jmq.jmsserver.management.util.ConnectionUtil;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.service.ConnectionUID;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.net.IPAddress;
import com.sun.messaging.jmq.util.admin.ConnectionInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.management.openmbean.ArrayType;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;

public class ConsumerUtil {
    private static CompositeType monitorCompType = null;

    public static int toExternalAckMode(int n) {
        switch (n) {
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
            case 0: {
                return 0;
            }
            case 32768: {
                return 32768;
            }
        }
        return -1;
    }

    public static String toExternalAckModeString(int n) {
        switch (n) {
            case 1: {
                return "AUTO_ACKNOWLEDGE";
            }
            case 2: {
                return "CLIENT_ACKNOWLEDGE";
            }
            case 3: {
                return "DUPS_OK_ACKNOWLEDGE";
            }
            case 0: {
                return "SESSION_TRANSACTED";
            }
            case 32768: {
                return "NO_ACKNOWLEDGE";
            }
        }
        return "UNKNOWN";
    }

    public static int toInternalAckMode(int n) {
        switch (n) {
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
            case 0: {
                return 0;
            }
            case 32768: {
                return 32768;
            }
        }
        return -1;
    }

    public static HashMap getAllConsumersNoChildren() {
        Iterator iterator = Consumer.getAllConsumers();
        HashMap<ConsumerUID, Consumer> hashMap = new HashMap<ConsumerUID, Consumer>();
        while (iterator.hasNext()) {
            Consumer consumer = (Consumer)iterator.next();
            ConsumerUID consumerUID = consumer.getConsumerUID();
            if (consumer.getSubscription() != null) continue;
            hashMap.put(consumerUID, consumer);
        }
        return hashMap;
    }

    public static int getNumConsumersNoChildren() {
        return ConsumerUtil.getAllConsumersNoChildren().size();
    }

    public static boolean isDurable(ConsumerUID consumerUID) {
        Consumer consumer = Consumer.getConsumer(consumerUID);
        if (consumer != null) {
            return consumer.isDurableSubscriber();
        }
        return false;
    }

    public static boolean isWildcard(ConsumerUID consumerUID) {
        Consumer consumer = Consumer.getConsumer(consumerUID);
        if (consumer != null) {
            return consumer.isWildcard();
        }
        return false;
    }

    public static String getNextMessageID(ConsumerUID consumerUID) {
        PacketReference packetReference;
        Consumer consumer = Consumer.getConsumer(consumerUID);
        if (consumer != null && (packetReference = consumer.peekNext()) != null) {
            return packetReference.getSysMessageID().toString();
        }
        return "";
    }

    public static boolean isDurableActive(ConsumerUID consumerUID) {
        if (!ConsumerUtil.isDurable(consumerUID)) {
            return false;
        }
        Consumer consumer = Consumer.getConsumer(consumerUID);
        if (consumer != null) {
            return consumer.isActive();
        }
        return false;
    }

    public static ConnectionUID getConnectionUID(ConsumerUID consumerUID) {
        Consumer consumer = Consumer.getConsumer(consumerUID);
        ConnectionUID connectionUID = null;
        if (ConsumerUtil.isDurable(consumerUID) && !ConsumerUtil.isDurableActive(consumerUID)) {
            return null;
        }
        if (consumer != null) {
            connectionUID = consumer.getConnectionUID();
        }
        return connectionUID;
    }

    public static Destination getDestination(ConsumerUID consumerUID) {
        Consumer consumer = Consumer.getConsumer(consumerUID);
        Destination destination = null;
        if (consumer != null) {
            destination = consumer.getFirstDestination();
        }
        return destination;
    }

    public static DestinationUID getDestinationUID(ConsumerUID consumerUID) {
        Consumer consumer = Consumer.getConsumer(consumerUID);
        DestinationUID destinationUID = null;
        if (consumer != null) {
            destinationUID = consumer.getDestinationUID();
        }
        return destinationUID;
    }

    public static Long getCreationTime(ConsumerUID consumerUID) {
        long l = System.currentTimeMillis();
        return new Long(l - consumerUID.age(l));
    }

    public static String[] getConsumerIDs() {
        int n = 0;
        HashSet hashSet = new HashSet(ConsumerUtil.getAllConsumersNoChildren().values());
        n = hashSet.size();
        if (n <= 0) {
            return null;
        }
        String[] stringArray = new String[n];
        Iterator iterator = hashSet.iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            String string;
            Consumer consumer = (Consumer)iterator.next();
            long l = consumer.getConsumerUID().longValue();
            stringArray[n2] = string = Long.toString(l);
            ++n2;
        }
        return stringArray;
    }

    public static CompositeData[] getConsumerInfo() throws BrokerException, OpenDataException {
        String[] stringArray = ConsumerUtil.getConsumerIDs();
        if (stringArray == null) {
            return null;
        }
        CompositeData[] compositeDataArray = new CompositeData[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            compositeDataArray[i] = ConsumerUtil.getConsumerInfo(stringArray[i]);
        }
        return compositeDataArray;
    }

    public static CompositeData getConsumerInfo(String string) throws BrokerException, OpenDataException {
        CompositeData compositeData = null;
        ConsumerUID consumerUID = null;
        BrokerResources brokerResources = Globals.getBrokerResources();
        if (string == null) {
            throw new IllegalArgumentException(brokerResources.getString("B4259"));
        }
        long l = 0L;
        try {
            l = Long.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException(brokerResources.getString("B4260", string));
        }
        ConsumerUID consumerUID2 = new ConsumerUID(l);
        Consumer consumer = Consumer.getConsumer(consumerUID2);
        if (consumer == null) {
            throw new BrokerException(brokerResources.getString("B4261", string));
        }
        consumer.load();
        consumerUID = consumer.getConsumerUID();
        if (consumerUID == null) {
            throw new BrokerException(brokerResources.getString("B4261", string));
        }
        compositeData = ConsumerUtil.getConsumerInfo(consumerUID);
        return compositeData;
    }

    private static Integer getAcknowledgeMode(ConsumerUID consumerUID) {
        return new Integer(ConsumerUtil.toExternalAckMode(consumerUID.getAckType()));
    }

    private static String getAcknowledgeModeLabel(ConsumerUID consumerUID) {
        return ConsumerUtil.toExternalAckModeString(consumerUID.getAckType());
    }

    private static String getClientID(ConsumerUID consumerUID) {
        Consumer consumer = Consumer.getConsumer(consumerUID);
        if (consumer == null) {
            return null;
        }
        return consumer.getClientID();
    }

    private static String getConnectionID(ConsumerUID consumerUID) {
        ConnectionUID connectionUID = ConsumerUtil.getConnectionUID(consumerUID);
        if (connectionUID == null) {
            return null;
        }
        return Long.toString(connectionUID.longValue());
    }

    private static String[] getDestinationNames(ConsumerUID consumerUID) {
        Consumer consumer = Consumer.getConsumer(consumerUID);
        String[] stringArray = null;
        if (consumer == null) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        Set set = consumer.getDestinations();
        if (set == null) {
            return null;
        }
        for (Destination destination : set) {
            arrayList.add(destination.getDestinationName());
        }
        if (arrayList.size() > 0) {
            stringArray = new String[arrayList.size()];
            stringArray = arrayList.toArray(stringArray);
        }
        return stringArray;
    }

    private static String getDestinationName(ConsumerUID consumerUID) {
        DestinationUID destinationUID = ConsumerUtil.getDestinationUID(consumerUID);
        if (destinationUID == null) {
            return null;
        }
        return destinationUID.getName();
    }

    private static String getDestinationType(ConsumerUID consumerUID) {
        Destination destination = ConsumerUtil.getDestination(consumerUID);
        if (destination == null) {
            return null;
        }
        return destination.isQueue() ? "q" : "t";
    }

    private static Boolean getWildcard(ConsumerUID consumerUID) {
        return new Boolean(ConsumerUtil.isWildcard(consumerUID));
    }

    private static Boolean getDurable(ConsumerUID consumerUID) {
        return new Boolean(ConsumerUtil.isDurable(consumerUID));
    }

    private static Boolean getDurableActive(ConsumerUID consumerUID) {
        if (!ConsumerUtil.getDurable(consumerUID).booleanValue()) {
            return null;
        }
        return new Boolean(ConsumerUtil.isDurableActive(consumerUID));
    }

    private static String getDurableName(ConsumerUID consumerUID) {
        if (!ConsumerUtil.getDurable(consumerUID).booleanValue()) {
            return null;
        }
        Consumer consumer = Consumer.getConsumer(consumerUID);
        if (consumer == null) {
            return null;
        }
        if (consumer instanceof Subscription) {
            return ((Subscription)consumer).getDurableName();
        }
        Subscription subscription = consumer.getSubscription();
        if (subscription != null) {
            return subscription.getDurableName();
        }
        return null;
    }

    private static Boolean getFlowPaused(ConsumerUID consumerUID) {
        Consumer consumer = Consumer.getConsumer(consumerUID);
        if (consumer == null) {
            return null;
        }
        return new Boolean(consumer.getIsFlowPaused());
    }

    private static String getHost(ConsumerUID consumerUID) {
        ConnectionUID connectionUID = ConsumerUtil.getConnectionUID(consumerUID);
        if (connectionUID == null) {
            return null;
        }
        ConnectionInfo connectionInfo = ConnectionUtil.getConnectionInfo(connectionUID.longValue());
        if (connectionInfo == null) {
            return null;
        }
        String string = null;
        if (connectionInfo.remoteIP != null) {
            string = String.valueOf(IPAddress.rawIPToString((byte[])connectionInfo.remoteIP, (boolean)true, (boolean)true));
        }
        return string;
    }

    private static Long getLastAckTime(ConsumerUID consumerUID) {
        Consumer consumer = Consumer.getConsumer(consumerUID);
        if (consumer == null) {
            return null;
        }
        return new Long(consumer.getLastAckTime());
    }

    private static Long getNumMsgs(ConsumerUID consumerUID) {
        Consumer consumer = Consumer.getConsumer(consumerUID);
        if (consumer == null) {
            return null;
        }
        return new Long(consumer.totalMsgsDelivered());
    }

    private static Long getNumMsgsPendingAcks(ConsumerUID consumerUID) {
        Consumer consumer = Consumer.getConsumer(consumerUID);
        if (consumer == null) {
            return null;
        }
        return new Long(consumer.numPendingAcks());
    }

    private static Long getNumPendingMsgs(ConsumerUID consumerUID) {
        Consumer consumer = Consumer.getConsumer(consumerUID);
        if (consumer == null) {
            return null;
        }
        return new Long(consumer.numInProcessMsgs());
    }

    private static String getSelector(ConsumerUID consumerUID) {
        Consumer consumer = Consumer.getConsumer(consumerUID);
        if (consumer == null) {
            return null;
        }
        return consumer.getSelectorStr();
    }

    private static String getServiceName(ConsumerUID consumerUID) {
        ConnectionUID connectionUID = ConsumerUtil.getConnectionUID(consumerUID);
        if (connectionUID == null) {
            return null;
        }
        String string = ConnectionUtil.getServiceOfConnection(connectionUID.longValue());
        return string;
    }

    private static String getUser(ConsumerUID consumerUID) {
        ConnectionUID connectionUID = ConsumerUtil.getConnectionUID(consumerUID);
        if (connectionUID == null) {
            return null;
        }
        ConnectionInfo connectionInfo = ConnectionUtil.getConnectionInfo(connectionUID.longValue());
        if (connectionInfo == null) {
            return null;
        }
        return connectionInfo.user;
    }

    private static CompositeData getConsumerInfo(ConsumerUID consumerUID) throws OpenDataException {
        String[] stringArray;
        String[] stringArray2 = stringArray = new String[]{"AcknowledgeMode", "AcknowledgeModeLabel", "ClientID", "ConnectionID", "ConsumerID", "CreationTime", "DestinationName", "DestinationNames", "DestinationType", "Durable", "DurableActive", "DurableName", "FlowPaused", "Host", "LastAckTime", "NumMsgs", "NumMsgsPending", "NumMsgsPendingAcks", "Selector", "ServiceName", "User", "Wildcard", "NextMessageID"};
        OpenType[] openTypeArray = new OpenType[]{SimpleType.INTEGER, SimpleType.STRING, SimpleType.STRING, SimpleType.STRING, SimpleType.STRING, SimpleType.LONG, SimpleType.STRING, new ArrayType(1, SimpleType.STRING), SimpleType.STRING, SimpleType.BOOLEAN, SimpleType.BOOLEAN, SimpleType.STRING, SimpleType.BOOLEAN, SimpleType.STRING, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.STRING, SimpleType.STRING, SimpleType.STRING, SimpleType.BOOLEAN, SimpleType.STRING};
        Object[] objectArray = new Object[]{ConsumerUtil.getAcknowledgeMode(consumerUID), ConsumerUtil.getAcknowledgeModeLabel(consumerUID), ConsumerUtil.getClientID(consumerUID), ConsumerUtil.getConnectionID(consumerUID), Long.toString(consumerUID.longValue()), ConsumerUtil.getCreationTime(consumerUID), ConsumerUtil.getDestinationName(consumerUID), ConsumerUtil.getDestinationNames(consumerUID), ConsumerUtil.getDestinationType(consumerUID), ConsumerUtil.getDurable(consumerUID), ConsumerUtil.getDurableActive(consumerUID), ConsumerUtil.getDurableName(consumerUID), ConsumerUtil.getFlowPaused(consumerUID), ConsumerUtil.getHost(consumerUID), ConsumerUtil.getLastAckTime(consumerUID), ConsumerUtil.getNumMsgs(consumerUID), ConsumerUtil.getNumPendingMsgs(consumerUID), ConsumerUtil.getNumMsgsPendingAcks(consumerUID), ConsumerUtil.getSelector(consumerUID), ConsumerUtil.getServiceName(consumerUID), ConsumerUtil.getUser(consumerUID), ConsumerUtil.getWildcard(consumerUID), ConsumerUtil.getNextMessageID(consumerUID)};
        CompositeDataSupport compositeDataSupport = null;
        Consumer consumer = Consumer.getConsumer(consumerUID);
        if (monitorCompType == null) {
            monitorCompType = new CompositeType("ConsumerMonitorInfo", "ConsumerMonitorInfo", stringArray, stringArray2, openTypeArray);
        }
        compositeDataSupport = new CompositeDataSupport(monitorCompType, stringArray, objectArray);
        return compositeDataSupport;
    }
}

