/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.file;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.io.SysMessageID;
import com.sun.messaging.jmq.io.VRFileRAF;
import com.sun.messaging.jmq.io.VRFileWarning;
import com.sun.messaging.jmq.io.VRecord;
import com.sun.messaging.jmq.io.VRecordRAF;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.config.BrokerConfig;
import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.jmsserver.persist.Store;
import com.sun.messaging.jmq.jmsserver.persist.file.MessageInfo;
import com.sun.messaging.jmq.jmsserver.persist.file.MsgStore;
import com.sun.messaging.jmq.jmsserver.persist.file.RandomAccessStore;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;

class DstMsgStore
extends RandomAccessStore {
    BrokerConfig config = Globals.getConfig();
    static final String USE_FILE_CHANNEL_PROP = "imq.persist.file.message.use_file_channel";
    static final boolean DEFAULT_USE_FILE_CHANNEL = false;
    static String VRFILE_NAME = "vrfile";
    static boolean useFileChannel = Globals.getConfig().getBooleanProperty("imq.persist.file.message.use_file_channel", false);
    DestinationUID myDestination = null;
    private MsgStore parent = null;
    private ConcurrentHashMap messageMap = new ConcurrentHashMap(1000);
    private AtomicBoolean loaded = new AtomicBoolean(false);
    protected float growthFactor = this.config.getPercentageProperty("imq.persist.file.message.vrfile.growth_factor", 0.5f);
    protected long threshold = this.config.getLongProperty("imq.persist.file.message.vrfile.threshold", 0L);
    protected float thresholdFactor = this.config.getPercentageProperty("imq.persist.file.message.vrfile.threshold_factor", 0.0f);
    private static FilenameFilter vrfileFilter = new FilenameFilter(){

        public boolean accept(File file, String string) {
            return !string.equals(VRFILE_NAME);
        }
    };
    private static Enumeration emptyEnum = new Enumeration(){

        public boolean hasMoreElements() {
            return false;
        }

        public Object nextElement() {
            return null;
        }
    };
    private int msgCount = 0;
    private long byteCount = 0L;
    private Object countLock = new Object();
    private VRFileRAF vrfile = null;
    int maxRecordSize = 0;

    DstMsgStore(MsgStore msgStore, DestinationUID destinationUID, File file) throws BrokerException {
        this(msgStore, destinationUID, file, false);
    }

    DstMsgStore(MsgStore msgStore, DestinationUID destinationUID, File file, boolean bl) throws BrokerException {
        super(file, msgStore.msgfdlimit, msgStore.poollimit, msgStore.cleanratio);
        this.parent = msgStore;
        this.myDestination = destinationUID;
        try {
            long l = msgStore.initialFileSize.getBytes();
            if (l > 0L) {
                this.maxRecordSize = (int)msgStore.maxRecordSize.getBytes();
                this.vrfile = new VRFileRAF(new File(file, VRFILE_NAME), l);
                this.vrfile.setBlockSize(msgStore.blockSize);
                try {
                    this.vrfile.setGrowthFactor(this.growthFactor);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    this.vrfile.setGrowthFactor(0.5f);
                    this.growthFactor = 0.5f;
                    this.logger.log(8, "Invalid growth_factor value. Using default value of 50%.");
                }
                try {
                    this.vrfile.setThreshold(this.threshold);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    this.vrfile.setThreshold(0L);
                    this.threshold = 0L;
                    this.logger.log(8, "Invalid threshold value. Using default value of 0.");
                }
                try {
                    this.vrfile.setThresholdFactor(this.thresholdFactor);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    this.vrfile.setThresholdFactor(0.0f);
                    this.thresholdFactor = 0.0f;
                    this.logger.log(8, "Invalid threshold_factor value. Using default value of 0%.");
                }
                try {
                    if (this.threshold != 0L || this.thresholdFactor != 0.0f) {
                        this.vrfile.checkGrowthFactorSanity();
                    }
                }
                catch (IllegalStateException illegalStateException) {
                    String string = illegalStateException.getMessage();
                    this.logger.log(8, string);
                }
                try {
                    this.vrfile.open();
                }
                catch (VRFileWarning vRFileWarning) {
                    this.logger.log(16, "possible data loss for " + this.myDestination, (Throwable)vRFileWarning);
                }
            }
            this.initCounts();
        }
        catch (IOException iOException) {
            this.logger.log(32, "B4147", (Object)file, (Object)destinationUID, (Throwable)iOException);
            throw new BrokerException(this.br.getString("B4147", file, destinationUID), iOException);
        }
        catch (Throwable throwable) {
            this.logger.log(32, "B4147", (Object)file, (Object)destinationUID, throwable);
            throw new BrokerException(this.br.getString("B4147", file, destinationUID), throwable);
        }
        if (bl) {
            this.loadMessages();
        }
    }

    public HashMap getStorageInfo() throws BrokerException {
        if (this.vrfile == null) {
            return new HashMap();
        }
        HashMap<String, Number> hashMap = new HashMap<String, Number>(3);
        long l = this.vrfile.getBytesUsed();
        long l2 = this.vrfile.getBytesFree();
        hashMap.put("diskUsed", new Long(l));
        hashMap.put("diskReserved", new Long(l + l2));
        hashMap.put("diskUtilizationRatio", new Integer((int)(this.vrfile.getUtilizationRatio() * 100.0f)));
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void compact() throws BrokerException {
        if (this.vrfile == null) {
            return;
        }
        VRFileRAF vRFileRAF = this.vrfile;
        synchronized (vRFileRAF) {
            try {
                this.vrfile.close();
                try {
                    this.vrfile.compact();
                }
                catch (VRFileWarning vRFileWarning) {
                    this.logger.log(16, "possible data loss for " + this.myDestination, (Throwable)vRFileWarning);
                }
                try {
                    this.vrfile.open();
                }
                catch (VRFileWarning vRFileWarning) {
                    this.logger.log(16, "possible data loss for " + this.myDestination, (Throwable)vRFileWarning);
                }
                this.messageMap.clear();
                Iterator iterator = this.vrfile.getRecords().iterator();
                MsgEnumeration msgEnumeration = new MsgEnumeration(this, iterator, emptyEnum);
                while (msgEnumeration.hasMoreElements()) {
                    msgEnumeration.nextElement();
                }
            }
            catch (IOException iOException) {
                throw new BrokerException("Failed to compact file: " + this.vrfile.getFile(), iOException);
            }
        }
    }

    MessageInfo storeMessage(Packet packet, ConsumerUID[] consumerUIDArray, int[] nArray, boolean bl) throws IOException, BrokerException {
        SysMessageID sysMessageID = packet.getSysMessageID();
        if (this.messageMap.containsKey(sysMessageID)) {
            this.logger.log(32, "B3008", (Object)sysMessageID, (Object)this.myDestination);
            throw new BrokerException(this.br.getString("B3008", sysMessageID, this.myDestination));
        }
        try {
            int n = packet.getPacketSize();
            MessageInfo messageInfo = null;
            messageInfo = this.vrfile != null && (this.maxRecordSize == 0 || n < this.maxRecordSize) ? new MessageInfo(this, this.vrfile, packet, consumerUIDArray, nArray, bl) : new MessageInfo(this, packet, consumerUIDArray, nArray, bl);
            this.messageMap.put(messageInfo.getID(), messageInfo);
            this.incrMsgCount(n);
            return messageInfo;
        }
        catch (IOException iOException) {
            this.logger.log(32, "B4004", (Object)sysMessageID.toString(), (Throwable)iOException);
            throw iOException;
        }
    }

    void removeMessage(SysMessageID sysMessageID, boolean bl) throws IOException, BrokerException {
        MessageInfo messageInfo = (MessageInfo)this.messageMap.remove(sysMessageID);
        if (messageInfo == null) {
            this.logger.log(32, "B3007", (Object)sysMessageID, (Object)this.myDestination);
            throw new BrokerException(this.br.getString("B3007", sysMessageID, this.myDestination));
        }
        messageInfo.free(bl);
        this.decrMsgCount(messageInfo.getSize());
    }

    void removeAllMessages(boolean bl) throws IOException, BrokerException {
        if (this.vrfile != null) {
            this.vrfile.clear(false);
        }
        this.removeAllData(bl);
        this.messageMap.clear();
        this.clearCounts();
    }

    void releaseMessageDir(boolean bl) throws IOException {
        if (this.vrfile != null) {
            this.vrfile.clear(false);
            this.vrfile.close();
            this.vrfile = null;
        }
        this.reset(true);
        super.close(false);
        this.messageMap.clear();
        this.clearCounts();
    }

    Enumeration messageEnumeration() {
        if (this.loaded.get()) {
            return new MsgEnumeration(this, this.getMessageIterator());
        }
        Iterator iterator = null;
        if (this.vrfile != null) {
            iterator = this.vrfile.getRecords().iterator();
        }
        return new MsgEnumeration(this, iterator, this.getEnumeration(false));
    }

    int getMessageCount() throws BrokerException {
        if (Store.getDEBUG()) {
            this.logger.log(4, "DstMsgStore:getMessageCount()");
        }
        return this.msgCount;
    }

    long getByteCount() throws BrokerException {
        if (Store.getDEBUG()) {
            this.logger.log(4, "DstMsgStore:getByteCount()");
        }
        return this.byteCount;
    }

    protected void close(boolean bl) {
        if (this.vrfile != null) {
            this.vrfile.close();
        }
        super.close(bl);
        this.messageMap.clear();
    }

    VRFileRAF getVRFile() {
        return this.vrfile;
    }

    private void loadMessages() throws BrokerException {
        Enumeration enumeration = this.messageEnumeration();
        while (enumeration.hasMoreElements()) {
            enumeration.nextElement();
        }
        this.logger.log(4, "loaded " + this.messageMap.size() + " messages");
    }

    MessageInfo getMessageInfo(SysMessageID sysMessageID) throws BrokerException {
        MessageInfo messageInfo = (MessageInfo)this.messageMap.get(sysMessageID);
        if (messageInfo == null) {
            this.logger.log(32, "B3007", (Object)sysMessageID, (Object)this.myDestination);
            throw new BrokerException(this.br.getString("B3007", sysMessageID, this.myDestination));
        }
        return messageInfo;
    }

    Object parseData(byte[] byArray, byte[] byArray2) throws IOException {
        MessageInfo messageInfo = new MessageInfo(this, byArray, byArray2);
        SysMessageID sysMessageID = messageInfo.getID();
        this.messageMap.put(sysMessageID, messageInfo);
        return sysMessageID;
    }

    FilenameFilter getFilenameFilter() {
        return vrfileFilter;
    }

    private void cacheMessageInfo(MessageInfo messageInfo) {
        this.messageMap.put(messageInfo.getID(), messageInfo);
    }

    private Iterator getMessageIterator() {
        return this.messageMap.keySet().iterator();
    }

    private void setLoadedFlag(boolean bl) {
        this.loaded.set(bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void incrMsgCount(int n) throws BrokerException {
        Object object = this.countLock;
        synchronized (object) {
            ++this.msgCount;
            this.byteCount += (long)n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decrMsgCount(int n) throws BrokerException {
        Object object = this.countLock;
        synchronized (object) {
            --this.msgCount;
            this.byteCount -= (long)n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearCounts() {
        if (Store.getDEBUG()) {
            this.logger.log(4, "DstMsgStore:clearCounts for " + this.myDestination);
        }
        Object object = this.countLock;
        synchronized (object) {
            this.msgCount = 0;
            this.byteCount = 0L;
        }
    }

    private void initCounts() throws BrokerException {
        Object object;
        Object object2;
        if (this.vrfile != null) {
            object2 = this.vrfile.getRecords();
            object = object2.iterator();
            while (object.hasNext()) {
                VRecordRAF vRecordRAF = (VRecordRAF)object.next();
                short s = vRecordRAF.getCookie();
                if (s == -1 || s != 0) {
                    String string = this.myDestination + ": found a " + "corrupted message at vrecord(" + vRecordRAF + "), a message might be lost";
                    this.logger.log(16, string);
                    try {
                        this.vrfile.free((VRecord)vRecordRAF);
                    }
                    catch (IOException iOException) {
                        this.logger.log(32, "Failed to free the corrupted vrecord: " + iOException);
                    }
                    continue;
                }
                try {
                    ++this.msgCount;
                    this.byteCount += (long)vRecordRAF.readInt();
                }
                catch (Throwable throwable) {
                    this.logger.log(32, "B4148", (Object)this.vrfile.getFile(), throwable);
                    throw new BrokerException(this.br.getString("B4148", this.vrfile.getFile()), throwable);
                }
            }
        }
        object2 = super.getEnumeration(true);
        while (object2.hasMoreElements()) {
            ++this.msgCount;
            object = (Long)object2.nextElement();
            this.byteCount += ((Long)object).longValue();
        }
        if (Store.getDEBUG()) {
            this.logger.log(4, "DstMsgStore: initialized msg count=" + this.msgCount + "; byte count = " + this.byteCount);
        }
    }

    Hashtable getDebugState() {
        int n = 0;
        if (this.vrfile != null) {
            n = this.vrfile.getNRecords();
        }
        int n2 = this.msgCount - n;
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put(this.myDestination + ":messages in vrfile", String.valueOf(n));
        hashtable.put(this.myDestination + ":messages in its own file", String.valueOf(n2));
        return hashtable;
    }

    void storeInterestStates(SysMessageID sysMessageID, ConsumerUID[] consumerUIDArray, int[] nArray, boolean bl) throws IOException, BrokerException {
        this.getMessageInfo(sysMessageID).storeStates(consumerUIDArray, nArray, bl);
    }

    void updateInterestState(SysMessageID sysMessageID, ConsumerUID consumerUID, int n, boolean bl) throws IOException, BrokerException {
        this.getMessageInfo(sysMessageID).updateState(consumerUID, n, bl);
    }

    boolean containsMsg(SysMessageID sysMessageID) {
        return this.messageMap.containsKey(sysMessageID);
    }

    Packet getMessage(SysMessageID sysMessageID) throws IOException, BrokerException {
        MessageInfo messageInfo = (MessageInfo)this.messageMap.get(sysMessageID);
        if (messageInfo == null) {
            this.logger.log(32, "B3007", (Object)sysMessageID, (Object)this.myDestination);
            throw new BrokerException(this.br.getString("B3007", sysMessageID, this.myDestination));
        }
        return messageInfo.getMessage();
    }

    void sync() throws BrokerException {
        try {
            if (Store.getDEBUG_SYNC()) {
                this.logger.log(4, "sync called on " + this.myDestination);
            }
            this.vrfile.force();
        }
        catch (IOException iOException) {
            throw new BrokerException("Failed to synchronize data to disk for file: " + this.vrfile, iOException);
        }
    }

    private static class MsgEnumeration
    implements Enumeration {
        DstMsgStore parent = null;
        Iterator itr = null;
        Iterator recitr = null;
        Enumeration msgEnum = null;
        Logger logger = Globals.getLogger();
        BrokerResources br = Globals.getBrokerResources();
        Object objToReturn = null;

        MsgEnumeration(DstMsgStore dstMsgStore, Iterator iterator) {
            this.parent = dstMsgStore;
            this.itr = iterator;
        }

        MsgEnumeration(DstMsgStore dstMsgStore, Iterator iterator, Enumeration enumeration) {
            this.parent = dstMsgStore;
            this.recitr = iterator;
            this.msgEnum = enumeration;
        }

        public boolean hasMoreElements() {
            Object var1_1 = null;
            if (this.itr != null) {
                if (this.itr.hasNext()) {
                    this.objToReturn = this.itr.next();
                    return true;
                }
                return false;
            }
            if (this.recitr != null) {
                while (this.recitr.hasNext()) {
                    try {
                        MessageInfo messageInfo = new MessageInfo(this.parent, (VRecordRAF)this.recitr.next());
                        this.objToReturn = messageInfo.getMessage();
                        this.parent.cacheMessageInfo(messageInfo);
                        return true;
                    }
                    catch (IOException iOException) {
                        this.logger.log(32, "B4143", (Object)this.parent.myDestination, (Throwable)iOException);
                    }
                }
            }
            if (this.msgEnum.hasMoreElements()) {
                this.objToReturn = this.msgEnum.nextElement();
                return true;
            }
            this.parent.setLoadedFlag(true);
            return false;
        }

        public Object nextElement() {
            if (this.objToReturn != null) {
                Object object = null;
                if (this.objToReturn instanceof SysMessageID) {
                    try {
                        object = this.parent.getMessage((SysMessageID)this.objToReturn);
                    }
                    catch (IOException iOException) {
                        this.logger.log(32, "B4005", this.objToReturn, (Object)this.parent.myDestination, (Throwable)iOException);
                        throw new NoSuchElementException();
                    }
                    catch (BrokerException brokerException) {
                        this.logger.log(32, "B4005", this.objToReturn, (Object)this.parent.myDestination, (Throwable)brokerException);
                        throw new NoSuchElementException();
                    }
                } else {
                    object = this.objToReturn;
                }
                this.objToReturn = null;
                return object;
            }
            throw new NoSuchElementException();
        }
    }
}

