/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.inmemory;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.BrokerAddress;
import com.sun.messaging.jmq.jmsserver.data.TransactionAcknowledgement;
import com.sun.messaging.jmq.jmsserver.data.TransactionBroker;
import com.sun.messaging.jmq.jmsserver.data.TransactionState;
import com.sun.messaging.jmq.jmsserver.data.TransactionUID;
import com.sun.messaging.jmq.jmsserver.persist.Store;
import com.sun.messaging.jmq.jmsserver.persist.TransactionInfo;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.Externalizable;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

class TxnStore {
    Logger logger = Globals.getLogger();
    BrokerResources br = Globals.getBrokerResources();
    private ConcurrentHashMap tidMap = null;
    private ConcurrentHashMap ackMap = null;
    private HashMap emptyHashMap = new HashMap();
    private TransactionAcknowledgement[] emptyAckArray = new TransactionAcknowledgement[0];

    TxnStore() {
        this.tidMap = new ConcurrentHashMap(1024);
        this.ackMap = new ConcurrentHashMap(1024);
    }

    void close(boolean bl) {
        if (Store.getDEBUG()) {
            this.logger.log(1, "TxnStore: closing, " + this.tidMap.size() + " in-memory transactions");
        }
        this.tidMap.clear();
        if (Store.getDEBUG()) {
            this.logger.log(1, "TxnStore: closing, " + this.ackMap.size() + " in-memory transactions with acks");
        }
        this.ackMap.clear();
    }

    void storeTransaction(TransactionUID transactionUID, TransactionState transactionState, boolean bl) throws IOException, BrokerException {
        try {
            TransactionInfo transactionInfo = this.tidMap.putIfAbsent(transactionUID, new TransactionInfo(new TransactionState(transactionState)));
            if (transactionInfo != null) {
                this.logger.log(32, "B3015", (Object)transactionUID);
                throw new BrokerException(this.br.getString("B3015", transactionUID));
            }
        }
        catch (RuntimeException runtimeException) {
            this.logger.log(32, "B4019", (Object)transactionUID, (Throwable)runtimeException);
            throw new BrokerException(this.br.getString("B4019", transactionUID), runtimeException);
        }
    }

    public void storeClusterTransaction(TransactionUID transactionUID, TransactionState transactionState, TransactionBroker[] transactionBrokerArray, boolean bl) throws BrokerException {
        TransactionInfo transactionInfo = null;
        try {
            transactionInfo = new TransactionInfo(new TransactionState(transactionState), null, transactionBrokerArray, 2);
            TransactionInfo transactionInfo2 = this.tidMap.putIfAbsent(transactionUID, transactionInfo);
            if (transactionInfo2 != null) {
                this.logger.log(32, "B3015", (Object)transactionUID);
                throw new BrokerException(this.br.getString("B3015", transactionUID));
            }
        }
        catch (RuntimeException runtimeException) {
            String string = transactionInfo != null ? transactionUID + " " + transactionInfo.toString() : transactionUID.toString();
            this.logger.log(32, "B4019", (Object)string, (Throwable)runtimeException);
            throw new BrokerException(this.br.getString("B4019", string), runtimeException);
        }
    }

    public void storeRemoteTransaction(TransactionUID transactionUID, TransactionState transactionState, TransactionAcknowledgement[] transactionAcknowledgementArray, BrokerAddress brokerAddress, boolean bl) throws BrokerException {
        TransactionInfo transactionInfo = null;
        boolean bl2 = false;
        try {
            if (this.tidMap.containsKey(transactionUID)) {
                this.logger.log(32, "B3015", (Object)transactionUID);
                throw new BrokerException(this.br.getString("B3015", transactionUID));
            }
            if (transactionAcknowledgementArray != null && transactionAcknowledgementArray.length > 0) {
                this.storeTransactionAcks(transactionUID, transactionAcknowledgementArray);
                bl2 = true;
            }
            transactionInfo = new TransactionInfo(new TransactionState(transactionState), brokerAddress, null, 3);
            this.tidMap.put(transactionUID, transactionInfo);
        }
        catch (RuntimeException runtimeException) {
            String string = transactionInfo != null ? transactionUID + " " + transactionInfo.toString() : transactionUID.toString();
            this.logger.log(32, "B4019", (Object)string, (Throwable)runtimeException);
            try {
                if (bl2) {
                    this.removeTransactionAck(transactionUID);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new BrokerException(this.br.getString("B4019", string), runtimeException);
        }
    }

    void storeTransaction(TransactionUID transactionUID, TransactionInfo transactionInfo, boolean bl) throws BrokerException {
        try {
            this.tidMap.put(transactionUID, transactionInfo);
        }
        catch (RuntimeException runtimeException) {
            this.logger.log(32, "B4019", (Object)transactionUID, (Throwable)runtimeException);
            throw new BrokerException(this.br.getString("B4019", transactionUID), runtimeException);
        }
    }

    void removeTransaction(TransactionUID transactionUID, boolean bl) throws BrokerException {
        try {
            Object v = this.tidMap.remove(transactionUID);
            if (v == null) {
                this.logger.log(32, "B3016", (Object)transactionUID);
                throw new BrokerException(this.br.getString("B3016", transactionUID), 404);
            }
        }
        catch (RuntimeException runtimeException) {
            this.logger.log(32, "B4138", (Object)transactionUID, (Throwable)runtimeException);
            throw new BrokerException(this.br.getString("B4138", transactionUID), runtimeException);
        }
    }

    void updateTransactionState(TransactionUID transactionUID, int n, boolean bl) throws IOException, BrokerException {
        try {
            TransactionInfo transactionInfo = (TransactionInfo)this.tidMap.get(transactionUID);
            if (transactionInfo == null) {
                this.logger.log(32, "B3016", (Object)transactionUID);
                throw new BrokerException(this.br.getString("B3016", transactionUID), 404);
            }
            TransactionState transactionState = transactionInfo.getTransactionState();
            if (transactionState.getState() != n) {
                transactionState.setState(n);
                this.tidMap.put(transactionUID, transactionInfo);
            }
        }
        catch (Exception exception) {
            this.logger.log(32, "B4137", (Object)transactionUID, (Throwable)exception);
            throw new BrokerException(this.br.getString("B4137", transactionUID), exception);
        }
    }

    public void updateClusterTransaction(TransactionUID transactionUID, TransactionBroker[] transactionBrokerArray, boolean bl) throws BrokerException {
        try {
            TransactionInfo transactionInfo = (TransactionInfo)this.tidMap.get(transactionUID);
            if (transactionInfo == null) {
                this.logger.log(32, "B3016", (Object)transactionUID);
                throw new BrokerException(this.br.getString("B3016", transactionUID), 404);
            }
            transactionInfo.setType(2);
            transactionInfo.setTransactionBrokers(transactionBrokerArray);
            this.tidMap.put(transactionUID, transactionInfo);
        }
        catch (RuntimeException runtimeException) {
            this.logger.log(32, "B4019", (Object)transactionUID, (Throwable)runtimeException);
            throw new BrokerException(this.br.getString("B4019", transactionUID), runtimeException);
        }
    }

    void updateTransactionBrokerState(TransactionUID transactionUID, int n, TransactionBroker transactionBroker, boolean bl) throws BrokerException {
        try {
            TransactionInfo transactionInfo = (TransactionInfo)this.tidMap.get(transactionUID);
            if (transactionInfo == null) {
                this.logger.log(32, "B3016", (Object)transactionUID);
                throw new BrokerException(this.br.getString("B3016", transactionUID), 404);
            }
            TransactionState transactionState = transactionInfo.getTransactionState();
            if (transactionState.getState() != n) {
                Object[] objectArray = new Object[]{transactionBroker, transactionUID, TransactionState.toString(n), TransactionState.toString(transactionState.getState())};
                throw new BrokerException(this.br.getKString("B3219", objectArray), 409);
            }
            transactionInfo.updateBrokerState(transactionBroker);
            this.tidMap.put(transactionUID, transactionInfo);
        }
        catch (Exception exception) {
            this.logger.log(32, "B4019", (Object)transactionUID, (Throwable)exception);
            throw new BrokerException(this.br.getString("B4019", transactionUID), exception);
        }
    }

    TransactionState getTransactionState(TransactionUID transactionUID) throws BrokerException {
        TransactionInfo transactionInfo = (TransactionInfo)this.tidMap.get(transactionUID);
        if (transactionInfo == null) {
            this.logger.log(32, "B3016", (Object)transactionUID);
            throw new BrokerException(this.br.getString("B3016", transactionUID), 404);
        }
        return new TransactionState(transactionInfo.getTransactionState());
    }

    int getTransactionStateValue(TransactionUID transactionUID) throws BrokerException {
        TransactionState transactionState;
        TransactionInfo transactionInfo = (TransactionInfo)this.tidMap.get(transactionUID);
        if (transactionInfo != null && (transactionState = transactionInfo.getTransactionState()) != null) {
            return transactionState.getState();
        }
        return -1;
    }

    TransactionInfo getTransactionInfo(TransactionUID transactionUID) throws BrokerException {
        TransactionInfo transactionInfo = (TransactionInfo)this.tidMap.get(transactionUID);
        if (transactionInfo == null) {
            this.logger.log(32, "B3016", (Object)transactionUID);
            throw new BrokerException(this.br.getString("B3016", transactionUID), 404);
        }
        return (TransactionInfo)transactionInfo.clone();
    }

    BrokerAddress getRemoteTransactionHomeBroker(TransactionUID transactionUID) throws BrokerException {
        TransactionInfo transactionInfo = (TransactionInfo)this.tidMap.get(transactionUID);
        if (transactionInfo == null) {
            this.logger.log(32, "B3016", (Object)transactionUID);
            throw new BrokerException(this.br.getString("B3016", transactionUID), 404);
        }
        return transactionInfo.getTransactionHomeBroker();
    }

    TransactionBroker[] getClusterTransactionBrokers(TransactionUID transactionUID) throws BrokerException {
        TransactionInfo transactionInfo = (TransactionInfo)this.tidMap.get(transactionUID);
        if (transactionInfo == null) {
            this.logger.log(32, "B3016", (Object)transactionUID);
            throw new BrokerException(this.br.getString("B3016", transactionUID), 404);
        }
        TransactionBroker[] transactionBrokerArray = transactionInfo.getTransactionBrokers();
        if (transactionBrokerArray != null) {
            transactionBrokerArray = (TransactionBroker[])transactionBrokerArray.clone();
        }
        return transactionBrokerArray;
    }

    HashMap getAllTransactionStates() throws IOException {
        HashMap hashMap = new HashMap(this.tidMap.size());
        for (Map.Entry entry : this.tidMap.entrySet()) {
            TransactionInfo transactionInfo = (TransactionInfo)entry.getValue();
            int n = transactionInfo.getType();
            if (n != 1 && n != 2) continue;
            hashMap.put(entry.getKey(), transactionInfo.getTransactionState());
        }
        return hashMap;
    }

    HashMap getAllRemoteTransactionStates() throws IOException {
        HashMap hashMap = new HashMap(this.tidMap.size());
        for (Map.Entry entry : this.tidMap.entrySet()) {
            TransactionInfo transactionInfo = (TransactionInfo)entry.getValue();
            int n = transactionInfo.getType();
            if (n != 3) continue;
            hashMap.put(entry.getKey(), transactionInfo.getTransactionState());
        }
        return hashMap;
    }

    Collection getAllTransactions() {
        return this.tidMap.keySet();
    }

    void clearAll() {
        if (Store.getDEBUG()) {
            this.logger.log(1, "TxnStore.clearAll() called");
        }
        this.tidMap.clear();
        this.ackMap.clear();
    }

    void clear(int n, boolean bl) throws BrokerException {
        Externalizable externalizable;
        boolean bl2 = false;
        RuntimeException runtimeException = null;
        Iterator iterator = this.tidMap.entrySet().iterator();
        while (iterator.hasNext()) {
            try {
                Object object = iterator.next();
                externalizable = (TransactionUID)object.getKey();
                TransactionState transactionState = (TransactionState)object.getValue();
                if (transactionState.getState() == n) continue;
                iterator.remove();
                this.removeTransactionAck((TransactionUID)externalizable);
            }
            catch (RuntimeException runtimeException2) {
                bl2 = true;
                runtimeException = runtimeException2;
                this.logger.log(32, "B4139", (Object)new Integer(n), (Throwable)runtimeException2);
            }
        }
        if (!bl2) {
            for (Object object : this.ackMap.keySet()) {
                externalizable = (TransactionInfo)this.tidMap.get(object);
                if (externalizable != null && ((TransactionInfo)externalizable).getTransactionStateValue() == n) continue;
                this.removeTransactionAck((TransactionUID)object);
            }
        }
        if (bl2) {
            this.clearAll();
            throw new BrokerException(this.br.getString("B4139", new Integer(n)), runtimeException);
        }
    }

    void storeTransactionAck(TransactionUID transactionUID, TransactionAcknowledgement transactionAcknowledgement, boolean bl) throws BrokerException {
        if (!this.tidMap.containsKey(transactionUID)) {
            this.logger.log(32, "B3016", (Object)transactionUID.toString());
            throw new BrokerException(this.br.getString("B3016", transactionUID.toString()));
        }
        try {
            boolean bl2 = false;
            HashSet hashSet = (HashSet)this.ackMap.get(transactionUID);
            if (hashSet == null) {
                bl2 = true;
                hashSet = new HashSet();
            } else if (hashSet.contains(transactionAcknowledgement)) {
                this.logger.log(32, "B3062", (Object)transactionAcknowledgement, (Object)transactionUID);
                throw new BrokerException(this.br.getString("B3062", transactionAcknowledgement, transactionUID));
            }
            hashSet.add(transactionAcknowledgement);
            HashSet hashSet2 = this.ackMap.putIfAbsent(transactionUID, hashSet);
            if (bl2 && hashSet2 != null) {
                hashSet = (HashSet)this.ackMap.get(transactionUID);
                hashSet.add(transactionAcknowledgement);
                this.ackMap.put(transactionUID, hashSet);
            }
        }
        catch (RuntimeException runtimeException) {
            this.logger.log(32, "B4056", (Object)transactionAcknowledgement.toString(), (Object)transactionUID.toString());
            throw new BrokerException(this.br.getString("B4056", transactionAcknowledgement.toString(), transactionUID.toString()), runtimeException);
        }
    }

    void storeTransactionAcks(TransactionUID transactionUID, TransactionAcknowledgement[] transactionAcknowledgementArray) throws BrokerException {
        List<TransactionAcknowledgement> list = Arrays.asList(transactionAcknowledgementArray);
        try {
            boolean bl = false;
            HashSet hashSet = (HashSet)this.ackMap.get(transactionUID);
            if (hashSet == null) {
                bl = true;
                hashSet = new HashSet(list.size());
            }
            hashSet.addAll(list);
            HashSet hashSet2 = this.ackMap.putIfAbsent(transactionUID, hashSet);
            if (bl && hashSet2 != null) {
                hashSet = (HashSet)this.ackMap.get(transactionUID);
                hashSet.addAll(list);
                this.ackMap.put(transactionUID, hashSet);
            }
        }
        catch (RuntimeException runtimeException) {
            this.logger.log(32, "B4056", (Object)list.toString(), (Object)transactionUID.toString());
            throw new BrokerException(this.br.getString("B4056", list.toString(), transactionUID.toString()), runtimeException);
        }
    }

    void removeTransactionAck(TransactionUID transactionUID) throws BrokerException {
        try {
            HashSet hashSet = (HashSet)this.ackMap.remove(transactionUID);
            if (hashSet != null) {
                hashSet.clear();
            }
        }
        catch (RuntimeException runtimeException) {
            this.logger.log(32, "B4060", (Object)transactionUID.toString());
            throw new BrokerException(this.br.getString("B4060", transactionUID.toString()), runtimeException);
        }
    }

    TransactionAcknowledgement[] getTransactionAcks(TransactionUID transactionUID) throws BrokerException {
        HashSet hashSet = (HashSet)this.ackMap.get(transactionUID);
        if (hashSet != null) {
            return hashSet.toArray(this.emptyAckArray);
        }
        return this.emptyAckArray;
    }

    HashMap getAllTransactionAcks() {
        if (this.ackMap.size() == 0) {
            return this.emptyHashMap;
        }
        HashMap hashMap = new HashMap(this.ackMap.size());
        Set set = this.ackMap.entrySet();
        for (Map.Entry entry : set) {
            HashSet hashSet = (HashSet)entry.getValue();
            TransactionAcknowledgement[] transactionAcknowledgementArray = hashSet.toArray(this.emptyAckArray);
            hashMap.put(entry.getKey(), transactionAcknowledgementArray);
        }
        return hashMap;
    }

    public int getNumberOfTxnAcks() {
        int n = 0;
        for (Map.Entry entry : this.ackMap.entrySet()) {
            HashSet hashSet = (HashSet)entry.getValue();
            n += hashSet.size();
        }
        return n;
    }

    Hashtable getDebugState() {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("Transactions", String.valueOf(this.tidMap.size()));
        hashtable.put("Txn acks", String.valueOf(this.ackMap.size()));
        return hashtable;
    }

    void printInfo(PrintStream printStream) {
        printStream.println("\nTransaction IDs");
        printStream.println("---------------");
        printStream.println("number of transaction ids: " + this.tidMap.size());
        printStream.println("\nTransaction acknowledgements");
        printStream.println("----------------------------");
        printStream.println("Number of transactions containing acknowledgements: " + this.ackMap.size());
    }
}

