/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.osgijavaeebase;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.ListIterator;
import java.util.jar.Manifest;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OSGiBundleArchive
implements ReadableArchive {
    private Bundle b;
    private String name;
    private URI uri;

    public OSGiBundleArchive(Bundle b) {
        this.b = b;
        this.init();
    }

    private void init() {
        File file;
        String location = this.b.getLocation();
        if (location != null && location.startsWith("reference:") && (location = location.substring("reference:".length())).startsWith("file:") && (file = new File((location = URLDecoder.decode(location)).substring("file:".length()))).exists()) {
            this.uri = file.toURI();
        }
        String symName = this.b.getSymbolicName();
        String version = (String)this.b.getHeaders().get("Bundle-Version");
        this.name = symName != null ? (version == null ? symName : symName.concat("_").concat(version)) : location;
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public Enumeration<String> entries() {
        return Collections.enumeration(this.entries(false));
    }

    @Override
    public Collection<String> getDirectories() throws IOException {
        return this.entries(true);
    }

    private Collection<String> entries(boolean directories) {
        ArrayList<String> entries = new ArrayList<String>();
        this.getEntryPaths(entries, "/");
        ListIterator<String> entriesIter = entries.listIterator();
        while (entriesIter.hasNext()) {
            String next = entriesIter.next();
            if (!next.endsWith("/")) continue;
            entriesIter.remove();
        }
        return entries;
    }

    private void getEntryPaths(Collection<String> entries, String path) {
        this.getEntryPaths2(entries, path);
    }

    private void getEntryPaths2(Collection<String> entries, String path) {
        Enumeration e = this.b.findEntries(path.startsWith("/") ? path : path.concat("/"), "*", true);
        if (e != null) {
            while (e.hasMoreElements()) {
                URL next = (URL)e.nextElement();
                String nextPath = next.getPath();
                entries.add(nextPath.substring(1));
            }
        }
    }

    @Override
    public Enumeration<String> entries(String prefix) {
        ArrayList<String> entries = new ArrayList<String>();
        this.getEntryPaths(entries, prefix);
        return Collections.enumeration(entries);
    }

    @Override
    public boolean isDirectory(String name) {
        return this.b.getEntryPaths(name) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Manifest getManifest() throws IOException {
        URL url = this.b.getEntry("META-INF/MANIFEST.MF");
        if (url != null) {
            InputStream is = url.openStream();
            try {
                Manifest manifest = new Manifest(is);
                return manifest;
            }
            finally {
                is.close();
            }
        }
        return null;
    }

    @Override
    public URI getURI() {
        return this.uri;
    }

    @Override
    public long getArchiveSize() throws SecurityException {
        return -1L;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public InputStream getEntry(String name) throws IOException {
        URL entry = this.b.getEntry(name);
        return entry != null ? entry.openStream() : null;
    }

    @Override
    public boolean exists(String name) throws IOException {
        return this.b.getEntry(name) != null;
    }

    @Override
    public long getEntrySize(String name) {
        return 0L;
    }

    @Override
    public void open(URI uri) throws IOException {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public ReadableArchive getSubArchive(String name) throws IOException {
        return null;
    }

    @Override
    public boolean exists() {
        return true;
    }

    @Override
    public boolean delete() {
        return false;
    }

    @Override
    public boolean renameTo(String name) {
        return false;
    }

    @Override
    public void setParentArchive(ReadableArchive parentArchive) {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public ReadableArchive getParentArchive() {
        return null;
    }
}

