/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.cli;

import com.sun.enterprise.security.cli.CreatePasswordAlias;
import com.sun.enterprise.security.store.PasswordAdapter;
import com.sun.enterprise.util.LocalStringManagerImpl;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@Service(name="update-password-alias")
@Scoped(value=PerLookup.class)
@I18n(value="update.password.alias")
public class UpdatePasswordAlias
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(CreatePasswordAlias.class);
    @Param(name="aliasname", primary=true)
    String aliasName;
    @Param(name="aliaspassword", password=true)
    String aliasPassword;

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        try {
            PasswordAdapter pa;
            String mp = System.getProperty("javax.net.ssl.trustStorePassword");
            if (mp == null) {
                mp = System.getProperty("javax.net.ssl.keyStorePassword");
            }
            if (mp == null) {
                mp = "changeit";
            }
            if ((pa = new PasswordAdapter(mp.toCharArray())).getPasswordForAlias(this.aliasName) == null) {
                report.setMessage(localStrings.getLocalString("update.password.alias.notfound", "Password alias for the alias {0} does not exist.", new Object[]{this.aliasName}));
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
            pa.setPasswordForAlias(this.aliasName, this.aliasPassword.getBytes());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            report.setMessage(localStrings.getLocalString("update.password.alias.fail", "Update of Password Alias {0} failed", new Object[]{this.aliasName}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)ex);
            return;
        }
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        report.setMessage(localStrings.getLocalString("update.password.alias.success", "Encrypted password for the alias {0} updated successfully", new Object[]{this.aliasName}));
    }
}

