/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.api.embedded.web;

import java.io.File;
import java.net.URL;
import org.glassfish.api.embedded.ContainerBuilder;
import org.glassfish.api.embedded.Server;
import org.glassfish.api.embedded.web.EmbeddedWebContainer;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(name="web")
public class WebBuilder
implements ContainerBuilder<EmbeddedWebContainer> {
    @Inject
    Habitat habitat;
    @Inject
    Server server;
    URL defaultWebXml;
    File docRoot;
    String listenerName;
    boolean listings;
    String virtualServerId = "server";
    String[] hostNames = new String[]{"localhost"};
    private EmbeddedWebContainer container = null;

    public WebBuilder setDefaultWebXml(URL url) {
        this.defaultWebXml = url;
        return this;
    }

    public URL getDefaultWebXml() {
        if (this.defaultWebXml == null) {
            this.defaultWebXml = this.getClass().getClassLoader().getResource("org/glassfish/web/embed/default-web.xml");
        }
        return this.defaultWebXml;
    }

    public WebBuilder setHttpListenerName(String name) {
        this.listenerName = name;
        return this;
    }

    public WebBuilder setDocRootDir(File f) {
        this.docRoot = f;
        return this;
    }

    public File getDocRootDir() {
        if (this.docRoot == null) {
            return new File(this.server.getFileSystem().instanceRoot, "docroot");
        }
        return this.docRoot;
    }

    public WebBuilder setListings(boolean b) {
        this.listings = b;
        return this;
    }

    public void setVirtualServerId(String virtualServerId) {
        this.virtualServerId = virtualServerId;
    }

    public String getVirtualServerId() {
        return this.virtualServerId;
    }

    public void setHostNames(String ... hostNames) {
        this.hostNames = hostNames;
    }

    public String[] getHostNames() {
        return this.hostNames;
    }

    public synchronized EmbeddedWebContainer create(Server server) {
        if (this.container == null) {
            this.container = (EmbeddedWebContainer)this.habitat.getByContract(EmbeddedWebContainer.class);
            this.container.setConfiguration(this);
        }
        return this.container;
    }
}

