/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deploy.jar;

import com.sun.enterprise.deploy.shared.AbstractArchiveHandler;
import com.sun.enterprise.loader.ASURLClassLoader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import java.util.logging.Level;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.deployment.archive.ArchiveHandler;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.deployment.common.DeploymentUtils;
import org.glassfish.loader.util.ASClassLoaderUtil;
import org.jvnet.hk2.annotations.Service;

@Service(name="DEFAULT")
public class JarHandler
extends AbstractArchiveHandler
implements ArchiveHandler {
    private static XMLInputFactory xmlIf = null;

    public String getArchiveType() {
        return "jar";
    }

    public boolean handles(ReadableArchive archive) {
        if (DeploymentUtils.isEAR(archive)) {
            throw new RuntimeException("no container associated with application of type : ear");
        }
        return true;
    }

    public ClassLoader getClassLoader(ClassLoader parent, DeploymentContext context) {
        ASURLClassLoader cloader = new ASURLClassLoader(parent);
        try {
            SunEjbJarXMLParser sunEjbJarXMLParser;
            String compatProp = context.getAppProps().getProperty("compatibility");
            if (compatProp == null && (compatProp = (sunEjbJarXMLParser = new SunEjbJarXMLParser(context.getSourceDir())).getCompatibilityValue()) != null) {
                context.getAppProps().put("compatibility", compatProp);
            }
            if (compatProp != null && compatProp.equals("v2")) {
                List<URL> moduleRootLibraries = ASClassLoaderUtil.getURLsAsList(null, new File[]{context.getSourceDir()}, true);
                for (URL url : moduleRootLibraries) {
                    cloader.addURL(url);
                }
            }
            cloader.addURL(context.getSource().getURI().toURL());
            cloader.addURL(context.getScratchDir("ejb").toURI().toURL());
            if (context.getArchiveHandler().getClass().getAnnotation(Service.class).name().equals("ear")) {
                for (URL url : this.getManifestLibraries(context)) {
                    cloader.addURL(url);
                }
            }
        }
        catch (Exception e) {
            this._logger.log(Level.SEVERE, e.getMessage());
            return null;
        }
        return cloader;
    }

    static {
        xmlIf = XMLInputFactory.newInstance();
        xmlIf.setProperty("javax.xml.stream.supportDTD", false);
    }

    private class SunEjbJarXMLParser {
        private XMLStreamReader parser = null;
        private String compatValue = null;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        SunEjbJarXMLParser(File baseDir) throws XMLStreamException, FileNotFoundException {
            FileInputStream input = null;
            File f = new File(baseDir, "META-INF/sun-ejb-jar.xml");
            if (f.exists()) {
                input = new FileInputStream(f);
                try {
                    this.read(input);
                }
                finally {
                    if (this.parser != null) {
                        try {
                            this.parser.close();
                        }
                        catch (Exception ex) {}
                    }
                    if (input != null) {
                        try {
                            ((InputStream)input).close();
                        }
                        catch (Exception ex) {}
                    }
                }
            }
        }

        private void read(InputStream input) throws XMLStreamException {
            this.parser = xmlIf.createXMLStreamReader(input);
            int event = 0;
            boolean done = false;
            this.skipRoot("sun-ejb-jar");
            while (!done && (event = this.parser.next()) != 8) {
                if (event != 1) continue;
                String name = this.parser.getLocalName();
                if ("compatibility".equals(name)) {
                    this.compatValue = this.parser.getElementText();
                    done = true;
                    continue;
                }
                this.skipSubTree(name);
            }
        }

        private void skipRoot(String name) throws XMLStreamException {
            int event;
            while ((event = this.parser.next()) != 1) {
            }
            if (!name.equals(this.parser.getLocalName())) {
                throw new XMLStreamException();
            }
        }

        private void skipSubTree(String name) throws XMLStreamException {
            int event;
            do {
                if ((event = this.parser.next()) != 8) continue;
                throw new XMLStreamException();
            } while (event != 2 || !name.equals(this.parser.getLocalName()));
        }

        String getCompatibilityValue() {
            return this.compatValue;
        }
    }
}

